import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpcComputeStorageVolumeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_storage_volume_snapshot#id DataOpcComputeStorageVolumeSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_storage_volume_snapshot#name DataOpcComputeStorageVolumeSnapshot#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/d/compute_storage_volume_snapshot opc_compute_storage_volume_snapshot}
*/
export declare class DataOpcComputeStorageVolumeSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opc_compute_storage_volume_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/d/compute_storage_volume_snapshot opc_compute_storage_volume_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpcComputeStorageVolumeSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: DataOpcComputeStorageVolumeSnapshotConfig);
    get account(): string;
    get collocated(): cdktf.IResolvable;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get machineImageName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get parentVolumeBootable(): cdktf.IResolvable;
    get platform(): string;
    get property(): string;
    get size(): string;
    get snapshotId(): string;
    get snapshotTimestamp(): string;
    get startTimestamp(): string;
    get status(): string;
    get statusDetail(): string;
    get statusTimestamp(): string;
    get tags(): string[];
    get uri(): string;
    get volumeName(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
