import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpcComputeMachineImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_machine_image#account DataOpcComputeMachineImage#account}
    */
    readonly account: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_machine_image#id DataOpcComputeMachineImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/d/compute_machine_image#name DataOpcComputeMachineImage#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/d/compute_machine_image opc_compute_machine_image}
*/
export declare class DataOpcComputeMachineImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opc_compute_machine_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/d/compute_machine_image opc_compute_machine_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpcComputeMachineImageConfig
    */
    constructor(scope: Construct, id: string, config: DataOpcComputeMachineImageConfig);
    private _account?;
    get account(): string;
    set account(value: string);
    get accountInput(): string | undefined;
    get attributes(): string;
    get description(): string;
    get errorReason(): string;
    get file(): string;
    private _hypervisor;
    get hypervisor(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageFormat(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get noUpload(): cdktf.IResolvable;
    get platform(): string;
    private _sizes;
    get sizes(): cdktf.StringMap;
    get state(): string;
    get uri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
