import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeVpnEndpointV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#customer_vpn_gateway ComputeVpnEndpointV2#customer_vpn_gateway}
    */
    readonly customerVpnGateway: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#description ComputeVpnEndpointV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#enabled ComputeVpnEndpointV2#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#id ComputeVpnEndpointV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#ike_identifier ComputeVpnEndpointV2#ike_identifier}
    */
    readonly ikeIdentifier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#ip_network ComputeVpnEndpointV2#ip_network}
    */
    readonly ipNetwork: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#name ComputeVpnEndpointV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#pre_shared_key ComputeVpnEndpointV2#pre_shared_key}
    */
    readonly preSharedKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#reachable_routes ComputeVpnEndpointV2#reachable_routes}
    */
    readonly reachableRoutes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#require_perfect_forward_secrecy ComputeVpnEndpointV2#require_perfect_forward_secrecy}
    */
    readonly requirePerfectForwardSecrecy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#tags ComputeVpnEndpointV2#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#vnic_sets ComputeVpnEndpointV2#vnic_sets}
    */
    readonly vnicSets: string[];
    /**
    * phase_one_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#phase_one_settings ComputeVpnEndpointV2#phase_one_settings}
    */
    readonly phaseOneSettings?: ComputeVpnEndpointV2PhaseOneSettings;
    /**
    * phase_two_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#phase_two_settings ComputeVpnEndpointV2#phase_two_settings}
    */
    readonly phaseTwoSettings?: ComputeVpnEndpointV2PhaseTwoSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#timeouts ComputeVpnEndpointV2#timeouts}
    */
    readonly timeouts?: ComputeVpnEndpointV2Timeouts;
}
export interface ComputeVpnEndpointV2PhaseOneSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#dh_group ComputeVpnEndpointV2#dh_group}
    */
    readonly dhGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#encryption ComputeVpnEndpointV2#encryption}
    */
    readonly encryption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#hash ComputeVpnEndpointV2#hash}
    */
    readonly hash: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#lifetime ComputeVpnEndpointV2#lifetime}
    */
    readonly lifetime?: number;
}
export declare function computeVpnEndpointV2PhaseOneSettingsToTerraform(struct?: ComputeVpnEndpointV2PhaseOneSettingsOutputReference | ComputeVpnEndpointV2PhaseOneSettings): any;
export declare class ComputeVpnEndpointV2PhaseOneSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeVpnEndpointV2PhaseOneSettings | undefined;
    set internalValue(value: ComputeVpnEndpointV2PhaseOneSettings | undefined);
    private _dhGroup?;
    get dhGroup(): string;
    set dhGroup(value: string);
    get dhGroupInput(): string | undefined;
    private _encryption?;
    get encryption(): string;
    set encryption(value: string);
    get encryptionInput(): string | undefined;
    private _hash?;
    get hash(): string;
    set hash(value: string);
    get hashInput(): string | undefined;
    private _lifetime?;
    get lifetime(): number;
    set lifetime(value: number);
    resetLifetime(): void;
    get lifetimeInput(): number | undefined;
}
export interface ComputeVpnEndpointV2PhaseTwoSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#encryption ComputeVpnEndpointV2#encryption}
    */
    readonly encryption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#hash ComputeVpnEndpointV2#hash}
    */
    readonly hash: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#lifetime ComputeVpnEndpointV2#lifetime}
    */
    readonly lifetime?: number;
}
export declare function computeVpnEndpointV2PhaseTwoSettingsToTerraform(struct?: ComputeVpnEndpointV2PhaseTwoSettingsOutputReference | ComputeVpnEndpointV2PhaseTwoSettings): any;
export declare class ComputeVpnEndpointV2PhaseTwoSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeVpnEndpointV2PhaseTwoSettings | undefined;
    set internalValue(value: ComputeVpnEndpointV2PhaseTwoSettings | undefined);
    private _encryption?;
    get encryption(): string;
    set encryption(value: string);
    get encryptionInput(): string | undefined;
    private _hash?;
    get hash(): string;
    set hash(value: string);
    get hashInput(): string | undefined;
    private _lifetime?;
    get lifetime(): number;
    set lifetime(value: number);
    resetLifetime(): void;
    get lifetimeInput(): number | undefined;
}
export interface ComputeVpnEndpointV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#create ComputeVpnEndpointV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#delete ComputeVpnEndpointV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2#update ComputeVpnEndpointV2#update}
    */
    readonly update?: string;
}
export declare function computeVpnEndpointV2TimeoutsToTerraform(struct?: ComputeVpnEndpointV2TimeoutsOutputReference | ComputeVpnEndpointV2Timeouts | cdktf.IResolvable): any;
export declare class ComputeVpnEndpointV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeVpnEndpointV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeVpnEndpointV2Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2 opc_compute_vpn_endpoint_v2}
*/
export declare class ComputeVpnEndpointV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_vpn_endpoint_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_vpn_endpoint_v2 opc_compute_vpn_endpoint_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeVpnEndpointV2Config
    */
    constructor(scope: Construct, id: string, config: ComputeVpnEndpointV2Config);
    private _customerVpnGateway?;
    get customerVpnGateway(): string;
    set customerVpnGateway(value: string);
    get customerVpnGatewayInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ikeIdentifier?;
    get ikeIdentifier(): string;
    set ikeIdentifier(value: string);
    resetIkeIdentifier(): void;
    get ikeIdentifierInput(): string | undefined;
    private _ipNetwork?;
    get ipNetwork(): string;
    set ipNetwork(value: string);
    get ipNetworkInput(): string | undefined;
    get localGatewayIpAddress(): string;
    get localGatewayPrivateIpAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _preSharedKey?;
    get preSharedKey(): string;
    set preSharedKey(value: string);
    get preSharedKeyInput(): string | undefined;
    private _reachableRoutes?;
    get reachableRoutes(): string[];
    set reachableRoutes(value: string[]);
    get reachableRoutesInput(): string[] | undefined;
    private _requirePerfectForwardSecrecy?;
    get requirePerfectForwardSecrecy(): boolean | cdktf.IResolvable;
    set requirePerfectForwardSecrecy(value: boolean | cdktf.IResolvable);
    resetRequirePerfectForwardSecrecy(): void;
    get requirePerfectForwardSecrecyInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tunnelStatus(): string;
    get uri(): string;
    private _vnicSets?;
    get vnicSets(): string[];
    set vnicSets(value: string[]);
    get vnicSetsInput(): string[] | undefined;
    private _phaseOneSettings;
    get phaseOneSettings(): ComputeVpnEndpointV2PhaseOneSettingsOutputReference;
    putPhaseOneSettings(value: ComputeVpnEndpointV2PhaseOneSettings): void;
    resetPhaseOneSettings(): void;
    get phaseOneSettingsInput(): ComputeVpnEndpointV2PhaseOneSettings | undefined;
    private _phaseTwoSettings;
    get phaseTwoSettings(): ComputeVpnEndpointV2PhaseTwoSettingsOutputReference;
    putPhaseTwoSettings(value: ComputeVpnEndpointV2PhaseTwoSettings): void;
    resetPhaseTwoSettings(): void;
    get phaseTwoSettingsInput(): ComputeVpnEndpointV2PhaseTwoSettings | undefined;
    private _timeouts;
    get timeouts(): ComputeVpnEndpointV2TimeoutsOutputReference;
    putTimeouts(value: ComputeVpnEndpointV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeVpnEndpointV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
