import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeStorageVolumeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#collocated ComputeStorageVolumeSnapshot#collocated}
    */
    readonly collocated?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#description ComputeStorageVolumeSnapshot#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#id ComputeStorageVolumeSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#name ComputeStorageVolumeSnapshot#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#parent_volume_bootable ComputeStorageVolumeSnapshot#parent_volume_bootable}
    */
    readonly parentVolumeBootable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#tags ComputeStorageVolumeSnapshot#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#volume_name ComputeStorageVolumeSnapshot#volume_name}
    */
    readonly volumeName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#timeouts ComputeStorageVolumeSnapshot#timeouts}
    */
    readonly timeouts?: ComputeStorageVolumeSnapshotTimeouts;
}
export interface ComputeStorageVolumeSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#create ComputeStorageVolumeSnapshot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot#delete ComputeStorageVolumeSnapshot#delete}
    */
    readonly delete?: string;
}
export declare function computeStorageVolumeSnapshotTimeoutsToTerraform(struct?: ComputeStorageVolumeSnapshotTimeoutsOutputReference | ComputeStorageVolumeSnapshotTimeouts | cdktf.IResolvable): any;
export declare class ComputeStorageVolumeSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeStorageVolumeSnapshotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeStorageVolumeSnapshotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot opc_compute_storage_volume_snapshot}
*/
export declare class ComputeStorageVolumeSnapshot extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_storage_volume_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_storage_volume_snapshot opc_compute_storage_volume_snapshot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeStorageVolumeSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: ComputeStorageVolumeSnapshotConfig);
    get account(): string;
    private _collocated?;
    get collocated(): boolean | cdktf.IResolvable;
    set collocated(value: boolean | cdktf.IResolvable);
    resetCollocated(): void;
    get collocatedInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get machineImageName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _parentVolumeBootable?;
    get parentVolumeBootable(): boolean | cdktf.IResolvable;
    set parentVolumeBootable(value: boolean | cdktf.IResolvable);
    resetParentVolumeBootable(): void;
    get parentVolumeBootableInput(): boolean | cdktf.IResolvable | undefined;
    get platform(): string;
    get property(): string;
    get size(): string;
    get snapshotId(): string;
    get snapshotTimestamp(): string;
    get startTimestamp(): string;
    get status(): string;
    get statusDetail(): string;
    get statusTimestamp(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get uri(): string;
    private _volumeName?;
    get volumeName(): string;
    set volumeName(value: string);
    get volumeNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeStorageVolumeSnapshotTimeoutsOutputReference;
    putTimeouts(value: ComputeStorageVolumeSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeStorageVolumeSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
