import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecurityRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#acl ComputeSecurityRule#acl}
    */
    readonly acl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#description ComputeSecurityRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#dst_ip_address_prefixes ComputeSecurityRule#dst_ip_address_prefixes}
    */
    readonly dstIpAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#dst_vnic_set ComputeSecurityRule#dst_vnic_set}
    */
    readonly dstVnicSet?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#enabled ComputeSecurityRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#flow_direction ComputeSecurityRule#flow_direction}
    */
    readonly flowDirection: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#id ComputeSecurityRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#name ComputeSecurityRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#security_protocols ComputeSecurityRule#security_protocols}
    */
    readonly securityProtocols?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#src_ip_address_prefixes ComputeSecurityRule#src_ip_address_prefixes}
    */
    readonly srcIpAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#src_vnic_set ComputeSecurityRule#src_vnic_set}
    */
    readonly srcVnicSet?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule#tags ComputeSecurityRule#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule opc_compute_security_rule}
*/
export declare class ComputeSecurityRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_security_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_security_rule opc_compute_security_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSecurityRuleConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSecurityRuleConfig);
    private _acl?;
    get acl(): string;
    set acl(value: string);
    resetAcl(): void;
    get aclInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dstIpAddressPrefixes?;
    get dstIpAddressPrefixes(): string[];
    set dstIpAddressPrefixes(value: string[]);
    resetDstIpAddressPrefixes(): void;
    get dstIpAddressPrefixesInput(): string[] | undefined;
    private _dstVnicSet?;
    get dstVnicSet(): string;
    set dstVnicSet(value: string);
    resetDstVnicSet(): void;
    get dstVnicSetInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _flowDirection?;
    get flowDirection(): string;
    set flowDirection(value: string);
    get flowDirectionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _securityProtocols?;
    get securityProtocols(): string[];
    set securityProtocols(value: string[]);
    resetSecurityProtocols(): void;
    get securityProtocolsInput(): string[] | undefined;
    private _srcIpAddressPrefixes?;
    get srcIpAddressPrefixes(): string[];
    set srcIpAddressPrefixes(value: string[]);
    resetSrcIpAddressPrefixes(): void;
    get srcIpAddressPrefixesInput(): string[] | undefined;
    private _srcVnicSet?;
    get srcVnicSet(): string;
    set srcVnicSet(value: string);
    resetSrcVnicSet(): void;
    get srcVnicSetInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get uri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
