import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#boot_order ComputeInstance#boot_order}
    */
    readonly bootOrder?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#desired_state ComputeInstance#desired_state}
    */
    readonly desiredState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#hostname ComputeInstance#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#id ComputeInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#image_list ComputeInstance#image_list}
    */
    readonly imageList?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#instance_attributes ComputeInstance#instance_attributes}
    */
    readonly instanceAttributes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#label ComputeInstance#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#name ComputeInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#reverse_dns ComputeInstance#reverse_dns}
    */
    readonly reverseDns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#shape ComputeInstance#shape}
    */
    readonly shape: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#ssh_keys ComputeInstance#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#tags ComputeInstance#tags}
    */
    readonly tags?: string[];
    /**
    * networking_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#networking_info ComputeInstance#networking_info}
    */
    readonly networkingInfo?: ComputeInstanceNetworkingInfo[] | cdktf.IResolvable;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#storage ComputeInstance#storage}
    */
    readonly storage?: ComputeInstanceStorage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#timeouts ComputeInstance#timeouts}
    */
    readonly timeouts?: ComputeInstanceTimeouts;
}
export interface ComputeInstanceNetworkingInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#dns ComputeInstance#dns}
    */
    readonly dns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#index ComputeInstance#index}
    */
    readonly index: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#ip_address ComputeInstance#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#ip_network ComputeInstance#ip_network}
    */
    readonly ipNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#is_default_gateway ComputeInstance#is_default_gateway}
    */
    readonly isDefaultGateway?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#mac_address ComputeInstance#mac_address}
    */
    readonly macAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#name_servers ComputeInstance#name_servers}
    */
    readonly nameServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#nat ComputeInstance#nat}
    */
    readonly nat?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#search_domains ComputeInstance#search_domains}
    */
    readonly searchDomains?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#sec_lists ComputeInstance#sec_lists}
    */
    readonly secLists?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#shared_network ComputeInstance#shared_network}
    */
    readonly sharedNetwork?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#vnic ComputeInstance#vnic}
    */
    readonly vnic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#vnic_sets ComputeInstance#vnic_sets}
    */
    readonly vnicSets?: string[];
}
export declare function computeInstanceNetworkingInfoToTerraform(struct?: ComputeInstanceNetworkingInfo | cdktf.IResolvable): any;
export declare class ComputeInstanceNetworkingInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceNetworkingInfo | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceNetworkingInfo | cdktf.IResolvable | undefined);
    private _dns?;
    get dns(): string[];
    set dns(value: string[]);
    resetDns(): void;
    get dnsInput(): string[] | undefined;
    private _index?;
    get index(): number;
    set index(value: number);
    get indexInput(): number | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipNetwork?;
    get ipNetwork(): string;
    set ipNetwork(value: string);
    resetIpNetwork(): void;
    get ipNetworkInput(): string | undefined;
    private _isDefaultGateway?;
    get isDefaultGateway(): boolean | cdktf.IResolvable;
    set isDefaultGateway(value: boolean | cdktf.IResolvable);
    resetIsDefaultGateway(): void;
    get isDefaultGatewayInput(): boolean | cdktf.IResolvable | undefined;
    private _macAddress?;
    get macAddress(): string;
    set macAddress(value: string);
    resetMacAddress(): void;
    get macAddressInput(): string | undefined;
    private _nameServers?;
    get nameServers(): string[];
    set nameServers(value: string[]);
    resetNameServers(): void;
    get nameServersInput(): string[] | undefined;
    private _nat?;
    get nat(): string[];
    set nat(value: string[]);
    resetNat(): void;
    get natInput(): string[] | undefined;
    private _searchDomains?;
    get searchDomains(): string[];
    set searchDomains(value: string[]);
    resetSearchDomains(): void;
    get searchDomainsInput(): string[] | undefined;
    private _secLists?;
    get secLists(): string[];
    set secLists(value: string[]);
    resetSecLists(): void;
    get secListsInput(): string[] | undefined;
    private _sharedNetwork?;
    get sharedNetwork(): boolean | cdktf.IResolvable;
    set sharedNetwork(value: boolean | cdktf.IResolvable);
    resetSharedNetwork(): void;
    get sharedNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _vnic?;
    get vnic(): string;
    set vnic(value: string);
    resetVnic(): void;
    get vnicInput(): string | undefined;
    private _vnicSets?;
    get vnicSets(): string[];
    set vnicSets(value: string[]);
    resetVnicSets(): void;
    get vnicSetsInput(): string[] | undefined;
}
export declare class ComputeInstanceNetworkingInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceNetworkingInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceNetworkingInfoOutputReference;
}
export interface ComputeInstanceStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#index ComputeInstance#index}
    */
    readonly index: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#volume ComputeInstance#volume}
    */
    readonly volume: string;
}
export declare function computeInstanceStorageToTerraform(struct?: ComputeInstanceStorage | cdktf.IResolvable): any;
export declare class ComputeInstanceStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeInstanceStorage | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceStorage | cdktf.IResolvable | undefined);
    private _index?;
    get index(): number;
    set index(value: number);
    get indexInput(): number | undefined;
    get name(): string;
    private _volume?;
    get volume(): string;
    set volume(value: string);
    get volumeInput(): string | undefined;
}
export declare class ComputeInstanceStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeInstanceStorage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeInstanceStorageOutputReference;
}
export interface ComputeInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#create ComputeInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#delete ComputeInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/compute_instance#update ComputeInstance#update}
    */
    readonly update?: string;
}
export declare function computeInstanceTimeoutsToTerraform(struct?: ComputeInstanceTimeoutsOutputReference | ComputeInstanceTimeouts | cdktf.IResolvable): any;
export declare class ComputeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/compute_instance opc_compute_instance}
*/
export declare class ComputeInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_compute_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/compute_instance opc_compute_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeInstanceConfig
    */
    constructor(scope: Construct, id: string, config: ComputeInstanceConfig);
    get attributes(): string;
    get availabilityDomain(): string;
    private _bootOrder?;
    get bootOrder(): number[];
    set bootOrder(value: number[]);
    resetBootOrder(): void;
    get bootOrderInput(): number[] | undefined;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    get domain(): string;
    get entry(): number;
    get fingerprint(): string;
    get fqdn(): string;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageFormat(): string;
    private _imageList?;
    get imageList(): string;
    set imageList(value: string);
    resetImageList(): void;
    get imageListInput(): string | undefined;
    private _instanceAttributes?;
    get instanceAttributes(): string;
    set instanceAttributes(value: string);
    resetInstanceAttributes(): void;
    get instanceAttributesInput(): string | undefined;
    get ipAddress(): string;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get placementRequirements(): string[];
    get platform(): string;
    get priority(): string;
    get quotaReservation(): string;
    get relationships(): string[];
    get resolvers(): string[];
    private _reverseDns?;
    get reverseDns(): boolean | cdktf.IResolvable;
    set reverseDns(value: boolean | cdktf.IResolvable);
    resetReverseDns(): void;
    get reverseDnsInput(): boolean | cdktf.IResolvable | undefined;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    get shapeInput(): string | undefined;
    get site(): string;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    get startTime(): string;
    get state(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get vcable(): string;
    get virtio(): cdktf.IResolvable;
    get vncAddress(): string;
    private _networkingInfo;
    get networkingInfo(): ComputeInstanceNetworkingInfoList;
    putNetworkingInfo(value: ComputeInstanceNetworkingInfo[] | cdktf.IResolvable): void;
    resetNetworkingInfo(): void;
    get networkingInfoInput(): cdktf.IResolvable | ComputeInstanceNetworkingInfo[] | undefined;
    private _storage;
    get storage(): ComputeInstanceStorageList;
    putStorage(value: ComputeInstanceStorage[] | cdktf.IResolvable): void;
    resetStorage(): void;
    get storageInput(): cdktf.IResolvable | ComputeInstanceStorage[] | undefined;
    private _timeouts;
    get timeouts(): ComputeInstanceTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
