/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.debug;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javarosa.debug.EvaluationResult;

public class Event {
    private final String message;
    private final List<EvaluationResult> evaluationResults;
    private static int id = 0;

    public Event(String message) {
        this(message, Collections.emptyList());
    }

    public Event(String message, EvaluationResult ref) {
        this(message, Collections.singletonList(ref));
    }

    public Event(String message, List<EvaluationResult> evaluationResults) {
        this.message = message;
        this.evaluationResults = evaluationResults;
    }

    public String getMessage() {
        return this.message;
    }

    protected List<EvaluationResult> getEvaluationResults() {
        return this.evaluationResults;
    }

    public String getDisplayMessage() {
        if (this.getEvaluationResults() == null) {
            return this.getMessage();
        }
        return "Processing '" + this.getMessage() + "' for " + Event.getShortFieldNames(this.getEvaluationResults());
    }

    public String asMessage() {
        return this.dump(" ---> ");
    }

    public String asLogLine() {
        return this.dump("\t");
    }

    public String dump(String separator) {
        String[] args = new String[]{String.format("%4d", ++id), this.getMessage(), Event.getShortFieldNames(this.getEvaluationResults())};
        return Event.join(separator, args);
    }

    private static String join(String separator, String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(arg);
        }
        return sb.toString();
    }

    private static String getShortFieldNames(Collection<EvaluationResult> evaluationResults) {
        if (evaluationResults == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (EvaluationResult evaluationResult : evaluationResults) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(Event.getShortFieldName(evaluationResult));
        }
        return sb.toString();
    }

    private static String getShortFieldName(EvaluationResult evaluationResult) {
        if (evaluationResult == null) {
            return "";
        }
        return evaluationResult.toString();
    }
}

