/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc1;

import com.filemaker.jdbc.FMColumnValue;
import java.io.IOException;
import java.io.InputStream;

public class FMInputStream
extends InputStream {
    private byte[] buffer;
    private int pos;
    FMColumnValue columnValue = null;
    private FMColumnValue.State state;
    private int markPosition = 0;
    private boolean isVector = false;

    public FMInputStream(FMColumnValue fMColumnValue) {
        this.columnValue = fMColumnValue;
        this.isVector = this.columnValue.isVector;
        if (!this.isVector) {
            this.buffer = this.columnValue.byteValue;
        } else {
            this.state = this.columnValue.getStartState();
        }
    }

    public FMInputStream(byte[] byArray) {
        this.isVector = false;
        this.buffer = byArray;
    }

    @Override
    public int read() throws IOException {
        try {
            int n;
            byte by = 0;
            if (!this.isVector) {
                if (this.pos >= this.buffer.length) {
                    return -1;
                }
                by = this.buffer[this.pos];
                ++this.pos;
            } else {
                n = 0;
                if ((long)this.state.position >= this.state.bytesRemaining) {
                    n = this.columnValue.getNextBlock(this.state);
                    ++this.state.currentBlock;
                    this.state.position = 0;
                }
                if (n != 0) {
                    return -1;
                }
                by = this.state.buffer[this.state.position];
                ++this.state.position;
            }
            n = by & 0x7F;
            if ((by & 0x80) == 128) {
                n |= 0x80;
            }
            return n;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.buffer = null;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public synchronized void mark(int n) {
        this.markPosition = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.pos = this.markPosition;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

