/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.ProtocolMessage;

public class FMNextRowsRequest
extends ProtocolMessage {
    private static final short CMD_FM_NEXT_ROWS_REQUEST = 114;
    private static final int MAX_ROWS_TO_FETCH = 65535;
    public static final short kFetchNext = 0;
    public static final short kFetchPrevious = 1;
    public static final short kFetchFirst = 2;
    public static final short kFetchLast = 3;
    public static final short kFetchRelative = 4;
    public static final short kFetchAbsolute = 5;
    private int commandID;
    private short direction;
    private long offset;
    private long rowsToFetch;

    public FMNextRowsRequest(int n, short s, long l, long l2) {
        super((short)114);
        this.addParameter16(n);
        this.addParameter8(s);
        this.addParameter64(l);
        this.addParameter64(l2);
    }

    public FMNextRowsRequest(byte[] byArray) {
        super(byArray);
    }

    @Override
    public boolean extract() {
        this.commandID = this.getParameter16();
        this.direction = this.getParameter8();
        this.offset = this.getParameter64();
        this.rowsToFetch = this.getParameter64();
        this.extracted = true;
        return true;
    }

    public int getCommandID() {
        if (!this.extracted) {
            this.extract();
        }
        return this.commandID;
    }

    public short getDirection() {
        if (!this.extracted) {
            this.extract();
        }
        return this.direction;
    }

    public long getOffset() {
        if (!this.extracted) {
            this.extract();
        }
        return this.offset;
    }

    public long getRowsToFetch() {
        if (!this.extracted) {
            this.extract();
        }
        return this.rowsToFetch;
    }
}

