from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

class AppListItem(AdditionalDataHolder, Parsable):
    """
    Represents an app in the list of managed applications
    """
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data

    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value

    @property
    def app_id(self,) -> Optional[str]:
        """
        Gets the appId property value. The application or bundle identifier of the application
        Returns: Optional[str]
        """
        return self._app_id

    @app_id.setter
    def app_id(self,value: Optional[str] = None) -> None:
        """
        Sets the appId property value. The application or bundle identifier of the application
        Args:
            value: Value to set for the appId property.
        """
        self._app_id = value

    @property
    def app_store_url(self,) -> Optional[str]:
        """
        Gets the appStoreUrl property value. The Store URL of the application
        Returns: Optional[str]
        """
        return self._app_store_url

    @app_store_url.setter
    def app_store_url(self,value: Optional[str] = None) -> None:
        """
        Sets the appStoreUrl property value. The Store URL of the application
        Args:
            value: Value to set for the appStoreUrl property.
        """
        self._app_store_url = value

    def __init__(self,) -> None:
        """
        Instantiates a new appListItem and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # The application or bundle identifier of the application
        self._app_id: Optional[str] = None
        # The Store URL of the application
        self._app_store_url: Optional[str] = None
        # The application name
        self._name: Optional[str] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # The publisher of the application
        self._publisher: Optional[str] = None

    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> AppListItem:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: AppListItem
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return AppListItem()

    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "app_id": lambda n : setattr(self, 'app_id', n.get_str_value()),
            "app_store_url": lambda n : setattr(self, 'app_store_url', n.get_str_value()),
            "name": lambda n : setattr(self, 'name', n.get_str_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "publisher": lambda n : setattr(self, 'publisher', n.get_str_value()),
        }
        return fields

    @property
    def name(self,) -> Optional[str]:
        """
        Gets the name property value. The application name
        Returns: Optional[str]
        """
        return self._name

    @name.setter
    def name(self,value: Optional[str] = None) -> None:
        """
        Sets the name property value. The application name
        Args:
            value: Value to set for the name property.
        """
        self._name = value

    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type

    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value

    @property
    def publisher(self,) -> Optional[str]:
        """
        Gets the publisher property value. The publisher of the application
        Returns: Optional[str]
        """
        return self._publisher

    @publisher.setter
    def publisher(self,value: Optional[str] = None) -> None:
        """
        Sets the publisher property value. The publisher of the application
        Args:
            value: Value to set for the publisher property.
        """
        self._publisher = value

    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_str_value("appId", self.app_id)
        writer.write_str_value("appStoreUrl", self.app_store_url)
        writer.write_str_value("name", self.name)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_str_value("publisher", self.publisher)
        writer.write_additional_data_value(self.additional_data)


