# Generated by Django 3.1.2 on 2020-10-22 09:59

from django.db import migrations


def populate_popup_config(apps, schema_editor):
    LayerModel = apps.get_model("terra_layer", "Layer")
    for layer in LayerModel.objects.all():
        layer.popup_config = {
            "enable": layer.popup_enable,
            "minzoom": layer.popup_minzoom,
            "maxzoom": layer.popup_maxzoom,
            "template": layer.popup_template,
            "wizard": {},
            "advanced": True,
        }
        layer.save()


def reverse_popuplate_popup_config(apps, schema_editor):
    LayerModel = apps.get_model("terra_layer", "Layer")
    for layer in LayerModel.objects.all():
        layer.popup_enable = layer.popup_config.get("enable", False)
        layer.popup_minzoom = layer.popup_config.get("minzoom", 0)
        layer.popup_maxzoom = layer.popup_config.get("maxzoom", 24)
        layer.popup_template = layer.popup_config.get("template", "")
        layer.save()


class Migration(migrations.Migration):

    dependencies = [
        ("terra_layer", "0051_layer_popup_config"),
    ]

    operations = [
        migrations.RunPython(
            populate_popup_config,
            reverse_code=reverse_popuplate_popup_config,
        )
    ]
