# -*- coding: utf-8 -*-
"""
@authors: Suhas Sharma and Rahul P
"""

from setuptools import setup, find_packages

with open("README.md", "r") as readme_file:
    readme = readme_file.read()

requirements = ["beautifulsoup4>=4.9.0", "bs4>=0.0.1", "numpy>=1.18.2", "pandas>=1.0.4", "python-whois>=0.7.2", "requests>=2.23.0", "scikit-learn>=0.21.3", "selenium>=3.141.0", "sklearn>=0.0", "tqdm>=4.46.0", "urllib3>=1.25.8"]

setup(
	  name="fluffypancakes",
	  version="0.0.11",
	  author="Suhas Sharma",
	  author_email="le.bon.garconn@gmail.com",   
	  description="Detect Phishing Websites using Machine Learning",
	  long_description=readme,
	  long_description_content_type="text/markdown",
	  url="https://github.com/suhasrsharma/FluffyPancakes",
	  py_modules=["fluffypancakes", "features", "controller", "recurrent"],
	  package_dir={'': 'src'},
      keywords="web phishing detection machine learning",
	  packages=find_packages(),
	  include_pacakage_data=True,
	  install_requires=requirements,
	  extras_require={
			  "dev": [
					  "pytest>=3.7",
					  "check-manifest>=0.42",
                   "twine>=3.1.1"
					  ],
				  },
	  classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Programming Language :: Python :: 2.6",
		 "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
		 "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Operating System :: OS Independent",
        "License :: OSI Approved :: MIT License"
    ],
)