# -*- coding: utf-8 -*-

"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_automatic_provisioning_controller_create_account_container_user_address import RechnungsdruckWebAppControllersApiAutomaticProvisioningControllerCreateAccountContainerUserAddress


class RechnungsdruckWebAppControllersApiAutomaticProvisioningControllerCreateAccountContainer(object):

    """Implementation of the 'Rechnungsdruck.WebApp.Controllers.Api.AutomaticProvisioningController.CreateAccountContainer' model.

    Data used to create a new Billbee user account

    Attributes:
        e_mail (string): The Email address of the user to create
        password (string): TODO: type description here.
        accept_terms (bool): Set to true, if the user has accepted the Billbee
            terms &amp; conditions
        address
            (RechnungsdruckWebAppControllersApiAutomaticProvisioningControllerC
            reateAccountContainerUserAddress): Represents the invoice address
            of a Billbee user
        newsletter (bool): Gets or sets if the user is interested in the
            Billbee newsletter
        affiliate_coupon_code (string): Specifies an billbee affiliate code to
            attach to the user
        vat_1_rate (float): Optionally specify the vat1 (normal) rate of the
            user
        vat_2_rate (float): Optionally specify the vat2 (reduced) rate of the
            user
        default_vat_mode (DefaultVatModeEnum): Optionally specify the default
            vat mode of the user
        default_currrency (string): Optionally specify the default currency of
            the user
        default_vat_index (int): Optionally specify the default vat index of
            the user

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "e_mail": 'EMail',
        "password": 'Password',
        "accept_terms": 'AcceptTerms',
        "address": 'Address',
        "newsletter": 'Newsletter',
        "affiliate_coupon_code": 'AffiliateCouponCode',
        "vat_1_rate": 'Vat1Rate',
        "vat_2_rate": 'Vat2Rate',
        "default_vat_mode": 'DefaultVatMode',
        "default_currrency": 'DefaultCurrrency',
        "default_vat_index": 'DefaultVatIndex'
    }

    def __init__(self,
                 e_mail=None,
                 password=None,
                 accept_terms=None,
                 address=None,
                 newsletter=None,
                 affiliate_coupon_code=None,
                 vat_1_rate=None,
                 vat_2_rate=None,
                 default_vat_mode=None,
                 default_currrency=None,
                 default_vat_index=None):
        """Constructor for the RechnungsdruckWebAppControllersApiAutomaticProvisioningControllerCreateAccountContainer class"""

        # Initialize members of the class
        self.e_mail = e_mail
        self.password = password
        self.accept_terms = accept_terms
        self.address = address
        self.newsletter = newsletter
        self.affiliate_coupon_code = affiliate_coupon_code
        self.vat_1_rate = vat_1_rate
        self.vat_2_rate = vat_2_rate
        self.default_vat_mode = default_vat_mode
        self.default_currrency = default_currrency
        self.default_vat_index = default_vat_index

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        e_mail = dictionary.get('EMail')
        password = dictionary.get('Password')
        accept_terms = dictionary.get('AcceptTerms')
        address = RechnungsdruckWebAppControllersApiAutomaticProvisioningControllerCreateAccountContainerUserAddress.from_dictionary(dictionary.get('Address')) if dictionary.get('Address') else None
        newsletter = dictionary.get('Newsletter')
        affiliate_coupon_code = dictionary.get('AffiliateCouponCode')
        vat_1_rate = dictionary.get('Vat1Rate')
        vat_2_rate = dictionary.get('Vat2Rate')
        default_vat_mode = dictionary.get('DefaultVatMode')
        default_currrency = dictionary.get('DefaultCurrrency')
        default_vat_index = dictionary.get('DefaultVatIndex')

        # Return an object of this model
        return cls(e_mail,
                   password,
                   accept_terms,
                   address,
                   newsletter,
                   affiliate_coupon_code,
                   vat_1_rate,
                   vat_2_rate,
                   default_vat_mode,
                   default_currrency,
                   default_vat_index)
