# -*- coding: utf-8 -*-

"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""
from billbeeapi.models.billbee_interfaces_billbee_api_model_product_image import BillbeeInterfacesBillbeeAPIModelProductImage


class BillbeeInterfacesBillbeeAPIModelSoldProduct(object):

    """Implementation of the 'Billbee.Interfaces.BillbeeAPI.Model.SoldProduct' model.

    TODO: type model description here.

    Attributes:
        old_id (string): This is for migration scenarios when the internal id
            of a product changes  I.E. Etsy when switching to the new
            inventory management, the ids for variants will change.
        id (string): The id of this product in the external system
        title (string): The name of this product
        weight (int): Weight of one item in gram
        sku (string): The SKU of this product
        sku_or_id (string): The SKU of this product or the id if the SKU is
            empty
        is_digital (bool): True if the product is a digital good (download
            etc.), false if not
        images (list of BillbeeInterfacesBillbeeAPIModelProductImage): The
            images of this product
        ean (string): The EAN / GTIN of this product
        platform_data (string): Optional platform specific Data as serialized
            JSON Object for the product
        taric_code (string): The TARIC code
        country_of_origin (string): The country where this article was made
        billbee_id (long|int): The Billbee internal id of the linked product

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "old_id": 'OldId',
        "id": 'Id',
        "title": 'Title',
        "weight": 'Weight',
        "sku": 'SKU',
        "sku_or_id": 'SkuOrId',
        "is_digital": 'IsDigital',
        "images": 'Images',
        "ean": 'EAN',
        "platform_data": 'PlatformData',
        "taric_code": 'TARICCode',
        "country_of_origin": 'CountryOfOrigin',
        "billbee_id": 'BillbeeId'
    }

    def __init__(self,
                 old_id=None,
                 id=None,
                 title=None,
                 weight=None,
                 sku=None,
                 sku_or_id=None,
                 is_digital=None,
                 images=None,
                 ean=None,
                 platform_data=None,
                 taric_code=None,
                 country_of_origin=None,
                 billbee_id=None):
        """Constructor for the BillbeeInterfacesBillbeeAPIModelSoldProduct class"""

        # Initialize members of the class
        self.old_id = old_id
        self.id = id
        self.title = title
        self.weight = weight
        self.sku = sku
        self.sku_or_id = sku_or_id
        self.is_digital = is_digital
        self.images = images
        self.ean = ean
        self.platform_data = platform_data
        self.taric_code = taric_code
        self.country_of_origin = country_of_origin
        self.billbee_id = billbee_id

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        old_id = dictionary.get('OldId')
        id = dictionary.get('Id')
        title = dictionary.get('Title')
        weight = dictionary.get('Weight')
        sku = dictionary.get('SKU')
        sku_or_id = dictionary.get('SkuOrId')
        is_digital = dictionary.get('IsDigital')
        images = None
        if dictionary.get('Images') is not None:
            images = [BillbeeInterfacesBillbeeAPIModelProductImage.from_dictionary(x) for x in dictionary.get('Images')]
        ean = dictionary.get('EAN')
        platform_data = dictionary.get('PlatformData')
        taric_code = dictionary.get('TARICCode')
        country_of_origin = dictionary.get('CountryOfOrigin')
        billbee_id = dictionary.get('BillbeeId')

        # Return an object of this model
        return cls(old_id,
                   id,
                   title,
                   weight,
                   sku,
                   sku_or_id,
                   is_digital,
                   images,
                   ean,
                   platform_data,
                   taric_code,
                   country_of_origin,
                   billbee_id)
