# -*- coding: utf-8 -*-

"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""
from billbeeapi.models.billbee_interfaces_billbee_api_model_order_item_attribute import BillbeeInterfacesBillbeeAPIModelOrderItemAttribute
from billbeeapi.models.billbee_interfaces_billbee_api_model_sold_product import BillbeeInterfacesBillbeeAPIModelSoldProduct


class BillbeeInterfacesBillbeeAPIModelOrderItem(object):

    """Implementation of the 'Billbee.Interfaces.BillbeeAPI.Model.OrderItem' model.

    TODO: type model description here.

    Attributes:
        billbee_id (long|int): The billbee id of this item
        transaction_id (string): Id of the individual transaction. Only
            required by Ebay to detect aggregated orders
        product (BillbeeInterfacesBillbeeAPIModelSoldProduct): TODO: type
            description here.
        quantity (float): The sold quantity
        total_price (float): The total price (unit price * quantity)
        tax_amount (float): The tax amount in the total price
        tax_index (int): The tax index.
        discount (float): Sets the discount in percent
        attributes (list of
            BillbeeInterfacesBillbeeAPIModelOrderItemAttribute): A list of
            product attributes for this position
        get_price_from_article_if_any (bool): If true, the price will be
            overwritten by the known article price in billbee if available
        is_coupon (bool): Determines if it is a coupon, which is interpreted
            as tax-free payment
        shipping_profile_id (string): Determines if it is a coupon, which is
            interpreted as tax-free payment
        dont_adjust_stock (bool): If true, the import of this order won't
            adjust the stock level at billbee.
        unrebated_total_price (float): Is just used for the billbee api
        serial_number (string): Contains the used serial number

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "billbee_id": 'BillbeeId',
        "transaction_id": 'TransactionId',
        "product": 'Product',
        "quantity": 'Quantity',
        "total_price": 'TotalPrice',
        "tax_amount": 'TaxAmount',
        "tax_index": 'TaxIndex',
        "discount": 'Discount',
        "attributes": 'Attributes',
        "get_price_from_article_if_any": 'GetPriceFromArticleIfAny',
        "is_coupon": 'IsCoupon',
        "shipping_profile_id": 'ShippingProfileId',
        "dont_adjust_stock": 'DontAdjustStock',
        "unrebated_total_price": 'UnrebatedTotalPrice',
        "serial_number": 'SerialNumber'
    }

    def __init__(self,
                 billbee_id=None,
                 transaction_id=None,
                 product=None,
                 quantity=None,
                 total_price=None,
                 tax_amount=None,
                 tax_index=None,
                 discount=None,
                 attributes=None,
                 get_price_from_article_if_any=None,
                 is_coupon=None,
                 shipping_profile_id=None,
                 dont_adjust_stock=None,
                 unrebated_total_price=None,
                 serial_number=None):
        """Constructor for the BillbeeInterfacesBillbeeAPIModelOrderItem class"""

        # Initialize members of the class
        self.billbee_id = billbee_id
        self.transaction_id = transaction_id
        self.product = product
        self.quantity = quantity
        self.total_price = total_price
        self.tax_amount = tax_amount
        self.tax_index = tax_index
        self.discount = discount
        self.attributes = attributes
        self.get_price_from_article_if_any = get_price_from_article_if_any
        self.is_coupon = is_coupon
        self.shipping_profile_id = shipping_profile_id
        self.dont_adjust_stock = dont_adjust_stock
        self.unrebated_total_price = unrebated_total_price
        self.serial_number = serial_number

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        billbee_id = dictionary.get('BillbeeId')
        transaction_id = dictionary.get('TransactionId')
        product = BillbeeInterfacesBillbeeAPIModelSoldProduct.from_dictionary(dictionary.get('Product')) if dictionary.get('Product') else None
        quantity = dictionary.get('Quantity')
        total_price = dictionary.get('TotalPrice')
        tax_amount = dictionary.get('TaxAmount')
        tax_index = dictionary.get('TaxIndex')
        discount = dictionary.get('Discount')
        attributes = None
        if dictionary.get('Attributes') is not None:
            attributes = [BillbeeInterfacesBillbeeAPIModelOrderItemAttribute.from_dictionary(x) for x in dictionary.get('Attributes')]
        get_price_from_article_if_any = dictionary.get('GetPriceFromArticleIfAny')
        is_coupon = dictionary.get('IsCoupon')
        shipping_profile_id = dictionary.get('ShippingProfileId')
        dont_adjust_stock = dictionary.get('DontAdjustStock')
        unrebated_total_price = dictionary.get('UnrebatedTotalPrice')
        serial_number = dictionary.get('SerialNumber')

        # Return an object of this model
        return cls(billbee_id,
                   transaction_id,
                   product,
                   quantity,
                   total_price,
                   tax_amount,
                   tax_index,
                   discount,
                   attributes,
                   get_price_from_article_if_any,
                   is_coupon,
                   shipping_profile_id,
                   dont_adjust_stock,
                   unrebated_total_price,
                   serial_number)
