# -*- coding: utf-8 -*-

"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""
from billbeeapi.api_helper import APIHelper
from billbeeapi.models.billbee_interfaces_billbee_api_model_comment_api_model import BillbeeInterfacesBillbeeAPIModelCommentApiModel
from billbeeapi.models.billbee_interfaces_billbee_api_model_customer_api_model import BillbeeInterfacesBillbeeAPIModelCustomerApiModel
from billbeeapi.models.billbee_interfaces_billbee_api_model_order_address_api_model import BillbeeInterfacesBillbeeAPIModelOrderAddressApiModel
from billbeeapi.models.billbee_interfaces_billbee_api_model_order_item import BillbeeInterfacesBillbeeAPIModelOrderItem
from billbeeapi.models.billbee_interfaces_billbee_api_model_order_user import BillbeeInterfacesBillbeeAPIModelOrderUser
from billbeeapi.models.billbee_interfaces_billbee_api_model_shipment import BillbeeInterfacesBillbeeAPIModelShipment
from billbeeapi.models.billbee_interfaces_billbee_api_models_order_payment import BillbeeInterfacesBillbeeAPIModelsOrderPayment
from billbeeapi.models.billbee_interfaces_order_history_entry import BillbeeInterfacesOrderHistoryEntry
from billbeeapi.models.billbee_interfaces_shipping_product_service import BillbeeInterfacesShippingProductService


class BillbeeInterfacesBillbeeAPIModelOrder(object):

    """Implementation of the 'Billbee.Interfaces.BillbeeAPI.Model.Order' model.

    A class that represents the Billbee data model of a single order

    Attributes:
        rebate_difference (float): TODO: type description here.
        shipping_ids (list of BillbeeInterfacesBillbeeAPIModelShipment): The
            shipments of the order
        accept_loss_of_return_right (bool): Customer accepts loss due to
            withdrawal
        id (string): Id of the order in the external system (marketplace)
        order_number (string): Order number of the order in the external
            system (marketplace)
        state (StateEnum): The current state of the order
        vat_mode (VatModeEnum): The vat mode of the order
        created_at (datetime): The date on which the order was created
        shipped_at (datetime): The date on which the order was shipped
        confirmed_at (datetime): The date on which the order was confirmed
        payed_at (datetime): The date on which the order was paid
        seller_comment (string): An internal seller comment
        comments (list of BillbeeInterfacesBillbeeAPIModelCommentApiModel):
            All messages / comments of the order
        invoice_number_prefix (string): The prefix of the invoice number
        invoice_number_postfix (string): The postfix of the invoice number
        invoice_number (int): The invoice number
        invoice_date (datetime): The date on which the invoice was created
        invoice_address
            (BillbeeInterfacesBillbeeAPIModelOrderAddressApiModel): TODO: type
            description here.
        shipping_address
            (BillbeeInterfacesBillbeeAPIModelOrderAddressApiModel): TODO: type
            description here.
        payment_method (PaymentMethodEnum): The payment method
        shipping_cost (float): The shipping cost
        total_cost (float): The total cost excluding shipping cost
        adjustment_cost (float): TODO: type description here.
        adjustment_reason (string): TODO: type description here.
        order_items (list of BillbeeInterfacesBillbeeAPIModelOrderItem): The
            list of items purchased like shirt, pant, toys etc
        currency (string): The three letter currency code.
        seller (BillbeeInterfacesBillbeeAPIModelOrderUser): TODO: type
            description here.
        buyer (BillbeeInterfacesBillbeeAPIModelOrderUser): TODO: type
            description here.
        updated_at (datetime): The date on which the order was last updated
        tax_rate_1 (float): The regular tax rate
        tax_rate_2 (float): The reduced tax rate
        bill_bee_order_id (long|int): The Order.Id from the Billbee database
        bill_bee_parent_order_id (long|int): The Id of the parent order in the
            Billbee database
        vat_id (string): The customers vat id
        tags (list of string): The Tags of the order
        ship_weight_kg (float): The total weight of the shipment(s)
        language_code (string): The two-letter language code of the customer
        paid_amount (float): TODO: type description here.
        shipping_profile_id (string): Internal Id for the shipping profile for
            that order
        shipping_provider_id (long|int): Internal Id for the used shipping
            provider
        shipping_provider_product_id (long|int): Internal Id for the used
            shipping product
        shipping_provider_name (string): The Name for of used shipping
            provider
        shipping_provider_product_name (string): The Name of the used shipping
            product
        shipping_profile_name (string): Display Name of Shipping profile, if
            available
        payment_instruction (string): A textfield optionaly filled with a
            payment instruction text for printout on the invoice (z.B. Ebay
            Kauf auf Rechnung)
        is_cancelation_for (string): An optional Order Id (externalid) for an
            order if this is a cancel order (shopify only at the moment)
        payment_transaction_id (string): The id of the payment transaction.
            For example the transaction id of PayPal payment. Should not be
            used any more. Please use 'Payments' instead.
        distribution_center (string): An optional code for the distribution
            center delivering this order
        delivery_source_country_code (string): An optional Country ISO2 Code
            of the country where order is shipped from (FBA)
        custom_invoice_note (string): An optional multiline text which is
            printed on the invoice
        customer_number (string): The customer number (not to be confused with
            the id of the customer)
        payment_reference (string): A payment reference. Should not be used
            any more. Please use 'Payments' instead.
        shipping_services (list of BillbeeInterfacesShippingProductService):
            Additional services for the shipment
        customer (BillbeeInterfacesBillbeeAPIModelCustomerApiModel): TODO:
            type description here.
        history (list of BillbeeInterfacesOrderHistoryEntry): TODO: type
            description here.
        payments (list of BillbeeInterfacesBillbeeAPIModelsOrderPayment):
            TODO: type description here.
        last_modified_at (datetime): Date of the last update, the order got

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "rebate_difference": 'RebateDifference',
        "shipping_ids": 'ShippingIds',
        "accept_loss_of_return_right": 'AcceptLossOfReturnRight',
        "id": 'Id',
        "order_number": 'OrderNumber',
        "state": 'State',
        "vat_mode": 'VatMode',
        "created_at": 'CreatedAt',
        "shipped_at": 'ShippedAt',
        "confirmed_at": 'ConfirmedAt',
        "payed_at": 'PayedAt',
        "seller_comment": 'SellerComment',
        "comments": 'Comments',
        "invoice_number_prefix": 'InvoiceNumberPrefix',
        "invoice_number_postfix": 'InvoiceNumberPostfix',
        "invoice_number": 'InvoiceNumber',
        "invoice_date": 'InvoiceDate',
        "invoice_address": 'InvoiceAddress',
        "shipping_address": 'ShippingAddress',
        "payment_method": 'PaymentMethod',
        "shipping_cost": 'ShippingCost',
        "total_cost": 'TotalCost',
        "adjustment_cost": 'AdjustmentCost',
        "adjustment_reason": 'AdjustmentReason',
        "order_items": 'OrderItems',
        "currency": 'Currency',
        "seller": 'Seller',
        "buyer": 'Buyer',
        "updated_at": 'UpdatedAt',
        "tax_rate_1": 'TaxRate1',
        "tax_rate_2": 'TaxRate2',
        "bill_bee_order_id": 'BillBeeOrderId',
        "bill_bee_parent_order_id": 'BillBeeParentOrderId',
        "vat_id": 'VatId',
        "tags": 'Tags',
        "ship_weight_kg": 'ShipWeightKg',
        "language_code": 'LanguageCode',
        "paid_amount": 'PaidAmount',
        "shipping_profile_id": 'ShippingProfileId',
        "shipping_provider_id": 'ShippingProviderId',
        "shipping_provider_product_id": 'ShippingProviderProductId',
        "shipping_provider_name": 'ShippingProviderName',
        "shipping_provider_product_name": 'ShippingProviderProductName',
        "shipping_profile_name": 'ShippingProfileName',
        "payment_instruction": 'PaymentInstruction',
        "is_cancelation_for": 'IsCancelationFor',
        "payment_transaction_id": 'PaymentTransactionId',
        "distribution_center": 'DistributionCenter',
        "delivery_source_country_code": 'DeliverySourceCountryCode',
        "custom_invoice_note": 'CustomInvoiceNote',
        "customer_number": 'CustomerNumber',
        "payment_reference": 'PaymentReference',
        "shipping_services": 'ShippingServices',
        "customer": 'Customer',
        "history": 'History',
        "payments": 'Payments',
        "last_modified_at": 'LastModifiedAt'
    }

    def __init__(self,
                 rebate_difference=None,
                 shipping_ids=None,
                 accept_loss_of_return_right=None,
                 id=None,
                 order_number=None,
                 state=None,
                 vat_mode=None,
                 created_at=None,
                 shipped_at=None,
                 confirmed_at=None,
                 payed_at=None,
                 seller_comment=None,
                 comments=None,
                 invoice_number_prefix=None,
                 invoice_number_postfix=None,
                 invoice_number=None,
                 invoice_date=None,
                 invoice_address=None,
                 shipping_address=None,
                 payment_method=None,
                 shipping_cost=None,
                 total_cost=None,
                 adjustment_cost=None,
                 adjustment_reason=None,
                 order_items=None,
                 currency=None,
                 seller=None,
                 buyer=None,
                 updated_at=None,
                 tax_rate_1=None,
                 tax_rate_2=None,
                 bill_bee_order_id=None,
                 bill_bee_parent_order_id=None,
                 vat_id=None,
                 tags=None,
                 ship_weight_kg=None,
                 language_code=None,
                 paid_amount=None,
                 shipping_profile_id=None,
                 shipping_provider_id=None,
                 shipping_provider_product_id=None,
                 shipping_provider_name=None,
                 shipping_provider_product_name=None,
                 shipping_profile_name=None,
                 payment_instruction=None,
                 is_cancelation_for=None,
                 payment_transaction_id=None,
                 distribution_center=None,
                 delivery_source_country_code=None,
                 custom_invoice_note=None,
                 customer_number=None,
                 payment_reference=None,
                 shipping_services=None,
                 customer=None,
                 history=None,
                 payments=None,
                 last_modified_at=None):
        """Constructor for the BillbeeInterfacesBillbeeAPIModelOrder class"""

        # Initialize members of the class
        self.rebate_difference = rebate_difference
        self.shipping_ids = shipping_ids
        self.accept_loss_of_return_right = accept_loss_of_return_right
        self.id = id
        self.order_number = order_number
        self.state = state
        self.vat_mode = vat_mode
        self.created_at = APIHelper.RFC3339DateTime(created_at) if created_at else None
        self.shipped_at = APIHelper.RFC3339DateTime(shipped_at) if shipped_at else None
        self.confirmed_at = APIHelper.RFC3339DateTime(confirmed_at) if confirmed_at else None
        self.payed_at = APIHelper.RFC3339DateTime(payed_at) if payed_at else None
        self.seller_comment = seller_comment
        self.comments = comments
        self.invoice_number_prefix = invoice_number_prefix
        self.invoice_number_postfix = invoice_number_postfix
        self.invoice_number = invoice_number
        self.invoice_date = APIHelper.RFC3339DateTime(invoice_date) if invoice_date else None
        self.invoice_address = invoice_address
        self.shipping_address = shipping_address
        self.payment_method = payment_method
        self.shipping_cost = shipping_cost
        self.total_cost = total_cost
        self.adjustment_cost = adjustment_cost
        self.adjustment_reason = adjustment_reason
        self.order_items = order_items
        self.currency = currency
        self.seller = seller
        self.buyer = buyer
        self.updated_at = APIHelper.RFC3339DateTime(updated_at) if updated_at else None
        self.tax_rate_1 = tax_rate_1
        self.tax_rate_2 = tax_rate_2
        self.bill_bee_order_id = bill_bee_order_id
        self.bill_bee_parent_order_id = bill_bee_parent_order_id
        self.vat_id = vat_id
        self.tags = tags
        self.ship_weight_kg = ship_weight_kg
        self.language_code = language_code
        self.paid_amount = paid_amount
        self.shipping_profile_id = shipping_profile_id
        self.shipping_provider_id = shipping_provider_id
        self.shipping_provider_product_id = shipping_provider_product_id
        self.shipping_provider_name = shipping_provider_name
        self.shipping_provider_product_name = shipping_provider_product_name
        self.shipping_profile_name = shipping_profile_name
        self.payment_instruction = payment_instruction
        self.is_cancelation_for = is_cancelation_for
        self.payment_transaction_id = payment_transaction_id
        self.distribution_center = distribution_center
        self.delivery_source_country_code = delivery_source_country_code
        self.custom_invoice_note = custom_invoice_note
        self.customer_number = customer_number
        self.payment_reference = payment_reference
        self.shipping_services = shipping_services
        self.customer = customer
        self.history = history
        self.payments = payments
        self.last_modified_at = APIHelper.RFC3339DateTime(last_modified_at) if last_modified_at else None

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        rebate_difference = dictionary.get('RebateDifference')
        shipping_ids = None
        if dictionary.get('ShippingIds') is not None:
            shipping_ids = [BillbeeInterfacesBillbeeAPIModelShipment.from_dictionary(x) for x in dictionary.get('ShippingIds')]
        accept_loss_of_return_right = dictionary.get('AcceptLossOfReturnRight')
        id = dictionary.get('Id')
        order_number = dictionary.get('OrderNumber')
        state = dictionary.get('State')
        vat_mode = dictionary.get('VatMode')
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("CreatedAt")).datetime if dictionary.get("CreatedAt") else None
        shipped_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("ShippedAt")).datetime if dictionary.get("ShippedAt") else None
        confirmed_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("ConfirmedAt")).datetime if dictionary.get("ConfirmedAt") else None
        payed_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("PayedAt")).datetime if dictionary.get("PayedAt") else None
        seller_comment = dictionary.get('SellerComment')
        comments = None
        if dictionary.get('Comments') is not None:
            comments = [BillbeeInterfacesBillbeeAPIModelCommentApiModel.from_dictionary(x) for x in dictionary.get('Comments')]
        invoice_number_prefix = dictionary.get('InvoiceNumberPrefix')
        invoice_number_postfix = dictionary.get('InvoiceNumberPostfix')
        invoice_number = dictionary.get('InvoiceNumber')
        invoice_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("InvoiceDate")).datetime if dictionary.get("InvoiceDate") else None
        invoice_address = BillbeeInterfacesBillbeeAPIModelOrderAddressApiModel.from_dictionary(dictionary.get('InvoiceAddress')) if dictionary.get('InvoiceAddress') else None
        shipping_address = BillbeeInterfacesBillbeeAPIModelOrderAddressApiModel.from_dictionary(dictionary.get('ShippingAddress')) if dictionary.get('ShippingAddress') else None
        payment_method = dictionary.get('PaymentMethod')
        shipping_cost = dictionary.get('ShippingCost')
        total_cost = dictionary.get('TotalCost')
        adjustment_cost = dictionary.get('AdjustmentCost')
        adjustment_reason = dictionary.get('AdjustmentReason')
        order_items = None
        if dictionary.get('OrderItems') is not None:
            order_items = [BillbeeInterfacesBillbeeAPIModelOrderItem.from_dictionary(x) for x in dictionary.get('OrderItems')]
        currency = dictionary.get('Currency')
        seller = BillbeeInterfacesBillbeeAPIModelOrderUser.from_dictionary(dictionary.get('Seller')) if dictionary.get('Seller') else None
        buyer = BillbeeInterfacesBillbeeAPIModelOrderUser.from_dictionary(dictionary.get('Buyer')) if dictionary.get('Buyer') else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("UpdatedAt")).datetime if dictionary.get("UpdatedAt") else None
        tax_rate_1 = dictionary.get('TaxRate1')
        tax_rate_2 = dictionary.get('TaxRate2')
        bill_bee_order_id = dictionary.get('BillBeeOrderId')
        bill_bee_parent_order_id = dictionary.get('BillBeeParentOrderId')
        vat_id = dictionary.get('VatId')
        tags = dictionary.get('Tags')
        ship_weight_kg = dictionary.get('ShipWeightKg')
        language_code = dictionary.get('LanguageCode')
        paid_amount = dictionary.get('PaidAmount')
        shipping_profile_id = dictionary.get('ShippingProfileId')
        shipping_provider_id = dictionary.get('ShippingProviderId')
        shipping_provider_product_id = dictionary.get('ShippingProviderProductId')
        shipping_provider_name = dictionary.get('ShippingProviderName')
        shipping_provider_product_name = dictionary.get('ShippingProviderProductName')
        shipping_profile_name = dictionary.get('ShippingProfileName')
        payment_instruction = dictionary.get('PaymentInstruction')
        is_cancelation_for = dictionary.get('IsCancelationFor')
        payment_transaction_id = dictionary.get('PaymentTransactionId')
        distribution_center = dictionary.get('DistributionCenter')
        delivery_source_country_code = dictionary.get('DeliverySourceCountryCode')
        custom_invoice_note = dictionary.get('CustomInvoiceNote')
        customer_number = dictionary.get('CustomerNumber')
        payment_reference = dictionary.get('PaymentReference')
        shipping_services = None
        if dictionary.get('ShippingServices') is not None:
            shipping_services = [BillbeeInterfacesShippingProductService.from_dictionary(x) for x in dictionary.get('ShippingServices')]
        customer = BillbeeInterfacesBillbeeAPIModelCustomerApiModel.from_dictionary(dictionary.get('Customer')) if dictionary.get('Customer') else None
        history = None
        if dictionary.get('History') is not None:
            history = [BillbeeInterfacesOrderHistoryEntry.from_dictionary(x) for x in dictionary.get('History')]
        payments = None
        if dictionary.get('Payments') is not None:
            payments = [BillbeeInterfacesBillbeeAPIModelsOrderPayment.from_dictionary(x) for x in dictionary.get('Payments')]
        last_modified_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("LastModifiedAt")).datetime if dictionary.get("LastModifiedAt") else None

        # Return an object of this model
        return cls(rebate_difference,
                   shipping_ids,
                   accept_loss_of_return_right,
                   id,
                   order_number,
                   state,
                   vat_mode,
                   created_at,
                   shipped_at,
                   confirmed_at,
                   payed_at,
                   seller_comment,
                   comments,
                   invoice_number_prefix,
                   invoice_number_postfix,
                   invoice_number,
                   invoice_date,
                   invoice_address,
                   shipping_address,
                   payment_method,
                   shipping_cost,
                   total_cost,
                   adjustment_cost,
                   adjustment_reason,
                   order_items,
                   currency,
                   seller,
                   buyer,
                   updated_at,
                   tax_rate_1,
                   tax_rate_2,
                   bill_bee_order_id,
                   bill_bee_parent_order_id,
                   vat_id,
                   tags,
                   ship_weight_kg,
                   language_code,
                   paid_amount,
                   shipping_profile_id,
                   shipping_provider_id,
                   shipping_provider_product_id,
                   shipping_provider_name,
                   shipping_provider_product_name,
                   shipping_profile_name,
                   payment_instruction,
                   is_cancelation_for,
                   payment_transaction_id,
                   distribution_center,
                   delivery_source_country_code,
                   custom_invoice_note,
                   customer_number,
                   payment_reference,
                   shipping_services,
                   customer,
                   history,
                   payments,
                   last_modified_at)
