# -*- coding: utf-8 -*-

"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""
from billbeeapi.api_helper import APIHelper
from billbeeapi.models.billbee_interfaces_billbee_api_model_shipment_address_api_model import BillbeeInterfacesBillbeeAPIModelShipmentAddressApiModel
from billbeeapi.models.billbee_interfaces_shipping_product_service import BillbeeInterfacesShippingProductService
from billbeeapi.models.billbee_interfaces_shipping_shipment_data_dimensions import BillbeeInterfacesShippingShipmentDataDimensions


class BillbeeInterfacesBillbeeAPIModelCreateShipmentApiModel(object):

    """Implementation of the 'Billbee.Interfaces.BillbeeAPI.Model.CreateShipmentApiModel' model.

    TODO: type model description here.

    Attributes:
        provider_name (string): The name of the provider as specified in the
            billbee account
        product_code (string): The productcode to be used when creating the
            shipment. Values depends on the carrier used
        printer_name (string): The name of a connected Cloudprinter to sent
            the label to
        printer_id_for_export_docs (long|int): The id of a connected
            Cloudprinter to sent the export docs to
        services (list of BillbeeInterfacesShippingProductService): A list of
            services to be used when creating the shipment
        receiver_address
            (BillbeeInterfacesBillbeeAPIModelShipmentAddressApiModel): TODO:
            type description here.
        client_reference (string): Optional specify a text to be included on
            the label. Not possible with all carriers
        customer_number (string): Not used anymore
        weight_in_gram (float): Optional specify the weight in gram of the
            shipment
        order_sum (float): The value of the shipments content
        order_currency_code (string): The Currency if the ordersum
        content (string): Optional specify a text describing the content of
            the shipment. Used for export shipments
        ship_date (datetime): Optional overwrite the shipdate to be
            transferred to the carrier
        shipping_carrier (ShippingCarrierEnum): TODO: type description here.
        dimension (BillbeeInterfacesShippingShipmentDataDimensions): TODO:
            type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "provider_name": 'ProviderName',
        "product_code": 'ProductCode',
        "printer_name": 'PrinterName',
        "printer_id_for_export_docs": 'PrinterIdForExportDocs',
        "services": 'Services',
        "receiver_address": 'ReceiverAddress',
        "client_reference": 'ClientReference',
        "customer_number": 'CustomerNumber',
        "weight_in_gram": 'WeightInGram',
        "order_sum": 'OrderSum',
        "order_currency_code": 'OrderCurrencyCode',
        "content": 'Content',
        "ship_date": 'ShipDate',
        "shipping_carrier": 'shippingCarrier',
        "dimension": 'Dimension'
    }

    def __init__(self,
                 provider_name=None,
                 product_code=None,
                 printer_name=None,
                 printer_id_for_export_docs=None,
                 services=None,
                 receiver_address=None,
                 client_reference=None,
                 customer_number=None,
                 weight_in_gram=None,
                 order_sum=None,
                 order_currency_code=None,
                 content=None,
                 ship_date=None,
                 shipping_carrier=None,
                 dimension=None):
        """Constructor for the BillbeeInterfacesBillbeeAPIModelCreateShipmentApiModel class"""

        # Initialize members of the class
        self.provider_name = provider_name
        self.product_code = product_code
        self.printer_name = printer_name
        self.printer_id_for_export_docs = printer_id_for_export_docs
        self.services = services
        self.receiver_address = receiver_address
        self.client_reference = client_reference
        self.customer_number = customer_number
        self.weight_in_gram = weight_in_gram
        self.order_sum = order_sum
        self.order_currency_code = order_currency_code
        self.content = content
        self.ship_date = APIHelper.RFC3339DateTime(ship_date) if ship_date else None
        self.shipping_carrier = shipping_carrier
        self.dimension = dimension

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        provider_name = dictionary.get('ProviderName')
        product_code = dictionary.get('ProductCode')
        printer_name = dictionary.get('PrinterName')
        printer_id_for_export_docs = dictionary.get('PrinterIdForExportDocs')
        services = None
        if dictionary.get('Services') is not None:
            services = [BillbeeInterfacesShippingProductService.from_dictionary(x) for x in dictionary.get('Services')]
        receiver_address = BillbeeInterfacesBillbeeAPIModelShipmentAddressApiModel.from_dictionary(dictionary.get('ReceiverAddress')) if dictionary.get('ReceiverAddress') else None
        client_reference = dictionary.get('ClientReference')
        customer_number = dictionary.get('CustomerNumber')
        weight_in_gram = dictionary.get('WeightInGram')
        order_sum = dictionary.get('OrderSum')
        order_currency_code = dictionary.get('OrderCurrencyCode')
        content = dictionary.get('Content')
        ship_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("ShipDate")).datetime if dictionary.get("ShipDate") else None
        shipping_carrier = dictionary.get('shippingCarrier')
        dimension = BillbeeInterfacesShippingShipmentDataDimensions.from_dictionary(dictionary.get('Dimension')) if dictionary.get('Dimension') else None

        # Return an object of this model
        return cls(provider_name,
                   product_code,
                   printer_name,
                   printer_id_for_export_docs,
                   services,
                   receiver_address,
                   client_reference,
                   customer_number,
                   weight_in_gram,
                   order_sum,
                   order_currency_code,
                   content,
                   ship_date,
                   shipping_carrier,
                   dimension)
