# -*- coding: utf-8 -*-

"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from billbeeapi.api_helper import APIHelper
from billbeeapi.configuration import Server
from billbeeapi.controllers.base_controller import BaseController
from billbeeapi.http.auth.basic_auth import BasicAuth
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_rechnungsdruck_web_app_controllers_api_shipment_with_label_result import RechnungsdruckWebAppControllersApiApiResultRechnungsdruckWebAppControllersApiShipmentWithLabelResult
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_shipment import RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelShipment


class ShipmentsController(BaseController):

    """A Controller to access Endpoints in the billbeeapi API."""

    def __init__(self, config, call_back=None):
        super(ShipmentsController, self).__init__(config, call_back)

    def shipment_post_shipment(self,
                               model):
        """Does a POST request to /api/v1/shipment/shipment.

        Creates a new shipment with the selected Shippingprovider

        Args:
            model (BillbeeInterfacesBillbeeAPIModelCreateShipmentApiModel):
                Data to specify shipment parameters

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/v1/shipment/shipment'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(model))
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def shipment_get_shippingproviders(self):
        """Does a GET request to /api/v1/shipment/shippingproviders.

        Query all defined shipping providers

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/v1/shipment/shippingproviders'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def shipment_ship_with_label(self,
                                 shipment_information):
        """Does a POST request to /api/v1/shipment/shipwithlabel.

        Creates a shipment for an order in billbee

        Args:
            shipment_information
                (RechnungsdruckWebAppControllersApiShipmentWithLabel): Details
                on the order and the shipping methods, that should be used.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultRechnungsdruckWebAppCont
                rollersApiShipmentWithLabelResult: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/v1/shipment/shipwithlabel'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(shipment_information))
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, RechnungsdruckWebAppControllersApiApiResultRechnungsdruckWebAppControllersApiShipmentWithLabelResult.from_dictionary)

        return decoded

    def shipment_get_shipping_carrier(self):
        """Does a GET request to /api/v1/shipment/shippingcarriers.

        Queries the currently available shipping carriers.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/v1/shipment/shippingcarriers'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def shipment_get_ping(self):
        """Does a GET request to /api/v1/shipment/ping.

        TODO: type endpoint description here.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/v1/shipment/ping'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def shipment_get_list(self,
                          page=None,
                          page_size=None,
                          created_at_min=None,
                          created_at_max=None,
                          order_id=None,
                          minimum_shipment_id=None,
                          shipping_provider_id=None):
        """Does a GET request to /api/v1/shipment/shipments.

        Get a list of all shipments optionally filtered by date. All
        parameters are optional.

        Args:
            page (int, optional): Specifies the page to request.
            page_size (int, optional): Specifies the pagesize. Defaults to 50,
                max value is 250
            created_at_min (datetime, optional): Specifies the oldest shipment
                date to include in the response
            created_at_max (datetime, optional): Specifies the newest shipment
                date to include in the response
            order_id (long|int, optional): Get shipments for this order only.
            minimum_shipment_id (long|int, optional): Get Shipments with a
                shipment greater or equal than this id. New shipments have a
                greater id than older shipments.
            shipping_provider_id (long|int, optional): Get Shippings for the
                specified shipping provider only. <seealso
                cref="M:Rechnungsdruck.WebApp.Controllers.Api.ShipmentControlle
                r.GetShippingproviders" />

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListBillbeeInterfacesBillbeeAPIModelShipment: Response
                from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/v1/shipment/shipments'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'pageSize': page_size,
            'createdAtMin': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_at_min),
            'createdAtMax': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_at_max),
            'orderId': order_id,
            'minimumShipmentId': minimum_shipment_id,
            'shippingProviderId': shipping_provider_id
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelShipment.from_dictionary)

        return decoded
