"""
    Perun RPC API

    Perun Remote Procedure Calls Application Programming Interface  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Contact: perun@cesnet.cz
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from perun.connector.perun_openapi.api_client import ApiClient, Endpoint as _Endpoint
from perun.connector.perun_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from perun.connector.perun_openapi.model.attribute import Attribute
from perun.connector.perun_openapi.model.attribute_definition import AttributeDefinition
from perun.connector.perun_openapi.model.attribute_policy_collection import (
    AttributePolicyCollection,
)
from perun.connector.perun_openapi.model.attribute_rights import AttributeRights
from perun.connector.perun_openapi.model.entityless_attributes_by_keys import (
    EntitylessAttributesByKeys,
)
from perun.connector.perun_openapi.model.graph_dto import GraphDTO
from perun.connector.perun_openapi.model.graph_file_format import GraphFileFormat
from perun.connector.perun_openapi.model.input_attribute_definition import (
    InputAttributeDefinition,
)
from perun.connector.perun_openapi.model.input_attribute_policy_collections import (
    InputAttributePolicyCollections,
)
from perun.connector.perun_openapi.model.input_attribute_rights import (
    InputAttributeRights,
)
from perun.connector.perun_openapi.model.input_create_attribute_definition import (
    InputCreateAttributeDefinition,
)
from perun.connector.perun_openapi.model.input_entityless_attribute import (
    InputEntitylessAttribute,
)
from perun.connector.perun_openapi.model.input_set_facility_attribute import (
    InputSetFacilityAttribute,
)
from perun.connector.perun_openapi.model.input_set_facility_attributes import (
    InputSetFacilityAttributes,
)
from perun.connector.perun_openapi.model.input_set_facility_resource_group_user_member_attributes import (
    InputSetFacilityResourceGroupUserMemberAttributes,
)
from perun.connector.perun_openapi.model.input_set_facility_resource_user_member_attributes import (
    InputSetFacilityResourceUserMemberAttributes,
)
from perun.connector.perun_openapi.model.input_set_facility_user_attributes import (
    InputSetFacilityUserAttributes,
)
from perun.connector.perun_openapi.model.input_set_group_attribute import (
    InputSetGroupAttribute,
)
from perun.connector.perun_openapi.model.input_set_group_attributes import (
    InputSetGroupAttributes,
)
from perun.connector.perun_openapi.model.input_set_group_resource_attribute import (
    InputSetGroupResourceAttribute,
)
from perun.connector.perun_openapi.model.input_set_group_resource_attributes import (
    InputSetGroupResourceAttributes,
)
from perun.connector.perun_openapi.model.input_set_host_attribute import (
    InputSetHostAttribute,
)
from perun.connector.perun_openapi.model.input_set_host_attributes import (
    InputSetHostAttributes,
)
from perun.connector.perun_openapi.model.input_set_member_attribute import (
    InputSetMemberAttribute,
)
from perun.connector.perun_openapi.model.input_set_member_attributes import (
    InputSetMemberAttributes,
)
from perun.connector.perun_openapi.model.input_set_member_group_attribute import (
    InputSetMemberGroupAttribute,
)
from perun.connector.perun_openapi.model.input_set_member_group_attributes import (
    InputSetMemberGroupAttributes,
)
from perun.connector.perun_openapi.model.input_set_member_group_with_user_attributes import (
    InputSetMemberGroupWithUserAttributes,
)
from perun.connector.perun_openapi.model.input_set_member_resource_and_user_attributes import (
    InputSetMemberResourceAndUserAttributes,
)
from perun.connector.perun_openapi.model.input_set_member_resource_attribute import (
    InputSetMemberResourceAttribute,
)
from perun.connector.perun_openapi.model.input_set_member_resource_attributes import (
    InputSetMemberResourceAttributes,
)
from perun.connector.perun_openapi.model.input_set_member_with_user_attributes import (
    InputSetMemberWithUserAttributes,
)
from perun.connector.perun_openapi.model.input_set_resource_attribute import (
    InputSetResourceAttribute,
)
from perun.connector.perun_openapi.model.input_set_resource_attributes import (
    InputSetResourceAttributes,
)
from perun.connector.perun_openapi.model.input_set_resource_group_attributes import (
    InputSetResourceGroupAttributes,
)
from perun.connector.perun_openapi.model.input_set_resource_group_with_group_attributes import (
    InputSetResourceGroupWithGroupAttributes,
)
from perun.connector.perun_openapi.model.input_set_user_attribute import (
    InputSetUserAttribute,
)
from perun.connector.perun_openapi.model.input_set_user_attributes import (
    InputSetUserAttributes,
)
from perun.connector.perun_openapi.model.input_set_user_ext_source_attribute import (
    InputSetUserExtSourceAttribute,
)
from perun.connector.perun_openapi.model.input_set_user_ext_source_attributes import (
    InputSetUserExtSourceAttributes,
)
from perun.connector.perun_openapi.model.input_set_user_facility_attribute import (
    InputSetUserFacilityAttribute,
)
from perun.connector.perun_openapi.model.input_set_user_facility_attributes import (
    InputSetUserFacilityAttributes,
)
from perun.connector.perun_openapi.model.input_set_vo_attribute import (
    InputSetVoAttribute,
)
from perun.connector.perun_openapi.model.input_set_vo_attributes import (
    InputSetVoAttributes,
)
from perun.connector.perun_openapi.model.perun_exception import PerunException


class AttributesManagerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.convert_attribute_to_nonunique_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/convertAttributeToNonunique",
                "operation_id": "convert_attribute_to_nonunique",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute_definition",
                ],
                "required": [
                    "attribute_definition",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute_definition": (int,),
                },
                "attribute_map": {
                    "attribute_definition": "attributeDefinition",
                },
                "location_map": {
                    "attribute_definition": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.convert_attribute_to_unique_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/convertAttributeToUnique",
                "operation_id": "convert_attribute_to_unique",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute_definition",
                ],
                "required": [
                    "attribute_definition",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute_definition": (int,),
                },
                "attribute_map": {
                    "attribute_definition": "attributeDefinition",
                },
                "location_map": {
                    "attribute_definition": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.create_attribute_definition_endpoint = _Endpoint(
            settings={
                "response_type": (AttributeDefinition,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/createAttribute",
                "operation_id": "create_attribute_definition",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_create_attribute_definition",
                ],
                "required": [
                    "input_create_attribute_definition",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_create_attribute_definition": (
                        InputCreateAttributeDefinition,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_create_attribute_definition": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.delete_attribute_definition_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/deleteAttribute",
                "operation_id": "delete_attribute_definition",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute",
                ],
                "required": [
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute": (int,),
                },
                "attribute_map": {
                    "attribute": "attribute",
                },
                "location_map": {
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.delete_attribute_definitions_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/deleteAttributes",
                "operation_id": "delete_attribute_definitions",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "attributes",
                ],
                "required": [
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_all_attribute_definitions_endpoint = _Endpoint(
            settings={
                "response_type": ([AttributeDefinition],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributesDefinition",
                "operation_id": "get_all_attribute_definitions",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/any",
                "operation_id": "get_attribute",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute_name",
                    "attribute_id",
                    "facility",
                    "user",
                    "vo",
                    "resource",
                    "member",
                    "group",
                    "host",
                    "user_ext_source",
                    "key",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute_name": (str,),
                    "attribute_id": (int,),
                    "facility": (int,),
                    "user": (int,),
                    "vo": (int,),
                    "resource": (int,),
                    "member": (int,),
                    "group": (int,),
                    "host": (int,),
                    "user_ext_source": (int,),
                    "key": (str,),
                },
                "attribute_map": {
                    "attribute_name": "attributeName",
                    "attribute_id": "attributeId",
                    "facility": "facility",
                    "user": "user",
                    "vo": "vo",
                    "resource": "resource",
                    "member": "member",
                    "group": "group",
                    "host": "host",
                    "user_ext_source": "userExtSource",
                    "key": "key",
                },
                "location_map": {
                    "attribute_name": "query",
                    "attribute_id": "query",
                    "facility": "query",
                    "user": "query",
                    "vo": "query",
                    "resource": "query",
                    "member": "query",
                    "group": "query",
                    "host": "query",
                    "user_ext_source": "query",
                    "key": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_definition_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (AttributeDefinition,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributeDefinitionById",
                "operation_id": "get_attribute_definition_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "id",
                ],
                "required": [
                    "id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "id": (int,),
                },
                "attribute_map": {
                    "id": "id",
                },
                "location_map": {
                    "id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_definition_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (AttributeDefinition,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributeDefinition",
                "operation_id": "get_attribute_definition_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute_name",
                ],
                "required": [
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_definitions_by_namespace_endpoint = _Endpoint(
            settings={
                "response_type": ([AttributeDefinition],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributesDefinitionByNamespace",
                "operation_id": "get_attribute_definitions_by_namespace",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "namespace",
                ],
                "required": [
                    "namespace",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "namespace": (str,),
                },
                "attribute_map": {
                    "namespace": "namespace",
                },
                "location_map": {
                    "namespace": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_modules_dependencies_for_attribute_graph_text_endpoint = _Endpoint(
            settings={
                "response_type": (GraphDTO,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributeModulesDependenciesGraphText/for-attribute",
                "operation_id": "get_attribute_modules_dependencies_for_attribute_graph_text",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "format",
                    "attr_name",
                ],
                "required": [
                    "format",
                    "attr_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "format": (GraphFileFormat,),
                    "attr_name": (str,),
                },
                "attribute_map": {
                    "format": "format",
                    "attr_name": "attrName",
                },
                "location_map": {
                    "format": "query",
                    "attr_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_modules_dependencies_graph_text_endpoint = _Endpoint(
            settings={
                "response_type": (GraphDTO,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributeModulesDependenciesGraphText",
                "operation_id": "get_attribute_modules_dependencies_graph_text",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "format",
                ],
                "required": [
                    "format",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "format": (GraphFileFormat,),
                },
                "attribute_map": {
                    "format": "format",
                },
                "location_map": {
                    "format": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_policy_collections_endpoint = _Endpoint(
            settings={
                "response_type": ([AttributePolicyCollection],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributePolicyCollections",
                "operation_id": "get_attribute_policy_collections",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute_id",
                ],
                "required": [
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attribute_rights_endpoint = _Endpoint(
            settings={
                "response_type": ([AttributeRights],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributeRights",
                "operation_id": "get_attribute_rights",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute_id",
                ],
                "required": [
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_attributes_definition_with_rights_endpoint = _Endpoint(
            settings={
                "response_type": ([AttributeDefinition],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/getAttributesDefinitionWithRights",
                "operation_id": "get_attributes_definition_with_rights",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "user",
                    "vo",
                    "group",
                    "resource",
                    "facility",
                    "host",
                    "user_ext_source",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "user": (int,),
                    "vo": (int,),
                    "group": (int,),
                    "resource": (int,),
                    "facility": (int,),
                    "host": (int,),
                    "user_ext_source": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "user": "user",
                    "vo": "vo",
                    "group": "group",
                    "resource": "resource",
                    "facility": "facility",
                    "host": "host",
                    "user_ext_source": "userExtSource",
                },
                "location_map": {
                    "member": "query",
                    "user": "query",
                    "vo": "query",
                    "group": "query",
                    "resource": "query",
                    "facility": "query",
                    "host": "query",
                    "user_ext_source": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_entityless_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-entityless",
                "operation_id": "get_entityless_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "key",
                    "attribute_name",
                ],
                "required": [
                    "key",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "key": (str,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "key": "key",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "key": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_entityless_attributes_by_key_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/key",
                "operation_id": "get_entityless_attributes_by_key",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "key",
                ],
                "required": [
                    "key",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "key": (str,),
                },
                "attribute_map": {
                    "key": "key",
                },
                "location_map": {
                    "key": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_entityless_attributes_by_name_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getEntitylessAttributes",
                "operation_id": "get_entityless_attributes_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "attr_name",
                ],
                "required": [
                    "attr_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attr_name": (str,),
                },
                "attribute_map": {
                    "attr_name": "attrName",
                },
                "location_map": {
                    "attr_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_entityless_attributes_with_keys_endpoint = _Endpoint(
            settings={
                "response_type": (EntitylessAttributesByKeys,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getEntitylessAttributesWithKeys",
                "operation_id": "get_entityless_attributes_with_keys",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "attr_name",
                    "keys",
                ],
                "required": [
                    "attr_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attr_name": (str,),
                    "keys": ([str],),
                },
                "attribute_map": {
                    "attr_name": "attrName",
                    "keys": "keys[]",
                },
                "location_map": {
                    "attr_name": "query",
                    "keys": "query",
                },
                "collection_format_map": {
                    "keys": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_entityless_keys_endpoint = _Endpoint(
            settings={
                "response_type": ([str],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getEntitylessKeys",
                "operation_id": "get_entityless_keys",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "attribute_definition",
                ],
                "required": [
                    "attribute_definition",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "attribute_definition": (int,),
                },
                "attribute_map": {
                    "attribute_definition": "attributeDefinition",
                },
                "location_map": {
                    "attribute_definition": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_facility_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-facility",
                "operation_id": "get_facility_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "attribute_id",
                ],
                "required": [
                    "facility",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "facility": "facility",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "facility": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_facility_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-facility",
                "operation_id": "get_facility_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "attribute_name",
                ],
                "required": [
                    "facility",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "facility": "facility",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "facility": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_facility_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/f",
                "operation_id": "get_facility_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                ],
                "required": [
                    "facility",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                },
                "attribute_map": {
                    "facility": "facility",
                },
                "location_map": {
                    "facility": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_facility_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/f-names",
                "operation_id": "get_facility_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "attr_names",
                ],
                "required": [
                    "facility",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "facility": "facility",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "facility": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_facility_resource_user_member_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/f-r-u-m",
                "operation_id": "get_facility_resource_user_member_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "resource",
                    "user",
                    "member",
                ],
                "required": [
                    "facility",
                    "resource",
                    "user",
                    "member",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "resource": (int,),
                    "user": (int,),
                    "member": (int,),
                },
                "attribute_map": {
                    "facility": "facility",
                    "resource": "resource",
                    "user": "user",
                    "member": "member",
                },
                "location_map": {
                    "facility": "query",
                    "resource": "query",
                    "user": "query",
                    "member": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_facility_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/f-u",
                "operation_id": "get_facility_user_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "user",
                ],
                "required": [
                    "facility",
                    "user",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "user": (int,),
                },
                "attribute_map": {
                    "facility": "facility",
                    "user": "user",
                },
                "location_map": {
                    "facility": "query",
                    "user": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_group_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-group",
                "operation_id": "get_group_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "attribute_id",
                ],
                "required": [
                    "group",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "group": "group",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "group": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_group_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-group",
                "operation_id": "get_group_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "attribute_name",
                ],
                "required": [
                    "group",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "group": "group",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "group": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/g",
                "operation_id": "get_group_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                ],
                "required": [
                    "group",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                },
                "attribute_map": {
                    "group": "group",
                },
                "location_map": {
                    "group": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_group_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/g-names",
                "operation_id": "get_group_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "attr_names",
                ],
                "required": [
                    "group",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "group": "group",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "group": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_group_resource_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-group-resource",
                "operation_id": "get_group_resource_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "resource",
                    "attribute_id",
                ],
                "required": [
                    "group",
                    "resource",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "resource": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "group": "group",
                    "resource": "resource",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "group": "query",
                    "resource": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_group_resource_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-group-resource",
                "operation_id": "get_group_resource_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "resource",
                    "attribute_name",
                ],
                "required": [
                    "group",
                    "resource",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "resource": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "group": "group",
                    "resource": "resource",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "group": "query",
                    "resource": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_group_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/group-resource",
                "operation_id": "get_group_resource_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "resource",
                ],
                "required": [
                    "group",
                    "resource",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "resource": (int,),
                },
                "attribute_map": {
                    "group": "group",
                    "resource": "resource",
                },
                "location_map": {
                    "group": "query",
                    "resource": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_host_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-host",
                "operation_id": "get_host_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "host",
                    "attribute_id",
                ],
                "required": [
                    "host",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "host": "host",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "host": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_host_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-host",
                "operation_id": "get_host_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "host",
                    "attribute_name",
                ],
                "required": [
                    "host",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "host": "host",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "host": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_host_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/h",
                "operation_id": "get_host_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "host",
                ],
                "required": [
                    "host",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host": (int,),
                },
                "attribute_map": {
                    "host": "host",
                },
                "location_map": {
                    "host": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_host_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/h-names",
                "operation_id": "get_host_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "host",
                    "attr_names",
                ],
                "required": [
                    "host",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "host": "host",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "host": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_logins_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getLogins",
                "operation_id": "get_logins",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                ],
                "required": [
                    "user",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                },
                "attribute_map": {
                    "user": "user",
                },
                "location_map": {
                    "user": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_and_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-wu",
                "operation_id": "get_member_and_user_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "work_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_and_user_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-names-wu",
                "operation_id": "get_member_and_user_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "attr_names",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "attr_names",
                    "work_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "attr_names": ([str],),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "attr_names": "attrNames[]",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "attr_names": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-member",
                "operation_id": "get_member_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "attribute_id",
                ],
                "required": [
                    "member",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "member": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-member",
                "operation_id": "get_member_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "attribute_name",
                ],
                "required": [
                    "member",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "member": "member",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "member": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m",
                "operation_id": "get_member_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                ],
                "required": [
                    "member",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                },
                "attribute_map": {
                    "member": "member",
                },
                "location_map": {
                    "member": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-names",
                "operation_id": "get_member_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "attr_names",
                ],
                "required": [
                    "member",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "member": "member",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "member": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_group_and_user_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-g-names-wu",
                "operation_id": "get_member_group_and_user_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "attr_names",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "group",
                    "attr_names",
                    "work_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "attr_names": ([str],),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "attr_names": "attrNames[]",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "attr_names": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_group_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-member-group",
                "operation_id": "get_member_group_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "attribute_id",
                ],
                "required": [
                    "member",
                    "group",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_group_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-member-group",
                "operation_id": "get_member_group_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "attribute_name",
                ],
                "required": [
                    "member",
                    "group",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-g",
                "operation_id": "get_member_group_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                ],
                "required": [
                    "member",
                    "group",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_group_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-g-names",
                "operation_id": "get_member_group_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "attr_names",
                ],
                "required": [
                    "member",
                    "group",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_resource_and_user_facility_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-r-wu",
                "operation_id": "get_member_resource_and_user_facility_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "resource",
                    "work_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_resource_and_user_facility_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-r-names-wu",
                "operation_id": "get_member_resource_and_user_facility_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                    "attr_names",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "resource",
                    "attr_names",
                    "work_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                    "attr_names": ([str],),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                    "attr_names": "attrNames[]",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                    "attr_names": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_resource_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-member-resource",
                "operation_id": "get_member_resource_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                    "attribute_id",
                ],
                "required": [
                    "member",
                    "resource",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_resource_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-member-resource",
                "operation_id": "get_member_resource_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                    "attribute_name",
                ],
                "required": [
                    "member",
                    "resource",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_member_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/m-r",
                "operation_id": "get_member_resource_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                ],
                "required": [
                    "member",
                    "resource",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_definition_endpoint = _Endpoint(
            settings={
                "response_type": ([AttributeDefinition],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributesDefinition",
                "operation_id": "get_required_attributes_definition",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                ],
                "required": [
                    "service",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                },
                "attribute_map": {
                    "service": "service",
                },
                "location_map": {
                    "service": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_facility_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/f",
                "operation_id": "get_required_attributes_facility",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                ],
                "required": [
                    "facility",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                },
                "attribute_map": {
                    "facility": "facility",
                },
                "location_map": {
                    "facility": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_facility_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-f",
                "operation_id": "get_required_attributes_facility_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "facility",
                ],
                "required": [
                    "service",
                    "facility",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "facility": (int,),
                },
                "attribute_map": {
                    "service": "service",
                    "facility": "facility",
                },
                "location_map": {
                    "service": "query",
                    "facility": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_facility_services_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/ss-f",
                "operation_id": "get_required_attributes_facility_services",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "services",
                    "facility",
                ],
                "required": [
                    "services",
                    "facility",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "services": ([int],),
                    "facility": (int,),
                },
                "attribute_map": {
                    "services": "services[]",
                    "facility": "facility",
                },
                "location_map": {
                    "services": "query",
                    "facility": "query",
                },
                "collection_format_map": {
                    "services": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_group_resource_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-r-g",
                "operation_id": "get_required_attributes_group_resource_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "resource",
                    "group",
                ],
                "required": [
                    "service",
                    "resource",
                    "group",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "resource": (int,),
                    "group": (int,),
                },
                "attribute_map": {
                    "service": "service",
                    "resource": "resource",
                    "group": "group",
                },
                "location_map": {
                    "service": "query",
                    "resource": "query",
                    "group": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_host_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-h",
                "operation_id": "get_required_attributes_host_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "host",
                ],
                "required": [
                    "service",
                    "host",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "host": (int,),
                },
                "attribute_map": {
                    "service": "service",
                    "host": "host",
                },
                "location_map": {
                    "service": "query",
                    "host": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_member_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/m",
                "operation_id": "get_required_attributes_member",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_member_group_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/m-g",
                "operation_id": "get_required_attributes_member_group",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "group",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_member_group_resource_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-r-g-m",
                "operation_id": "get_required_attributes_member_group_resource_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "resource",
                    "group",
                    "member",
                    "work_with_user_attributes",
                ],
                "required": [
                    "service",
                    "resource",
                    "group",
                    "member",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "resource": (int,),
                    "group": (int,),
                    "member": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "service": "service",
                    "resource": "resource",
                    "group": "group",
                    "member": "member",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "service": "query",
                    "resource": "query",
                    "group": "query",
                    "member": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_member_group_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-g-m",
                "operation_id": "get_required_attributes_member_group_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "group",
                    "member",
                    "work_with_user_attributes",
                ],
                "required": [
                    "service",
                    "group",
                    "member",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "group": (int,),
                    "member": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "service": "service",
                    "group": "group",
                    "member": "member",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "service": "query",
                    "group": "query",
                    "member": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_member_resource_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/m-r",
                "operation_id": "get_required_attributes_member_resource",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "resource",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_member_resource_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-r-m",
                "operation_id": "get_required_attributes_member_resource_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "resource",
                    "member",
                    "work_with_user_attributes",
                ],
                "required": [
                    "service",
                    "resource",
                    "member",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "resource": (int,),
                    "member": (int,),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "service": "service",
                    "resource": "resource",
                    "member": "member",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "service": "query",
                    "resource": "query",
                    "member": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_resource_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/r",
                "operation_id": "get_required_attributes_resource",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                ],
                "required": [
                    "resource",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                },
                "attribute_map": {
                    "resource": "resource",
                },
                "location_map": {
                    "resource": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_resource_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-r",
                "operation_id": "get_required_attributes_resource_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "resource",
                ],
                "required": [
                    "service",
                    "resource",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "resource": (int,),
                },
                "attribute_map": {
                    "service": "service",
                    "resource": "resource",
                },
                "location_map": {
                    "service": "query",
                    "resource": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_resource_services_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/ss-r",
                "operation_id": "get_required_attributes_resource_services",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "services",
                    "resource",
                ],
                "required": [
                    "services",
                    "resource",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "services": ([int],),
                    "resource": (int,),
                },
                "attribute_map": {
                    "services": "services[]",
                    "resource": "resource",
                },
                "location_map": {
                    "services": "query",
                    "resource": "query",
                },
                "collection_format_map": {
                    "services": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_user_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/u",
                "operation_id": "get_required_attributes_user",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                ],
                "required": [
                    "user",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                },
                "attribute_map": {
                    "user": "user",
                },
                "location_map": {
                    "user": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_user_facility_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/u-f",
                "operation_id": "get_required_attributes_user_facility",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "facility",
                ],
                "required": [
                    "user",
                    "facility",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "facility": (int,),
                },
                "attribute_map": {
                    "user": "user",
                    "facility": "facility",
                },
                "location_map": {
                    "user": "query",
                    "facility": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_required_attributes_vo_service_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getRequiredAttributes/s-v",
                "operation_id": "get_required_attributes_vo_service",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service",
                    "vo",
                ],
                "required": [
                    "service",
                    "vo",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service": (int,),
                    "vo": (int,),
                },
                "attribute_map": {
                    "service": "service",
                    "vo": "vo",
                },
                "location_map": {
                    "service": "query",
                    "vo": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-resource",
                "operation_id": "get_resource_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "attribute_id",
                ],
                "required": [
                    "resource",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "resource": "resource",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "resource": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-resource",
                "operation_id": "get_resource_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "attribute_name",
                ],
                "required": [
                    "resource",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "resource": "resource",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "resource": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/r",
                "operation_id": "get_resource_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                ],
                "required": [
                    "resource",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                },
                "attribute_map": {
                    "resource": "resource",
                },
                "location_map": {
                    "resource": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/r-names",
                "operation_id": "get_resource_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "attr_names",
                ],
                "required": [
                    "resource",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "resource": "resource",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "resource": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_group_and_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/r-g-wg",
                "operation_id": "get_resource_group_and_group_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "group",
                    "work_with_group_attributes",
                ],
                "required": [
                    "resource",
                    "group",
                    "work_with_group_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "group": (int,),
                    "work_with_group_attributes": (bool,),
                },
                "attribute_map": {
                    "resource": "resource",
                    "group": "group",
                    "work_with_group_attributes": "workWithGroupAttributes",
                },
                "location_map": {
                    "resource": "query",
                    "group": "query",
                    "work_with_group_attributes": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_group_and_group_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/r-g-names-wg",
                "operation_id": "get_resource_group_and_group_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "group",
                    "attr_names",
                    "work_with_group_attributes",
                ],
                "required": [
                    "resource",
                    "group",
                    "attr_names",
                    "work_with_group_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "group": (int,),
                    "attr_names": ([str],),
                    "work_with_group_attributes": (bool,),
                },
                "attribute_map": {
                    "resource": "resource",
                    "group": "group",
                    "attr_names": "attrNames[]",
                    "work_with_group_attributes": "workWithGroupAttributes",
                },
                "location_map": {
                    "resource": "query",
                    "group": "query",
                    "attr_names": "query",
                    "work_with_group_attributes": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/r-g",
                "operation_id": "get_resource_group_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "group",
                ],
                "required": [
                    "resource",
                    "group",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "group": (int,),
                },
                "attribute_map": {
                    "resource": "resource",
                    "group": "group",
                },
                "location_map": {
                    "resource": "query",
                    "group": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_resource_group_member_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/r-g-m-names",
                "operation_id": "get_resource_group_member_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "group",
                    "member",
                    "attr_names",
                ],
                "required": [
                    "resource",
                    "group",
                    "member",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "group": (int,),
                    "member": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "resource": "resource",
                    "group": "group",
                    "member": "member",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "resource": "query",
                    "group": "query",
                    "member": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-user",
                "operation_id": "get_user_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "attribute_id",
                ],
                "required": [
                    "user",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "user": "user",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "user": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-user",
                "operation_id": "get_user_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "attribute_name",
                ],
                "required": [
                    "user",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "user": "user",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "user": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/u",
                "operation_id": "get_user_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                ],
                "required": [
                    "user",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                },
                "attribute_map": {
                    "user": "user",
                },
                "location_map": {
                    "user": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/u-names",
                "operation_id": "get_user_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "attr_names",
                ],
                "required": [
                    "user",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "user": "user",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "user": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_ext_source_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-ues",
                "operation_id": "get_user_ext_source_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user_ext_source",
                    "attribute_id",
                ],
                "required": [
                    "user_ext_source",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user_ext_source": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "user_ext_source": "userExtSource",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "user_ext_source": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_ext_source_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-ues",
                "operation_id": "get_user_ext_source_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user_ext_source",
                    "attribute_name",
                ],
                "required": [
                    "user_ext_source",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user_ext_source": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "user_ext_source": "userExtSource",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "user_ext_source": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_ext_source_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/ues",
                "operation_id": "get_user_ext_source_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user_ext_source",
                ],
                "required": [
                    "user_ext_source",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user_ext_source": (int,),
                },
                "attribute_map": {
                    "user_ext_source": "userExtSource",
                },
                "location_map": {
                    "user_ext_source": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_ext_source_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/ues-names",
                "operation_id": "get_user_ext_source_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user_ext_source",
                    "attr_names",
                ],
                "required": [
                    "user_ext_source",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user_ext_source": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "user_ext_source": "userExtSource",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "user_ext_source": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_facility_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-user_facility",
                "operation_id": "get_user_facility_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "facility",
                    "attribute_id",
                ],
                "required": [
                    "user",
                    "facility",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "facility": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "user": "user",
                    "facility": "facility",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "user": "query",
                    "facility": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_facility_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-user_facility",
                "operation_id": "get_user_facility_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "facility",
                    "attribute_name",
                ],
                "required": [
                    "user",
                    "facility",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "facility": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "user": "user",
                    "facility": "facility",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "user": "query",
                    "facility": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_user_facility_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/user-facility",
                "operation_id": "get_user_facility_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "facility",
                ],
                "required": [
                    "user",
                    "facility",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "facility": (int,),
                },
                "attribute_map": {
                    "user": "user",
                    "facility": "facility",
                },
                "location_map": {
                    "user": "query",
                    "facility": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_vo_attribute_by_id_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/id-vo",
                "operation_id": "get_vo_attribute_by_id",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "vo",
                    "attribute_id",
                ],
                "required": [
                    "vo",
                    "attribute_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "vo": (int,),
                    "attribute_id": (int,),
                },
                "attribute_map": {
                    "vo": "vo",
                    "attribute_id": "attributeId",
                },
                "location_map": {
                    "vo": "query",
                    "attribute_id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_vo_attribute_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (Attribute,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttribute/name-vo",
                "operation_id": "get_vo_attribute_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "vo",
                    "attribute_name",
                ],
                "required": [
                    "vo",
                    "attribute_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "vo": (int,),
                    "attribute_name": (str,),
                },
                "attribute_map": {
                    "vo": "vo",
                    "attribute_name": "attributeName",
                },
                "location_map": {
                    "vo": "query",
                    "attribute_name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_vo_attributes_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/vo",
                "operation_id": "get_vo_attributes",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "vo",
                ],
                "required": [
                    "vo",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "vo": (int,),
                },
                "attribute_map": {
                    "vo": "vo",
                },
                "location_map": {
                    "vo": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_vo_attributes_by_names_endpoint = _Endpoint(
            settings={
                "response_type": ([Attribute],),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/getAttributes/vo-names",
                "operation_id": "get_vo_attributes_by_names",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "vo",
                    "attr_names",
                ],
                "required": [
                    "vo",
                    "attr_names",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "vo": (int,),
                    "attr_names": ([str],),
                },
                "attribute_map": {
                    "vo": "vo",
                    "attr_names": "attrNames[]",
                },
                "location_map": {
                    "vo": "query",
                    "attr_names": "query",
                },
                "collection_format_map": {
                    "attr_names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_attributes_for_facility_resource_group_user_member_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/f-r-g-u-m",
                "operation_id": "remove_attributes_for_facility_resource_group_user_member",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "resource",
                    "group",
                    "user",
                    "member",
                    "attributes",
                ],
                "required": [
                    "facility",
                    "resource",
                    "group",
                    "user",
                    "member",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "resource": (int,),
                    "group": (int,),
                    "user": (int,),
                    "member": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "facility": "facility",
                    "resource": "resource",
                    "group": "group",
                    "user": "user",
                    "member": "member",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "facility": "query",
                    "resource": "query",
                    "group": "query",
                    "user": "query",
                    "member": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_attributes_for_facility_resource_user_member_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/f-r-u-m",
                "operation_id": "remove_attributes_for_facility_resource_user_member",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "resource",
                    "user",
                    "member",
                    "attributes",
                ],
                "required": [
                    "facility",
                    "resource",
                    "user",
                    "member",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "resource": (int,),
                    "user": (int,),
                    "member": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "facility": "facility",
                    "resource": "resource",
                    "user": "user",
                    "member": "member",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "facility": "query",
                    "resource": "query",
                    "user": "query",
                    "member": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_entityless_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/e",
                "operation_id": "remove_entityless_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "key",
                    "attribute",
                ],
                "required": [
                    "key",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "key": (str,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "key": "key",
                    "attribute": "attribute",
                },
                "location_map": {
                    "key": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_facility_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/f",
                "operation_id": "remove_facility_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "attribute",
                ],
                "required": [
                    "facility",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "facility": "facility",
                    "attribute": "attribute",
                },
                "location_map": {
                    "facility": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_facility_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/f",
                "operation_id": "remove_facility_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "facility",
                    "attributes",
                ],
                "required": [
                    "facility",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "facility": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "facility": "facility",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "facility": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_group_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/g",
                "operation_id": "remove_group_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "attribute",
                ],
                "required": [
                    "group",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "group": "group",
                    "attribute": "attribute",
                },
                "location_map": {
                    "group": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/g",
                "operation_id": "remove_group_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "attributes",
                ],
                "required": [
                    "group",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "group": "group",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "group": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_group_resource_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/g-r",
                "operation_id": "remove_group_resource_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "resource",
                    "attribute",
                ],
                "required": [
                    "group",
                    "resource",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "resource": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "group": "group",
                    "resource": "resource",
                    "attribute": "attribute",
                },
                "location_map": {
                    "group": "query",
                    "resource": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_group_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/g-r",
                "operation_id": "remove_group_resource_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "resource",
                    "attributes",
                ],
                "required": [
                    "group",
                    "resource",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "resource": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "group": "group",
                    "resource": "resource",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "group": "query",
                    "resource": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_group_resource_attributes_work_with_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/g-r-workWithGroupAttributes",
                "operation_id": "remove_group_resource_attributes_work_with_group_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "group",
                    "resource",
                    "attributes",
                    "work_with_group_attributes",
                ],
                "required": [
                    "group",
                    "resource",
                    "attributes",
                    "work_with_group_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "group": (int,),
                    "resource": (int,),
                    "attributes": ([int],),
                    "work_with_group_attributes": (bool,),
                },
                "attribute_map": {
                    "group": "group",
                    "resource": "resource",
                    "attributes": "attributes[]",
                    "work_with_group_attributes": "workWithGroupAttributes",
                },
                "location_map": {
                    "group": "query",
                    "resource": "query",
                    "attributes": "query",
                    "work_with_group_attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_host_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/h",
                "operation_id": "remove_host_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "host",
                    "attribute",
                ],
                "required": [
                    "host",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "host": "host",
                    "attribute": "attribute",
                },
                "location_map": {
                    "host": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_host_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/h",
                "operation_id": "remove_host_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "host",
                    "attributes",
                ],
                "required": [
                    "host",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "host": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "host": "host",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "host": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/m",
                "operation_id": "remove_member_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "attribute",
                ],
                "required": [
                    "member",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "attribute": "attribute",
                },
                "location_map": {
                    "member": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/m",
                "operation_id": "remove_member_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "attributes",
                ],
                "required": [
                    "member",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "member": "member",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "member": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_attributes_work_with_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/m-workWithUserAttributes",
                "operation_id": "remove_member_attributes_work_with_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "attributes",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "attributes",
                    "work_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "attributes": ([int],),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "attributes": "attributes[]",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "attributes": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_group_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/m-g",
                "operation_id": "remove_member_group_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "attribute",
                ],
                "required": [
                    "member",
                    "group",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "attribute": "attribute",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/m-g",
                "operation_id": "remove_member_group_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "attributes",
                ],
                "required": [
                    "member",
                    "group",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_group_attributes_work_with_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/m-g-workWithUserAttributes",
                "operation_id": "remove_member_group_attributes_work_with_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "group",
                    "attributes",
                    "work_with_user_attributes",
                ],
                "required": [
                    "member",
                    "group",
                    "attributes",
                    "work_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "group": (int,),
                    "attributes": ([int],),
                    "work_with_user_attributes": (bool,),
                },
                "attribute_map": {
                    "member": "member",
                    "group": "group",
                    "attributes": "attributes[]",
                    "work_with_user_attributes": "workWithUserAttributes",
                },
                "location_map": {
                    "member": "query",
                    "group": "query",
                    "attributes": "query",
                    "work_with_user_attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_resource_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/m-r",
                "operation_id": "remove_member_resource_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                    "attribute",
                ],
                "required": [
                    "member",
                    "resource",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                    "attribute": "attribute",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_member_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/m-r",
                "operation_id": "remove_member_resource_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "member",
                    "resource",
                    "attributes",
                ],
                "required": [
                    "member",
                    "resource",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "member": (int,),
                    "resource": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "member": "member",
                    "resource": "resource",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "member": "query",
                    "resource": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_resource_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/r",
                "operation_id": "remove_resource_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "attribute",
                ],
                "required": [
                    "resource",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "resource": "resource",
                    "attribute": "attribute",
                },
                "location_map": {
                    "resource": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/r",
                "operation_id": "remove_resource_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "resource",
                    "attributes",
                ],
                "required": [
                    "resource",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "resource": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "resource": "resource",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "resource": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_ues_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/ues",
                "operation_id": "remove_ues_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "user_ext_source",
                    "attributes",
                ],
                "required": [
                    "user_ext_source",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user_ext_source": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "user_ext_source": "userExtSource",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "user_ext_source": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_user_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/u",
                "operation_id": "remove_user_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "attribute",
                ],
                "required": [
                    "user",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "user": "user",
                    "attribute": "attribute",
                },
                "location_map": {
                    "user": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/u",
                "operation_id": "remove_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "attributes",
                ],
                "required": [
                    "user",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "user": "user",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "user": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_user_ext_source_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/ues",
                "operation_id": "remove_user_ext_source_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "user_ext_source",
                    "attribute",
                ],
                "required": [
                    "user_ext_source",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user_ext_source": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "user_ext_source": "userExtSource",
                    "attribute": "attribute",
                },
                "location_map": {
                    "user_ext_source": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_user_facility_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/u-f",
                "operation_id": "remove_user_facility_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "facility",
                    "attribute",
                ],
                "required": [
                    "user",
                    "facility",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "facility": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "user": "user",
                    "facility": "facility",
                    "attribute": "attribute",
                },
                "location_map": {
                    "user": "query",
                    "facility": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_user_facility_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/u-f",
                "operation_id": "remove_user_facility_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "user",
                    "facility",
                    "attributes",
                ],
                "required": [
                    "user",
                    "facility",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "user": (int,),
                    "facility": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "user": "user",
                    "facility": "facility",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "user": "query",
                    "facility": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_vo_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttribute/v",
                "operation_id": "remove_vo_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "vo",
                    "attribute",
                ],
                "required": [
                    "vo",
                    "attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "vo": (int,),
                    "attribute": (int,),
                },
                "attribute_map": {
                    "vo": "vo",
                    "attribute": "attribute",
                },
                "location_map": {
                    "vo": "query",
                    "attribute": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.remove_vo_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/urlinjsonout/attributesManager/removeAttributes/v",
                "operation_id": "remove_vo_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "vo",
                    "attributes",
                ],
                "required": [
                    "vo",
                    "attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "vo": (int,),
                    "attributes": ([int],),
                },
                "attribute_map": {
                    "vo": "vo",
                    "attributes": "attributes[]",
                },
                "location_map": {
                    "vo": "query",
                    "attributes": "query",
                },
                "collection_format_map": {
                    "attributes": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.set_attribute_policy_collections_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributePolicyCollections",
                "operation_id": "set_attribute_policy_collections",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_attribute_policy_collections",
                ],
                "required": [
                    "input_attribute_policy_collections",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_attribute_policy_collections": (
                        InputAttributePolicyCollections,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_attribute_policy_collections": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_attribute_rights_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributeRights",
                "operation_id": "set_attribute_rights",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_attribute_rights",
                ],
                "required": [
                    "input_attribute_rights",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_attribute_rights": (InputAttributeRights,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_attribute_rights": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_entityless_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/entityless",
                "operation_id": "set_entityless_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_entityless_attribute",
                ],
                "required": [
                    "input_entityless_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_entityless_attribute": (InputEntitylessAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_entityless_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_facility_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/facility",
                "operation_id": "set_facility_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_facility_attribute",
                ],
                "required": [
                    "input_set_facility_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_facility_attribute": (InputSetFacilityAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_facility_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_facility_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/f",
                "operation_id": "set_facility_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_facility_attributes",
                ],
                "required": [
                    "input_set_facility_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_facility_attributes": (InputSetFacilityAttributes,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_facility_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_facility_resource_group_user_member_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/f-r-g-u-m",
                "operation_id": "set_facility_resource_group_user_member_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_facility_resource_group_user_member_attributes",
                ],
                "required": [
                    "input_set_facility_resource_group_user_member_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_facility_resource_group_user_member_attributes": (
                        InputSetFacilityResourceGroupUserMemberAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_facility_resource_group_user_member_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_facility_resource_user_member_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/f-r-u-m",
                "operation_id": "set_facility_resource_user_member_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_facility_resource_user_member_attributes",
                ],
                "required": [
                    "input_set_facility_resource_user_member_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_facility_resource_user_member_attributes": (
                        InputSetFacilityResourceUserMemberAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_facility_resource_user_member_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_facility_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/f-u",
                "operation_id": "set_facility_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_facility_user_attributes",
                ],
                "required": [
                    "input_set_facility_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_facility_user_attributes": (
                        InputSetFacilityUserAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_facility_user_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_group_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/group",
                "operation_id": "set_group_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_group_attribute",
                ],
                "required": [
                    "input_set_group_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_group_attribute": (InputSetGroupAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_group_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/g",
                "operation_id": "set_group_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_group_attributes",
                ],
                "required": [
                    "input_set_group_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_group_attributes": (InputSetGroupAttributes,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_group_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_group_resource_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/group-resource",
                "operation_id": "set_group_resource_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_group_resource_attribute",
                ],
                "required": [
                    "input_set_group_resource_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_group_resource_attribute": (
                        InputSetGroupResourceAttribute,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_group_resource_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_group_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/group-resource",
                "operation_id": "set_group_resource_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_group_resource_attributes",
                ],
                "required": [
                    "input_set_group_resource_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_group_resource_attributes": (
                        InputSetGroupResourceAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_group_resource_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_host_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/host",
                "operation_id": "set_host_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_host_attribute",
                ],
                "required": [
                    "input_set_host_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_host_attribute": (InputSetHostAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_host_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_host_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/h",
                "operation_id": "set_host_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_host_attributes",
                ],
                "required": [
                    "input_set_host_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_host_attributes": (InputSetHostAttributes,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_host_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/member",
                "operation_id": "set_member_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_attribute",
                ],
                "required": [
                    "input_set_member_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_attribute": (InputSetMemberAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/m",
                "operation_id": "set_member_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_attributes",
                ],
                "required": [
                    "input_set_member_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_attributes": (InputSetMemberAttributes,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_group_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/member-group",
                "operation_id": "set_member_group_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_group_attribute",
                ],
                "required": [
                    "input_set_member_group_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_group_attribute": (InputSetMemberGroupAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_group_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/m-g",
                "operation_id": "set_member_group_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_group_attributes",
                ],
                "required": [
                    "input_set_member_group_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_group_attributes": (
                        InputSetMemberGroupAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_group_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_group_with_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/m-g-wu",
                "operation_id": "set_member_group_with_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_group_with_user_attributes",
                ],
                "required": [
                    "input_set_member_group_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_group_with_user_attributes": (
                        InputSetMemberGroupWithUserAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_group_with_user_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_resource_and_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/m-r-wu",
                "operation_id": "set_member_resource_and_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_resource_and_user_attributes",
                ],
                "required": [
                    "input_set_member_resource_and_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_resource_and_user_attributes": (
                        InputSetMemberResourceAndUserAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_resource_and_user_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_resource_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/member-resource",
                "operation_id": "set_member_resource_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_resource_attribute",
                ],
                "required": [
                    "input_set_member_resource_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_resource_attribute": (
                        InputSetMemberResourceAttribute,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_resource_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/m-r",
                "operation_id": "set_member_resource_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_resource_attributes",
                ],
                "required": [
                    "input_set_member_resource_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_resource_attributes": (
                        InputSetMemberResourceAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_resource_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_member_with_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/m-wu",
                "operation_id": "set_member_with_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_member_with_user_attributes",
                ],
                "required": [
                    "input_set_member_with_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_member_with_user_attributes": (
                        InputSetMemberWithUserAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_member_with_user_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_resource_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/resource",
                "operation_id": "set_resource_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_resource_attribute",
                ],
                "required": [
                    "input_set_resource_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_resource_attribute": (InputSetResourceAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_resource_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_resource_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/r",
                "operation_id": "set_resource_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_resource_attributes",
                ],
                "required": [
                    "input_set_resource_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_resource_attributes": (InputSetResourceAttributes,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_resource_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_resource_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/r-g",
                "operation_id": "set_resource_group_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_resource_group_attributes",
                ],
                "required": [
                    "input_set_resource_group_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_resource_group_attributes": (
                        InputSetResourceGroupAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_resource_group_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_resource_group_with_group_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/r-g-wg",
                "operation_id": "set_resource_group_with_group_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_resource_group_with_group_attributes",
                ],
                "required": [
                    "input_set_resource_group_with_group_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_resource_group_with_group_attributes": (
                        InputSetResourceGroupWithGroupAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_resource_group_with_group_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_user_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/user",
                "operation_id": "set_user_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_user_attribute",
                ],
                "required": [
                    "input_set_user_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_user_attribute": (InputSetUserAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_user_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_user_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/u",
                "operation_id": "set_user_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_user_attributes",
                ],
                "required": [
                    "input_set_user_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_user_attributes": (InputSetUserAttributes,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_user_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_user_ext_source_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/userExtSource",
                "operation_id": "set_user_ext_source_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_user_ext_source_attribute",
                ],
                "required": [
                    "input_set_user_ext_source_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_user_ext_source_attribute": (
                        InputSetUserExtSourceAttribute,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_user_ext_source_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_user_ext_source_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/ues",
                "operation_id": "set_user_ext_source_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_user_ext_source_attributes",
                ],
                "required": [
                    "input_set_user_ext_source_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_user_ext_source_attributes": (
                        InputSetUserExtSourceAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_user_ext_source_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_user_facility_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/facility-user",
                "operation_id": "set_user_facility_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_user_facility_attribute",
                ],
                "required": [
                    "input_set_user_facility_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_user_facility_attribute": (
                        InputSetUserFacilityAttribute,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_user_facility_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_user_facility_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/facility-user",
                "operation_id": "set_user_facility_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_user_facility_attributes",
                ],
                "required": [
                    "input_set_user_facility_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_user_facility_attributes": (
                        InputSetUserFacilityAttributes,
                    ),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_user_facility_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_vo_attribute_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttribute/vo",
                "operation_id": "set_vo_attribute",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_vo_attribute",
                ],
                "required": [
                    "input_set_vo_attribute",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_vo_attribute": (InputSetVoAttribute,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_vo_attribute": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.set_vo_attributes_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/setAttributes/vo",
                "operation_id": "set_vo_attributes",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_set_vo_attributes",
                ],
                "required": [
                    "input_set_vo_attributes",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_set_vo_attributes": (InputSetVoAttributes,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_set_vo_attributes": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )
        self.update_attribute_definition_endpoint = _Endpoint(
            settings={
                "response_type": (AttributeDefinition,),
                "auth": ["BasicAuth", "BearerAuth"],
                "endpoint_path": "/json/attributesManager/updateAttributeDefinition",
                "operation_id": "update_attribute_definition",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "input_attribute_definition",
                ],
                "required": [
                    "input_attribute_definition",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "input_attribute_definition": (InputAttributeDefinition,),
                },
                "attribute_map": {},
                "location_map": {
                    "input_attribute_definition": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
        )

    def convert_attribute_to_nonunique(self, attribute_definition, **kwargs):
        """Converts attribute to nonunique - unmarks unique flag from attribute definition, and deletes all values from a special table with unique constraint that ensures that all values remain unique.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.convert_attribute_to_nonunique(attribute_definition, async_req=True)
        >>> result = thread.get()

        Args:
            attribute_definition (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attribute_definition"] = attribute_definition
        return self.convert_attribute_to_nonunique_endpoint.call_with_http_info(
            **kwargs
        )

    def convert_attribute_to_unique(self, attribute_definition, **kwargs):
        """Converts attribute to unique - marks its definition as unique and ensures that all its values are unique. Entityless attributes cannot be converted to unique, only attributes attached to PerunBeans or pairs of PerunBeans.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.convert_attribute_to_unique(attribute_definition, async_req=True)
        >>> result = thread.get()

        Args:
            attribute_definition (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attribute_definition"] = attribute_definition
        return self.convert_attribute_to_unique_endpoint.call_with_http_info(**kwargs)

    def create_attribute_definition(self, input_create_attribute_definition, **kwargs):
        """Creates AttributeDefinition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_attribute_definition(input_create_attribute_definition, async_req=True)
        >>> result = thread.get()

        Args:
            input_create_attribute_definition (InputCreateAttributeDefinition):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttributeDefinition
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_create_attribute_definition"] = input_create_attribute_definition
        return self.create_attribute_definition_endpoint.call_with_http_info(**kwargs)

    def delete_attribute_definition(self, attribute, **kwargs):
        """Deletes attribute definition from Perun including all values set for any entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_attribute_definition(attribute, async_req=True)
        >>> result = thread.get()

        Args:
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attribute"] = attribute
        return self.delete_attribute_definition_endpoint.call_with_http_info(**kwargs)

    def delete_attribute_definitions(self, attributes, **kwargs):
        """Deletes attribute definitions from Perun including all values set for any entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_attribute_definitions(attributes, async_req=True)
        >>> result = thread.get()

        Args:
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attributes"] = attributes
        return self.delete_attribute_definitions_endpoint.call_with_http_info(**kwargs)

    def get_all_attribute_definitions(self, **kwargs):
        """Returns all AttributeDefinitions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_attribute_definitions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [AttributeDefinition]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.get_all_attribute_definitions_endpoint.call_with_http_info(**kwargs)

    def get_attribute(self, **kwargs):
        """Returns an Attribute by its name or id.  # noqa: E501

        This method cannot be fully described correctly in OpenID, because it cannot describe allowed combinations of parameters. One of attributeName, attributeId is required. The other parameters specify ids that can be combined in the following ways:  (facility), (user), (user,facility), (vo), (member), (group), (resource),  (member,group), (member,resource), (group,resource),(userExtSource), (host), (key) Use the specialized methods getFacilityAttributeByName(), getMemberResourceAttributeById() etc.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            attribute_name (str): full name of attribute (namespace + ':' + friendlyName). [optional]
            attribute_id (int): id of attribute. [optional]
            facility (int): id of Facility. [optional]
            user (int): id of User. [optional]
            vo (int): id of Vo. [optional]
            resource (int): id of Resource. [optional]
            member (int): id of Member. [optional]
            group (int): id of Group. [optional]
            host (int): id of Host. [optional]
            user_ext_source (int): id of UserExtSource. [optional]
            key (str): key for entityless attribute. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.get_attribute_endpoint.call_with_http_info(**kwargs)

    def get_attribute_definition_by_id(self, id, **kwargs):
        """Returns an AttributeDefinition by its id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute_definition_by_id(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): numeric id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttributeDefinition
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["id"] = id
        return self.get_attribute_definition_by_id_endpoint.call_with_http_info(
            **kwargs
        )

    def get_attribute_definition_by_name(self, attribute_name, **kwargs):
        """Returns an AttributeDefinition by its name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute_definition_by_name(attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttributeDefinition
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attribute_name"] = attribute_name
        return self.get_attribute_definition_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_attribute_definitions_by_namespace(self, namespace, **kwargs):
        """Returns all AttributeDefinitions in a namespace.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute_definitions_by_namespace(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str): name of namespace to obtain attribute definitions from

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [AttributeDefinition]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["namespace"] = namespace
        return self.get_attribute_definitions_by_namespace_endpoint.call_with_http_info(
            **kwargs
        )

    def get_attribute_modules_dependencies_for_attribute_graph_text(
        self, format, attr_name, **kwargs
    ):
        """Generates text file describing dependencies between attribute modules. The format of text file can be specified by parameter. Modules that has no dependency relations are omitted.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute_modules_dependencies_for_attribute_graph_text(format, attr_name, async_req=True)
        >>> result = thread.get()

        Args:
            format (GraphFileFormat):
            attr_name (str): Attribute name which dependencies will be found.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GraphDTO
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["format"] = format
        kwargs["attr_name"] = attr_name
        return self.get_attribute_modules_dependencies_for_attribute_graph_text_endpoint.call_with_http_info(
            **kwargs
        )

    def get_attribute_modules_dependencies_graph_text(self, format, **kwargs):
        """Generates text file describing dependencies between attribute modules. The format of text file can be specified by parameter. Modules that has no dependency relations are omitted.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute_modules_dependencies_graph_text(format, async_req=True)
        >>> result = thread.get()

        Args:
            format (GraphFileFormat):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GraphDTO
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["format"] = format
        return self.get_attribute_modules_dependencies_graph_text_endpoint.call_with_http_info(
            **kwargs
        )

    def get_attribute_policy_collections(self, attribute_id, **kwargs):
        """Gets attribute policy collections for an attribute definition with given id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute_policy_collections(attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [AttributePolicyCollection]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attribute_id"] = attribute_id
        return self.get_attribute_policy_collections_endpoint.call_with_http_info(
            **kwargs
        )

    def get_attribute_rights(self, attribute_id, **kwargs):
        """Gets AttributeRights for specified Attribute. Rights specify which Role can do particular actions (read / write) with Attribute. Method always return rights for following roles: VOADMIN, GROUPADMIN, FACILITYADMIN, SELF.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attribute_rights(attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [AttributeRights]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attribute_id"] = attribute_id
        return self.get_attribute_rights_endpoint.call_with_http_info(**kwargs)

    def get_attributes_definition_with_rights(self, **kwargs):
        """Returns all AttributeDefinitions for every entity and possible combination of entities with rights. Only attribute definition of attributes user can read (or write) you will get. Combination of entities is based on provided parameters, which are optional (at least one must be present).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attributes_definition_with_rights(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            member (int): id of Member. [optional]
            user (int): id of User. [optional]
            vo (int): id of Vo. [optional]
            group (int): id of Group. [optional]
            resource (int): id of Resource. [optional]
            facility (int): id of Facility. [optional]
            host (int): id of Host. [optional]
            user_ext_source (int): id of UserExtSource. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [AttributeDefinition]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.get_attributes_definition_with_rights_endpoint.call_with_http_info(
            **kwargs
        )

    def get_entityless_attribute_by_name(self, key, attribute_name, **kwargs):
        """Returns an entityless Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for entityless key and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entityless_attribute_by_name(key, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): key for entityless attribute
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["key"] = key
        kwargs["attribute_name"] = attribute_name
        return self.get_entityless_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_entityless_attributes_by_key(self, key, **kwargs):
        """get_entityless_attributes_by_key  # noqa: E501

        Get all entityless attributes with subject equaled String key.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entityless_attributes_by_key(key, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): key for entityless attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["key"] = key
        return self.get_entityless_attributes_by_key_endpoint.call_with_http_info(
            **kwargs
        )

    def get_entityless_attributes_by_name(self, attr_name, **kwargs):
        """Returns all entityless attributes with attrName.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entityless_attributes_by_name(attr_name, async_req=True)
        >>> result = thread.get()

        Args:
            attr_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attr_name"] = attr_name
        return self.get_entityless_attributes_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_entityless_attributes_with_keys(self, attr_name, **kwargs):
        """Get entityless attributes mapped by their keys.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entityless_attributes_with_keys(attr_name, async_req=True)
        >>> result = thread.get()

        Args:
            attr_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            keys ([str]): key for entityless attribute. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EntitylessAttributesByKeys
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attr_name"] = attr_name
        return self.get_entityless_attributes_with_keys_endpoint.call_with_http_info(
            **kwargs
        )

    def get_entityless_keys(self, attribute_definition, **kwargs):
        """Returns list of Keys which fits the attributeDefinition.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entityless_keys(attribute_definition, async_req=True)
        >>> result = thread.get()

        Args:
            attribute_definition (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [str]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["attribute_definition"] = attribute_definition
        return self.get_entityless_keys_endpoint.call_with_http_info(**kwargs)

    def get_facility_attribute_by_id(self, facility, attribute_id, **kwargs):
        """Returns a facility Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for facility and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_facility_attribute_by_id(facility, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["attribute_id"] = attribute_id
        return self.get_facility_attribute_by_id_endpoint.call_with_http_info(**kwargs)

    def get_facility_attribute_by_name(self, facility, attribute_name, **kwargs):
        """Returns a facility Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for facility and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_facility_attribute_by_name(facility, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["attribute_name"] = attribute_name
        return self.get_facility_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_facility_attributes(self, facility, **kwargs):
        """Returns all non-empty Facility attributes for selected Facility.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_facility_attributes(facility, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        return self.get_facility_attributes_endpoint.call_with_http_info(**kwargs)

    def get_facility_attributes_by_names(self, facility, attr_names, **kwargs):
        """Returns all specified Facility attributes for selected Facility.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_facility_attributes_by_names(facility, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["attr_names"] = attr_names
        return self.get_facility_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_facility_resource_user_member_attributes(
        self, facility, resource, user, member, **kwargs
    ):
        """Get all non-empty member, user, member-resource and user-facility attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_facility_resource_user_member_attributes(facility, resource, user, member, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            resource (int): id of Resource
            user (int): id of User
            member (int): id of Member

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["resource"] = resource
        kwargs["user"] = user
        kwargs["member"] = member
        return self.get_facility_resource_user_member_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def get_facility_user_attributes(self, facility, user, **kwargs):
        """Get all non-empty attributes associated with the user on the facility.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_facility_user_attributes(facility, user, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            user (int): id of User

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["user"] = user
        return self.get_facility_user_attributes_endpoint.call_with_http_info(**kwargs)

    def get_group_attribute_by_id(self, group, attribute_id, **kwargs):
        """Returns a group Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for group and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_attribute_by_id(group, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["attribute_id"] = attribute_id
        return self.get_group_attribute_by_id_endpoint.call_with_http_info(**kwargs)

    def get_group_attribute_by_name(self, group, attribute_name, **kwargs):
        """Returns a group Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for group and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_attribute_by_name(group, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["attribute_name"] = attribute_name
        return self.get_group_attribute_by_name_endpoint.call_with_http_info(**kwargs)

    def get_group_attributes(self, group, **kwargs):
        """get_group_attributes  # noqa: E501

        Get all non-empty attributes associated with the group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_attributes(group, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        return self.get_group_attributes_endpoint.call_with_http_info(**kwargs)

    def get_group_attributes_by_names(self, group, attr_names, **kwargs):
        """get_group_attributes_by_names  # noqa: E501

        Get all attributes associated with the group which have name in list attrNames (empty too). Virtual attribute too.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_attributes_by_names(group, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["attr_names"] = attr_names
        return self.get_group_attributes_by_names_endpoint.call_with_http_info(**kwargs)

    def get_group_resource_attribute_by_id(
        self, group, resource, attribute_id, **kwargs
    ):
        """Returns a group_resource Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for group, resource and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_resource_attribute_by_id(group, resource, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            resource (int): id of Resource
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["resource"] = resource
        kwargs["attribute_id"] = attribute_id
        return self.get_group_resource_attribute_by_id_endpoint.call_with_http_info(
            **kwargs
        )

    def get_group_resource_attribute_by_name(
        self, group, resource, attribute_name, **kwargs
    ):
        """Returns a group_resource Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for group, resource and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_resource_attribute_by_name(group, resource, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            resource (int): id of Resource
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["resource"] = resource
        kwargs["attribute_name"] = attribute_name
        return self.get_group_resource_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_group_resource_attributes(self, group, resource, **kwargs):
        """Returns all non-empty Group-Resource attributes for selected Group and Resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_resource_attributes(group, resource, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            resource (int): id of Resource

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["resource"] = resource
        return self.get_group_resource_attributes_endpoint.call_with_http_info(**kwargs)

    def get_host_attribute_by_id(self, host, attribute_id, **kwargs):
        """Returns a host Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for host and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_attribute_by_id(host, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            host (int): id of Host
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["host"] = host
        kwargs["attribute_id"] = attribute_id
        return self.get_host_attribute_by_id_endpoint.call_with_http_info(**kwargs)

    def get_host_attribute_by_name(self, host, attribute_name, **kwargs):
        """Returns a host Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for host and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_attribute_by_name(host, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            host (int): id of Host
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["host"] = host
        kwargs["attribute_name"] = attribute_name
        return self.get_host_attribute_by_name_endpoint.call_with_http_info(**kwargs)

    def get_host_attributes(self, host, **kwargs):
        """get_host_attributes  # noqa: E501

        Get all non-empty attributes associated with the host.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_attributes(host, async_req=True)
        >>> result = thread.get()

        Args:
            host (int): id of Host

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["host"] = host
        return self.get_host_attributes_endpoint.call_with_http_info(**kwargs)

    def get_host_attributes_by_names(self, host, attr_names, **kwargs):
        """get_host_attributes_by_names  # noqa: E501

        Get all non-empty attributes associated with the host which have name in list attrNames (empty too). Empty list attrNames will return no attributes.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_attributes_by_names(host, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            host (int): id of Host
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["host"] = host
        kwargs["attr_names"] = attr_names
        return self.get_host_attributes_by_names_endpoint.call_with_http_info(**kwargs)

    def get_logins(self, user, **kwargs):
        """Get all users logins as Attributes. Meaning it returns all non-empty User attributes with URN starting with: \"urn:perun:user:attribute-def:def:login-namespace:\".  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_logins(user, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        return self.get_logins_endpoint.call_with_http_info(**kwargs)

    def get_member_and_user_attributes(
        self, member, work_with_user_attributes, **kwargs
    ):
        """get_member_and_user_attributes  # noqa: E501

        Get all non-empty attributes associated with the member and if workWithUserAttributes is true, get all non-empty attributes associated with user, who is this member.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_and_user_attributes(member, work_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            work_with_user_attributes (bool): flag to work with user attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["work_with_user_attributes"] = work_with_user_attributes
        return self.get_member_and_user_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_and_user_attributes_by_names(
        self, member, attr_names, work_with_user_attributes, **kwargs
    ):
        """get_member_and_user_attributes_by_names  # noqa: E501

        Get all attributes associated with the member which have name in list attrNames (empty too). Virtual attributes too. If workWithUserAttribute is true, return also all user attributes in list of attrNames (with virtual attributes too).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_and_user_attributes_by_names(member, attr_names, work_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            attr_names ([str]): list of attribute names List<String>
            work_with_user_attributes (bool): flag to work with user attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["attr_names"] = attr_names
        kwargs["work_with_user_attributes"] = work_with_user_attributes
        return (
            self.get_member_and_user_attributes_by_names_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_member_attribute_by_id(self, member, attribute_id, **kwargs):
        """Returns a member Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for member and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_attribute_by_id(member, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["attribute_id"] = attribute_id
        return self.get_member_attribute_by_id_endpoint.call_with_http_info(**kwargs)

    def get_member_attribute_by_name(self, member, attribute_name, **kwargs):
        """Returns a member Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for member and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_attribute_by_name(member, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["attribute_name"] = attribute_name
        return self.get_member_attribute_by_name_endpoint.call_with_http_info(**kwargs)

    def get_member_attributes(self, member, **kwargs):
        """get_member_attributes  # noqa: E501

        Get all non-empty attributes associated with the member.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_attributes(member, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        return self.get_member_attributes_endpoint.call_with_http_info(**kwargs)

    def get_member_attributes_by_names(self, member, attr_names, **kwargs):
        """get_member_attributes_by_names  # noqa: E501

        Get all attributes associated with the member which have name in list attrNames (empty too). Virtual attribute too.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_attributes_by_names(member, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["attr_names"] = attr_names
        return self.get_member_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_group_and_user_attributes_by_names(
        self, member, group, attr_names, work_with_user_attributes, **kwargs
    ):
        """get_member_group_and_user_attributes_by_names  # noqa: E501

        Get all attributes associated with the member in the group which have name in list attrNames (empty too). If workWithUserAttribute is true, return also all user attributes in list of attrNames (with virtual attributes too).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_group_and_user_attributes_by_names(member, group, attr_names, work_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group
            attr_names ([str]): list of attribute names List<String>
            work_with_user_attributes (bool): flag to work with user attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        kwargs["attr_names"] = attr_names
        kwargs["work_with_user_attributes"] = work_with_user_attributes
        return self.get_member_group_and_user_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_group_attribute_by_id(self, member, group, attribute_id, **kwargs):
        """Returns a member_group Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for member, group and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_group_attribute_by_id(member, group, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        kwargs["attribute_id"] = attribute_id
        return self.get_member_group_attribute_by_id_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_group_attribute_by_name(
        self, member, group, attribute_name, **kwargs
    ):
        """Returns a member_group Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for member, group and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_group_attribute_by_name(member, group, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        kwargs["attribute_name"] = attribute_name
        return self.get_member_group_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_group_attributes(self, member, group, **kwargs):
        """get_member_group_attributes  # noqa: E501

        Get all non-empty attributes associated with the member in the group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_group_attributes(member, group, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        return self.get_member_group_attributes_endpoint.call_with_http_info(**kwargs)

    def get_member_group_attributes_by_names(self, member, group, attr_names, **kwargs):
        """get_member_group_attributes_by_names  # noqa: E501

        Get all attributes (empty and virtual too)associated with the member in the group which have name in list attrNames.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_group_attributes_by_names(member, group, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        kwargs["attr_names"] = attr_names
        return self.get_member_group_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_resource_and_user_facility_attributes(
        self, member, resource, work_with_user_attributes, **kwargs
    ):
        """get_member_resource_and_user_facility_attributes  # noqa: E501

        Gets all non-empty attributes associated with the member on the resource and if workWithUserAttributes is true, gets also all non-empty user, user-facility and member attributes.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_resource_and_user_facility_attributes(member, resource, work_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource
            work_with_user_attributes (bool): flag to work with user attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        kwargs["work_with_user_attributes"] = work_with_user_attributes
        return self.get_member_resource_and_user_facility_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_resource_and_user_facility_attributes_by_names(
        self, member, resource, attr_names, work_with_user_attributes, **kwargs
    ):
        """get_member_resource_and_user_facility_attributes_by_names  # noqa: E501

        Gets selected non-empty attributes associated with the member and the resource. It returns member and member-resource attributes and also user and user-facility attributes if workWithUserAttributes is true. Attributes are selected by list of attr_names. Empty list means all attributes.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_resource_and_user_facility_attributes_by_names(member, resource, attr_names, work_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource
            attr_names ([str]): list of attribute names List<String>
            work_with_user_attributes (bool): flag to work with user attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        kwargs["attr_names"] = attr_names
        kwargs["work_with_user_attributes"] = work_with_user_attributes
        return self.get_member_resource_and_user_facility_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_resource_attribute_by_id(
        self, member, resource, attribute_id, **kwargs
    ):
        """Returns a member_resource Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for member, resource and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_resource_attribute_by_id(member, resource, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        kwargs["attribute_id"] = attribute_id
        return self.get_member_resource_attribute_by_id_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_resource_attribute_by_name(
        self, member, resource, attribute_name, **kwargs
    ):
        """Returns a member_resource Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for member, resource and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_resource_attribute_by_name(member, resource, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        kwargs["attribute_name"] = attribute_name
        return self.get_member_resource_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_member_resource_attributes(self, member, resource, **kwargs):
        """Get all non-empty attributes associated with the member on the resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_member_resource_attributes(member, resource, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        return self.get_member_resource_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_definition(self, service, **kwargs):
        """Returns required attributes definition for a Service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_definition(service, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [AttributeDefinition]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        return self.get_required_attributes_definition_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_facility(self, facility, **kwargs):
        """Returns required facility attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_facility(facility, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        return self.get_required_attributes_facility_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_facility_service(self, service, facility, **kwargs):
        """Returns facility attributes required by specified service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_facility_service(service, facility, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            facility (int): id of Facility

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["facility"] = facility
        return (
            self.get_required_attributes_facility_service_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_required_attributes_facility_services(self, services, facility, **kwargs):
        """Returns facility attributes required by specified list of services.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_facility_services(services, facility, async_req=True)
        >>> result = thread.get()

        Args:
            services ([int]): list of Service ids List<Integer>
            facility (int): id of Facility

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["services"] = services
        kwargs["facility"] = facility
        return (
            self.get_required_attributes_facility_services_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_required_attributes_group_resource_service(
        self, service, resource, group, **kwargs
    ):
        """Returns group-resource attributes required by specified service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_group_resource_service(service, resource, group, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            resource (int): id of Resource
            group (int): id of Group

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["resource"] = resource
        kwargs["group"] = group
        return self.get_required_attributes_group_resource_service_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_host_service(self, service, host, **kwargs):
        """Returns required host attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_host_service(service, host, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            host (int): id of Host

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["host"] = host
        return self.get_required_attributes_host_service_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_member(self, member, **kwargs):
        """Returns required member attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_member(member, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member

        Keyword Args:
            work_with_user_attributes (bool): flag to work with user attributes. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        return self.get_required_attributes_member_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_member_group(self, member, group, **kwargs):
        """Returns required member-group attributes. If workWithUserAttributes == TRUE, then returns also user attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_member_group(member, group, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group

        Keyword Args:
            work_with_user_attributes (bool): flag to work with user attributes. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        return self.get_required_attributes_member_group_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_member_group_resource_service(
        self, service, resource, group, member, **kwargs
    ):
        """Returns member, member-group and member-resource attributes required by specified service. If workWithUserAttributes == TRUE, then returns also user and user-facility attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_member_group_resource_service(service, resource, group, member, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            resource (int): id of Resource
            group (int): id of Group
            member (int): id of Member

        Keyword Args:
            work_with_user_attributes (bool): flag to work with user attributes. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["resource"] = resource
        kwargs["group"] = group
        kwargs["member"] = member
        return self.get_required_attributes_member_group_resource_service_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_member_group_service(
        self, service, group, member, **kwargs
    ):
        """Returns member-group attributes required by specified service. If workWithUserAttributes == TRUE, then returns also member and user attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_member_group_service(service, group, member, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            group (int): id of Group
            member (int): id of Member

        Keyword Args:
            work_with_user_attributes (bool): flag to work with user attributes. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["group"] = group
        kwargs["member"] = member
        return self.get_required_attributes_member_group_service_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_member_resource(self, member, resource, **kwargs):
        """Returns member-resource attributes required by specified list of services. If workWithUserAttributes == TRUE, then returns also user attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_member_resource(member, resource, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource

        Keyword Args:
            work_with_user_attributes (bool): flag to work with user attributes. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        return (
            self.get_required_attributes_member_resource_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_required_attributes_member_resource_service(
        self, service, resource, member, **kwargs
    ):
        """Returns member and member-resource attributes required by the specified service. If workWithUserAttributes == TRUE, then returns also user attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_member_resource_service(service, resource, member, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            resource (int): id of Resource
            member (int): id of Member

        Keyword Args:
            work_with_user_attributes (bool): flag to work with user attributes. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["resource"] = resource
        kwargs["member"] = member
        return self.get_required_attributes_member_resource_service_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_resource(self, resource, **kwargs):
        """Returns required resource attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_resource(resource, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        return self.get_required_attributes_resource_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_resource_service(self, service, resource, **kwargs):
        """Returns resource attributes required by specified service.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_resource_service(service, resource, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            resource (int): id of Resource

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["resource"] = resource
        return (
            self.get_required_attributes_resource_service_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_required_attributes_resource_services(self, services, resource, **kwargs):
        """Returns resource attributes required by specified list of services.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_resource_services(services, resource, async_req=True)
        >>> result = thread.get()

        Args:
            services ([int]): list of Service ids List<Integer>
            resource (int): id of Resource

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["services"] = services
        kwargs["resource"] = resource
        return (
            self.get_required_attributes_resource_services_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_required_attributes_user(self, user, **kwargs):
        """Returns required user attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_user(user, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        return self.get_required_attributes_user_endpoint.call_with_http_info(**kwargs)

    def get_required_attributes_user_facility(self, user, facility, **kwargs):
        """Returns required user-facility attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_user_facility(user, facility, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            facility (int): id of Facility

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["facility"] = facility
        return self.get_required_attributes_user_facility_endpoint.call_with_http_info(
            **kwargs
        )

    def get_required_attributes_vo_service(self, service, vo, **kwargs):
        """Returns required vo attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_required_attributes_vo_service(service, vo, async_req=True)
        >>> result = thread.get()

        Args:
            service (int): id of Service
            vo (int): id of Vo

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["service"] = service
        kwargs["vo"] = vo
        return self.get_required_attributes_vo_service_endpoint.call_with_http_info(
            **kwargs
        )

    def get_resource_attribute_by_id(self, resource, attribute_id, **kwargs):
        """Returns a resource Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for resource and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_attribute_by_id(resource, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["attribute_id"] = attribute_id
        return self.get_resource_attribute_by_id_endpoint.call_with_http_info(**kwargs)

    def get_resource_attribute_by_name(self, resource, attribute_name, **kwargs):
        """Returns a resource Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for resource and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_attribute_by_name(resource, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["attribute_name"] = attribute_name
        return self.get_resource_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_resource_attributes(self, resource, **kwargs):
        """Get all non-empty attributes associated with the resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_attributes(resource, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        return self.get_resource_attributes_endpoint.call_with_http_info(**kwargs)

    def get_resource_attributes_by_names(self, resource, attr_names, **kwargs):
        """get_resource_attributes_by_names  # noqa: E501

        Get all attributes associated with the resource which have name in list attrNames (empty too). Virtual attributes too.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_attributes_by_names(resource, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["attr_names"] = attr_names
        return self.get_resource_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_resource_group_and_group_attributes(
        self, resource, group, work_with_group_attributes, **kwargs
    ):
        """get_resource_group_and_group_attributes  # noqa: E501

        Get all non-empty attributes associated with the group and resource. Virtual attributes too. If workWithGroupAttributes is true, return also all group attributes.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_group_and_group_attributes(resource, group, work_with_group_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            group (int): id of Group
            work_with_group_attributes (bool): flag to work with group attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["group"] = group
        kwargs["work_with_group_attributes"] = work_with_group_attributes
        return (
            self.get_resource_group_and_group_attributes_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_resource_group_and_group_attributes_by_names(
        self, resource, group, attr_names, work_with_group_attributes, **kwargs
    ):
        """get_resource_group_and_group_attributes_by_names  # noqa: E501

        Get all attributes associated with the group and the resource which have their name in list attrNames (empty too). Virtual attributes too. If workWithGroupAttributes is true, return also all group attributes in list of attrNames (with virtual attributes too).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_group_and_group_attributes_by_names(resource, group, attr_names, work_with_group_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            group (int): id of Group
            attr_names ([str]): list of attribute names List<String>
            work_with_group_attributes (bool): flag to work with group attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["group"] = group
        kwargs["attr_names"] = attr_names
        kwargs["work_with_group_attributes"] = work_with_group_attributes
        return self.get_resource_group_and_group_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_resource_group_attributes(self, resource, group, **kwargs):
        """Get all non-empty attributes associated with the group on resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_group_attributes(resource, group, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            group (int): id of Group

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["group"] = group
        return self.get_resource_group_attributes_endpoint.call_with_http_info(**kwargs)

    def get_resource_group_member_attributes_by_names(
        self, resource, group, member, attr_names, **kwargs
    ):
        """get_resource_group_member_attributes_by_names  # noqa: E501

        Get all attributes by the list of attrNames if they are in one of these namespaces: - member - group - member-group - resource - member-resource - group-resource - user (get from member object) - facility (get from resource object) - user-facility Returns all attributes even if they are empty or virtual.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resource_group_member_attributes_by_names(resource, group, member, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            group (int): id of Group
            member (int): id of Member
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["group"] = group
        kwargs["member"] = member
        kwargs["attr_names"] = attr_names
        return self.get_resource_group_member_attributes_by_names_endpoint.call_with_http_info(
            **kwargs
        )

    def get_user_attribute_by_id(self, user, attribute_id, **kwargs):
        """Returns a user Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for user and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_attribute_by_id(user, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["attribute_id"] = attribute_id
        return self.get_user_attribute_by_id_endpoint.call_with_http_info(**kwargs)

    def get_user_attribute_by_name(self, user, attribute_name, **kwargs):
        """Returns a user Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for user and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_attribute_by_name(user, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["attribute_name"] = attribute_name
        return self.get_user_attribute_by_name_endpoint.call_with_http_info(**kwargs)

    def get_user_attributes(self, user, **kwargs):
        """get_user_attributes  # noqa: E501

        Get all non-empty attributes associated with the user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_attributes(user, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        return self.get_user_attributes_endpoint.call_with_http_info(**kwargs)

    def get_user_attributes_by_names(self, user, attr_names, **kwargs):
        """get_user_attributes_by_names  # noqa: E501

        Get all attributes associated with the user which have name in list attrNames (empty too).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_attributes_by_names(user, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["attr_names"] = attr_names
        return self.get_user_attributes_by_names_endpoint.call_with_http_info(**kwargs)

    def get_user_ext_source_attribute_by_id(
        self, user_ext_source, attribute_id, **kwargs
    ):
        """Returns a UserExtSource Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for UserExtSource and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_ext_source_attribute_by_id(user_ext_source, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            user_ext_source (int): id of UserExtSource
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user_ext_source"] = user_ext_source
        kwargs["attribute_id"] = attribute_id
        return self.get_user_ext_source_attribute_by_id_endpoint.call_with_http_info(
            **kwargs
        )

    def get_user_ext_source_attribute_by_name(
        self, user_ext_source, attribute_name, **kwargs
    ):
        """Returns a UserExtSource Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for UserExtSource and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_ext_source_attribute_by_name(user_ext_source, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            user_ext_source (int): id of UserExtSource
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user_ext_source"] = user_ext_source
        kwargs["attribute_name"] = attribute_name
        return self.get_user_ext_source_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_user_ext_source_attributes(self, user_ext_source, **kwargs):
        """get_user_ext_source_attributes  # noqa: E501

        Get all non-empty attributes associated with the UserExtSource.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_ext_source_attributes(user_ext_source, async_req=True)
        >>> result = thread.get()

        Args:
            user_ext_source (int): id of UserExtSource

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user_ext_source"] = user_ext_source
        return self.get_user_ext_source_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def get_user_ext_source_attributes_by_names(
        self, user_ext_source, attr_names, **kwargs
    ):
        """get_user_ext_source_attributes_by_names  # noqa: E501

        Get all attributes associated with the userExtSource which have name in list attrNames (empty too).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_ext_source_attributes_by_names(user_ext_source, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            user_ext_source (int): id of UserExtSource
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user_ext_source"] = user_ext_source
        kwargs["attr_names"] = attr_names
        return (
            self.get_user_ext_source_attributes_by_names_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def get_user_facility_attribute_by_id(self, user, facility, attribute_id, **kwargs):
        """Returns a user_facility Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for user, facility and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_facility_attribute_by_id(user, facility, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            facility (int): id of Facility
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["facility"] = facility
        kwargs["attribute_id"] = attribute_id
        return self.get_user_facility_attribute_by_id_endpoint.call_with_http_info(
            **kwargs
        )

    def get_user_facility_attribute_by_name(
        self, user, facility, attribute_name, **kwargs
    ):
        """Returns a user_facility Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for user, facility and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_facility_attribute_by_name(user, facility, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            facility (int): id of Facility
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["facility"] = facility
        kwargs["attribute_name"] = attribute_name
        return self.get_user_facility_attribute_by_name_endpoint.call_with_http_info(
            **kwargs
        )

    def get_user_facility_attributes(self, user, facility, **kwargs):
        """Returns all non-empty User-Facility attributes for selected User and Facility.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_facility_attributes(user, facility, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            facility (int): id of Facility

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["facility"] = facility
        return self.get_user_facility_attributes_endpoint.call_with_http_info(**kwargs)

    def get_vo_attribute_by_id(self, vo, attribute_id, **kwargs):
        """Returns a Vo Attribute by its id.  # noqa: E501

        This is an overloaded method getAttribute, specialized for virtual organization and attribute id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vo_attribute_by_id(vo, attribute_id, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attribute_id (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["vo"] = vo
        kwargs["attribute_id"] = attribute_id
        return self.get_vo_attribute_by_id_endpoint.call_with_http_info(**kwargs)

    def get_vo_attribute_by_name(self, vo, attribute_name, **kwargs):
        """Returns a Vo Attribute by its name.  # noqa: E501

        This is an overloaded method getAttribute, specialized for virtual organization and attribute name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vo_attribute_by_name(vo, attribute_name, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attribute_name (str): full name of attribute definition (namespace + ':' + friendlyName)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Attribute
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["vo"] = vo
        kwargs["attribute_name"] = attribute_name
        return self.get_vo_attribute_by_name_endpoint.call_with_http_info(**kwargs)

    def get_vo_attributes(self, vo, **kwargs):
        """Get all attributes associated with the vo.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vo_attributes(vo, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["vo"] = vo
        return self.get_vo_attributes_endpoint.call_with_http_info(**kwargs)

    def get_vo_attributes_by_names(self, vo, attr_names, **kwargs):
        """Get all attributes associated with the vo which have name in list attrNames (empty too).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vo_attributes_by_names(vo, attr_names, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attr_names ([str]): list of attribute names List<String>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [Attribute]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["vo"] = vo
        kwargs["attr_names"] = attr_names
        return self.get_vo_attributes_by_names_endpoint.call_with_http_info(**kwargs)

    def remove_attributes_for_facility_resource_group_user_member(
        self, facility, resource, group, user, member, attributes, **kwargs
    ):
        """Remove attributes of namespace facility, resource, group, user and member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_attributes_for_facility_resource_group_user_member(facility, resource, group, user, member, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            resource (int): id of Resource
            group (int): id of Group
            user (int): id of User
            member (int): id of Member
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["resource"] = resource
        kwargs["group"] = group
        kwargs["user"] = user
        kwargs["member"] = member
        kwargs["attributes"] = attributes
        return self.remove_attributes_for_facility_resource_group_user_member_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_attributes_for_facility_resource_user_member(
        self, facility, resource, user, member, attributes, **kwargs
    ):
        """Remove attributes of namespace facility, resource, user and member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_attributes_for_facility_resource_user_member(facility, resource, user, member, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            resource (int): id of Resource
            user (int): id of User
            member (int): id of Member
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["resource"] = resource
        kwargs["user"] = user
        kwargs["member"] = member
        kwargs["attributes"] = attributes
        return self.remove_attributes_for_facility_resource_user_member_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_entityless_attribute(self, key, attribute, **kwargs):
        """Remove entityless attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_entityless_attribute(key, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): key of an entityless attribute
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["key"] = key
        kwargs["attribute"] = attribute
        return self.remove_entityless_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_facility_attribute(self, facility, attribute, **kwargs):
        """Remove facility attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_facility_attribute(facility, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["attribute"] = attribute
        return self.remove_facility_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_facility_attributes(self, facility, attributes, **kwargs):
        """Remove attributes of namespace facility  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_facility_attributes(facility, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            facility (int): id of Facility
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["facility"] = facility
        kwargs["attributes"] = attributes
        return self.remove_facility_attributes_endpoint.call_with_http_info(**kwargs)

    def remove_group_attribute(self, group, attribute, **kwargs):
        """Remove group attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_group_attribute(group, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["attribute"] = attribute
        return self.remove_group_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_group_attributes(self, group, attributes, **kwargs):
        """Remove attributes of namespace group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_group_attributes(group, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["attributes"] = attributes
        return self.remove_group_attributes_endpoint.call_with_http_info(**kwargs)

    def remove_group_resource_attribute(self, group, resource, attribute, **kwargs):
        """Remove group-resource attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_group_resource_attribute(group, resource, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            resource (int): id of Resource
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["resource"] = resource
        kwargs["attribute"] = attribute
        return self.remove_group_resource_attribute_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_group_resource_attributes(self, group, resource, attributes, **kwargs):
        """Remove attributes of namespace group-resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_group_resource_attributes(group, resource, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            resource (int): id of Resource
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["resource"] = resource
        kwargs["attributes"] = attributes
        return self.remove_group_resource_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_group_resource_attributes_work_with_group_attributes(
        self, group, resource, attributes, work_with_group_attributes, **kwargs
    ):
        """Remove attributes of namespace group-resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_group_resource_attributes_work_with_group_attributes(group, resource, attributes, work_with_group_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            group (int): id of Group
            resource (int): id of Resource
            attributes ([int]): list of attribute ids List<Integer>
            work_with_group_attributes (bool): flag to work with group attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["group"] = group
        kwargs["resource"] = resource
        kwargs["attributes"] = attributes
        kwargs["work_with_group_attributes"] = work_with_group_attributes
        return self.remove_group_resource_attributes_work_with_group_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_host_attribute(self, host, attribute, **kwargs):
        """Remove host attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_host_attribute(host, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            host (int): id of Host
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["host"] = host
        kwargs["attribute"] = attribute
        return self.remove_host_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_host_attributes(self, host, attributes, **kwargs):
        """Remove attributes of namespace host  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_host_attributes(host, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            host (int): id of Host
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["host"] = host
        kwargs["attributes"] = attributes
        return self.remove_host_attributes_endpoint.call_with_http_info(**kwargs)

    def remove_member_attribute(self, member, attribute, **kwargs):
        """Remove member attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_attribute(member, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["attribute"] = attribute
        return self.remove_member_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_member_attributes(self, member, attributes, **kwargs):
        """Remove attributes of namespace member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_attributes(member, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["attributes"] = attributes
        return self.remove_member_attributes_endpoint.call_with_http_info(**kwargs)

    def remove_member_attributes_work_with_user_attributes(
        self, member, attributes, work_with_user_attributes, **kwargs
    ):
        """Remove attributes of namespace member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_attributes_work_with_user_attributes(member, attributes, work_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            attributes ([int]): list of attribute ids List<Integer>
            work_with_user_attributes (bool): flag to work with user attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["attributes"] = attributes
        kwargs["work_with_user_attributes"] = work_with_user_attributes
        return self.remove_member_attributes_work_with_user_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_member_group_attribute(self, member, group, attribute, **kwargs):
        """Remove member-group attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_group_attribute(member, group, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        kwargs["attribute"] = attribute
        return self.remove_member_group_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_member_group_attributes(self, member, group, attributes, **kwargs):
        """Remove attributes of namespace member-group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_group_attributes(member, group, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        kwargs["attributes"] = attributes
        return self.remove_member_group_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_member_group_attributes_work_with_user_attributes(
        self, member, group, attributes, work_with_user_attributes, **kwargs
    ):
        """Remove attributes of namespace member-group  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_group_attributes_work_with_user_attributes(member, group, attributes, work_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            group (int): id of Group
            attributes ([int]): list of attribute ids List<Integer>
            work_with_user_attributes (bool): flag to work with user attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["group"] = group
        kwargs["attributes"] = attributes
        kwargs["work_with_user_attributes"] = work_with_user_attributes
        return self.remove_member_group_attributes_work_with_user_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_member_resource_attribute(self, member, resource, attribute, **kwargs):
        """Remove member-resource attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_resource_attribute(member, resource, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        kwargs["attribute"] = attribute
        return self.remove_member_resource_attribute_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_member_resource_attributes(self, member, resource, attributes, **kwargs):
        """Remove attributes of namespace member-resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_member_resource_attributes(member, resource, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            member (int): id of Member
            resource (int): id of Resource
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["member"] = member
        kwargs["resource"] = resource
        kwargs["attributes"] = attributes
        return self.remove_member_resource_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_resource_attribute(self, resource, attribute, **kwargs):
        """Remove resource attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_resource_attribute(resource, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["attribute"] = attribute
        return self.remove_resource_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_resource_attributes(self, resource, attributes, **kwargs):
        """Remove attributes of namespace resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_resource_attributes(resource, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            resource (int): id of Resource
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["resource"] = resource
        kwargs["attributes"] = attributes
        return self.remove_resource_attributes_endpoint.call_with_http_info(**kwargs)

    def remove_ues_attributes(self, user_ext_source, attributes, **kwargs):
        """Remove attributes of namespace userExtSource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_ues_attributes(user_ext_source, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            user_ext_source (int): id of UserExtSource
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user_ext_source"] = user_ext_source
        kwargs["attributes"] = attributes
        return self.remove_ues_attributes_endpoint.call_with_http_info(**kwargs)

    def remove_user_attribute(self, user, attribute, **kwargs):
        """Remove user attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_attribute(user, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["attribute"] = attribute
        return self.remove_user_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_user_attributes(self, user, attributes, **kwargs):
        """Remove attributes of namespace user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_attributes(user, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["attributes"] = attributes
        return self.remove_user_attributes_endpoint.call_with_http_info(**kwargs)

    def remove_user_ext_source_attribute(self, user_ext_source, attribute, **kwargs):
        """Remove userExtSource attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_ext_source_attribute(user_ext_source, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            user_ext_source (int): id of UserExtSource
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user_ext_source"] = user_ext_source
        kwargs["attribute"] = attribute
        return self.remove_user_ext_source_attribute_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_user_facility_attribute(self, user, facility, attribute, **kwargs):
        """Remove user facility attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_facility_attribute(user, facility, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            facility (int): id of Facility
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["facility"] = facility
        kwargs["attribute"] = attribute
        return self.remove_user_facility_attribute_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_user_facility_attributes(self, user, facility, attributes, **kwargs):
        """Remove attributes of namespace user-facility  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_facility_attributes(user, facility, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            user (int): id of User
            facility (int): id of Facility
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["user"] = user
        kwargs["facility"] = facility
        kwargs["attributes"] = attributes
        return self.remove_user_facility_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def remove_vo_attribute(self, vo, attribute, **kwargs):
        """Remove vo attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vo_attribute(vo, attribute, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attribute (int): id of AttributeDefinition

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["vo"] = vo
        kwargs["attribute"] = attribute
        return self.remove_vo_attribute_endpoint.call_with_http_info(**kwargs)

    def remove_vo_attributes(self, vo, attributes, **kwargs):
        """Remove attributes of namespace vo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vo_attributes(vo, attributes, async_req=True)
        >>> result = thread.get()

        Args:
            vo (int): id of Vo
            attributes ([int]): list of attribute ids List<Integer>

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["vo"] = vo
        kwargs["attributes"] = attributes
        return self.remove_vo_attributes_endpoint.call_with_http_info(**kwargs)

    def set_attribute_policy_collections(
        self, input_attribute_policy_collections, **kwargs
    ):
        """Deletes old attribute policy collections and sets attribute policy collections for an attribute definition provided in given policy collections.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_attribute_policy_collections(input_attribute_policy_collections, async_req=True)
        >>> result = thread.get()

        Args:
            input_attribute_policy_collections (InputAttributePolicyCollections):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_attribute_policy_collections"
        ] = input_attribute_policy_collections
        return self.set_attribute_policy_collections_endpoint.call_with_http_info(
            **kwargs
        )

    def set_attribute_rights(self, input_attribute_rights, **kwargs):
        """Sets all AttributeRights in the list given as a parameter. Allowed Roles to set rights for are: VOADMIN, GROUPADMIN, FACILITYADMIN, SELF.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_attribute_rights(input_attribute_rights, async_req=True)
        >>> result = thread.get()

        Args:
            input_attribute_rights (InputAttributeRights):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_attribute_rights"] = input_attribute_rights
        return self.set_attribute_rights_endpoint.call_with_http_info(**kwargs)

    def set_entityless_attribute(self, input_entityless_attribute, **kwargs):
        """Sets entityless Attribute.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_entityless_attribute(input_entityless_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_entityless_attribute (InputEntitylessAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_entityless_attribute"] = input_entityless_attribute
        return self.set_entityless_attribute_endpoint.call_with_http_info(**kwargs)

    def set_facility_attribute(self, input_set_facility_attribute, **kwargs):
        """Sets Attribute for Facility.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_facility_attribute(input_set_facility_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_facility_attribute (InputSetFacilityAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_facility_attribute"] = input_set_facility_attribute
        return self.set_facility_attribute_endpoint.call_with_http_info(**kwargs)

    def set_facility_attributes(self, input_set_facility_attributes, **kwargs):
        """set_facility_attributes  # noqa: E501

        Store the attributes associated with the facility. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_facility_attributes(input_set_facility_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_facility_attributes (InputSetFacilityAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_facility_attributes"] = input_set_facility_attributes
        return self.set_facility_attributes_endpoint.call_with_http_info(**kwargs)

    def set_facility_resource_group_user_member_attributes(
        self, input_set_facility_resource_group_user_member_attributes, **kwargs
    ):
        """set_facility_resource_group_user_member_attributes  # noqa: E501

        Store the member, user, member-group, member-resource and user-facility attributes. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification). Group and group-resource attributes are not supported in this context.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_facility_resource_group_user_member_attributes(input_set_facility_resource_group_user_member_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_facility_resource_group_user_member_attributes (InputSetFacilityResourceGroupUserMemberAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_facility_resource_group_user_member_attributes"
        ] = input_set_facility_resource_group_user_member_attributes
        return self.set_facility_resource_group_user_member_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def set_facility_resource_user_member_attributes(
        self, input_set_facility_resource_user_member_attributes, **kwargs
    ):
        """set_facility_resource_user_member_attributes  # noqa: E501

        Store the member, user, member-resource and user-facility attributes. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_facility_resource_user_member_attributes(input_set_facility_resource_user_member_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_facility_resource_user_member_attributes (InputSetFacilityResourceUserMemberAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_facility_resource_user_member_attributes"
        ] = input_set_facility_resource_user_member_attributes
        return self.set_facility_resource_user_member_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def set_facility_user_attributes(
        self, input_set_facility_user_attributes, **kwargs
    ):
        """set_facility_user_attributes  # noqa: E501

        Store the attributes associated with the facility and user combination. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_facility_user_attributes(input_set_facility_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_facility_user_attributes (InputSetFacilityUserAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_facility_user_attributes"
        ] = input_set_facility_user_attributes
        return self.set_facility_user_attributes_endpoint.call_with_http_info(**kwargs)

    def set_group_attribute(self, input_set_group_attribute, **kwargs):
        """Sets Attribute for Group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_group_attribute(input_set_group_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_group_attribute (InputSetGroupAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_group_attribute"] = input_set_group_attribute
        return self.set_group_attribute_endpoint.call_with_http_info(**kwargs)

    def set_group_attributes(self, input_set_group_attributes, **kwargs):
        """set_group_attributes  # noqa: E501

        Store the attributes associated with the group. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_group_attributes(input_set_group_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_group_attributes (InputSetGroupAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_group_attributes"] = input_set_group_attributes
        return self.set_group_attributes_endpoint.call_with_http_info(**kwargs)

    def set_group_resource_attribute(
        self, input_set_group_resource_attribute, **kwargs
    ):
        """Sets Attribute for Group and Resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_group_resource_attribute(input_set_group_resource_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_group_resource_attribute (InputSetGroupResourceAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_group_resource_attribute"
        ] = input_set_group_resource_attribute
        return self.set_group_resource_attribute_endpoint.call_with_http_info(**kwargs)

    def set_group_resource_attributes(
        self, input_set_group_resource_attributes, **kwargs
    ):
        """Sets Attributes for Group and Resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_group_resource_attributes(input_set_group_resource_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_group_resource_attributes (InputSetGroupResourceAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_group_resource_attributes"
        ] = input_set_group_resource_attributes
        return self.set_group_resource_attributes_endpoint.call_with_http_info(**kwargs)

    def set_host_attribute(self, input_set_host_attribute, **kwargs):
        """Sets Attribute for Host.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_host_attribute(input_set_host_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_host_attribute (InputSetHostAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_host_attribute"] = input_set_host_attribute
        return self.set_host_attribute_endpoint.call_with_http_info(**kwargs)

    def set_host_attributes(self, input_set_host_attributes, **kwargs):
        """set_host_attributes  # noqa: E501

        Store the attributes associated with the host. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_host_attributes(input_set_host_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_host_attributes (InputSetHostAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_host_attributes"] = input_set_host_attributes
        return self.set_host_attributes_endpoint.call_with_http_info(**kwargs)

    def set_member_attribute(self, input_set_member_attribute, **kwargs):
        """Sets Attribute for Member.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_attribute(input_set_member_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_attribute (InputSetMemberAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_member_attribute"] = input_set_member_attribute
        return self.set_member_attribute_endpoint.call_with_http_info(**kwargs)

    def set_member_attributes(self, input_set_member_attributes, **kwargs):
        """set_member_attributes  # noqa: E501

        Store the attributes associated with the member. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_attributes(input_set_member_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_attributes (InputSetMemberAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_member_attributes"] = input_set_member_attributes
        return self.set_member_attributes_endpoint.call_with_http_info(**kwargs)

    def set_member_group_attribute(self, input_set_member_group_attribute, **kwargs):
        """Sets Attribute for Member and Group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_group_attribute(input_set_member_group_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_group_attribute (InputSetMemberGroupAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_member_group_attribute"] = input_set_member_group_attribute
        return self.set_member_group_attribute_endpoint.call_with_http_info(**kwargs)

    def set_member_group_attributes(self, input_set_member_group_attributes, **kwargs):
        """set_member_group_attributes  # noqa: E501

        Store the attributes associated with the member and group combination. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_group_attributes(input_set_member_group_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_group_attributes (InputSetMemberGroupAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_member_group_attributes"] = input_set_member_group_attributes
        return self.set_member_group_attributes_endpoint.call_with_http_info(**kwargs)

    def set_member_group_with_user_attributes(
        self, input_set_member_group_with_user_attributes, **kwargs
    ):
        """set_member_group_with_user_attributes  # noqa: E501

        Store the attributes associated with the member and group combination. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification). If workWithUserAttributes is true, the method stores also the attributes associated with user and member.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_group_with_user_attributes(input_set_member_group_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_group_with_user_attributes (InputSetMemberGroupWithUserAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_member_group_with_user_attributes"
        ] = input_set_member_group_with_user_attributes
        return self.set_member_group_with_user_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def set_member_resource_and_user_attributes(
        self, input_set_member_resource_and_user_attributes, **kwargs
    ):
        """set_member_resource_and_user_attributes  # noqa: E501

        Store the attributes associated with the resource and member combination. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification). If workWithUserAttributes is true, the method stores also the attributes associated with user, user-facility and member.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_resource_and_user_attributes(input_set_member_resource_and_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_resource_and_user_attributes (InputSetMemberResourceAndUserAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_member_resource_and_user_attributes"
        ] = input_set_member_resource_and_user_attributes
        return (
            self.set_member_resource_and_user_attributes_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def set_member_resource_attribute(
        self, input_set_member_resource_attribute, **kwargs
    ):
        """Sets Attribute for Member and Resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_resource_attribute(input_set_member_resource_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_resource_attribute (InputSetMemberResourceAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_member_resource_attribute"
        ] = input_set_member_resource_attribute
        return self.set_member_resource_attribute_endpoint.call_with_http_info(**kwargs)

    def set_member_resource_attributes(
        self, input_set_member_resource_attributes, **kwargs
    ):
        """set_member_resource_attributes  # noqa: E501

        Store the attributes associated with the resource and member combination. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_resource_attributes(input_set_member_resource_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_resource_attributes (InputSetMemberResourceAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_member_resource_attributes"
        ] = input_set_member_resource_attributes
        return self.set_member_resource_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def set_member_with_user_attributes(
        self, input_set_member_with_user_attributes, **kwargs
    ):
        """set_member_with_user_attributes  # noqa: E501

        Store the attributes associated with member and user (which we get from this member) if workWithUserAttributes is true.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_member_with_user_attributes(input_set_member_with_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_member_with_user_attributes (InputSetMemberWithUserAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_member_with_user_attributes"
        ] = input_set_member_with_user_attributes
        return self.set_member_with_user_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def set_resource_attribute(self, input_set_resource_attribute, **kwargs):
        """Sets Attribute for Resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_resource_attribute(input_set_resource_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_resource_attribute (InputSetResourceAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_resource_attribute"] = input_set_resource_attribute
        return self.set_resource_attribute_endpoint.call_with_http_info(**kwargs)

    def set_resource_attributes(self, input_set_resource_attributes, **kwargs):
        """set_resource_attributes  # noqa: E501

        Store the attributes associated with the resource.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_resource_attributes(input_set_resource_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_resource_attributes (InputSetResourceAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_resource_attributes"] = input_set_resource_attributes
        return self.set_resource_attributes_endpoint.call_with_http_info(**kwargs)

    def set_resource_group_attributes(
        self, input_set_resource_group_attributes, **kwargs
    ):
        """set_resource_group_attributes  # noqa: E501

        Store the attributes associated with the group on resource.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_resource_group_attributes(input_set_resource_group_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_resource_group_attributes (InputSetResourceGroupAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_resource_group_attributes"
        ] = input_set_resource_group_attributes
        return self.set_resource_group_attributes_endpoint.call_with_http_info(**kwargs)

    def set_resource_group_with_group_attributes(
        self, input_set_resource_group_with_group_attributes, **kwargs
    ):
        """set_resource_group_with_group_attributes  # noqa: E501

        Store the attributes associated with group and resource, if workWithUserAttributes is true then also from group itself. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_resource_group_with_group_attributes(input_set_resource_group_with_group_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_resource_group_with_group_attributes (InputSetResourceGroupWithGroupAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_resource_group_with_group_attributes"
        ] = input_set_resource_group_with_group_attributes
        return (
            self.set_resource_group_with_group_attributes_endpoint.call_with_http_info(
                **kwargs
            )
        )

    def set_user_attribute(self, input_set_user_attribute, **kwargs):
        """Sets Attribute for User.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_user_attribute(input_set_user_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_user_attribute (InputSetUserAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_user_attribute"] = input_set_user_attribute
        return self.set_user_attribute_endpoint.call_with_http_info(**kwargs)

    def set_user_attributes(self, input_set_user_attributes, **kwargs):
        """set_user_attributes  # noqa: E501

        Store the attributes associated with the user. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_user_attributes(input_set_user_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_user_attributes (InputSetUserAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_user_attributes"] = input_set_user_attributes
        return self.set_user_attributes_endpoint.call_with_http_info(**kwargs)

    def set_user_ext_source_attribute(
        self, input_set_user_ext_source_attribute, **kwargs
    ):
        """Sets Attribute for UserExtSource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_user_ext_source_attribute(input_set_user_ext_source_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_user_ext_source_attribute (InputSetUserExtSourceAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_user_ext_source_attribute"
        ] = input_set_user_ext_source_attribute
        return self.set_user_ext_source_attribute_endpoint.call_with_http_info(**kwargs)

    def set_user_ext_source_attributes(
        self, input_set_user_ext_source_attributes, **kwargs
    ):
        """set_user_ext_source_attributes  # noqa: E501

        Store the attributes associated with the UserExtSource. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_user_ext_source_attributes(input_set_user_ext_source_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_user_ext_source_attributes (InputSetUserExtSourceAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_user_ext_source_attributes"
        ] = input_set_user_ext_source_attributes
        return self.set_user_ext_source_attributes_endpoint.call_with_http_info(
            **kwargs
        )

    def set_user_facility_attribute(self, input_set_user_facility_attribute, **kwargs):
        """Sets Attribute for User and Facility.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_user_facility_attribute(input_set_user_facility_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_user_facility_attribute (InputSetUserFacilityAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_user_facility_attribute"] = input_set_user_facility_attribute
        return self.set_user_facility_attribute_endpoint.call_with_http_info(**kwargs)

    def set_user_facility_attributes(
        self, input_set_user_facility_attributes, **kwargs
    ):
        """Sets Attributes for User and Facility.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_user_facility_attributes(input_set_user_facility_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_user_facility_attributes (InputSetUserFacilityAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs[
            "input_set_user_facility_attributes"
        ] = input_set_user_facility_attributes
        return self.set_user_facility_attributes_endpoint.call_with_http_info(**kwargs)

    def set_vo_attribute(self, input_set_vo_attribute, **kwargs):
        """Sets Attribute for Vo.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_vo_attribute(input_set_vo_attribute, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_vo_attribute (InputSetVoAttribute):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_vo_attribute"] = input_set_vo_attribute
        return self.set_vo_attribute_endpoint.call_with_http_info(**kwargs)

    def set_vo_attributes(self, input_set_vo_attributes, **kwargs):
        """set_vo_attributes  # noqa: E501

        Store the attributes associated with the vo. If an attribute is core attribute then the attribute isn't stored (It's skipped without any notification).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_vo_attributes(input_set_vo_attributes, async_req=True)
        >>> result = thread.get()

        Args:
            input_set_vo_attributes (InputSetVoAttributes):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_set_vo_attributes"] = input_set_vo_attributes
        return self.set_vo_attributes_endpoint.call_with_http_info(**kwargs)

    def update_attribute_definition(self, input_attribute_definition, **kwargs):
        """Updates AttributeDefinition in Perun based on provided object. Update is done on AttributeDefinition selected by its <code>id</code>.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_attribute_definition(input_attribute_definition, async_req=True)
        >>> result = thread.get()

        Args:
            input_attribute_definition (InputAttributeDefinition):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AttributeDefinition
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["input_attribute_definition"] = input_attribute_definition
        return self.update_attribute_definition_endpoint.call_with_http_info(**kwargs)
