# ltp_server
基于Python的用FastAPI简单封装的LTP服务

## 安装

```shell script
pip install ltp_server
```



## 服务端

### 使用方式

#### 方式一：Python库引用

示例：

```shell script
from ltp_server import Server
if __name__ == '__main__':
    model_path = r"/root/Data/NLP/Model/LTP"
    # server = Server(model_path=model_path)
    # server.run()
    Server(model_path).run()
```

#### 方式二：shell命令

示例：

```shell script
ltp_server --model_path=/root/Data/NLP/Model/LTP
```

### 可用选项

| 参数名     | 是否可选 | 默认值    | 说明                     |
| ---------- | -------- | --------- | ------------------------ |
| model_path | 否       |           | LTP模型路径（绝对路径）  |
| dict_path  | 是       | None      | 用户词表路径（绝对路径） |
| max_window | 是       | 4         | 前向分词最大窗口         |
| host       | 是       | 127.0.0.1 | 服务主机名               |
| port       | 是       | 8000      | 服务监听端口             |

### 服务概览

| 服务功能           | 服务路由    | 请求方式 |
| ------------------ | ----------- | -------- |
| 分句               | /sent_split | POST     |
| 增加自定义词语     | /add_words  | POST     |
| 分词               | /seg        | POST     |
| 词性标注           | /pos        | POST     |
| 命名实体识别       | /ner        | POST     |
| 语义角色标注       | /srl        | POST     |
| 依存句法分析       | /dep        | POST     |
| 语义依存分析（树） | /sdp         | POST     |
| 语义依存分析（图） | /sdpg        | POST     |

### 请求示例

#### 分句

```bash
### sent_split
POST http://localhost:8000/sent_split
Content-Type: application/json

{
  "texts": ["曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"]
}
```

返回值：

```json
{
  "texts": [
    "曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"
  ],
  "sents": [
    "曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"
  ],
  "status": 0
}
```

#### 增加自定义词语

```bash
### add_words
POST http://localhost:8000/add_words
Content-Type: application/json

{
  "words": ["江大桥"]
}
```



返回值

```json
{
  "status": 0
}
```

#### 分词

```bash
### seg
POST http://localhost:8000/seg
Content-Type: application/json

{
  "texts": ["曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"]
}
```



返回值

```json
{
  "status": 0,
  "texts": [
    "曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"
  ],
  "res": [
    [
      "曹操",
      "和",
      "司马懿",
      "去",
      "赶集",
      "，",
      "中途",
      "遇",
      "上",
      "关羽",
      "，",
      "一起",
      "吃",
      "了",
      "个",
      "饭",
      "。"
    ]
  ]
}
```

#### 词性标注

```shell script
### pos
POST http://localhost:8000/pos
Content-Type: application/json

{
"texts": ["南京市长江大桥"]
}
```

返回值

```json
{
  "status": 0,
  "texts": [
    "南京市长江大桥"
  ],
  "res": [
    [
      [
        "南京市",
        "ns"
      ],
      [
        "长江",
        "ns"
      ],
      [
        "大桥",
        "n"
      ]
    ]
  ],
  "seg": [
    [
      "南京市",
      "长江",
      "大桥"
    ]
  ]
}
```

#### 命名实体识别

```bash
### ner
POST http://localhost:8000/ner
Content-Type: application/json

{
"texts": ["曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"]
}
```



返回值

```json
{
  "status": 0,
  "texts": [
    "乔丹是一位出生在纽约的美国职业篮球运动员。"
  ],
  "res": [
    [
      [
        "乔丹",
        "Nh",
        0,
        0
      ],
      [
        "纽约",
        "Ns",
        6,
        6
      ],
      [
        "美国",
        "Ns",
        8,
        8
      ]
    ]
  ],
  "seg": [
    [
      "乔丹",
      "是",
      "一",
      "位",
      "出生",
      "在",
      "纽约",
      "的",
      "美国",
      "职业",
      "篮球",
      "运动员",
      "。"
    ]
  ]
}
```

#### 语义角色标注

```bash
### srl
POST http://localhost:8000/srl
Content-Type: application/json

{
  "texts": ["曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"]
}
```



返回值

```json
{
  "status": 0,
  "texts": [
    "乔丹是一位出生在纽约的美国职业篮球运动员。"
  ],
  "res": [
    [
      [
        "是",
        1,
        [
          [
            "A0",
            [
              "乔丹"
            ],
            0,
            0
          ],
          [
            "A1",
            [
              "一",
              "位",
              "出生",
              "在",
              "纽约",
              "的",
              "美国",
              "职业",
              "篮球",
              "运动员"
            ],
            2,
            11
          ]
        ]
      ],
      [
        "出生",
        4,
        [
          [
            "A1",
            [
              "在",
              "纽约"
            ],
            5,
            6
          ],
          [
            "A0",
            [
              "职业",
              "篮球",
              "运动员"
            ],
            9,
            11
          ]
        ]
      ]
    ]
  ],
  "seg": [
    [
      "乔丹",
      "是",
      "一",
      "位",
      "出生",
      "在",
      "纽约",
      "的",
      "美国",
      "职业",
      "篮球",
      "运动员",
      "。"
    ]
  ]
}
```

#### 依存句法分析

```bash
### dep
POST http://localhost:8000/dep
Content-Type: application/json

{
  "texts": ["曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"]
}
```



返回值

```json
{
  "status": 0,
  "texts": [
    "乔丹是一位出生在纽约的美国职业篮球运动员。"
  ],
  "res": [
    [
      [
        1,
        "乔丹",
        2,
        "是",
        "SBV"
      ],
      [
        2,
        "是",
        0,
        "ROOT",
        "HED"
      ],
      [
        3,
        "一",
        4,
        "位",
        "ATT"
      ],
      [
        4,
        "位",
        12,
        "运动员",
        "ATT"
      ],
      [
        5,
        "出生",
        12,
        "运动员",
        "ATT"
      ],
      [
        6,
        "在",
        5,
        "出生",
        "CMP"
      ],
      [
        7,
        "纽约",
        6,
        "在",
        "POB"
      ],
      [
        8,
        "的",
        5,
        "出生",
        "RAD"
      ],
      [
        9,
        "美国",
        12,
        "运动员",
        "ATT"
      ],
      [
        10,
        "职业",
        12,
        "运动员",
        "ATT"
      ],
      [
        11,
        "篮球",
        12,
        "运动员",
        "ATT"
      ],
      [
        12,
        "运动员",
        2,
        "是",
        "VOB"
      ],
      [
        13,
        "。",
        2,
        "是",
        "WP"
      ]
    ]
  ],
  "seg": [
    [
      "乔丹",
      "是",
      "一",
      "位",
      "出生",
      "在",
      "纽约",
      "的",
      "美国",
      "职业",
      "篮球",
      "运动员",
      "。"
    ]
  ]
}
```

#### 语义依存分析（树）

```bash
### sdp
POST http://localhost:8000/sdp
Content-Type: application/json

{
  "texts": ["曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"]
}
```



返回值

```json
{
  "status": 0,
  "texts": [
    "曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"
  ],
  "res": [
    [
      [
        1,
        "曹操",
        4,
        "去",
        "AGT"
      ],
      [
        1,
        "曹操",
        5,
        "赶集",
        "AGT"
      ],
      [
        2,
        "和",
        3,
        "司马懿",
        "mRELA"
      ],
      [
        3,
        "司马懿",
        4,
        "去",
        "AGT"
      ],
      [
        4,
        "去",
        0,
        "ROOT",
        "Root"
      ],
      [
        5,
        "赶集",
        4,
        "去",
        "eSUCC"
      ],
      [
        6,
        "，",
        5,
        "赶集",
        "mPUNC"
      ],
      [
        7,
        "中途",
        8,
        "遇",
        "MANN"
      ],
      [
        8,
        "遇",
        5,
        "赶集",
        "eSUCC"
      ],
      [
        9,
        "上",
        8,
        "遇",
        "mDEPD"
      ],
      [
        10,
        "关羽",
        8,
        "遇",
        "DATV"
      ],
      [
        11,
        "，",
        8,
        "遇",
        "mPUNC"
      ],
      [
        12,
        "一起",
        13,
        "吃",
        "MANN"
      ],
      [
        13,
        "吃",
        8,
        "遇",
        "eSUCC"
      ],
      [
        14,
        "了",
        13,
        "吃",
        "mDEPD"
      ],
      [
        15,
        "个",
        16,
        "饭",
        "MEAS"
      ],
      [
        16,
        "饭",
        13,
        "吃",
        "PAT"
      ],
      [
        17,
        "。",
        13,
        "吃",
        "mPUNC"
      ]
    ]
  ],
  "seg": [
    [
      "曹操",
      "和",
      "司马懿",
      "去",
      "赶集",
      "，",
      "中途",
      "遇",
      "上",
      "关羽",
      "，",
      "一起",
      "吃",
      "了",
      "个",
      "饭",
      "。"
    ]
  ]
}
```

#### 语义依存分析（图）

```bash
### sdpg
POST http://localhost:8000/sdpg
Content-Type: application/json

{
  "texts": ["曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"]
}
```



返回值

```json
{
  "status": 0,
  "texts": [
    "曹操和司马懿去赶集，中途遇上关羽，一起吃了个饭。"
  ],
  "res": [
    [
      [
        1,
        "曹操",
        4,
        "去",
        "AGT"
      ],
      [
        1,
        "曹操",
        5,
        "赶集",
        "AGT"
      ],
      [
        2,
        "和",
        3,
        "司马懿",
        "mRELA"
      ],
      [
        3,
        "司马懿",
        4,
        "去",
        "AGT"
      ],
      [
        4,
        "去",
        0,
        "ROOT",
        "Root"
      ],
      [
        5,
        "赶集",
        4,
        "去",
        "eSUCC"
      ],
      [
        6,
        "，",
        5,
        "赶集",
        "mPUNC"
      ],
      [
        7,
        "中途",
        8,
        "遇",
        "MANN"
      ],
      [
        8,
        "遇",
        5,
        "赶集",
        "eSUCC"
      ],
      [
        9,
        "上",
        8,
        "遇",
        "mDEPD"
      ],
      [
        10,
        "关羽",
        8,
        "遇",
        "DATV"
      ],
      [
        11,
        "，",
        8,
        "遇",
        "mPUNC"
      ],
      [
        12,
        "一起",
        13,
        "吃",
        "MANN"
      ],
      [
        13,
        "吃",
        8,
        "遇",
        "eSUCC"
      ],
      [
        14,
        "了",
        13,
        "吃",
        "mDEPD"
      ],
      [
        15,
        "个",
        16,
        "饭",
        "MEAS"
      ],
      [
        16,
        "饭",
        13,
        "吃",
        "PAT"
      ],
      [
        17,
        "。",
        13,
        "吃",
        "mPUNC"
      ]
    ]
  ],
  "seg": [
    [
      "曹操",
      "和",
      "司马懿",
      "去",
      "赶集",
      "，",
      "中途",
      "遇",
      "上",
      "关羽",
      "，",
      "一起",
      "吃",
      "了",
      "个",
      "饭",
      "。"
    ]
  ]
}
```

## 客户端

### 使用方式

#### 方式一：Python库使用

示例如下：

```python
from ltp_server import Client

if __name__ == '__main__':
    client = Client()
    texts = ["乔丹是一位出生在纽约的美国职业篮球运动员。"]

    print(client.sent_split(texts))
    print(client.seg(texts))
    print(client.pos(texts))
    print(client.ner(texts))
    print(client.srl(texts))
    print(client.dep(texts))
    print(client.sdp(texts))
    print(client.sdpg(texts))
```

请求结果：

```json
{'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'status': 0}
{'status': 0, 'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': [['乔丹', '是', '一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员', '。']]}
{'status': 0, 'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': [[['乔丹', 'nh'], ['是', 'v'], ['一', 'm'], ['位', 'q'], ['出生', 'v'], ['在', 'p'], ['纽约', 'ns'], ['的', 'u'], ['美国', 'ns'], ['职业', 'n'], ['篮球', 'n'], ['运动员', 'n'], ['。', 'wp']]], 'seg': [['乔丹', '是', '一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员', '。']]}
{'status': 0, 'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': [[['乔丹', 'Nh', 0, 0], ['纽约', 'Ns', 6, 6], ['美国', 'Ns', 8, 8]]], 'seg': [['乔丹', '是', '一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员', '。']]}
{'status': 0, 'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': [[['是', 1, [['A0', ['乔丹'], 0, 0], ['A1', ['一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员'], 2, 11]]], ['出生', 4, [['A1', ['在', '纽约'], 5, 6], ['A0', ['职业', '篮球', '运动员'], 9, 11]]]]], 'seg': [['乔丹', '是', '一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员', '。']]}
{'status': 0, 'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': [[[1, '乔丹', 2, '是', 'SBV'], [2, '是', 0, 'ROOT', 'HED'], [3, '一', 4, '位', 'ATT'], [4, '位', 12, '运动员', 'ATT'], [5, '出生', 12, '运动员', 'ATT'], [6, '在', 5, '出生', 'CMP'], [7, '纽约', 6, '在', 'POB'], [8, '的', 5, '出生', 'RAD'], [9, '美国', 12, '运动员', 'ATT'], [10, '职业', 12, '运动员', 'ATT'], [11, '篮球', 12, '运动员', 'ATT'], [12, '运动员', 2, '是', 'VOB'], [13, '。', 2, '是', 'WP']]], 'seg': [['乔丹', '是', '一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员', '。']]}
{'status': 0, 'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': [[[1, '乔丹', 2, '是', 'EXP'], [2, '是', 0, 'ROOT', 'Root'], [3, '一', 4, '位', 'MEAS'], [4, '位', 12, '运动员', 'MEAS'], [5, '出生', 12, '运动员', 'rEXP'], [6, '在', 7, '纽约', 'mRELA'], [7, '纽约', 5, '出生', 'LOC'], [8, '的', 5, '出生', 'mDEPD'], [9, '美国', 12, '运动员', 'FEAT'], [10, '职业', 11, '篮球', 'FEAT'], [10, '职业', 12, '运动员', 'FEAT'], [11, '篮球', 12, '运动员', 'FEAT'], [12, '运动员', 2, '是', 'LINK'], [13, '。', 2, '是', 'mPUNC']]], 'seg': [['乔丹', '是', '一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员', '。']]}
{'status': 0, 'texts': ['乔丹是一位出生在纽约的美国职业篮球运动员。'], 'res': [[[1, '乔丹', 2, '是', 'EXP'], [2, '是', 0, 'ROOT', 'Root'], [3, '一', 4, '位', 'MEAS'], [4, '位', 12, '运动员', 'MEAS'], [5, '出生', 12, '运动员', 'rEXP'], [6, '在', 7, '纽约', 'mRELA'], [7, '纽约', 5, '出生', 'LOC'], [8, '的', 5, '出生', 'mDEPD'], [9, '美国', 12, '运动员', 'FEAT'], [10, '职业', 11, '篮球', 'FEAT'], [10, '职业', 12, '运动员', 'FEAT'], [11, '篮球', 12, '运动员', 'FEAT'], [12, '运动员', 2, '是', 'LINK'], [13, '。', 2, '是', 'mPUNC']]], 'seg': [['乔丹', '是', '一', '位', '出生', '在', '纽约', '的', '美国', '职业', '篮球', '运动员', '。']]}
```

#### 方式二：自己通过http请求调用

略

## 参考

- [HIT-SCIR/ltp: Language Technology Platform](https://github.com/HIT-SCIR/ltp)
- [ltp/quickstart.rst at master · HIT-SCIR/ltp](https://github.com/HIT-SCIR/ltp/blob/master/docs/quickstart.rst)
- [python fire使用指南_coordinate的博客-CSDN博客](https://blog.csdn.net/qq_17550379/article/details/79943740)
- [命令行脚本 — Python Packaging Tutorial](https://python-packaging-zh.readthedocs.io/zh_CN/latest/command-line-scripts.html)
- [玩转 Python 命令行：4 大主流工具库的对比 - Python猫的个人空间 - OSCHINA - 中文开源技术交流社区](https://my.oschina.net/u/4051725/blog/4379955)
- [用它5分钟以后，我放弃用了四年的 Flask_涛哥聊Python-CSDN博客](https://blog.csdn.net/wuShiJingZuo/article/details/104111961)