/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Logger;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.Field;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.Utils;
import org.postgresql.jdbc.EscapedFunctions;
import org.postgresql.jdbc.PgArray;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PgParameterMetaData;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.jdbc.PgSQLXML;
import org.postgresql.jdbc.ResultWrapper;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.HStoreConverter;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGTime;
import org.postgresql.util.PGTimestamp;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PgStatement
implements BaseStatement {
    private static final boolean DEFAULT_FORCE_BINARY_TRANSFERS = Boolean.getBoolean("org.postgresql.forceBinary");
    private boolean forceBinaryTransfers = DEFAULT_FORCE_BINARY_TRANSFERS;
    protected ArrayList<Query> batchStatements = null;
    protected ArrayList<ParameterList> batchParameters = null;
    protected final int resultsettype;
    protected final int concurrency;
    private final int rsHoldability;
    private boolean poolable;
    private boolean closeOnCompletion = false;
    protected int fetchdirection = 1000;
    private volatile TimerTask cancelTimerTask = null;
    private static final AtomicReferenceFieldUpdater<PgStatement, TimerTask> CANCEL_TIMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PgStatement.class, TimerTask.class, "cancelTimerTask");
    private volatile int statementState = 0;
    private static final int STATE_IDLE = 0;
    private static final int STATE_IN_QUERY = 1;
    private static final int STATE_CANCELLING = 2;
    private static final int STATE_CANCELLED = 3;
    private static final AtomicIntegerFieldUpdater<PgStatement> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PgStatement.class, "statementState");
    protected boolean wantsGeneratedKeysOnce = false;
    public boolean wantsGeneratedKeysAlways = false;
    protected final BaseConnection connection;
    protected SQLWarning warnings = null;
    protected SQLWarning lastWarning = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected ResultWrapper result = null;
    protected ResultWrapper firstUnclosedResult = null;
    protected ResultWrapper generatedKeys = null;
    protected boolean adjustIndex = false;
    protected boolean outParmBeforeFunc = false;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short IN_IDENTIFIER = 6;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private static final short ESC_FUNCTION = 4;
    private static final short ESC_OUTERJOIN = 5;
    private static final short ESC_ESCAPECHAR = 7;
    protected final CachedQuery preparedQuery;
    protected final ParameterList preparedParameters;
    protected Query lastSimpleQuery;
    protected int m_prepareThreshold;
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    protected int maxfieldSize = 0;
    protected boolean isClosed = false;
    private int lastIndex = 0;

    PgStatement(PgConnection c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.connection = c;
        this.preparedQuery = null;
        this.preparedParameters = null;
        this.lastSimpleQuery = null;
        this.forceBinaryTransfers |= c.getForceBinary();
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
        this.setFetchSize(c.getDefaultFetchSize());
        this.setPrepareThreshold(c.getPrepareThreshold());
        this.rsHoldability = rsHoldability;
    }

    PgStatement(PgConnection connection, String sql, boolean isCallable, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.connection = connection;
        this.lastSimpleQuery = null;
        CachedQuery cachedQuery = connection.borrowQuery(sql, isCallable);
        if (isCallable) {
            this.isFunction = cachedQuery.isFunction;
            this.outParmBeforeFunc = cachedQuery.outParmBeforeFunc;
        }
        this.preparedQuery = cachedQuery;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
        if (this.isFunction) {
            int inParamCount = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
        }
        this.forceBinaryTransfers |= connection.getForceBinary();
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
        this.setFetchSize(connection.getDefaultFetchSize());
        this.setPrepareThreshold(connection.getPrepareThreshold());
        this.rsHoldability = rsHoldability;
        this.poolable = true;
    }

    @Override
    public ResultSet createResultSet(Query originalQuery, Field[] fields, List tuples, ResultCursor cursor) throws SQLException {
        PgResultSet newResult = new PgResultSet(originalQuery, this, fields, tuples, cursor, this.getMaxRows(), this.getMaxFieldSize(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
        newResult.setFetchSize(this.getFetchSize());
        newResult.setFetchDirection(this.getFetchDirection());
        return newResult;
    }

    public BaseConnection getPGConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return null;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }

    @Override
    public ResultSet executeQuery(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.forceBinaryTransfers) {
            this.clearWarnings();
            while (this.firstUnclosedResult != null) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
            PreparedStatement ps = this.connection.prepareStatement(p_sql, this.resultsettype, this.concurrency, this.getResultSetHoldability());
            ps.setMaxFieldSize(this.getMaxFieldSize());
            ps.setFetchSize(this.getFetchSize());
            ps.setFetchDirection(this.getFetchDirection());
            PgResultSet rs = (PgResultSet)ps.executeQuery();
            rs.registerRealStatement(this);
            this.result = this.firstUnclosedResult = new ResultWrapper(rs);
            return rs;
        }
        if (!this.executeWithFlags(p_sql, 0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    @Override
    public int executeUpdate(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.isFunction) {
            this.executeWithFlags(p_sql, 0);
            return 0;
        }
        this.executeWithFlags(p_sql, 4);
        for (ResultWrapper iter = this.result; iter != null; iter = iter.getNext()) {
            if (iter.getResultSet() == null) continue;
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        this.executeWithFlags(4);
        for (ResultWrapper iter = this.result; iter != null; iter = iter.getNext()) {
            if (iter.getResultSet() == null) continue;
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this.executeWithFlags(p_sql, 0);
    }

    @Override
    public boolean executeWithFlags(String p_sql, int flags) throws SQLException {
        this.checkClosed();
        p_sql = PgStatement.replaceProcessing(p_sql, this.replaceProcessingEnabled, this.connection.getStandardConformingStrings());
        Query simpleQuery = this.connection.getQueryExecutor().createSimpleQuery(p_sql);
        this.execute(simpleQuery, null, 1 | flags);
        this.lastSimpleQuery = simpleQuery;
        return this.result != null && this.result.getResultSet() != null;
    }

    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        this.checkClosed();
        this.execute(this.preparedQuery.query, this.preparedParameters, flags);
        if (this.isFunction && this.returnTypeSet) {
            int outParameterCount;
            if (this.result == null || this.result.getResultSet() == null) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            ResultSet rs = this.result.getResultSet();
            if (!rs.next()) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            int cols = rs.getMetaData().getColumnCount();
            if (cols != (outParameterCount = this.preparedParameters.getOutParameterCount())) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters"), PSQLState.SYNTAX_ERROR);
            }
            this.lastIndex = 0;
            this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
            int i = 0;
            int j = 0;
            while (i < cols) {
                while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                    ++j;
                }
                this.callResult[j] = rs.getObject(i + 1);
                int columnType = rs.getMetaData().getColumnType(i + 1);
                if (columnType != this.functionReturnType[j]) {
                    if (columnType == 8 && this.functionReturnType[j] == 7) {
                        if (this.callResult[j] != null) {
                            this.callResult[j] = Float.valueOf(((Double)this.callResult[j]).floatValue());
                        }
                    } else {
                        throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", new Object[]{i + 1, "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]}), PSQLState.DATA_TYPE_MISMATCH);
                    }
                }
                ++i;
                ++j;
            }
            rs.close();
            this.result = null;
            return false;
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    protected void closeForNextExecution() throws SQLException {
        this.clearWarnings();
        while (this.firstUnclosedResult != null) {
            ResultSet rs = this.firstUnclosedResult.getResultSet();
            if (rs != null) {
                rs.close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        this.result = null;
        if (this.lastSimpleQuery != null) {
            this.lastSimpleQuery.close();
            this.lastSimpleQuery = null;
        }
        if (this.generatedKeys != null) {
            if (this.generatedKeys.getResultSet() != null) {
                this.generatedKeys.getResultSet().close();
            }
            this.generatedKeys = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Query queryToExecute, ParameterList queryParameters, int flags) throws SQLException {
        this.closeForNextExecution();
        if (!(this.fetchSize <= 0 || this.wantsScrollableResultSet() || this.connection.getAutoCommit() || this.wantsHoldableResultSet())) {
            flags |= 8;
        }
        if ((this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) && ((flags |= 0x40) & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        if (this.preparedQuery != null && this.preparedQuery.query == queryToExecute) {
            this.preparedQuery.increaseExecuteCount();
            if (!(this.m_prepareThreshold != 0 && this.preparedQuery.getExecuteCount() >= this.m_prepareThreshold || this.forceBinaryTransfers)) {
                flags |= 1;
            }
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        if (this.concurrency != 1007) {
            flags |= 0x100;
        }
        if (queryToExecute.isEmpty()) {
            flags |= 0x10;
        }
        if (!queryToExecute.isStatementDescribed() && this.forceBinaryTransfers) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, (ResultHandler)handler2, 0, 0, flags2);
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        StatementResultHandler handler = new StatementResultHandler();
        this.result = null;
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, (ResultHandler)handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask();
        }
        this.result = this.firstUnclosedResult = handler.getResults();
        if (this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) {
            this.generatedKeys = this.result;
            this.result = this.result.getNext();
            if (this.wantsGeneratedKeysOnce) {
                this.wantsGeneratedKeysOnce = false;
            }
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null || this.result.getResultSet() != null) {
            return -1;
        }
        return this.result.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.result == null) {
            return false;
        }
        this.result = this.result.getNext();
        while (this.firstUnclosedResult != this.result) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("Maximum number of rows must be a value grater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxrows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getQueryTimeoutMs() / 1000;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.setQueryTimeoutMs(seconds * 1000);
    }

    public int getQueryTimeoutMs() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public void setQueryTimeoutMs(int millis) throws SQLException {
        this.checkClosed();
        if (millis < 0) {
            throw new PSQLException(GT.tr("Query timeout must be a value greater than or equals to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = millis;
    }

    public void addWarning(SQLWarning warn) {
        if (this.warnings == null) {
            this.warnings = warn;
            this.lastWarning = warn;
        } else {
            this.lastWarning.setNextWarning(warn);
            this.lastWarning = warn;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxfieldSize = max;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
        this.lastWarning = null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return null;
        }
        return this.result.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.cleanupTimer();
        this.closeForNextExecution();
        if (this.preparedQuery != null) {
            CachedQuery cachedQuery = this.preparedQuery;
            synchronized (cachedQuery) {
                if (!this.isClosed) {
                    ((PgConnection)this.connection).releaseQuery(this.preparedQuery);
                }
            }
        }
        this.isClosed = true;
    }

    static String replaceProcessing(String p_sql, boolean replaceProcessingEnabled, boolean standardConformingStrings) throws SQLException {
        if (replaceProcessingEnabled) {
            int len = p_sql.length();
            StringBuilder newsql = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                if ((i = PgStatement.parseSql(p_sql, i, newsql, false, standardConformingStrings)) >= len) continue;
                newsql.append(p_sql.charAt(i));
                ++i;
            }
            return newsql.toString();
        }
        return p_sql;
    }

    protected static int parseSql(String p_sql, int i, StringBuilder newsql, boolean stopOnComma, boolean stdStrings) throws SQLException {
        int state = 0;
        int len = p_sql.length();
        int nestedParenthesis = 0;
        boolean endOfNested = false;
        --i;
        while (!endOfNested && ++i < len) {
            char c = p_sql.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                    } else if (c == '\"') {
                        state = 6;
                    } else if (c == '(') {
                        ++nestedParenthesis;
                    } else if (c == ')') {
                        if (--nestedParenthesis < 0) {
                            endOfNested = true;
                            break;
                        }
                    } else {
                        if (stopOnComma && c == ',' && nestedParenthesis == 0) {
                            endOfNested = true;
                            break;
                        }
                        if (c == '{' && i + 1 < len) {
                            char nextnext;
                            char next = p_sql.charAt(i + 1);
                            char c2 = nextnext = i + 2 < len ? p_sql.charAt(i + 2) : (char)'\u0000';
                            if (next == 'd' || next == 'D') {
                                state = 3;
                                ++i;
                                newsql.append("DATE ");
                                break;
                            }
                            if (next == 't' || next == 'T') {
                                state = 3;
                                if (nextnext == 's' || nextnext == 'S') {
                                    i += 2;
                                    newsql.append("TIMESTAMP ");
                                    break;
                                }
                                ++i;
                                newsql.append("TIME ");
                                break;
                            }
                            if (next == 'f' || next == 'F') {
                                state = 4;
                                i += nextnext == 'n' || nextnext == 'N' ? 2 : 1;
                                break;
                            }
                            if (next == 'o' || next == 'O') {
                                state = 5;
                                i += nextnext == 'j' || nextnext == 'J' ? 2 : 1;
                                break;
                            }
                            if (next == 'e' || next == 'E') {
                                state = 7;
                                break;
                            }
                        }
                    }
                    newsql.append(c);
                    break;
                }
                case 1: {
                    if (c == '\'') {
                        state = 0;
                    } else if (c == '\\' && !stdStrings) {
                        state = 2;
                    }
                    newsql.append(c);
                    break;
                }
                case 6: {
                    if (c == '\"') {
                        state = 0;
                    }
                    newsql.append(c);
                    break;
                }
                case 2: {
                    state = 1;
                    newsql.append(c);
                    break;
                }
                case 4: {
                    int posArgs = p_sql.indexOf(40, i);
                    if (posArgs != -1) {
                        String functionName = p_sql.substring(i, posArgs).trim();
                        i = posArgs + 1;
                        StringBuilder args = new StringBuilder();
                        i = PgStatement.parseSql(p_sql, i, args, false, stdStrings);
                        newsql.append(PgStatement.escapeFunction(functionName, args.toString(), stdStrings));
                    }
                    ++i;
                    while (i < len && p_sql.charAt(i) != '}') {
                        newsql.append(p_sql.charAt(i++));
                    }
                    state = 0;
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (c == '}') {
                        state = 0;
                        break;
                    }
                    newsql.append(c);
                }
            }
        }
        return i;
    }

    protected static String escapeFunction(String functionName, String args, boolean stdStrings) throws SQLException {
        int len = args.length();
        ArrayList<StringBuilder> parsedArgs = new ArrayList<StringBuilder>();
        for (int i = 0; i < len; ++i) {
            int lastPos = i;
            StringBuilder arg = new StringBuilder();
            if (lastPos == (i = PgStatement.parseSql(args, i, arg, true, stdStrings))) continue;
            parsedArgs.add(arg);
        }
        try {
            Method escapeMethod = EscapedFunctions.getFunction(functionName);
            return (String)escapeMethod.invoke(null, parsedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new PSQLException(e.getTargetException().getMessage(), PSQLState.SYSTEM_ERROR);
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder();
            buf.append(functionName).append('(');
            for (int iArg = 0; iArg < parsedArgs.size(); ++iArg) {
                buf.append(parsedArgs.get(iArg));
                if (iArg == parsedArgs.size() - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            return buf.toString();
        }
    }

    @Override
    public long getLastOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0L;
        }
        return this.result.getInsertOID();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        this.checkClosed();
        if (sqlType == 16) {
            sqlType = -7;
        }
        switch (sqlType) {
            case 2009: {
                oid = 142;
                break;
            }
            case 4: {
                oid = 23;
                break;
            }
            case -6: 
            case 5: {
                oid = 21;
                break;
            }
            case -5: {
                oid = 20;
                break;
            }
            case 7: {
                oid = 700;
                break;
            }
            case 6: 
            case 8: {
                oid = 701;
                break;
            }
            case 2: 
            case 3: {
                oid = 1700;
                break;
            }
            case 1: {
                oid = 1042;
                break;
            }
            case -1: 
            case 12: {
                oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 91: {
                oid = 1082;
                break;
            }
            case 92: 
            case 93: {
                oid = 0;
                break;
            }
            case -7: {
                oid = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
                    oid = 17;
                    break;
                }
                oid = 26;
                break;
            }
            case 2004: 
            case 2005: {
                oid = 26;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                oid = 0;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown Types value."), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        if (this.adjustIndex) {
            --parameterIndex;
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.bindString(parameterIndex, x ? "1" : "0", 16);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setShort(parameterIndex, (short)x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(21)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(23)) {
            byte[] val = new byte[4];
            ByteConverter.int4(val, 0, x);
            this.bindBytes(parameterIndex, val, 23);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(20)) {
            byte[] val = new byte[8];
            ByteConverter.int8(val, 0, x);
            this.bindBytes(parameterIndex, val, 20);
            return;
        }
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(700)) {
            byte[] val = new byte[4];
            ByteConverter.float4(val, 0, x);
            this.bindBytes(parameterIndex, val, 700);
            return;
        }
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(701)) {
            byte[] val = new byte[8];
            ByteConverter.float8(val, 0, x);
            this.bindBytes(parameterIndex, val, 701);
            return;
        }
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x, this.getStringType());
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (this.adjustIndex) {
                --parameterIndex;
            }
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            byte[] copy = new byte[x.length];
            System.arraycopy(x, 0, copy, 0, x.length);
            this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            lob.write(x);
            lob.close();
            this.setLong(parameterIndex, oid);
        }
    }

    public void setDate(int parameterIndex, java.sql.Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader l_inStream = new InputStreamReader(x, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 1043);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
        catch (IOException l_ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            this.preparedParameters.setBytea(parameterIndex, x, length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setLong(parameterIndex, oid);
        }
    }

    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private void setPGobject(int parameterIndex, PGobject x) throws SQLException {
        String typename = x.getType();
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof PGBinaryObject && this.connection.binaryTransferSend(oid)) {
            PGBinaryObject binObj = (PGBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int parameterIndex, Map x) throws SQLException {
        int oid = this.connection.getTypeInfo().getPGType("hstore");
        if (oid == 0) {
            throw new PSQLException(GT.tr("No hstore extension installed."), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(oid)) {
            byte[] data = HStoreConverter.toBytes(x, this.connection.getEncoding());
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        if (targetSqlType == 16) {
            targetSqlType = -7;
        }
        if (targetSqlType == 1111 && in instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)in);
            return;
        }
        switch (targetSqlType) {
            case 2009: {
                if (in instanceof SQLXML) {
                    this.setSQLXML(parameterIndex, (SQLXML)in);
                    break;
                }
                this.setSQLXML(parameterIndex, (SQLXML)new PgSQLXML(this.connection, in.toString()));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, PgStatement.castToInt(in));
                break;
            }
            case -6: 
            case 5: {
                this.setShort(parameterIndex, PgStatement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, PgStatement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, PgStatement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, PgStatement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, PgStatement.castToBigDecimal(in, scale));
                break;
            }
            case 1: {
                this.setString(parameterIndex, PgStatement.castToString(in), 1042);
                break;
            }
            case -1: 
            case 12: {
                this.setString(parameterIndex, PgStatement.castToString(in), this.getStringType());
                break;
            }
            case 91: {
                if (in instanceof java.sql.Date) {
                    this.setDate(parameterIndex, (java.sql.Date)in);
                    break;
                }
                java.sql.Date tmpd = in instanceof Date ? new java.sql.Date(((Date)in).getTime()) : this.connection.getTimestampUtils().toDate(null, in.toString());
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                Time tmpt = in instanceof Date ? new Time(((Date)in).getTime()) : this.connection.getTimestampUtils().toTime(null, in.toString());
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                Timestamp tmpts = in instanceof Date ? new Timestamp(((Date)in).getTime()) : this.connection.getTimestampUtils().toTimestamp(null, in.toString());
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case -7: {
                this.setBoolean(parameterIndex, PgStatement.castToBoolean(in));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                if (in instanceof InputStream) {
                    long oid = this.createBlob(parameterIndex, (InputStream)in, -1L);
                    this.setLong(parameterIndex, oid);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.BLOB"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.CLOB"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", new Object[]{in.getClass().getName(), "Types.ARRAY"}), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 1111: {
                if (in instanceof PGobject) {
                    this.setPGobject(parameterIndex, (PGobject)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof Date) {
                return (int)((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(PgStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "int");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof Date) {
                return (short)((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(PgStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "short");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(PgStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(PgStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "float");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(PgStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            BigDecimal rc = null;
            if (in instanceof String) {
                rc = new BigDecimal((String)in);
            } else if (in instanceof BigDecimal) {
                rc = (BigDecimal)in;
            } else if (in instanceof BigInteger) {
                rc = new BigDecimal((BigInteger)in);
            } else if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                rc = BigDecimal.valueOf(((Number)in).longValue());
            } else if (in instanceof Double || in instanceof Float) {
                rc = BigDecimal.valueOf(((Number)in).doubleValue());
            } else if (in instanceof Date) {
                rc = BigDecimal.valueOf(((Date)in).getTime());
            } else if (in instanceof Boolean) {
                rc = (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (in instanceof Clob) {
                rc = new BigDecimal(PgStatement.asString((Clob)in));
            } else if (in instanceof Character) {
                rc = new BigDecimal(new char[]{((Character)in).charValue()});
            }
            if (rc != null) {
                if (scale >= 0) {
                    rc = rc.setScale(scale, RoundingMode.HALF_UP);
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static boolean castToBoolean(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return ((String)in).equalsIgnoreCase("true") || ((String)in).equals("1") || ((String)in).equalsIgnoreCase("t");
            }
            if (in instanceof BigDecimal) {
                return ((BigDecimal)in).signum() != 0;
            }
            if (in instanceof Number) {
                return ((Number)in).longValue() != 0L;
            }
            if (in instanceof Date) {
                return ((Date)in).getTime() != 0L;
            }
            if (in instanceof Boolean) {
                return (Boolean)in;
            }
            if (in instanceof Clob) {
                String asString = PgStatement.asString((Clob)in);
                return asString.equalsIgnoreCase("true") || asString.equals("1") || asString.equalsIgnoreCase("t");
            }
            if (in instanceof Character) {
                return ((Character)in).charValue() == '1' || ((Character)in).charValue() == 't' || ((Character)in).charValue() == 'T';
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "boolean", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "boolean");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Number || in instanceof Boolean || in instanceof Character || in instanceof Date) {
                return in.toString();
            }
            if (in instanceof Clob) {
                return PgStatement.asString((Clob)in);
            }
        }
        catch (Exception e) {
            throw PgStatement.cannotCastException(in.getClass().getName(), "String", e);
        }
        throw PgStatement.cannotCastException(in.getClass().getName(), "String");
    }

    private static PSQLException cannotCastException(String fromType, String toType) {
        return PgStatement.cannotCastException(fromType, toType, null);
    }

    private static PSQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{fromType, toType}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)x);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (short)((Short)x));
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (int)((Integer)x));
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (long)((Long)x));
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (double)((Double)x));
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof java.sql.Date) {
            this.setDate(parameterIndex, (java.sql.Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (boolean)((Boolean)x));
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (byte)((Byte)x));
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof PGobject) {
            this.setPGobject(parameterIndex, (PGobject)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else {
            throw new PSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, boolean setPreparedParameters) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = 5;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        if (setPreparedParameters) {
            this.preparedParameters.registerOutParameter(parameterIndex, sqlType);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale, boolean setPreparedParameters) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, setPreparedParameters);
    }

    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result."), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult[parameterIndex - 1];
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[parameterIndex - 1];
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Byte");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return (Integer)this.callResult[parameterIndex - 1];
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[parameterIndex - 1];
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[parameterIndex - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    public java.sql.Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (java.sql.Date)this.callResult[parameterIndex - 1];
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    protected void bindBytes(int paramIndex, byte[] b, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setBinaryParameter(paramIndex, b, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered."), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed."), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    @Override
    public void setPrepareThreshold(int newThreshold) throws SQLException {
        this.checkClosed();
        if (newThreshold < 0) {
            this.forceBinaryTransfers = true;
            newThreshold = 1;
        }
        this.m_prepareThreshold = newThreshold;
    }

    @Override
    public int getPrepareThreshold() {
        return this.m_prepareThreshold;
    }

    @Override
    public void setUseServerPrepare(boolean flag) throws SQLException {
        this.setPrepareThreshold(flag ? 1 : 0);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.m_prepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.m_prepareThreshold;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new PSQLException(GT.tr("This statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void addBatch(String p_sql) throws SQLException {
        this.checkClosed();
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement."), PSQLState.WRONG_OBJECT_TYPE);
        }
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        p_sql = PgStatement.replaceProcessing(p_sql, this.replaceProcessingEnabled, this.connection.getStandardConformingStrings());
        this.batchStatements.add(this.connection.getQueryExecutor().createSimpleQuery(p_sql));
        this.batchParameters.add(null);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
            this.batchParameters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        if (this.batchStatements == null || this.batchStatements.isEmpty()) {
            return new int[0];
        }
        int size = this.batchStatements.size();
        int[] updateCounts = new int[size];
        Query[] queries = this.batchStatements.toArray(new Query[this.batchStatements.size()]);
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[this.batchParameters.size()]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        int flags = 0;
        boolean preDescribe = false;
        flags = this.wantsGeneratedKeysAlways ? 320 : 4;
        if (this.preparedQuery != null) {
            this.preparedQuery.increaseExecuteCount(queries.length);
        }
        if (this.m_prepareThreshold == 0 || this.preparedQuery == null || this.preparedQuery.getExecuteCount() < this.m_prepareThreshold) {
            flags |= 1;
        } else {
            preDescribe = this.wantsGeneratedKeysAlways && !queries[0].isStatementDescribed();
            flags |= 0x200;
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        if (preDescribe || this.forceBinaryTransfers) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(queries[0], parameterLists[0], (ResultHandler)handler2, 0, 0, flags2);
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        this.result = null;
        ResultHandler handler = this.isFunction ? new CallableBatchResultHandler(queries, parameterLists, updateCounts) : new BatchResultHandler(queries, parameterLists, updateCounts, this.wantsGeneratedKeysAlways);
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queries, parameterLists, handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask();
        }
        if (this.wantsGeneratedKeysAlways) {
            this.generatedKeys = new ResultWrapper(((BatchResultHandler)handler).getGeneratedKeys());
        }
        return updateCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        BaseConnection baseConnection;
        if (!STATE_UPDATER.compareAndSet(this, 1, 2)) {
            return;
        }
        try {
            baseConnection = this.connection;
            synchronized (baseConnection) {
                this.connection.cancelQuery();
            }
        }
        finally {
            STATE_UPDATER.set(this, 3);
            baseConnection = this.connection;
            synchronized (baseConnection) {
                this.connection.notifyAll();
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchdirection;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.concurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultsettype;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = direction;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", direction), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchStatements.add(this.preparedQuery.query);
        this.batchParameters.add(this.preparedParameters.copy());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null || ((PgResultSet)rs).isResultSetClosed()) {
            int flags = 49;
            StatementResultHandler handler = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, (ResultHandler)handler, 0, 0, flags);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                rs = wrapper.getResultSet();
            }
        }
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    public void setArray(int i, Array x) throws SQLException {
        PgArray arr;
        this.checkClosed();
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = x.getBaseTypeName() + "[]";
        int oid = this.connection.getTypeInfo().getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof PgArray && (arr = (PgArray)x).isBinary()) {
            this.bindBytes(i, arr.toBytes(), oid);
            return;
        }
        this.setString(i, x.toString(), oid);
    }

    protected long createBlob(int i, InputStream inputStream, long length) throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream outputStream = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            long remaining = length > 0L ? length : Long.MAX_VALUE;
            int numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                outputStream.write(buf, 0, numRead);
                numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {}
        }
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2004);
            return;
        }
        InputStream inStream = x.getBinaryStream();
        try {
            long oid = this.createBlob(i, inStream, x.length());
            this.setLong(i, oid);
        }
        finally {
            try {
                inStream.close();
            }
            catch (Exception e) {}
        }
    }

    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (this.connection.haveMinimumServerVersion(ServerVersion.v7_2)) {
                this.setNull(i, 12);
            } else {
                this.setNull(i, 2005);
            }
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            try {
                int n;
                while ((n = x.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
                }
            }
            catch (IOException l_ioe) {
                throw new PSQLException(GT.tr("Provided Reader failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
            }
            this.setString(i, new String(l_chars, 0, l_charsRead));
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            long oid = lom.createLO();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setLong(i, oid);
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2005);
            return;
        }
        Reader l_inStream = x.getCharacterStream();
        int l_length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        Charset connectionCharset = Charset.forName(this.connection.getEncoding().name());
        OutputStream los = lob.getOutputStream();
        OutputStreamWriter lw = new OutputStreamWriter(los, connectionCharset);
        try {
            int c = l_inStream.read();
            for (int p = 0; c > -1 && p < l_length; ++p) {
                ((Writer)lw).write(c);
                c = l_inStream.read();
            }
            ((Writer)lw).close();
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        this.setLong(i, oid);
    }

    public void setNull(int i, int t, String s) throws SQLException {
        this.checkClosed();
        this.setNull(i, t);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    public void setDate(int i, java.sql.Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] val = new byte[4];
            TimeZone tz = cal != null ? cal.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(tz, val, d);
            this.preparedParameters.setBinaryParameter(i, val, 1082);
            return;
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 0);
    }

    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        int oid = 0;
        if (t instanceof PGTime) {
            PGTime pgTime = (PGTime)t;
            if (pgTime.getCalendar() == null) {
                oid = 1083;
            } else {
                oid = 1266;
                cal = pgTime.getCalendar();
            }
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        int oid = 0;
        if (t instanceof PGTimestamp) {
            PGTimestamp pgTimestamp = (PGTimestamp)t;
            if (pgTimestamp.getCalendar() == null) {
                oid = 1114;
            } else {
                oid = 1184;
                cal = pgTimestamp.getCalendar();
            }
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public Object getObjectImpl(int i, Map map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    public java.sql.Date getDate(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 91, "Date");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toDate(cal, value);
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 92, "Time");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTime(cal, value);
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 93, "Timestamp");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTimestamp(cal, value);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
    }

    private void startTimer() {
        this.cleanupTimer();
        STATE_UPDATER.set(this, 1);
        if (this.timeout == 0) {
            return;
        }
        TimerTask cancelTask = new TimerTask(){

            public void run() {
                try {
                    if (!CANCEL_TIMER_UPDATER.compareAndSet(PgStatement.this, this, null)) {
                        return;
                    }
                    PgStatement.this.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        CANCEL_TIMER_UPDATER.set(this, cancelTask);
        this.connection.addTimerTask(cancelTask, this.timeout);
    }

    private boolean cleanupTimer() {
        TimerTask timerTask = CANCEL_TIMER_UPDATER.get(this);
        if (timerTask == null) {
            return this.timeout == 0;
        }
        if (!CANCEL_TIMER_UPDATER.compareAndSet(this, timerTask, null)) {
            return false;
        }
        timerTask.cancel();
        this.connection.purgeTimerTasks();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killTimerTask() {
        boolean timerTaskIsClear = this.cleanupTimer();
        if (timerTaskIsClear && STATE_UPDATER.compareAndSet(this, 1, 0)) {
            return;
        }
        boolean interrupted = false;
        while (!STATE_UPDATER.compareAndSet(this, 3, 0)) {
            BaseConnection baseConnection = this.connection;
            synchronized (baseConnection) {
                try {
                    this.connection.wait(10L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected boolean getForceBinaryTransfer() {
        return this.forceBinaryTransfers;
    }

    static String addReturning(BaseConnection connection, String sql, String[] columns, boolean escape) throws SQLException {
        if (!connection.haveMinimumServerVersion(ServerVersion.v8_2)) {
            throw new PSQLException(GT.tr("Returning autogenerated keys is only supported for 8.2 and later servers."), PSQLState.NOT_IMPLEMENTED);
        }
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        StringBuilder sb = new StringBuilder(sql);
        sb.append(" RETURNING ");
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (escape) {
                Utils.escapeIdentifier(sb, columns[i]);
                continue;
            }
            sb.append(columns[i]);
        }
        return sb.toString();
    }

    public ParameterMetaData createParameterMetaData(BaseConnection conn, int[] oids) throws SQLException {
        return new PgParameterMetaData(conn, oids);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLargeUpdateCount");
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLargeMaxRows");
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLargeMaxRows");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeBatch");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    public long executeLargeUpdate() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader)");
    }

    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Object is too large to send over the protocol."), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        this.preparedParameters.setBytea(parameterIndex, value, (int)length);
    }

    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        this.preparedParameters.setBytea(parameterIndex, value);
    }

    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader, long)");
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader)");
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length < 0L) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        long oid = this.createBlob(parameterIndex, inputStream, length);
        this.setLong(parameterIndex, oid);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        long oid = this.createBlob(parameterIndex, inputStream, -1L);
        this.setLong(parameterIndex, oid);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        if (xmlObject == null || xmlObject.getString() == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, xmlObject.getString(), 142);
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    public RowId getRowId(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    public RowId getRowId(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(String)");
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRowId(String, RowId)");
    }

    public void setNString(String parameterName, String value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNString(String, String)");
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader, long)");
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(String, Reader)");
    }

    public void setCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String, Reader, long)");
    }

    public void setCharacterStream(String parameterName, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String, Reader)");
    }

    public void setBinaryStream(String parameterName, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String, InputStream, long)");
    }

    public void setBinaryStream(String parameterName, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String, InputStream)");
    }

    public void setAsciiStream(String parameterName, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream, long)");
    }

    public void setAsciiStream(String parameterName, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String, InputStream)");
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, NClob)");
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Reader, long)");
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Reader)");
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, InputStream, long)");
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, InputStream)");
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, Reader, long)");
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(String, Reader)");
    }

    public NClob getNClob(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    public NClob getNClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(String)");
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setSQLXML(String, SQLXML)");
    }

    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2009, "SQLXML");
        return (SQLXML)this.callResult[parameterIndex - 1];
    }

    public SQLXML getSQLXML(String parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String)");
    }

    private void setUuid(int parameterIndex, UUID uuid) throws SQLException {
        if (this.connection.binaryTransferSend(2950)) {
            byte[] val = new byte[16];
            ByteConverter.int8(val, 0, uuid.getMostSignificantBits());
            ByteConverter.int8(val, 8, uuid.getLeastSignificantBits());
            this.bindBytes(parameterIndex, val, 2950);
        } else {
            this.bindLiteral(parameterIndex, uuid.toString(), 2950);
        }
    }

    public String getNString(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    public String getNString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(String)");
    }

    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(String)");
    }

    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(String)");
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(String, Blob)");
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(String, Clob)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw Driver.notImplemented(this.getClass(), "getParentLogger()");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(int, Class<T>)");
    }

    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Class<T>)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompletion() throws SQLException {
        if (!this.closeOnCompletion) {
            return;
        }
        for (ResultWrapper result = this.firstUnclosedResult; result != null; result = result.getNext()) {
            if (result.getResultSet() == null || result.getResultSet().isClosed()) continue;
            return;
        }
        this.closeOnCompletion = false;
        try {
            this.close();
        }
        finally {
            this.closeOnCompletion = true;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1 && this.result != null && this.result.getResultSet() != null) {
            this.result.getResultSet().close();
        }
        if (this.result != null) {
            this.result = this.result.getNext();
        }
        if (current == 3) {
            while (this.firstUnclosedResult != this.result) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        if (this.generatedKeys == null || this.generatedKeys.getResultSet() == null) {
            return this.createDriverResultSet(new Field[0], new ArrayList());
        }
        return this.generatedKeys.getResultSet();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        sql = PgStatement.addReturning(this.connection, sql, new String[]{"*"}, false);
        this.wantsGeneratedKeysOnce = true;
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            return this.executeUpdate(sql);
        }
        sql = PgStatement.addReturning(this.connection, sql, columnNames, true);
        this.wantsGeneratedKeysOnce = true;
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        sql = PgStatement.addReturning(this.connection, sql, new String[]{"*"}, false);
        this.wantsGeneratedKeysOnce = true;
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            return this.execute(sql);
        }
        sql = PgStatement.addReturning(this.connection, sql, columnNames, true);
        this.wantsGeneratedKeysOnce = true;
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        int flags = 49;
        StatementResultHandler handler = new StatementResultHandler();
        this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, (ResultHandler)handler, 0, 0, flags);
        int[] oids = this.preparedParameters.getTypeOIDs();
        if (oids != null) {
            return this.createParameterMetaData(this.connection, oids);
        }
        return null;
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int)");
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,int)");
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,String)");
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(String,URL)");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int)");
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBoolean(String,boolean)");
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setByte(String,byte)");
    }

    public void setShort(String parameterName, short x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setShort(String,short)");
    }

    public void setInt(String parameterName, int x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setInt(String,int)");
    }

    public void setLong(String parameterName, long x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLong(String,long)");
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setFloat(String,float)");
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDouble(String,double)");
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBigDecimal(String,BigDecimal)");
    }

    public void setString(String parameterName, String x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setString(String,String)");
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBytes(String,byte)");
    }

    public void setDate(String parameterName, java.sql.Date x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date)");
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time)");
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp)");
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String,InputStream,int)");
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String,InputStream,int)");
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int,int)");
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int)");
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object)");
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String,Reader,int)");
    }

    public void setDate(String parameterName, java.sql.Date x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date,Calendar)");
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time,Calendar)");
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp,Calendar)");
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int,String)");
    }

    public String getString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getString(String)");
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBoolean(String)");
    }

    public byte getByte(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getByte(String)");
    }

    public short getShort(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getShort(String)");
    }

    public int getInt(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getInt(String)");
    }

    public long getLong(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLong(String)");
    }

    public float getFloat(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getFloat(String)");
    }

    public double getDouble(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDouble(String)");
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBytes(String)");
    }

    public java.sql.Date getDate(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String)");
    }

    public Time getTime(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String)");
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String)");
    }

    public Object getObject(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String)");
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBigDecimal(String)");
    }

    public Object getObjectImpl(String parameterName, Map map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String,Map)");
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(String)");
    }

    public Blob getBlob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(String)");
    }

    public Clob getClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(String)");
    }

    public Array getArray(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getArray(String)");
    }

    public java.sql.Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String,Calendar)");
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String,Calendar)");
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String,Calendar)");
    }

    public URL getURL(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                sqlType = -7;
                break;
            }
        }
        this.registerOutParameter(parameterIndex, sqlType, !this.adjustIndex);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public ResultSet createDriverResultSet(Field[] fields, List tuples) throws SQLException {
        return this.createResultSet(null, fields, tuples, null);
    }

    private class CallableBatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private final int[] updateCounts;

        CallableBatchResultHandler(Query[] queries, ParameterList[] parameterLists, int[] updateCounts) {
            this.queries = queries;
            this.parameterLists = parameterLists;
            this.updateCounts = updateCounts;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            if (this.resultIndex >= this.updateCounts.length) {
                this.handleError(new PSQLException(GT.tr("Too many update results were returned."), PSQLState.TOO_MANY_RESULTS));
                return;
            }
            this.updateCounts[this.resultIndex++] = updateCount;
        }

        public void handleWarning(SQLWarning warning) {
            PgStatement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.batchException == null) {
                int[] successCounts;
                if (this.resultIndex >= this.updateCounts.length) {
                    successCounts = this.updateCounts;
                } else {
                    successCounts = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, successCounts, 0, this.resultIndex);
                }
                String queryString = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{this.resultIndex, queryString}), newError.getSQLState(), successCounts);
            }
            this.batchException.setNextException(newError);
        }

        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }
    }

    private class BatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private final int[] updateCounts;
        private final boolean expectGeneratedKeys;
        private ResultSet generatedKeys;

        BatchResultHandler(Query[] queries, ParameterList[] parameterLists, int[] updateCounts, boolean expectGeneratedKeys) {
            this.queries = queries;
            this.parameterLists = parameterLists;
            this.updateCounts = updateCounts;
            this.expectGeneratedKeys = expectGeneratedKeys;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
            if (!this.expectGeneratedKeys) {
                this.handleError(new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS));
            } else if (this.generatedKeys == null) {
                try {
                    this.generatedKeys = PgStatement.this.createResultSet(fromQuery, fields, tuples, cursor);
                }
                catch (SQLException e) {
                    this.handleError(e);
                }
            } else {
                ((PgResultSet)this.generatedKeys).addRows(tuples);
            }
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            if (this.resultIndex >= this.updateCounts.length) {
                this.handleError(new PSQLException(GT.tr("Too many update results were returned."), PSQLState.TOO_MANY_RESULTS));
                return;
            }
            this.updateCounts[this.resultIndex++] = updateCount;
        }

        public void handleWarning(SQLWarning warning) {
            PgStatement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.batchException == null) {
                int[] successCounts;
                if (this.resultIndex >= this.updateCounts.length) {
                    successCounts = this.updateCounts;
                } else {
                    successCounts = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, successCounts, 0, this.resultIndex);
                }
                String queryString = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{this.resultIndex, queryString}), newError.getSQLState(), successCounts);
            }
            this.batchException.setNextException(newError);
        }

        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }

        public ResultSet getGeneratedKeys() {
            return this.generatedKeys;
        }
    }

    public class StatementResultHandler
    implements ResultHandler {
        private SQLException error;
        private ResultWrapper results;

        ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper newResult) {
            if (this.results == null) {
                this.results = newResult;
            } else {
                this.results.append(newResult);
            }
        }

        public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
            try {
                ResultSet rs = PgStatement.this.createResultSet(fromQuery, fields, tuples, cursor);
                this.append(new ResultWrapper(rs));
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.append(new ResultWrapper(updateCount, insertOID));
        }

        public void handleWarning(SQLWarning warning) {
            PgStatement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

