/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGpoint
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    public double x;
    public double y;

    public PGpoint(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public PGpoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGpoint() {
        this.setType("point");
    }

    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        try {
            this.x = Double.parseDouble(t.getToken(0));
            this.y = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, s}), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    public void setByteValue(byte[] b, int offset) {
        this.x = ByteConverter.float8(b, offset);
        this.y = ByteConverter.float8(b, offset + 8);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpoint) {
            PGpoint p = (PGpoint)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    public int lengthInBytes() {
        return 16;
    }

    public void toBytes(byte[] b, int offset) {
        ByteConverter.float8(b, offset, this.x);
        ByteConverter.float8(b, offset + 8, this.y);
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void move(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(int x, int y) {
        this.move((double)x, (double)y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }
}

