/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import org.postgresql.core.ParameterList;

public class NativeQuery {
    private static final String[] BIND_NAMES = new String[128];
    private static final int[] NO_BINDS = new int[0];
    public final String nativeSql;
    public final int[] bindPositions;

    public NativeQuery(String nativeSql) {
        this(nativeSql, NO_BINDS);
    }

    public NativeQuery(String nativeSql, int[] bindPositions) {
        this.nativeSql = nativeSql;
        this.bindPositions = bindPositions == null || bindPositions.length == 0 ? NO_BINDS : bindPositions;
    }

    public String toString(ParameterList parameters) {
        if (this.bindPositions.length == 0) {
            return this.nativeSql;
        }
        int queryLength = this.nativeSql.length();
        String[] params = new String[this.bindPositions.length];
        for (int i = 1; i <= this.bindPositions.length; ++i) {
            String param;
            params[i - 1] = param = parameters == null ? "?" : parameters.toString(i);
            queryLength += param.length() - NativeQuery.bindName(i).length();
        }
        StringBuilder sbuf = new StringBuilder(queryLength);
        sbuf.append(this.nativeSql, 0, this.bindPositions[0]);
        for (int i = 1; i <= this.bindPositions.length; ++i) {
            sbuf.append(params[i - 1]);
            int nextBind = i < this.bindPositions.length ? this.bindPositions[i] : this.nativeSql.length();
            sbuf.append(this.nativeSql, this.bindPositions[i - 1] + NativeQuery.bindName(i).length(), nextBind);
        }
        return sbuf.toString();
    }

    public static String bindName(int index) {
        return index < BIND_NAMES.length ? BIND_NAMES[index] : "$" + index;
    }

    static {
        for (int i = 1; i < BIND_NAMES.length; ++i) {
            NativeQuery.BIND_NAMES[i] = "$" + i;
        }
    }
}

