# coding: utf-8

"""
    Nomad Envoy

    This is the API descriptor for the Nomad Envoy API, responsible for order operation and product lists. Developed by [Samarkand Global](https://samarkand.global) in partnership with [Youzan](https://www.youzan.com/), [LittleRED](https://www.xiaohongshu.com/), [PDD](http://www.pinduoduo.com/), etc. Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_envoy_cli` - Install for python with `pip install nomad-envoy-cli`  # noqa: E501

    The version of the OpenAPI document: 1.41.4
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_envoy_cli.configuration import Configuration


class Address(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'first_name': 'str',
        'last_name': 'str',
        'address1': 'str',
        'address2': 'str',
        'city': 'str',
        'state': 'str',
        'country': 'str',
        'zip': 'str',
        'tin': 'str',
        'phone': 'str',
        'country_code': 'str',
        'email': 'str',
        'chinese_id': 'str'
    }

    attribute_map = {
        'first_name': 'firstName',
        'last_name': 'lastName',
        'address1': 'address1',
        'address2': 'address2',
        'city': 'city',
        'state': 'state',
        'country': 'country',
        'zip': 'zip',
        'tin': 'tin',
        'phone': 'phone',
        'country_code': 'countryCode',
        'email': 'email',
        'chinese_id': 'chineseId'
    }

    def __init__(self, first_name=None, last_name=None, address1=None, address2=None, city=None, state=None, country=None, zip=None, tin=None, phone=None, country_code=None, email=None, chinese_id=None, local_vars_configuration=None):  # noqa: E501
        """Address - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._first_name = None
        self._last_name = None
        self._address1 = None
        self._address2 = None
        self._city = None
        self._state = None
        self._country = None
        self._zip = None
        self._tin = None
        self._phone = None
        self._country_code = None
        self._email = None
        self._chinese_id = None
        self.discriminator = None

        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if address1 is not None:
            self.address1 = address1
        if address2 is not None:
            self.address2 = address2
        if city is not None:
            self.city = city
        if state is not None:
            self.state = state
        if country is not None:
            self.country = country
        if zip is not None:
            self.zip = zip
        if tin is not None:
            self.tin = tin
        if phone is not None:
            self.phone = phone
        if country_code is not None:
            self.country_code = country_code
        if email is not None:
            self.email = email
        if chinese_id is not None:
            self.chinese_id = chinese_id

    @property
    def first_name(self):
        """Gets the first_name of this Address.  # noqa: E501


        :return: The first_name of this Address.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this Address.


        :param first_name: The first_name of this Address.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this Address.  # noqa: E501


        :return: The last_name of this Address.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this Address.


        :param last_name: The last_name of this Address.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def address1(self):
        """Gets the address1 of this Address.  # noqa: E501


        :return: The address1 of this Address.  # noqa: E501
        :rtype: str
        """
        return self._address1

    @address1.setter
    def address1(self, address1):
        """Sets the address1 of this Address.


        :param address1: The address1 of this Address.  # noqa: E501
        :type: str
        """

        self._address1 = address1

    @property
    def address2(self):
        """Gets the address2 of this Address.  # noqa: E501


        :return: The address2 of this Address.  # noqa: E501
        :rtype: str
        """
        return self._address2

    @address2.setter
    def address2(self, address2):
        """Sets the address2 of this Address.


        :param address2: The address2 of this Address.  # noqa: E501
        :type: str
        """

        self._address2 = address2

    @property
    def city(self):
        """Gets the city of this Address.  # noqa: E501


        :return: The city of this Address.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this Address.


        :param city: The city of this Address.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def state(self):
        """Gets the state of this Address.  # noqa: E501


        :return: The state of this Address.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Address.


        :param state: The state of this Address.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def country(self):
        """Gets the country of this Address.  # noqa: E501


        :return: The country of this Address.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this Address.


        :param country: The country of this Address.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def zip(self):
        """Gets the zip of this Address.  # noqa: E501


        :return: The zip of this Address.  # noqa: E501
        :rtype: str
        """
        return self._zip

    @zip.setter
    def zip(self, zip):
        """Sets the zip of this Address.


        :param zip: The zip of this Address.  # noqa: E501
        :type: str
        """

        self._zip = zip

    @property
    def tin(self):
        """Gets the tin of this Address.  # noqa: E501

        Taxpayer identification number, including Chinese ID. https://www.gov.uk/hmrc-internal-manuals/international-exchange-of-information/ieim402040  # noqa: E501

        :return: The tin of this Address.  # noqa: E501
        :rtype: str
        """
        return self._tin

    @tin.setter
    def tin(self, tin):
        """Sets the tin of this Address.

        Taxpayer identification number, including Chinese ID. https://www.gov.uk/hmrc-internal-manuals/international-exchange-of-information/ieim402040  # noqa: E501

        :param tin: The tin of this Address.  # noqa: E501
        :type: str
        """

        self._tin = tin

    @property
    def phone(self):
        """Gets the phone of this Address.  # noqa: E501


        :return: The phone of this Address.  # noqa: E501
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """Sets the phone of this Address.


        :param phone: The phone of this Address.  # noqa: E501
        :type: str
        """

        self._phone = phone

    @property
    def country_code(self):
        """Gets the country_code of this Address.  # noqa: E501

        missing  # noqa: E501

        :return: The country_code of this Address.  # noqa: E501
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """Sets the country_code of this Address.

        missing  # noqa: E501

        :param country_code: The country_code of this Address.  # noqa: E501
        :type: str
        """

        self._country_code = country_code

    @property
    def email(self):
        """Gets the email of this Address.  # noqa: E501


        :return: The email of this Address.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Address.


        :param email: The email of this Address.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def chinese_id(self):
        """Gets the chinese_id of this Address.  # noqa: E501

        Chinese ID card. Deprecated, use 'tin' instead.  # noqa: E501

        :return: The chinese_id of this Address.  # noqa: E501
        :rtype: str
        """
        return self._chinese_id

    @chinese_id.setter
    def chinese_id(self, chinese_id):
        """Sets the chinese_id of this Address.

        Chinese ID card. Deprecated, use 'tin' instead.  # noqa: E501

        :param chinese_id: The chinese_id of this Address.  # noqa: E501
        :type: str
        """

        self._chinese_id = chinese_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Address):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Address):
            return True

        return self.to_dict() != other.to_dict()
