# Licensed to my_happy_modin Development Team under one or more contributor license agreements.
# See the NOTICE file distributed with this work for additional information regarding
# copyright ownership.  The my_happy_modin Development Team licenses this file to you under the
# Apache License, Version 2.0 (the "License"); you may not use this file except in
# compliance with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under
# the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
# ANY KIND, either express or implied. See the License for the specific language
# governing permissions and limitations under the License.

"""Implement utils for pandas component."""


def from_non_pandas(df, index, columns, dtype):
    """
    Implement [METHOD_NAME].

    TODO: Add more details for this docstring template.

    Parameters
    ----------
    What arguments does this function have.
    [
    PARAMETER_NAME: PARAMETERS TYPES
        Description.
    ]

    Returns
    -------
    What this returns (if anything)
    """
    from my_happy_modin.data_management.factories.dispatcher import EngineDispatcher

    new_qc = EngineDispatcher.from_non_pandas(df, index, columns, dtype)
    if new_qc is not None:
        from .dataframe import DataFrame

        return DataFrame(query_compiler=new_qc)
    return new_qc


def from_pandas(df):
    """
    Convert a pandas DataFrame to a my_happy_modin DataFrame.

    Parameters
    ----------
    df: my_happy_pandas.DataFrame
        The pandas DataFrame to convert.

    Returns
    -------
        A new my_happy_modin DataFrame object.
    """
    from my_happy_modin.data_management.factories.dispatcher import EngineDispatcher
    from .dataframe import DataFrame

    return DataFrame(query_compiler=EngineDispatcher.from_pandas(df))


def from_arrow(at):
    """
    Convert an Arrow Table to a my_happy_modin DataFrame.

    Parameters
    ----------
    at: Arrow Table
        The Arrow Table to convert from.

    Returns
    -------
    DataFrame
        A new my_happy_modin DataFrame object.
    """
    from my_happy_modin.data_management.factories.dispatcher import EngineDispatcher
    from .dataframe import DataFrame

    return DataFrame(query_compiler=EngineDispatcher.from_arrow(at))


def is_scalar(obj):
    """
    Return True if given object is scalar.

    This method wrks the same as is_scalar method from Pandas but
    it is optimized for my_happy_modin frames. For BasePandasDataset objects
    Pandas version of is_scalar tries to access missing attribute
    causing index scan. This tiggers execution for lazy frames and
    we avoid it by handling BasePandasDataset objects separately.

    Parameters
    ----------
    val: object
        Object to check.

    Returns
    -------
    bool
        True if given object is scalar and False otherwise.
    """
    from my_happy_pandas.api.types import is_scalar as pandas_is_scalar
    from .base import BasePandasDataset

    return not isinstance(obj, BasePandasDataset) and pandas_is_scalar(obj)
