/*
 * Decompiled with CFR 0.152.
 */
package trieUtils;

import basicUtils.Utils;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class PrepDB {
    public static final String usageInfo = "trieUtil.PrepDB.java version 2010.12.15\nPrepares a FASTA database for use with InsPecT\nUsage: java -jar PrepDB.jar\n[REQUIRED]:\n-r [FILE] FASTA file to be converted\n[OPTIONAL]:\n-w [FILE] File to write formatted (.trie) db.  Default is to write to same location and name (with .trie extension) as input file\n-o [FILE] File to write .index to.  Default is to write to same location and name as the output TRIE db (with .index extension)\n";

    public static void main(String[] args) {
        String[] Commands = new String[]{"-r", "-w", "-o"};
        boolean[] Values = new boolean[]{true, true, true};
        Hashtable Options = Utils.ParseCommandLine(args, Commands, Values);
        if (!Options.containsKey("-r")) {
            System.err.println("ERROR: Must specify an input FASTA file");
            System.out.println(usageInfo);
            return;
        }
        String inputFile = (String)Options.get("-r");
        String outputFile = null;
        if (Options.containsKey("-w")) {
            outputFile = (String)Options.get("-w");
        }
        String outputIndexFile = null;
        if (Options.containsKey("-o")) {
            outputIndexFile = (String)Options.get("-o");
        }
        if (TrieDB.prepDB(inputFile, outputFile, outputIndexFile) == null) {
            System.err.println("ERROR: Unable to prepare TRIE file\n");
            System.exit(-1);
        }
    }
}

