/*
 * Decompiled with CFR 0.152.
 */
package ms2dbUtils;

import basicUtils.GFFFile;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import trieUtils.TrieDB;

public class BuildMS2DB {
    public static String UsageInfo = "BuildMS2DB.java version 2011.27.10\nCreates an ms2db database given a fasta file (formatted using PrepDB.py) and\na set of exon/intron predictions in a gff file.  In contrast to the Inspect version of\nBuildMS2DB.c, multiple sequences can be specified and the exons will be correctly\ngrouped into genes.  In the Notes column of the GFF file, it uses the 'parent=XXX' to distinguish\nexons from the same transcript.  If no parent is specified, then it looks for 'id=XXX'. Also,\nthe sequence name in the FASTA file must be identical to the sequence name in the GFF file.\nREQUIRED:\n-r [FILE] GFF file build on the sequences in the sequence file given (may specify multiple times)\n-s [FILE] The FASTA or trie file version of the sequence file(if .trie then a corresponding .index file is assumed to exist)\n-w [FILE] The output file\nOPTIONAL:\n-c [NUM] Genetic code table to use for translation (default: 0)\n-t [STRING] The interval type to use (e.g. CDS, Exon, Match), case-insensitive (may specify multiple times, default: CDS)\n-d Run in Debug Mode\n-f Interpret the 'frame' as the 'phase'.  The frame is the number of nucleotides to skip before the start of the codon.  The phase \n   is the position of the first nucleotide in the codon (0,1,2).\n-g [NUM1-NUM2] Add introns between compatible exons if they are within this base pair range [NUM1-NUM2] (inclusive). (Default: no introns are added)\n-m [NUM] Max number of artificially added introns for each exon. (Default: 10 if intron range is specified with -g)\n";
    public boolean Debug = false;
    public boolean ReadPhase = false;
    private int minIntronLen = -1;
    private int maxIntronLen = -1;
    private int maxOutEdgesAdded = 10;
    private int codonTable = 0;
    private Hashtable HashedSequences = null;
    public String TrieFile;
    public TrieDB Trie;
    public int ForwardFlag;
    public String OutputFileName;
    public FileWriter OutputFile = null;
    public String[] GFFFiles;
    public Hashtable ExonHash;
    public MS2Exon FirstExon;
    public MS2Exon LastExon;
    public GFFGeneClass FirstGFFGene;
    public GFFGeneClass LastGFFGene;
    public MS2Gene FirstMS2Gene;
    public MS2Gene LastMS2Gene;
    public String[] intervalTypes = null;
    int ExonCount = 0;
    int GeneCount = 0;
    int GeneIndex = 0;
    public GFFGeneClass CurrentGene = null;
    public MS2Exon PrevExon = null;
    public String CurrFileName = "";

    private void printParams() {
        System.out.println("PARAMS:");
        System.out.println("FASTA file: " + this.TrieFile);
        System.out.println("Genetic code: " + Utils.dnaCodeNames[this.codonTable]);
        System.out.println("GFF files:");
        int i = 0;
        while (i < this.GFFFiles.length) {
            System.out.println(" " + this.GFFFiles[i]);
            ++i;
        }
    }

    private String BuildHashKey(MS2Exon Exon) {
        return String.valueOf(Exon.SequenceName) + "@" + Exon.Start + "@" + Exon.End + "@" + Exon.ReadingFrame + "@" + Exon.Strand;
    }

    private String BuildHashKey(String SequenceName, int Start, int End, int ReadingFrame, int Strand) {
        return String.valueOf(SequenceName) + "@" + Start + "@" + End + "@" + ReadingFrame + "@" + Strand;
    }

    public int BuildGFFCrossReferenceRecur(MS2CrossReference CR, MS2Gene Gene, int Start, int End, int ReadingFrame) {
        boolean LocalDebug;
        boolean bl = LocalDebug = this.Debug;
        if (LocalDebug) {
            System.out.println("Building cross reference of gene " + Gene.GeneName);
            System.out.println("Looking at exon " + Start + " to " + End + ", frame " + ReadingFrame);
            System.out.println("Total exons: " + Gene.Exons.size());
        }
        int i = 0;
        while (i < Gene.Exons.size()) {
            MS2Exon Exon = (MS2Exon)Gene.Exons.get(i);
            if (LocalDebug) {
                System.out.println("Exon [" + i + "]");
                Exon.DebugPrint(true);
            }
            if (Exon.ReadingFrame == ReadingFrame) {
                if (Exon.Start == Start && Exon.End == End) {
                    CR.AddID(Exon.Index);
                    if (LocalDebug) {
                        System.out.println("MS2Exon " + Exon.Index + " [" + Exon.Start + "-" + Exon.End + "] exactly matches GFFExon region [" + Start + "-" + End + "]");
                    }
                    return 1;
                }
                if (Gene.ForwardFlag == 1 && Exon.Start == Start && Exon.End <= End) {
                    CR.AddID(Exon.Index);
                    if (LocalDebug) {
                        System.out.println("MS2Exon " + Exon.Index + " [" + Exon.Start + "-" + Exon.End + "] only partially matches GFFExon region [" + Start + "-" + End + "]");
                    }
                    return this.BuildGFFCrossReferenceRecur(CR, Gene, Exon.End, End, ReadingFrame);
                }
                if (Gene.ForwardFlag == 0 && Exon.End == End && Exon.Start >= Start) {
                    CR.AddID(Exon.Index);
                    if (LocalDebug) {
                        System.out.println("MS2Exon " + Exon.Index + " [" + Exon.Start + "-" + Exon.End + "] only partially matches GFFExon region [" + Start + "-" + End + "]");
                    }
                    return this.BuildGFFCrossReferenceRecur(CR, Gene, Start, Exon.Start, ReadingFrame);
                }
            }
            ++i;
        }
        return 0;
    }

    public int BuildGFFCrossReference(MS2CrossReference CR, MS2Gene Gene, int Start, int End, int ReadingFrame) {
        boolean LocalDebug = this.Debug;
        boolean[] covered = new boolean[End - Start];
        covered = Utils.initializeBooleanArray(covered, false);
        if (LocalDebug) {
            System.out.println("Building cross reference of gene " + Gene.GeneName);
            System.out.println("Looking at exon " + Start + " to " + End + ", frame " + ReadingFrame);
            System.out.println("Total exons: " + Gene.Exons.size());
        }
        int i = 0;
        while (i < Gene.Exons.size()) {
            MS2Exon Exon = (MS2Exon)Gene.Exons.get(i);
            if (LocalDebug) {
                System.out.println("Exon [" + i + "]");
                Exon.DebugPrint(true);
            }
            if (Exon.ReadingFrame == ReadingFrame && Utils.HasOverlap(Start, End, Exon.Start, Exon.End)) {
                if (Exon.Start == Start && Exon.End == End) {
                    CR.AddID(Exon.Index);
                    if (LocalDebug) {
                        System.out.println("MS2Exon " + Exon.Index + " [" + Exon.Start + "-" + Exon.End + "] exactly matches GFFExon region [" + Start + "-" + End + "]");
                    }
                    return 1;
                }
                boolean found = false;
                int j = Exon.Start;
                while (j < Exon.End) {
                    if (j >= Start && j < End) {
                        covered[j - Start] = true;
                        found = true;
                    }
                    ++j;
                }
                if (found) {
                    CR.AddID(Exon.Index);
                }
            }
            ++i;
        }
        i = 0;
        while (i < covered.length) {
            if (!covered[i]) {
                return 0;
            }
            ++i;
        }
        return 1;
    }

    public void BuildGFFCrossReferences() {
        boolean LocalDebug = this.Debug;
        GFFGeneClass GFFGene = this.FirstGFFGene;
        while (GFFGene != null) {
            boolean CoveredFlag = false;
            if (LocalDebug) {
                System.out.println("Building a GFF Cross Reference with " + GFFGene.Name);
            }
            MS2Gene Gene = this.FirstMS2Gene;
            while (Gene != null) {
                if (Gene.SequenceName.compareTo(GFFGene.SequenceName) == 0 && Gene.ForwardFlag == GFFGene.Strand) {
                    boolean OverlapFlag = false;
                    GFFExonClass GFFExon = (GFFExonClass)GFFGene.GFFExons.get(0);
                    int i = 0;
                    while (i < Gene.Exons.size()) {
                        MS2Exon CurrExon = (MS2Exon)Gene.Exons.get(i);
                        if (Utils.HasOverlap(CurrExon.Start, CurrExon.End, GFFExon.Start, GFFExon.End) && CurrExon.ReadingFrame == GFFExon.ReadingFrame) {
                            OverlapFlag = true;
                        }
                        ++i;
                    }
                    if (OverlapFlag) {
                        if (LocalDebug) {
                            System.out.println("GFF Gene overlaps with MS2DBGene: " + Gene.GeneName);
                        }
                        if (GFFGene.CrossReference == null) {
                            GFFGene.CrossReference = new MS2CrossReference();
                        }
                        GFFGene.CrossReference.GFFGene = GFFGene;
                        GFFGene.CrossReference.Gene = Gene;
                        Gene.CrossReferences.add(GFFGene.CrossReference);
                        boolean CoverageComplete = true;
                        int j = 0;
                        while (j < GFFGene.GFFExons.size()) {
                            GFFExon = (GFFExonClass)GFFGene.GFFExons.get(j);
                            int Result = this.BuildGFFCrossReference(GFFGene.CrossReference, Gene, GFFExon.Start, GFFExon.End, GFFExon.ReadingFrame);
                            if (Result == 0) {
                                System.err.println("ERROR: GFF Coverage incomplete for gene " + GFFGene.Name + " exon index " + j + " from " + GFFExon.Start + " to " + GFFExon.End);
                                CoverageComplete = false;
                            } else if (LocalDebug) {
                                System.out.println("Coverage is complete for Exon " + j + " (" + GFFExon.Start + "-" + GFFExon.End + ")" + GFFExon.ReadingFrame + " of GFFGene");
                            }
                            ++j;
                        }
                        if (!CoverageComplete) {
                            System.err.println("ERROR: GFFCoverage incomplete for gene " + GFFGene.Name);
                            Utils.WaitForEnter();
                        }
                        CoveredFlag = true;
                        break;
                    }
                }
                Gene = Gene.Next;
            }
            if (!CoveredFlag) {
                System.err.println("ERROR: GFFCoverage incomplete for gene " + GFFGene.Name);
                Utils.WaitForEnter();
            }
            if (LocalDebug) {
                System.out.println("Cross reference contains " + GFFGene.CrossReference.ExonIDs.size() + " exons");
                Utils.WaitForEnter();
            }
            GFFGene = GFFGene.Next;
        }
    }

    public void AddMS2Exon(MS2Exon Exon) {
        boolean LocalDebug = false;
        if (this.FirstExon == null) {
            this.FirstExon = Exon;
            if (LocalDebug) {
                System.out.println("This is teh first exon!!");
            }
        } else {
            this.LastExon.Next = Exon;
            Exon.Prev = this.LastExon;
            if (LocalDebug) {
                System.out.println("This is the new last exon!!");
            }
        }
        this.LastExon = Exon;
        ++this.ExonCount;
        if (LocalDebug) {
            Utils.WaitForEnter();
        }
    }

    public MS2Exon HashExon(int Start, int End, int ReadingFrame, String SequenceName, int Strand) {
        String HashValue = this.BuildHashKey(SequenceName, Start, End, ReadingFrame, Strand);
        if (this.ExonHash.containsKey(HashValue)) {
            if (this.Debug) {
                System.out.println("We've already created this exon [" + Start + "-" + End + "]" + ReadingFrame + " on " + SequenceName + " on strand " + Strand);
            }
            return (MS2Exon)this.ExonHash.get(HashValue);
        }
        MS2Exon Exon = new MS2Exon(Start, End, ReadingFrame, SequenceName, Strand);
        this.ExonHash.put(HashValue, Exon);
        this.AddMS2Exon(Exon);
        return Exon;
    }

    public int HandleGFFFileLine(int LineNumber, int FilePos, String LineBuffer, String DesiredSeqName) {
        String[] Bits2;
        String[] Bits = (LineBuffer = LineBuffer.trim()).split("\t");
        if (Bits.length < 9) {
            return 0;
        }
        String SeqName = Bits[GFFFile.GFFColumns.SequenceName];
        if (Utils.IsInteger(SeqName)) {
            SeqName = "chr" + SeqName;
        }
        if (SeqName.toLowerCase().compareTo("unknown") == 0) {
            SeqName = "chr" + SeqName;
        }
        if (DesiredSeqName != null && DesiredSeqName.toLowerCase().compareTo(SeqName.toLowerCase()) != 0) {
            return -1;
        }
        String DatabaseName = Bits[GFFFile.GFFColumns.Source];
        String IntervalType = Bits[GFFFile.GFFColumns.FeatureType];
        if (!Utils.MatchesAnyCaseInsensitive(IntervalType, this.intervalTypes)) {
            return -1;
        }
        int Start = 0;
        int End = 0;
        int ReadingFrame = 0;
        String GeneName = null;
        if (this.Debug) {
            System.out.println("[" + LineNumber + "]:" + LineBuffer);
        }
        Start = Integer.parseInt(Bits[GFFFile.GFFColumns.Start]) - 1;
        End = Integer.parseInt(Bits[GFFFile.GFFColumns.End]);
        int Strand = GFFFile.ParseStrand(Bits[GFFFile.GFFColumns.Strand]);
        if (Strand < 0) {
            Strand = this.ForwardFlag;
        }
        if (Strand != this.ForwardFlag) {
            return -1;
        }
        try {
            ReadingFrame = Integer.parseInt(Bits[GFFFile.GFFColumns.Frame]);
        }
        catch (Exception E) {
            ReadingFrame = 0;
        }
        if (ReadingFrame < 0 || ReadingFrame > 2) {
            return -1;
        }
        String Notes = Bits[GFFFile.GFFColumns.Attributes];
        String[] NoteElements = Notes.split(";");
        GeneName = null;
        int i = 0;
        while (i < NoteElements.length) {
            Bits2 = NoteElements[i].split("=");
            if (Bits2[0].toLowerCase().indexOf("parent") >= 0) {
                GeneName = Bits2[1].replaceAll("\"", "");
                break;
            }
            ++i;
        }
        if (GeneName == null) {
            i = 0;
            while (i < NoteElements.length) {
                Bits2 = NoteElements[i].split("=");
                if (Bits2[0].toLowerCase().indexOf("id") >= 0) {
                    GeneName = Bits2[1].replaceAll("\"", "");
                    break;
                }
                ++i;
            }
        }
        if (GeneName == null) {
            GeneName = SeqName;
        }
        if (this.ReadPhase) {
            ReadingFrame = (3 - ReadingFrame) % 3;
        }
        ReadingFrame = this.ForwardFlag == 1 ? (Start + ReadingFrame) % 3 : (End - 1 - ReadingFrame) % 3;
        if (this.CurrentGene == null || GeneName.compareTo(this.CurrentGene.Name) != 0) {
            if (this.Debug) {
                System.out.println("Creating a new GFF Gene: " + GeneName + " on " + SeqName);
            }
            GFFGeneClass GFFGene = new GFFGeneClass();
            GFFGene.Name = GeneName;
            GFFGene.DatabaseName = DatabaseName;
            GFFGene.SequenceName = SeqName;
            GFFGene.Strand = Strand;
            this.CurrentGene = GFFGene;
            if (this.FirstGFFGene == null) {
                this.FirstGFFGene = GFFGene;
            } else {
                this.LastGFFGene.Next = GFFGene;
            }
            this.LastGFFGene = GFFGene;
            this.PrevExon = null;
        } else if (this.Debug) {
            System.out.println("Adding to current gene");
        }
        GFFExonClass GFFExon = new GFFExonClass(Start, End, ReadingFrame, SeqName);
        this.CurrentGene.GFFExons.add(GFFExon);
        MS2Exon Exon = this.HashExon(Start, End, ReadingFrame, SeqName, Strand);
        if (this.PrevExon != null) {
            if (Utils.HasOverlap(Exon.Start, Exon.End, this.PrevExon.Start, this.PrevExon.End)) {
                System.err.println("ERROR: Exon [" + Exon.Start + "-" + Exon.End + "] overlaps previous exon [" + this.PrevExon.Start + "-" + this.PrevExon.End + "]");
                System.err.println(LineBuffer);
                return -1;
            }
            if (this.PrevExon.Start < Exon.Start) {
                this.PrevExon.LinkExonForward(Exon);
                int PrevPrefix = 0;
                int Suffix = 0;
                if (this.ForwardFlag == 0) {
                    int tRF;
                    int k = 0;
                    while (k < 3) {
                        tRF = (this.PrevExon.End - 1 - k) % 3;
                        if (tRF == this.PrevExon.ReadingFrame) {
                            PrevPrefix = k;
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < 3) {
                        tRF = (Exon.End - 1 - k) % 3;
                        if (tRF == Exon.ReadingFrame) {
                            int Prefix = k;
                            Suffix = (Exon.End - Exon.Start - Prefix) % 3;
                        }
                        ++k;
                    }
                    if ((Suffix + PrevPrefix) % 3 != 0) {
                        System.err.println("ERROR: Consecutive exons do not have consistent reading frames (prevExon prefix = " + PrevPrefix + " while exon suffix = " + Suffix);
                        this.PrevExon.DebugPrint(true);
                        Exon.DebugPrint(true);
                        Utils.WaitForEnter();
                    }
                }
            } else {
                Exon.LinkExonForward(this.PrevExon);
                int PrevPrefix = 0;
                int Suffix = 0;
                if (this.ForwardFlag == 0) {
                    int tRF;
                    int k = 0;
                    while (k < 3) {
                        tRF = (Exon.End - 1 - k) % 3;
                        if (tRF == Exon.ReadingFrame) {
                            PrevPrefix = k;
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < 3) {
                        tRF = (this.PrevExon.End - 1 - k) % 3;
                        if (tRF == this.PrevExon.ReadingFrame) {
                            int Prefix = k;
                            Suffix = (this.PrevExon.End - this.PrevExon.Start - Prefix) % 3;
                        }
                        ++k;
                    }
                    if ((Suffix + PrevPrefix) % 3 != 0) {
                        System.err.println("ERROR: Consecutive exons do not have consistent reading frames (Exon prefix = " + PrevPrefix + " while  prev exon suffix = " + Suffix);
                        this.PrevExon.DebugPrint(true);
                        Exon.DebugPrint(true);
                        Utils.WaitForEnter();
                    }
                }
            }
        }
        if (this.Debug) {
            Exon.DebugPrint(true);
            System.out.println("PrevExon: ");
            if (this.PrevExon != null) {
                this.PrevExon.DebugPrint(true);
            }
            Utils.WaitForEnter();
        }
        this.PrevExon = Exon;
        return 1;
    }

    public void ParseGFFFiles(String SeqName) {
        BufferedReader Buf = null;
        this.CurrentGene = null;
        this.PrevExon = null;
        this.CurrFileName = "";
        int i = 0;
        while (i < this.GFFFiles.length) {
            block11: {
                String Line = null;
                try {
                    Buf = new BufferedReader(new FileReader(this.GFFFiles[i]));
                    Line = Buf.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    break block11;
                }
                this.CurrFileName = this.GFFFiles[i];
                int LineNumber = 0;
                int FilePos = 0;
                while (Line != null) {
                    if ((Line = Line.trim()).length() == 0 || Line.charAt(0) == '#') {
                        try {
                            Line = Buf.readLine();
                            continue;
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                            break;
                        }
                    }
                    this.HandleGFFFileLine(LineNumber, FilePos, Line, SeqName);
                    ++LineNumber;
                    FilePos += Line.length();
                    try {
                        Line = Buf.readLine();
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        break;
                    }
                }
                try {
                    Buf.close();
                }
                catch (IOException E) {
                    E.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void DeleteMS2Exon(MS2Exon Exon) {
        boolean LocalDebug = false;
        String HashValue = this.BuildHashKey(Exon);
        this.ExonHash.remove(HashValue);
        if (Exon == this.FirstExon) {
            if (LocalDebug) {
                System.out.println("This is the first exon!!");
            }
            this.FirstExon = this.FirstExon.Next;
        }
        if (Exon == this.LastExon) {
            if (LocalDebug) {
                System.out.println("This is the last exon!!");
            }
            this.LastExon = this.LastExon.Prev;
        }
        if (Exon.Next != null) {
            Exon.Next.Prev = Exon.Prev;
        }
        if (Exon.Prev != null) {
            Exon.Prev.Next = Exon.Next;
        }
        Exon.Prev = null;
        Exon.Next = null;
        if (LocalDebug) {
            if (Exon.ForwardIntrons != null) {
                System.out.println("We still have forward exons!!");
            }
            if (Exon.ReverseIntrons != null) {
                System.out.println("We still have reverse exons!!");
            }
            Utils.WaitForEnter();
        }
        MS2Edge E = Exon.ForwardIntrons;
        while (E != null) {
            if (LocalDebug) {
                E.LinkTo.DebugPrint(true);
            }
            E.LinkTo.RemoveBackwardEdge(Exon);
            if (LocalDebug) {
                E.LinkTo.DebugPrint(true);
                Utils.WaitForEnter();
            }
            E = E.Next;
        }
        E = Exon.ReverseIntrons;
        while (E != null) {
            E.LinkTo.RemoveForwardEdge(Exon);
            E = E.Next;
        }
        Exon.ReverseIntrons = null;
        Exon.ForwardIntrons = null;
        --this.ExonCount;
    }

    public void SplitOverlappingExons() {
        boolean LocalDebug = this.Debug;
        MS2Exon ExonA = this.FirstExon;
        MS2Exon NextExonA = null;
        MS2Exon ExonB = null;
        MS2Exon NextExonB = null;
        while (ExonA != null) {
            NextExonA = ExonA.Next;
            ExonB = ExonA.Next;
            while (ExonB != null) {
                MS2Exon Exon3;
                MS2Exon Exon2;
                MS2Exon Exon1;
                NextExonB = ExonB.Next;
                if (ExonA.ReadingFrame != ExonB.ReadingFrame) {
                    ExonB = ExonB.Next;
                    continue;
                }
                if (ExonA.Strand != ExonB.Strand) {
                    ExonB = ExonB.Next;
                    continue;
                }
                if (!Utils.HasOverlap(ExonA.Start, ExonA.End, ExonB.Start, ExonB.End)) {
                    ExonB = ExonB.Next;
                    continue;
                }
                if (ExonA.SequenceName.compareTo(ExonB.SequenceName) != 0) {
                    ExonB = ExonB.Next;
                    continue;
                }
                if (LocalDebug) {
                    System.out.println("Considering our exon!!!");
                }
                if (LocalDebug) {
                    System.out.println("Split overlapping exons...the following have overlap");
                    ExonA.DebugPrint(true);
                    ExonB.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                if (ExonA.Start == ExonB.Start && ExonA.End == ExonB.End) {
                    ExonA.ExonInheritForwardEdges(ExonB);
                    ExonA.ExonInheritBackwardEdges(ExonB);
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("No new exon");
                    Utils.WaitForEnter();
                    continue;
                }
                if (ExonA.Start == ExonB.Start) {
                    if (ExonA.End > ExonB.End) {
                        Exon1 = this.HashExon(ExonB.End, ExonA.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                        Exon1.ExonInheritForwardEdges(ExonA);
                        ExonB.ExonInheritBackwardEdges(ExonA);
                        NextExonA = ExonA.Next;
                        this.DeleteMS2Exon(ExonA);
                        if (!LocalDebug) break;
                        System.out.println("New Exon: ");
                        Exon1.DebugPrint(true);
                        System.out.println("Old Exon: ");
                        ExonB.DebugPrint(true);
                        Utils.WaitForEnter();
                        break;
                    }
                    Exon1 = this.HashExon(ExonA.End, ExonB.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritForwardEdges(ExonB);
                    ExonA.ExonInheritBackwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("New Exon: ");
                    Exon1.DebugPrint(true);
                    System.out.println("Old Exon: ");
                    ExonA.DebugPrint(true);
                    Utils.WaitForEnter();
                    continue;
                }
                if (ExonA.End == ExonB.End) {
                    if (ExonA.Start < ExonB.Start) {
                        Exon1 = this.HashExon(ExonA.Start, ExonB.Start, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                        ExonB.ExonInheritForwardEdges(ExonA);
                        Exon1.ExonInheritBackwardEdges(ExonA);
                        NextExonA = ExonA.Next;
                        this.DeleteMS2Exon(ExonA);
                        if (!LocalDebug) break;
                        System.out.println("New Exon: ");
                        Exon1.DebugPrint(true);
                        System.out.println("Old Exon: ");
                        ExonB.DebugPrint(true);
                        Utils.WaitForEnter();
                        break;
                    }
                    Exon1 = this.HashExon(ExonB.Start, ExonA.Start, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    ExonA.ExonInheritForwardEdges(ExonB);
                    Exon1.ExonInheritBackwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("New Exon: ");
                    Exon1.DebugPrint(true);
                    System.out.println("Old Exon: ");
                    ExonA.DebugPrint(true);
                    Utils.WaitForEnter();
                    continue;
                }
                if (ExonA.Start < ExonB.Start && ExonA.End < ExonB.End) {
                    Exon1 = this.HashExon(ExonA.Start, ExonB.Start, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonB.Start, ExonA.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon3 = this.HashExon(ExonA.End, ExonB.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonA);
                    Exon2.ExonInheritBackwardEdges(ExonB);
                    Exon2.ExonInheritForwardEdges(ExonA);
                    Exon3.ExonInheritForwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    this.DeleteMS2Exon(ExonA);
                    if (!LocalDebug) break;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Exon3.DebugPrint(true);
                    Utils.WaitForEnter();
                    break;
                }
                if (ExonA.Start < ExonB.Start && ExonA.End > ExonB.End) {
                    Exon1 = this.HashExon(ExonA.Start, ExonB.Start, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonB.End, ExonA.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonA);
                    Exon2.ExonInheritForwardEdges(ExonA);
                    NextExonA = ExonA.Next;
                    this.DeleteMS2Exon(ExonA);
                    if (!LocalDebug) break;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Utils.WaitForEnter();
                    break;
                }
                if (ExonA.Start > ExonB.Start && ExonA.End > ExonB.End) {
                    Exon1 = this.HashExon(ExonB.Start, ExonA.Start, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonA.Start, ExonB.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon3 = this.HashExon(ExonB.End, ExonA.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonB);
                    Exon2.ExonInheritBackwardEdges(ExonA);
                    Exon2.ExonInheritForwardEdges(ExonB);
                    Exon3.ExonInheritForwardEdges(ExonA);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    this.DeleteMS2Exon(ExonA);
                    if (!LocalDebug) break;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Exon3.DebugPrint(true);
                    Utils.WaitForEnter();
                    break;
                }
                if (ExonA.Start > ExonB.Start && ExonA.End < ExonB.End) {
                    Exon1 = this.HashExon(ExonB.Start, ExonA.Start, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon2 = this.HashExon(ExonA.End, ExonB.End, ExonA.ReadingFrame, ExonA.SequenceName, ExonA.Strand);
                    Exon1.ExonInheritBackwardEdges(ExonB);
                    Exon2.ExonInheritForwardEdges(ExonB);
                    NextExonA = ExonA.Next;
                    if (NextExonA.compareTo(ExonB) == 0) {
                        NextExonA = ExonB.Next;
                    }
                    NextExonB = ExonB.Next;
                    this.DeleteMS2Exon(ExonB);
                    ExonB = NextExonB;
                    if (!LocalDebug) continue;
                    System.out.println("New Exons: ");
                    Exon1.DebugPrint(true);
                    Exon2.DebugPrint(true);
                    Utils.WaitForEnter();
                    continue;
                }
                System.err.println("ERROR: UNHANDLED Split CASE!!!");
            }
            ExonA = NextExonA;
        }
    }

    public void AddAdjacentExonLinks() {
        boolean debug = false;
        ArrayList candidateLinkToExons = new ArrayList();
        MS2Exon ExonA = this.FirstExon;
        while (ExonA != null) {
            candidateLinkToExons.clear();
            if (debug) {
                System.out.println("This is our main guy!");
                ExonA.DebugPrint(true);
            }
            MS2Exon ExonB = this.FirstExon;
            while (ExonB != null) {
                if (debug) {
                    System.out.println("This is our candidate guy!");
                    ExonB.DebugPrint(true);
                }
                if (ExonA.Strand == ExonB.Strand && ExonA.SequenceName.compareTo(ExonB.SequenceName) == 0) {
                    MS2Edge TestEdge;
                    boolean LinkFound;
                    boolean readingFrameCompatible;
                    int delta = ExonB.Start - ExonA.End;
                    boolean bl = readingFrameCompatible = this.ForwardFlag == 1 && (ExonA.Suffix.length() + ExonB.Prefix.length()) % 3 == 0 || this.ForwardFlag == 0 && (ExonB.Suffix.length() + ExonA.Prefix.length()) % 3 == 0;
                    if (ExonA.ReadingFrame == ExonB.ReadingFrame && delta == 0) {
                        if (debug) {
                            System.out.println(" - They are adjacent!!");
                        }
                        LinkFound = false;
                        TestEdge = ExonA.ForwardIntrons;
                        while (TestEdge != null) {
                            if (TestEdge.LinkTo == ExonB) {
                                LinkFound = true;
                                break;
                            }
                            TestEdge = TestEdge.Next;
                        }
                        if (!LinkFound) {
                            ExonA.LinkExonForward(ExonB);
                        }
                    } else if (this.minIntronLen >= 0 && delta >= this.minIntronLen && delta <= this.maxIntronLen && readingFrameCompatible) {
                        if (debug) {
                            System.out.println(" - They are close: " + delta);
                        }
                        LinkFound = false;
                        TestEdge = ExonA.ForwardIntrons;
                        while (TestEdge != null) {
                            if (TestEdge.LinkTo == ExonB) {
                                LinkFound = true;
                                break;
                            }
                            TestEdge = TestEdge.Next;
                        }
                        if (!LinkFound) {
                            if (debug) {
                                System.out.println(" - No previous link found!");
                            }
                            candidateLinkToExons = Utils.InsertInOrder(candidateLinkToExons, ExonB);
                        } else if (debug) {
                            System.out.println(" - Previous link is found!");
                        }
                        while (candidateLinkToExons.size() > this.maxOutEdgesAdded) {
                            candidateLinkToExons.remove(candidateLinkToExons.size() - 1);
                        }
                    } else if (debug) {
                        System.out.println(" - Out of range: " + delta);
                    }
                } else if (debug) {
                    System.out.println(" - Not compatible!");
                }
                ExonB = ExonB.Next;
            }
            if (candidateLinkToExons.size() > 0) {
                int i = 0;
                while (i < candidateLinkToExons.size()) {
                    MS2Exon ExonB2 = (MS2Exon)candidateLinkToExons.get(i);
                    if (debug) {
                        System.out.println("Adding link " + i);
                        ExonB2.DebugPrint(true);
                    }
                    ExonA.LinkExonForward(ExonB2);
                    ++i;
                }
            }
            if (debug) {
                Utils.WaitForEnter();
            }
            ExonA = ExonA.Next;
        }
    }

    public void GroupExonsIntoGenes() {
        boolean LocalDebug = false;
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            if (LocalDebug) {
                System.out.println("Attempting to group:");
                Exon.DebugPrint(true);
                Utils.WaitForEnter();
            }
            if (Exon.ParentGene == null) {
                MS2Gene Gene = new MS2Gene();
                Gene.SequenceName = Exon.SequenceName;
                if (Gene.SequenceName != null) {
                    Gene.GeneName = String.valueOf(Gene.SequenceName) + "@" + this.GeneIndex;
                }
                ArrayList<MS2Exon> exonQueue = new ArrayList<MS2Exon>();
                exonQueue.add(Exon);
                while (exonQueue.size() > 0) {
                    MS2Exon e = (MS2Exon)exonQueue.remove(0);
                    if (e.ParentGene != null) continue;
                    Gene.AddSingleExonToGene(e);
                    MS2Edge Edge = e.ForwardIntrons;
                    while (Edge != null) {
                        exonQueue.add(Edge.LinkTo);
                        Edge = Edge.Next;
                    }
                    Edge = e.ReverseIntrons;
                    while (Edge != null) {
                        exonQueue.add(Edge.LinkTo);
                        Edge = Edge.Next;
                    }
                }
                if (this.Debug) {
                    System.out.println("Created a new gene!");
                    Gene.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                if (this.FirstMS2Gene == null) {
                    this.FirstMS2Gene = Gene;
                } else {
                    this.LastMS2Gene.Next = Gene;
                }
                this.LastMS2Gene = Gene;
                ++this.GeneCount;
                ++this.GeneIndex;
            }
            Exon = Exon.Next;
        }
    }

    public static String GetSequenceNameFromGene(String GeneName) {
        return GeneName.split("@")[0];
    }

    public void ReadExonSequence(MS2Exon Exon) {
        int Modulo;
        boolean LocalDebug = false;
        String FullSeq = null;
        if (!this.HashedSequences.containsKey(Exon.SequenceName) && this.Trie.getNumProteins() > 1) {
            int SequenceID = this.Trie.getProteinID(Exon.SequenceName);
            FullSeq = this.Trie.getProteinSequence(SequenceID);
            this.HashedSequences.put(Exon.SequenceName, FullSeq);
        }
        String ExonSeq = null;
        if (this.Trie.getNumProteins() == 1) {
            FullSeq = this.Trie.GetProteinSubstring(0, Exon.Start, Exon.End);
            ExonSeq = Utils.CleanUpPeptideString(FullSeq);
        } else {
            FullSeq = (String)this.HashedSequences.get(Exon.SequenceName);
            ExonSeq = Utils.CleanUpPeptideString(FullSeq.substring(Exon.Start, Exon.End));
        }
        if (LocalDebug) {
            System.out.println("Loading exon from sequence " + Exon.SequenceName);
        }
        if (ExonSeq == null) {
            System.out.println("EXON SEQ IS NULL, WTF!!");
            Exon.DebugPrint(true);
            Utils.WaitForEnter();
        }
        if (LocalDebug) {
            System.out.println("Exon Seq: " + ExonSeq);
        }
        int SkipBits = 0;
        String TranslateMe = "";
        if (Exon.Strand == 1) {
            Modulo = Exon.Start % 3;
            if (Modulo == Exon.ReadingFrame) {
                Exon.Prefix = "";
            } else if ((Exon.ReadingFrame + 1) % 3 == Modulo) {
                SkipBits = 2;
                if (ExonSeq.length() < 2) {
                    SkipBits = ExonSeq.length();
                }
                Exon.Prefix = ExonSeq.substring(0, SkipBits);
            } else {
                SkipBits = 1;
                Exon.Prefix = ExonSeq.substring(0, 1);
            }
            TranslateMe = ExonSeq.substring(SkipBits);
        } else {
            ExonSeq = Utils.ReverseComplement(ExonSeq);
            Modulo = (Exon.End - 1) % 3;
            if (Modulo == Exon.ReadingFrame) {
                SkipBits = 0;
                Exon.Prefix = "";
            } else if ((Exon.ReadingFrame + 1) % 3 == Modulo) {
                SkipBits = 1;
                Exon.Prefix = ExonSeq.substring(0, 1);
            } else {
                SkipBits = 2;
                if (ExonSeq.length() < 2) {
                    SkipBits = ExonSeq.length();
                }
                Exon.Prefix = ExonSeq.substring(0, SkipBits);
            }
            TranslateMe = ExonSeq.substring(SkipBits);
        }
        Exon.Sequence = Utils.translateSequence(TranslateMe, this.codonTable);
        if (LocalDebug) {
            System.out.println("Seq: " + Exon.Sequence);
        }
        Exon.Suffix = TranslateMe.length() % 3 != 0 ? TranslateMe.substring(TranslateMe.length() - TranslateMe.length() % 3) : "";
        if (LocalDebug) {
            Exon.DebugPrint(true);
            Utils.WaitForEnter();
        }
        int LengthPrefix = Exon.Prefix.length();
        int LengthSuffix = Exon.Suffix.length();
        int LengthBody = Exon.Sequence.length() * 3;
        int LengthFull = LengthPrefix + LengthBody + LengthSuffix;
        if (LengthFull != Exon.End - Exon.Start) {
            System.err.println("ERROR: Length " + LengthFull + " != genomic span " + (Exon.End - Exon.Start));
        }
    }

    public void SetExonInfo(MS2Exon Exon) {
        int Len;
        int Modulo;
        boolean LocalDebug = false;
        Object FullSeq = null;
        int SkipBits = 0;
        int TranslateLength = Exon.End - Exon.Start;
        if (Exon.Strand == 1) {
            Modulo = Exon.Start % 3;
            if (Modulo == Exon.ReadingFrame) {
                Exon.Prefix = "";
            } else if ((Exon.ReadingFrame + 1) % 3 == Modulo) {
                SkipBits = 2;
                if (Exon.End - Exon.Start < 2) {
                    SkipBits = Exon.End - Exon.Start;
                }
                if (SkipBits == 0) {
                    Exon.Prefix = "";
                } else if (SkipBits == 1) {
                    Exon.Prefix = "T";
                } else if (SkipBits == 2) {
                    Exon.Prefix = "TT";
                }
            } else {
                SkipBits = 1;
                Exon.Prefix = "T";
            }
            TranslateLength -= Exon.Prefix.length();
        } else {
            Modulo = (Exon.End - 1) % 3;
            if (Modulo == Exon.ReadingFrame) {
                SkipBits = 0;
                Exon.Prefix = "";
            } else if ((Exon.ReadingFrame + 1) % 3 == Modulo) {
                SkipBits = 1;
                Exon.Prefix = "T";
            } else {
                SkipBits = 2;
                if (Exon.End - Exon.Start < 2) {
                    SkipBits = Exon.End - Exon.Start;
                }
                if (SkipBits == 0) {
                    Exon.Prefix = "";
                } else if (SkipBits == 1) {
                    Exon.Prefix = "T";
                } else if (SkipBits == 2) {
                    Exon.Prefix = "TT";
                }
            }
            TranslateLength -= Exon.Prefix.length();
        }
        Exon.Sequence = "";
        if (LocalDebug) {
            System.out.println("Seq: " + Exon.Sequence);
        }
        Exon.Suffix = TranslateLength % 3 != 0 ? ((Len = TranslateLength % 3) == 1 ? "T" : "TT") : "";
    }

    public void OutputMS2Exon(MS2Gene Gene, MS2Exon Exon) throws IOException {
        if (this.OutputFile == null) {
            return;
        }
        int PrefixLen = 0;
        int SuffixLen = 0;
        String Prefix = "";
        String Suffix = "";
        String ExonSeq = Utils.CleanUpPeptideString(Exon.Sequence);
        if (Exon.Prefix != null) {
            PrefixLen = Exon.Prefix.length();
            Prefix = Exon.Prefix;
        }
        if (Exon.Suffix != null) {
            SuffixLen = Exon.Suffix.length();
            Suffix = Exon.Suffix;
        }
        this.OutputFile.write("  <Exon Index=\"" + Exon.Index + "\" Start=\"" + Exon.Start + "\" End=\"" + Exon.End + "\"" + " PrefixLen=\"" + PrefixLen + "\" SuffixLen=\"" + SuffixLen + "\"" + " ReadingFrame=\"" + Exon.ReadingFrame + "\"" + " Prefix=\"" + Prefix + "\" Suffix=\"" + Suffix + "\">\n");
        if (this.Debug) {
            System.out.print("  <Exon Index=\"" + Exon.Index + "\" Start=\"" + Exon.Start + "\" End=\"" + Exon.End + "\">\n");
        }
        if (Exon.Sequence != null) {
            this.OutputFile.write("    <ExonSequence Length=\"" + ExonSeq.length() + "\">" + ExonSeq + "</ExonSequence>\n");
            if (this.Debug) {
                System.out.print("    <ExonSequence Length=\"" + ExonSeq.length() + "\">" + ExonSeq + "</ExonSequence>\n");
            }
        } else {
            this.OutputFile.write("    <ExonSequence Length=\"0\"></ExonSequence>\n");
            if (this.Debug) {
                System.out.print("    <ExonSequence Length=\"0\"></ExonSequence>\n");
            }
        }
        MS2Edge Edge = null;
        Edge = Gene.ForwardFlag == 1 ? Exon.ReverseIntrons : Exon.ForwardIntrons;
        while (Edge != null) {
            MS2Exon LinkExon = Edge.LinkTo;
            if (LinkExon.Start == Exon.End || LinkExon.End == Exon.Start) {
                this.OutputFile.write("    <ExtendsExon");
                if (this.Debug) {
                    System.out.print("    <ExtendsExon");
                }
            } else {
                this.OutputFile.write("    <LinkFrom");
                if (this.Debug) {
                    System.out.print("    <LinkFrom");
                }
            }
            this.OutputFile.write(" Index=\"" + LinkExon.Index + "\"");
            if (this.Debug) {
                System.out.print(" Index=\"" + LinkExon.Index + "\"");
            }
            char AA = '\u0000';
            if (Exon.MS2_EXON_CUSTOMAA_HEAD) {
                AA = (char)Exon.CustomAA;
            } else if (Exon.MS2_EXON_CUSTOMAA) {
                AA = '\u0000';
            } else if (LinkExon.MS2_EXON_CUSTOMAA) {
                AA = (char)LinkExon.CustomAA;
            } else {
                AA = '\u0000';
                String SpanningCodon = null;
                int LengthA = 0;
                if (LinkExon.Suffix != null) {
                    LengthA = LinkExon.Suffix.length();
                } else {
                    System.out.println("NO SUFFIX FOR ");
                    LinkExon.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                int LengthB = 0;
                if (Exon.Prefix != null) {
                    LengthB = Exon.Prefix.length();
                } else {
                    System.out.println("NO PREFIX FOR ");
                    Exon.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                if (LengthA + LengthB == 3) {
                    SpanningCodon = String.valueOf(LinkExon.Suffix) + Exon.Prefix;
                } else if (LengthA + LengthB == 0) {
                    SpanningCodon = null;
                } else {
                    int Modulo;
                    if (Exon.Strand == 1) {
                        Modulo = Exon.Start % 3;
                        if ((Exon.ReadingFrame + 1) % 3 != Modulo) {
                            System.err.println("This exon is not a middle of a codon!!");
                        }
                    } else {
                        Modulo = (Exon.End - 1) % 3;
                        int test = Exon.ReadingFrame - 1;
                        if (test == -1) {
                            test = 2;
                        }
                        if (test % 3 != Modulo) {
                            System.err.println("This exon is not a middle of a codon!!");
                            System.err.println("Modulo: " + Modulo);
                            System.err.println("Test: " + test % 3);
                        }
                    }
                    System.err.println("ERROR: Exons " + LinkExon.Index + " is linked to " + Exon.Index + " with incompatible reading frame!!");
                    LinkExon.DebugPrint(true);
                    Exon.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                if (SpanningCodon != null) {
                    if (this.Debug) {
                        System.out.println("\nSpanning Codon: " + SpanningCodon);
                    }
                    AA = Utils.translateCodon(SpanningCodon.toCharArray(), this.codonTable);
                    if (this.Debug) {
                        System.out.println("Spanning AA: " + AA);
                        Utils.WaitForEnter();
                    }
                    if (AA == 'X' && Edge.SpecialAA != '\u0000') {
                        AA = Edge.SpecialAA;
                    }
                }
            }
            if (AA != '\u0000') {
                this.OutputFile.write(" AA=\"" + AA + "\"");
                if (this.Debug) {
                    System.out.print(" AA=\"" + AA + "\"");
                }
            }
            this.OutputFile.write("/>\n");
            if (this.Debug) {
                System.out.print("/>\n");
            }
            Edge = Edge.Next;
        }
        this.OutputFile.write("  </Exon>\n");
        if (this.Debug) {
            System.out.print("  </Exon>\n");
        }
    }

    public void SortMS2GeneExons(MS2Gene Gene) {
        if (Gene.ForwardFlag == 1) {
            this.SortMS2GeneExonsForward(Gene);
        } else {
            this.SortMS2GeneExonsReverse(Gene);
        }
    }

    private void SortMS2GeneExonsForward(MS2Gene Gene) {
        if (this.Debug) {
            System.out.println("Sorting exons for Gene: " + Gene.GeneName);
            Utils.WaitForEnter();
        }
        int ExonCount = Gene.Exons.size();
        if (this.Debug) {
            System.out.println("has " + ExonCount + " exons");
        }
        int i = 0;
        while (i < ExonCount) {
            int MinIndex = i;
            MS2Exon MinExon = (MS2Exon)Gene.Exons.get(i);
            int j = i + 1;
            while (j < ExonCount) {
                MS2Exon CurrExon = (MS2Exon)Gene.Exons.get(j);
                if (CurrExon.compareTo(MinExon) < 0) {
                    MinExon = CurrExon;
                    MinIndex = j;
                }
                ++j;
            }
            if (MinIndex != i) {
                Object Temp = Gene.Exons.get(i);
                MinExon.Index = i;
                Gene.Exons.set(i, MinExon);
                Gene.Exons.set(MinIndex, Temp);
            } else {
                MinExon.Index = i;
            }
            if (this.Debug) {
                System.out.println("Min Exon: ");
                MinExon.DebugPrint(true);
                Utils.WaitForEnter();
            }
            ++i;
        }
    }

    private void SortMS2GeneExonsReverse(MS2Gene Gene) {
        if (this.Debug) {
            System.out.println("Sorting(reverse) exons for Gene: " + Gene.GeneName);
            Utils.WaitForEnter();
        }
        int ExonCount = Gene.Exons.size();
        int i = 0;
        while (i < ExonCount) {
            int MaxIndex = i;
            MS2Exon MaxExon = (MS2Exon)Gene.Exons.get(i);
            int j = i + 1;
            while (j < ExonCount) {
                MS2Exon CurrExon = (MS2Exon)Gene.Exons.get(j);
                if (CurrExon.compareTo(MaxExon) > 0) {
                    MaxExon = CurrExon;
                    MaxIndex = j;
                }
                ++j;
            }
            if (MaxIndex != i) {
                Object Temp = Gene.Exons.get(i);
                MaxExon.Index = i;
                Gene.Exons.set(i, MaxExon);
                Gene.Exons.set(MaxIndex, Temp);
            } else {
                MaxExon.Index = i;
            }
            ++i;
        }
    }

    public void OutputMS2CrossReference(MS2CrossReference CR) throws IOException {
        if (this.OutputFile == null) {
            return;
        }
        this.OutputFile.write("  <CrossReference Database=\"" + CR.GFFGene.DatabaseName + "\" ID=\"" + CR.GFFGene.Name + "\">\n");
        this.OutputFile.write("    <CRExons Index=\"");
        if (this.Debug) {
            System.out.print("  <CrossReference Database=\"" + CR.GFFGene.DatabaseName + "\" ID=\"" + CR.GFFGene.Name + "\">\n");
            System.out.print("    <CRExons Index=\"");
        }
        int i = 0;
        while (i < CR.ExonIDs.size()) {
            if (i < CR.ExonIDs.size() - 1) {
                this.OutputFile.write(String.valueOf((Integer)CR.ExonIDs.get(i)) + ", ");
                if (this.Debug) {
                    System.out.print(String.valueOf((Integer)CR.ExonIDs.get(i)) + ", ");
                }
            } else {
                this.OutputFile.write(String.valueOf((Integer)CR.ExonIDs.get(i)));
                if (this.Debug) {
                    System.out.print(String.valueOf((Integer)CR.ExonIDs.get(i)));
                }
            }
            ++i;
        }
        this.OutputFile.write("\"/>\n");
        this.OutputFile.write("  </CrossReference>\n");
    }

    public void OutputMS2Gene(MS2Gene Gene) throws IOException {
        if (this.OutputFile == null) {
            return;
        }
        int ExonCount = Gene.Exons.size();
        this.OutputFile.write("<Gene Name=\"" + Gene.GeneName + "\" ExonCount=\"" + ExonCount + "\" Chromosome=\"" + Gene.SequenceName + "\" ForwardFlag=\"" + Gene.ForwardFlag + "\">\n");
        if (this.Debug) {
            System.out.print("<Gene ExonCount=\"" + ExonCount + "\" Chromosome\"" + Gene.SequenceName + "\" ForwardFlag=\"" + Gene.ForwardFlag + "\">\n");
        }
        int i = 0;
        while (i < ExonCount) {
            int j = 0;
            while (j < ExonCount) {
                MS2Exon CurrExon = (MS2Exon)Gene.Exons.get(j);
                if (CurrExon.Index == i) {
                    this.OutputMS2Exon(Gene, CurrExon);
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < Gene.CrossReferences.size()) {
            this.OutputMS2CrossReference((MS2CrossReference)Gene.CrossReferences.get(i));
            ++i;
        }
        this.OutputFile.write("</Gene>\n\n");
        this.OutputFile.flush();
        if (this.Debug) {
            System.out.print("</Gene>\n\n");
            Utils.WaitForEnter();
        }
    }

    public static int GetCodonHashValue(String Codon) {
        int[] Multiplier = new int[]{1, 4, 16};
        int Value = 0;
        int i = 0;
        while (i < Codon.length()) {
            switch (Codon.charAt(i)) {
                case 'A': 
                case 'a': {
                    Value += 0 * Multiplier[i];
                    break;
                }
                case 'C': 
                case 'c': {
                    Value += 1 * Multiplier[i];
                    break;
                }
                case 'G': 
                case 'g': {
                    Value += 2 * Multiplier[i];
                    break;
                }
                case 'T': 
                case 't': {
                    Value += 3 * Multiplier[i];
                    break;
                }
                default: {
                    System.err.println("ERROR: Unidentified nucleotide '" + Codon.charAt(i) + "'");
                    return 0;
                }
            }
            ++i;
        }
        return Value;
    }

    public void RepairPromiscuousSingtonExons() {
        String Codon = "";
        String RCCodon = "";
        String EncodeCodon = "";
        MS2Exon[] CodonExons = new MS2Exon[64];
        boolean LocalDebug = this.Debug;
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            int Modulo;
            if (Exon.End > Exon.Start + 1) {
                Exon = Exon.Next;
                continue;
            }
            if (Exon.Strand == 1) {
                Modulo = Exon.Start % 3;
                if ((Exon.ReadingFrame + 1) % 3 != Modulo) {
                    Exon = Exon.Next;
                    continue;
                }
            } else {
                Modulo = (Exon.End - 1) % 3;
                int test = Exon.ReadingFrame - 1;
                if (test == -1) {
                    test = 2;
                }
                if (test % 3 != Modulo) {
                    Exon = Exon.Next;
                    continue;
                }
            }
            if (Exon.CustomAA != -1) {
                Exon = Exon.Next;
                continue;
            }
            if (LocalDebug) {
                System.out.println("Considering singlteon exon:");
                Exon.DebugPrint(true);
                if (Exon.ReverseIntrons == null) {
                    System.out.println("THERE ARE NO REVERSE INTRONS!!");
                }
                if (Exon.ForwardIntrons == null) {
                    System.out.println("THERE ARE NO FORWARD INTRONS!!");
                }
                Utils.WaitForEnter();
            }
            boolean BridgedFlag = false;
            int i = 0;
            while (i < CodonExons.length) {
                CodonExons[i] = null;
                ++i;
            }
            MS2Edge BackwardEdge = Exon.ReverseIntrons;
            while (BackwardEdge != null) {
                MS2Edge ForwardEdge = Exon.ForwardIntrons;
                while (ForwardEdge != null) {
                    if (Exon.Strand == 1) {
                        EncodeCodon = Codon = String.valueOf(BackwardEdge.LinkTo.Suffix) + Exon.Prefix + ForwardEdge.LinkTo.Prefix;
                        if (LocalDebug) {
                            System.out.println("Considering PrevExon:");
                            BackwardEdge.LinkTo.DebugPrint(true);
                            System.out.println("And NextExon:");
                            ForwardEdge.LinkTo.DebugPrint(true);
                        }
                    } else {
                        Codon = String.valueOf(ForwardEdge.LinkTo.Suffix) + Exon.Prefix + BackwardEdge.LinkTo.Prefix;
                        EncodeCodon = RCCodon = Utils.ReverseComplement(Codon);
                        if (LocalDebug) {
                            System.out.println("Considering NextExon:");
                            BackwardEdge.LinkTo.DebugPrint(true);
                            System.out.println("And PrevExon:");
                            ForwardEdge.LinkTo.DebugPrint(true);
                            System.out.println("CODON: " + EncodeCodon);
                        }
                    }
                    if (EncodeCodon.length() > 3) {
                        System.out.println("THIS GUY HAS TOO MUCH GOING ON (Codon is size: " + EncodeCodon.length() + "!!");
                        Exon.DebugPrint(true);
                        System.out.println("BackLink:");
                        BackwardEdge.LinkTo.DebugPrint(true);
                        System.out.println("ForwardLink:");
                        ForwardEdge.LinkTo.DebugPrint(true);
                        Utils.WaitForEnter();
                    }
                    if (EncodeCodon.length() < 3) {
                        System.err.println("ERROR: Split codon has fewer than 3 letters!");
                        System.err.println("CODON: " + Codon);
                        System.err.println("RCCODON: " + RCCodon);
                        System.err.println("EncodeCODON: " + EncodeCodon);
                        System.out.println("Considering NextExon:");
                        BackwardEdge.LinkTo.DebugPrint(true);
                        System.out.println("And PrevExon:");
                        ForwardEdge.LinkTo.DebugPrint(true);
                        Utils.WaitForEnter();
                    }
                    int CodonValue = BuildMS2DB.GetCodonHashValue(EncodeCodon);
                    if (LocalDebug) {
                        System.out.println("Codon Value: " + CodonValue);
                    }
                    if (CodonValue < 0 || CodonValue > 64) {
                        System.err.println("ERROR: Invalid codon hash value for " + EncodeCodon + " = " + CodonValue);
                    }
                    if (CodonExons[CodonValue] == null) {
                        CodonExons[CodonValue] = new MS2Exon(Exon.Start, Exon.End, Exon.ReadingFrame, Exon.SequenceName, Exon.Strand);
                        CodonExons[CodonValue].Prefix = Exon.Prefix;
                        CodonExons[CodonValue].Suffix = Exon.Suffix;
                        CodonExons[CodonValue].CustomAA = Utils.translateCodon(EncodeCodon.toCharArray(), this.codonTable);
                        this.AddMS2Exon(CodonExons[CodonValue]);
                        if (LocalDebug) {
                            System.out.println("This is the first time we used this special codon!");
                        }
                    }
                    MS2Exon otherExon = ForwardEdge.LinkTo;
                    CodonExons[CodonValue].LinkExonForward(otherExon);
                    if (LocalDebug) {
                        System.out.println("Added forward edge");
                        otherExon.DebugPrint(true);
                        CodonExons[CodonValue].DebugPrint(true);
                    }
                    otherExon = BackwardEdge.LinkTo;
                    otherExon.LinkExonForward(CodonExons[CodonValue]);
                    if (LocalDebug) {
                        System.out.println("Added backward edge");
                        otherExon.DebugPrint(true);
                        CodonExons[CodonValue].DebugPrint(true);
                        Utils.WaitForEnter();
                    }
                    if (LocalDebug) {
                        CodonExons[CodonValue].DebugPrint(true);
                        if (LocalDebug) {
                            System.out.println("What do the other guys look like?");
                            System.out.println("Considering NextExon:");
                            BackwardEdge.LinkTo.DebugPrint(true);
                            System.out.println("And PrevExon:");
                            ForwardEdge.LinkTo.DebugPrint(true);
                            System.out.println("CODON: " + EncodeCodon);
                        }
                        Utils.WaitForEnter();
                    }
                    BridgedFlag = true;
                    ForwardEdge = ForwardEdge.Next;
                }
                BackwardEdge = BackwardEdge.Next;
            }
            if (LocalDebug) {
                System.out.println("BridgedFlag: " + BridgedFlag);
            }
            int CodonValue = 0;
            while (CodonValue < 64) {
                if (CodonExons[CodonValue] != null) {
                    CodonExons[CodonValue].MS2_EXON_CUSTOMAA = true;
                    MS2Edge Edge = null;
                    Edge = Exon.Strand == 1 ? CodonExons[CodonValue].ForwardIntrons : CodonExons[CodonValue].ReverseIntrons;
                    if (Edge != null && Edge.Next == null) {
                        if (Edge.LinkFrom.Start == Edge.LinkTo.End || Edge.LinkFrom.End == Edge.LinkTo.Start) {
                            CodonExons[CodonValue].MS2_EXON_CUSTOMAA_HEAD = true;
                        }
                        if (LocalDebug) {
                            System.out.println("Edge.LinkFrom.Start: " + Edge.LinkFrom.Start);
                            System.out.println("Edge.LinkTo.End: " + Edge.LinkTo.End);
                            System.out.println("Edge.LinkFrom.End: " + Edge.LinkFrom.End);
                            System.out.println("Edge.LinkTo.Start: " + Edge.LinkTo.Start);
                            System.out.println("New singleton exon:");
                            CodonExons[CodonValue].DebugPrint(true);
                            Utils.WaitForEnter();
                        }
                    }
                }
                ++CodonValue;
            }
            if (LocalDebug) {
                System.out.println("FINAL EXON: ");
                Exon.DebugPrint(true);
                Utils.WaitForEnter();
            }
            MS2Exon NextExon = Exon.Next;
            if (BridgedFlag) {
                this.DeleteMS2Exon(Exon);
            } else {
                System.err.println("WARNING: Exon not bridged!!");
                Exon.DebugPrint(true);
                Utils.WaitForEnter();
            }
            Exon = NextExon;
        }
    }

    public void BuildForEventFinder(String[] GFFFiles, String SeqName) {
        boolean LocalDebug = false;
        this.GFFFiles = GFFFiles;
        this.ExonHash = new Hashtable();
        this.ForwardFlag = 0;
        while (this.ForwardFlag <= 1) {
            this.ParseGFFFiles(SeqName);
            if (this.FirstExon == null) {
                System.err.println("ERROR: Unable to build any exons!!!");
                Utils.WaitForEnter();
            } else {
                System.out.println("Finished parsing GFF files, created " + this.ExonCount + " exons");
            }
            ++this.ForwardFlag;
        }
        MS2Exon E = null;
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        System.out.println("Splitting Overlapping Exons...");
        this.SplitOverlappingExons();
        E = this.FirstExon;
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        System.out.println("Adding Adjacent Links...");
        this.AddAdjacentExonLinks();
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        System.out.println("Reading Exon Sequence...");
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            this.SetExonInfo(Exon);
            Exon = Exon.Next;
        }
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        System.out.println("Repairing Singleton Exons...");
        this.RepairPromiscuousSingtonExons();
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        System.out.println("Grouping Exons...");
        this.GroupExonsIntoGenes();
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    E.ParentGene.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        System.out.println("Sorting genes...");
        MS2Gene Gene = this.FirstMS2Gene;
        while (Gene != null) {
            this.SortMS2GeneExons(Gene);
            Gene = Gene.Next;
        }
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    E.ParentGene.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        this.BuildGFFCrossReferences();
        if (LocalDebug) {
            E = this.FirstExon;
            while (E != null) {
                if (E.Start == 130725011 || E.End == 130725119 || E.Start == 130725093) {
                    E.DebugPrint(true);
                    Utils.WaitForEnter();
                }
                E = E.Next;
            }
        }
        if (LocalDebug) {
            this.DebugPrintBuilder();
        }
        System.out.println("Total Genes: " + this.GeneCount);
        System.out.println("Total Exons: " + this.ExonCount);
    }

    public void Build(int ForwardFlag) {
        if (this.TrieFile == null) {
            return;
        }
        if (this.Trie == null) {
            this.Trie = new TrieDB(this.TrieFile);
        }
        if (this.GFFFiles == null) {
            return;
        }
        if (this.OutputFileName == null) {
            return;
        }
        this.ForwardFlag = ForwardFlag;
        if (this.OutputFile == null) {
            return;
        }
        this.ExonHash = new Hashtable();
        if (this.Debug) {
            System.out.println("Parsing GFF File Lines...");
        }
        this.ParseGFFFiles(null);
        if (this.FirstExon == null) {
            if (ForwardFlag == 0) {
                System.err.println("WARNING: Unable to build any exons on reverse strand!!!");
            } else {
                System.err.println("WARNING: Unable to build any exons on forward strand!!!");
            }
            return;
        }
        System.out.println("Finished parsing GFF files, created " + this.ExonCount + " exons");
        if (this.Debug) {
            this.DebugPrintBuilder();
            Utils.WaitForEnter();
        }
        System.out.println("Splitting Overlapping Exons...");
        if (this.Debug) {
            Utils.WaitForEnter();
        }
        this.SplitOverlappingExons();
        if (this.Debug) {
            this.DebugPrintBuilder();
            Utils.WaitForEnter();
        }
        System.out.println("Reading Exon Sequence...");
        if (this.Debug) {
            Utils.WaitForEnter();
        }
        MS2Exon Exon = this.FirstExon;
        while (Exon != null) {
            this.ReadExonSequence(Exon);
            Exon = Exon.Next;
        }
        System.out.println("Adding Adjacent Links...");
        if (this.Debug) {
            Utils.WaitForEnter();
        }
        this.AddAdjacentExonLinks();
        if (this.Debug) {
            this.DebugPrintBuilder();
            Utils.WaitForEnter();
        }
        if (this.Debug) {
            this.DebugPrintBuilder();
            Utils.WaitForEnter();
        }
        System.out.println("Repairing Singleton Exons...");
        if (this.Debug) {
            Utils.WaitForEnter();
        }
        this.RepairPromiscuousSingtonExons();
        if (this.Debug) {
            this.DebugPrintBuilder();
            Utils.WaitForEnter();
        }
        System.out.println("Grouping Exons...");
        if (this.Debug) {
            Utils.WaitForEnter();
        }
        this.GroupExonsIntoGenes();
        if (this.Debug) {
            this.DebugPrintBuilder();
            System.out.println("Genes: " + this.GeneCount);
            Utils.WaitForEnter();
        }
        if (this.Debug) {
            if (this.FirstMS2Gene == null) {
                System.out.println("SHIT NO GENES!!");
            }
            Utils.WaitForEnter();
        }
        System.out.println("Sorting genes...");
        MS2Gene Gene = this.FirstMS2Gene;
        while (Gene != null) {
            this.SortMS2GeneExons(Gene);
            Gene = Gene.Next;
        }
        if (this.Debug) {
            this.DebugPrintBuilder();
            Utils.WaitForEnter();
        }
        this.BuildGFFCrossReferences();
        Gene = this.FirstMS2Gene;
        while (Gene != null) {
            try {
                this.OutputMS2Gene(Gene);
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
            Gene = Gene.Next;
        }
        System.out.println("Total Genes: " + this.GeneCount);
        System.out.println("Total Exons: " + this.ExonCount);
        this.ClearBuilder();
    }

    public void ClearBuilder() {
        this.ExonHash.clear();
        this.FirstExon = null;
        this.LastExon = null;
        this.FirstGFFGene = null;
        this.LastGFFGene = null;
        this.FirstMS2Gene = null;
        this.LastMS2Gene = null;
        this.ExonCount = 0;
        this.GeneCount = 0;
    }

    public BuildMS2DB(String TrieFile, String[] GFFFiles, String OutputName) {
        String ext = Utils.GetFileExtension(TrieFile);
        if (ext.compareTo(".fasta") == 0 || ext.compareTo(".fa") == 0) {
            System.out.println("WE GOT A FASTA, so we have to convert to trie!!");
            String tFile = String.valueOf(Utils.GetFileNameNoExtension(TrieFile)) + ".trie";
            String[] names = TrieDB.prepDB(TrieFile, tFile);
            System.out.println("Prepping the db");
            this.TrieFile = names[0];
            System.out.println("Produced trie file " + this.TrieFile);
            this.Trie = new TrieDB(this.TrieFile);
        } else if (ext.compareTo(".trie") == 0) {
            this.TrieFile = TrieFile;
            this.Trie = new TrieDB(this.TrieFile);
        } else {
            System.err.println("ERROR: Invalid file type for '" + TrieFile + "'.  Please specify either a .fasta or .trie file\n");
            System.exit(-1);
        }
        this.GFFFiles = GFFFiles;
        this.OutputFileName = OutputName;
        this.HashedSequences = new Hashtable();
        try {
            this.OutputFile = new FileWriter(OutputName);
            this.OutputFile.write("<Database CreatedBy=\"BuildMS2DB.java\">\n");
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public void DebugPrintBuilder() {
        block4: {
            block3: {
                System.out.println("=======Builder========");
                System.out.println("SeqFile: " + this.TrieFile);
                System.out.println("OutputFile: " + this.OutputFileName);
                int i = 0;
                while (i < this.GFFFiles.length) {
                    System.out.println("GFFFile[" + i + "]: " + this.GFFFiles[i]);
                    ++i;
                }
                System.out.println("NumExons: " + this.ExonCount);
                System.out.println("ForwardFlag: " + this.ForwardFlag);
                System.out.println("GeneCount: " + this.GeneCount);
                if (this.FirstMS2Gene == null) break block3;
                MS2Gene Gene = this.FirstMS2Gene;
                while (Gene != null) {
                    Gene.DebugPrint(true);
                    Utils.WaitForEnter();
                    Gene = Gene.Next;
                }
                break block4;
            }
            if (this.FirstExon == null) break block4;
            System.out.println("NO GENES, PRINTING BY EXON");
            MS2Exon Exon = this.FirstExon;
            while (Exon != null) {
                Exon.DebugPrint(true);
                Exon = Exon.Next;
            }
        }
    }

    public void DestroyBuilder() {
        try {
            this.OutputFile.write("\n</Database>\n");
            this.OutputFile.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public BuildMS2DB() {
    }

    public MS2Gene NewMS2Gene() {
        return new MS2Gene();
    }

    public MS2Exon NewMS2Exon(int Start, int End, int ReadingFrame, String SeqName, int Strand) {
        return new MS2Exon(Start, End, ReadingFrame, SeqName, Strand);
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-s", "-w", "-d", "-t", "-f", "-g", "-m", "-c"};
        boolean[] blArray = new boolean[9];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        boolean[] values = blArray;
        Hashtable Options = Utils.ParseCommandLineMulti(args, options, values);
        if (!Options.containsKey("-r")) {
            System.err.println("ERROR: Must specify at least 1 gff file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        if (!Options.containsKey("-s")) {
            System.err.println("ERROR: Must specify a FASTA or trie formated sequence file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        if (!Options.containsKey("-w")) {
            System.err.println("ERROR: Must specify an output ms2db file");
            System.out.println(UsageInfo);
            Utils.printGeneticCodeOptions();
            return;
        }
        ArrayList Temp = (ArrayList)Options.get("-r");
        String[] GFFFiles = Utils.ConvertArraylistToStringArray(Temp);
        Temp = (ArrayList)Options.get("-s");
        String TrieDB2 = (String)Temp.get(0);
        Temp = (ArrayList)Options.get("-w");
        String OutputFileName = (String)Temp.get(0);
        BuildMS2DB Builder = new BuildMS2DB(TrieDB2, GFFFiles, OutputFileName);
        if (Options.containsKey("-c")) {
            Temp = (ArrayList)Options.get("-c");
            Builder.codonTable = Integer.parseInt((String)Temp.get(0));
            if (Builder.codonTable < 0 || Builder.codonTable >= Utils.dnaCodeNames.length) {
                System.err.println("ERROR: Invalid codon table number '" + Builder.codonTable + "'");
                System.out.println(UsageInfo);
                Utils.printGeneticCodeOptions();
                return;
            }
        }
        if (Options.containsKey("-t")) {
            Temp = (ArrayList)Options.get("-t");
            Builder.intervalTypes = Utils.ConvertArraylistToStringArray(Temp);
        } else {
            Builder.intervalTypes = new String[1];
            Builder.intervalTypes[0] = "CDS";
        }
        if (Options.containsKey("-d")) {
            Builder.Debug = true;
        }
        if (Options.containsKey("-f")) {
            Builder.ReadPhase = true;
        }
        if (Options.containsKey("-g")) {
            Temp = (ArrayList)Options.get("-g");
            String[] interval = ((String)Temp.get(0)).split("-");
            Builder.minIntronLen = Integer.parseInt(interval[0]);
            Builder.maxIntronLen = Integer.parseInt(interval[1]);
            if (Builder.minIntronLen <= 0 || Builder.maxIntronLen < Builder.minIntronLen) {
                System.err.println("ERROR: Invalid intron length range [" + Builder.minIntronLen + " - " + Builder.maxIntronLen + "]!");
                return;
            }
            if (Options.containsKey("-m")) {
                Temp = (ArrayList)Options.get("-m");
                String val = (String)Temp.get(0);
                Builder.maxOutEdgesAdded = Integer.parseInt(val);
                if (Builder.maxOutEdgesAdded <= 0) {
                    System.err.println("ERROR: Invalid max introns per gene '" + Builder.maxOutEdgesAdded + "'!");
                    return;
                }
            }
        }
        Builder.printParams();
        Builder.Build(0);
        Builder.Build(1);
        Builder.DestroyBuilder();
    }

    public class GFFExonClass {
        public int Start;
        public int End;
        public int ReadingFrame;
        public String SequenceName;

        public GFFExonClass(int Start, int End, int ReadingFrame, String SeqName) {
            this.Start = Start;
            this.End = End;
            this.ReadingFrame = ReadingFrame;
            this.SequenceName = SeqName;
        }
    }

    public class GFFGeneClass {
        public String Name;
        public String DatabaseName;
        public String SequenceName;
        public ArrayList GFFExons = new ArrayList();
        public GFFGeneClass Next;
        public MS2CrossReference CrossReference;
        public int Start;
        public int End;
        public int Strand;

        public void AddGFFExon(GFFExonClass NewExon) {
            this.GFFExons.add(NewExon);
        }
    }

    public class MS2CrossReference {
        public MS2Gene Gene;
        public GFFGeneClass GFFGene;
        public ArrayList ExonIDs = new ArrayList();
        public MS2CrossReference Next;

        public void AddID(int ID) {
            this.ExonIDs.add(new Integer(ID));
        }

        public void DebugPrint() {
            System.out.println("---MS2XRef---");
            System.out.println("  GFFGene: " + this.GFFGene.Name + " on " + this.GFFGene.SequenceName);
            int[] Exons = Utils.ConvertArraylistToIntArray(this.ExonIDs);
            String S = "";
            int j = 0;
            while (j < this.ExonIDs.size()) {
                S = String.valueOf(S) + Exons[j] + ",";
                ++j;
            }
            System.out.println("  Exons covered: " + S);
        }
    }

    public class MS2Edge {
        public MS2Exon LinkTo;
        public MS2Exon LinkFrom;
        public MS2Edge Next;
        public char SpecialAA = '\u0000';

        public MS2Edge(MS2Exon Prev, MS2Exon Next) {
            this.LinkFrom = Prev;
            this.LinkTo = Next;
        }

        public void DebugPrint() {
            if (this.LinkFrom.Index >= 0) {
                if (this.SpecialAA != '\u0000') {
                    System.out.println("----MS2Edge [" + this.LinkFrom.Index + " to " + this.LinkTo.Index + "] : " + this.SpecialAA);
                } else {
                    System.out.println("----MS2Edge [" + this.LinkFrom.Index + " to " + this.LinkTo.Index + "]");
                }
            } else {
                System.out.print("----MS2Edge [(" + this.LinkFrom.Start + "-" + this.LinkFrom.End + ":" + this.LinkFrom.ReadingFrame);
                if (this.LinkFrom.MS2_EXON_CUSTOMAA || this.LinkFrom.MS2_EXON_CUSTOMAA_HEAD) {
                    System.out.print(" " + (char)this.LinkFrom.CustomAA);
                }
                System.out.print(") to (" + this.LinkTo.Start + "-" + this.LinkTo.End + ":" + this.LinkTo.ReadingFrame);
                if (this.LinkTo.MS2_EXON_CUSTOMAA || this.LinkTo.MS2_EXON_CUSTOMAA_HEAD) {
                    System.out.print(" " + (char)this.LinkTo.CustomAA);
                }
                System.out.print(")]");
                if (this.SpecialAA != '\u0000') {
                    System.out.println(": " + this.SpecialAA);
                } else {
                    System.out.println("");
                }
            }
        }
    }

    public class MS2Exon
    implements Comparable {
        public int Start;
        public int End;
        public int ReadingFrame;
        public MS2Exon Next;
        public MS2Exon Prev;
        public String Prefix;
        public String Suffix;
        public int PrefixLen;
        public int SuffixLen;
        public MS2Edge ForwardIntrons;
        public MS2Edge ReverseIntrons;
        public MS2Gene ParentGene = null;
        public String SequenceName;
        public int Strand = -1;
        public int Index = -1;
        public String Sequence;
        public int CustomAA = -1;
        public boolean MS2_EXON_CUSTOMAA_HEAD = false;
        public boolean MS2_EXON_CUSTOMAA = false;

        public MS2Exon(int Start, int End, int ReadingFrame, String SeqName, int Strand) {
            this.Start = Start;
            this.End = End;
            this.ReadingFrame = ReadingFrame;
            this.SequenceName = SeqName;
            this.Strand = Strand;
            if (this.Strand == 1) {
                int k = 0;
                while (k < 3) {
                    int tRF = (this.Start + k) % 3;
                    if (tRF == this.ReadingFrame) {
                        this.PrefixLen = Math.min(k, this.End - this.Start);
                        this.SuffixLen = (this.End - this.Start - this.PrefixLen) % 3;
                    }
                    ++k;
                }
            } else {
                int k = 0;
                while (k < 3) {
                    int tRF = (this.End - 1 - k) % 3;
                    if (tRF == this.ReadingFrame) {
                        this.PrefixLen = Math.min(k, this.End - this.Start);
                        this.SuffixLen = (this.End - this.Start - this.PrefixLen) % 3;
                    }
                    ++k;
                }
            }
        }

        public MS2Exon(MS2Exon OldExon) {
            this(OldExon.Start, OldExon.End, OldExon.ReadingFrame, OldExon.SequenceName, OldExon.Strand);
            this.Sequence = Utils.ReverseString(OldExon.Sequence);
            this.Prefix = OldExon.Suffix;
            this.Suffix = OldExon.Prefix;
            this.Strand = 1 - OldExon.Strand;
            this.ReadingFrame = this.Strand == 1 ? (this.Start + this.Prefix.length()) % 3 : (this.End - 1 - this.Prefix.length()) % 3;
            this.MS2_EXON_CUSTOMAA = OldExon.MS2_EXON_CUSTOMAA;
            this.CustomAA = OldExon.CustomAA;
        }

        public void LinkExonForward(MS2Exon ToExon) {
            boolean LocalDebug = false;
            if (ToExon.Start < this.End) {
                System.err.println("ERROR: Cannot link exon ending at " + this.End + " forward to exon starting at " + ToExon.Start);
                return;
            }
            MS2Edge Edge = this.ForwardIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == ToExon) {
                    if (LocalDebug) {
                        System.out.println("Edge Exists!!");
                    }
                    return;
                }
                Edge = Edge.Next;
            }
            Edge = ToExon.ReverseIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == this) {
                    System.err.println("ERROR: Reverse edge (and no forward edge) exists between " + this.Start + "-" + this.End + " and " + ToExon.Start + "-" + ToExon.End);
                    Utils.WaitForEnter();
                }
                Edge = Edge.Next;
            }
            Edge = new MS2Edge(this, ToExon);
            Edge.Next = this.ForwardIntrons;
            this.ForwardIntrons = Edge;
            if (LocalDebug && ToExon.ReverseIntrons != null) {
                System.out.println("(1)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
            }
            MS2Edge Edge2 = new MS2Edge(ToExon, this);
            Edge2.Next = ToExon.ReverseIntrons;
            ToExon.ReverseIntrons = Edge2;
            if (LocalDebug && ToExon.ReverseIntrons.Next != null) {
                System.out.println("(2)This is not the first reverse intron for this exon");
                System.out.println("To Exon:");
                ToExon.DebugPrint(true);
                System.out.println("Exon:");
                this.DebugPrint(true);
                Utils.WaitForEnter();
            }
        }

        public void LinkExonForward(MS2Exon ToExon, char AA) {
            boolean LocalDebug = false;
            if (ToExon.Start < this.End) {
                System.err.println("ERROR: Cannot link exon ending at " + this.End + " forward to exon starting at " + ToExon.Start);
                return;
            }
            MS2Edge Edge = this.ForwardIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == ToExon) {
                    if (LocalDebug) {
                        System.out.println("Edge Exists!!");
                    }
                    return;
                }
                Edge = Edge.Next;
            }
            Edge = ToExon.ReverseIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == this) {
                    System.err.println("ERROR: Reverse edge (and no forward edge) exists between " + this.Start + "-" + this.End + " and " + ToExon.Start + "-" + ToExon.End);
                    Utils.WaitForEnter();
                }
                Edge = Edge.Next;
            }
            Edge = new MS2Edge(this, ToExon);
            Edge.Next = this.ForwardIntrons;
            Edge.SpecialAA = AA;
            this.ForwardIntrons = Edge;
            MS2Edge Edge2 = new MS2Edge(ToExon, this);
            Edge2.Next = ToExon.ReverseIntrons;
            Edge2.SpecialAA = AA;
            ToExon.ReverseIntrons = Edge2;
        }

        public void RemoveBackwardEdge(MS2Exon LinkedExon) {
            MS2Edge Prev = null;
            MS2Edge Edge = this.ReverseIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == LinkedExon) {
                    if (Prev != null) {
                        Prev.Next = Edge.Next;
                    } else {
                        this.ReverseIntrons = Edge.Next;
                    }
                    return;
                }
                Prev = Edge;
                Edge = Edge.Next;
            }
        }

        public void RemoveForwardEdge(MS2Exon LinkedExon) {
            MS2Edge Prev = null;
            MS2Edge Edge = this.ForwardIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == LinkedExon) {
                    if (Prev != null) {
                        Prev.Next = Edge.Next;
                        break;
                    }
                    this.ForwardIntrons = Edge.Next;
                    break;
                }
                Prev = Edge;
                Edge = Edge.Next;
            }
        }

        public void ExonInheritForwardEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            if (this.End != DeadExon.End) {
                System.err.println("ERROR: Exon ending at " + this.End + " cannot inherit edges from " + DeadExon.End);
                return;
            }
            MS2Edge Edge = DeadExon.ForwardIntrons;
            while (Edge != null) {
                if (LocalDebug) {
                    System.out.println("Attempting to link [" + this.Start + "-" + this.End + "] to [" + Edge.LinkTo.Start + "-" + Edge.LinkTo.End + "]");
                }
                this.LinkExonForward(Edge.LinkTo);
                Edge.LinkTo.RemoveBackwardEdge(DeadExon);
                if (LocalDebug) {
                    Edge.LinkTo.DebugPrint(true);
                }
                Edge = Edge.Next;
            }
            DeadExon.ForwardIntrons = null;
            if (LocalDebug) {
                this.DebugPrint(true);
                DeadExon.DebugPrint(true);
                Utils.WaitForEnter();
            }
        }

        public void ExonInheritBackwardEdges(MS2Exon DeadExon) {
            boolean LocalDebug = false;
            if (this.Start != DeadExon.Start) {
                System.err.println("ERROR: Exon starting at " + this.Start + " cannot inherit edges from " + DeadExon.Start);
                return;
            }
            MS2Edge Edge = DeadExon.ReverseIntrons;
            while (Edge != null) {
                if (LocalDebug) {
                    System.out.println("Inheriting backward edge: ");
                    Edge.DebugPrint();
                }
                Edge.LinkTo.LinkExonForward(this);
                Edge.LinkTo.RemoveForwardEdge(DeadExon);
                if (LocalDebug) {
                    Edge.LinkTo.DebugPrint(true);
                }
                Edge = Edge.Next;
            }
            DeadExon.ReverseIntrons = null;
            if (LocalDebug) {
                this.DebugPrint(true);
                DeadExon.DebugPrint(true);
                Utils.WaitForEnter();
            }
        }

        public void DebugPrint(boolean Full) {
            if (this.ParentGene != null) {
                System.out.println("**----MS2Exon " + this.Index + " of " + this.ParentGene.GeneName + "----");
            } else {
                System.out.println("**----MS2Exon (No Parent)------");
            }
            System.out.println("[" + this.Start + " - " + this.End + "] frame: " + this.ReadingFrame);
            if (Full) {
                System.out.println("SequenceName: " + this.SequenceName);
                System.out.println("Sequence: " + this.Sequence);
                System.out.println("Strand: " + this.Strand);
                System.out.println("MS2_EXON_CUSTOMAA_HEAD: " + this.MS2_EXON_CUSTOMAA_HEAD);
                System.out.println("MS2_EXON_CUSTOMAA: " + this.MS2_EXON_CUSTOMAA);
                if (this.CustomAA != -1) {
                    System.out.println("CustomAA: " + (char)this.CustomAA);
                }
                if (this.Prefix != null && this.Suffix != null) {
                    System.out.println("Prefix: " + this.Prefix + ", PrefixLen: " + this.Prefix.length() + ", Suffix: " + this.Suffix + ", SuffixLen: " + this.Suffix.length());
                } else {
                    System.out.println("PrefixLen: " + this.PrefixLen + ", SuffixLen: " + this.SuffixLen);
                }
                System.out.println("Links to ...");
                MS2Edge Temp = this.ForwardIntrons;
                while (Temp != null) {
                    Temp.DebugPrint();
                    Temp = Temp.Next;
                }
                System.out.println("Links from ...");
                Temp = this.ReverseIntrons;
                while (Temp != null) {
                    Temp.DebugPrint();
                    Temp = Temp.Next;
                }
            }
        }

        public int compareTo(Object arg0) {
            MS2Exon Other = (MS2Exon)arg0;
            if (this == Other) {
                return 0;
            }
            if (this.SequenceName.compareTo(Other.SequenceName) < 0) {
                return -1;
            }
            if (this.SequenceName.compareTo(Other.SequenceName) > 0) {
                return 1;
            }
            if (this.Strand < Other.Strand) {
                return -1;
            }
            if (this.Strand > Other.Strand) {
                return 1;
            }
            if (this.Start < Other.Start) {
                return -1;
            }
            if (this.Start > Other.Start) {
                return 1;
            }
            if (this.End < Other.End) {
                return -1;
            }
            if (this.End > Other.End) {
                return 1;
            }
            if (this.ReadingFrame < Other.ReadingFrame) {
                return -1;
            }
            if (this.ReadingFrame > Other.ReadingFrame) {
                return 1;
            }
            return 0;
        }

        public void ExonInheritOneForwardEdge(MS2Edge OldEdge) {
            MS2Exon DisplacedExon = OldEdge.LinkFrom;
            MS2Exon LinkedExon = OldEdge.LinkTo;
            LinkedExon.RemoveBackwardEdge(DisplacedExon);
            this.LinkExonForward(LinkedExon);
        }

        public void ExonInheritOneBackwardEdge(MS2Edge OldEdge) {
            MS2Exon DisplacedExon = OldEdge.LinkFrom;
            MS2Exon LinkedExon = OldEdge.LinkTo;
            LinkedExon.RemoveForwardEdge(DisplacedExon);
            LinkedExon.LinkExonForward(this);
        }

        public void ExonInheritOneForwardEdgeDebug(MS2Edge OldEdge) {
            MS2Exon DisplacedExon = OldEdge.LinkFrom;
            MS2Exon LinkedExon = OldEdge.LinkTo;
            System.out.println("BEFORE:");
            System.out.println("DisplacedExon:");
            DisplacedExon.DebugPrint(true);
            System.out.println("LinkedToExon:");
            LinkedExon.DebugPrint(true);
            System.out.println("ThisExon:");
            this.DebugPrint(true);
            LinkedExon.RemoveBackwardEdge(DisplacedExon);
            DisplacedExon.RemoveForwardEdge(LinkedExon);
            this.LinkExonForward(LinkedExon);
            System.out.println("AFTER:");
            System.out.println("DisplacedExon:");
            DisplacedExon.DebugPrint(true);
            System.out.println("LinkedToExon:");
            LinkedExon.DebugPrint(true);
            System.out.println("ThisExon:");
            this.DebugPrint(true);
            Utils.WaitForEnter();
        }

        public void ExonInheritOneBackwardEdgeDebug(MS2Edge OldEdge) {
            MS2Exon DisplacedExon = OldEdge.LinkFrom;
            MS2Exon LinkedExon = OldEdge.LinkTo;
            System.out.println("BEFORE:");
            System.out.println("DisplacedExon:");
            DisplacedExon.DebugPrint(true);
            System.out.println("LinkedToExon:");
            LinkedExon.DebugPrint(true);
            System.out.println("ThisExon:");
            this.DebugPrint(true);
            DisplacedExon.RemoveBackwardEdge(LinkedExon);
            LinkedExon.RemoveForwardEdge(DisplacedExon);
            LinkedExon.LinkExonForward(this);
            System.out.println("AFTER:");
            System.out.println("DisplacedExon:");
            DisplacedExon.DebugPrint(true);
            System.out.println("LinkedToExon:");
            LinkedExon.DebugPrint(true);
            System.out.println("ThisExon:");
            this.DebugPrint(true);
            Utils.WaitForEnter();
        }

        public boolean HasBackwardEdge(MS2Exon LinkedExon) {
            MS2Edge Prev = null;
            MS2Edge Edge = this.ReverseIntrons;
            while (Edge != null) {
                if (Edge.LinkTo == LinkedExon) {
                    return true;
                }
                Prev = Edge;
                Edge = Edge.Next;
            }
            return false;
        }
    }

    public class MS2Gene {
        public ArrayList Exons = new ArrayList();
        public MS2Gene Next;
        public String SequenceName;
        public String GeneName = "Unknown";
        public int ForwardFlag = -1;
        public ArrayList CrossReferences = new ArrayList();
        public int GeneStart = -1;
        public int GeneEnd = -1;

        public void DebugPrint(boolean Full) {
            System.out.println("---MS2Gene " + this.GeneName + " on " + this.SequenceName + ", ForwardFlag: " + this.ForwardFlag);
            System.out.println("TotalExons: " + this.Exons.size());
            if (Full) {
                int i = 0;
                while (this.Exons != null && i < this.Exons.size()) {
                    ((MS2Exon)this.Exons.get(i)).DebugPrint(true);
                    ++i;
                }
                i = 0;
                while (i < this.CrossReferences.size()) {
                    ((MS2CrossReference)this.CrossReferences.get(i)).DebugPrint();
                    ++i;
                }
            }
        }

        public void AddExonToGene(MS2Exon Exon) {
            boolean LocalDebug = false;
            if (Exon.ParentGene != null) {
                if (LocalDebug) {
                    System.out.println("This exon already has a gene: " + Exon.ParentGene.GeneName);
                    Utils.WaitForEnter();
                }
                return;
            }
            if (this.ForwardFlag == -1) {
                this.ForwardFlag = Exon.Strand;
                if (LocalDebug) {
                    System.out.println("This gene now has a strand!!! = " + this.ForwardFlag);
                }
            }
            Exon.ParentGene = this;
            this.Exons.add(Exon);
            MS2Edge Edge = Exon.ForwardIntrons;
            while (Edge != null) {
                this.AddExonToGene(Edge.LinkTo);
                Edge = Edge.Next;
            }
            Edge = Exon.ReverseIntrons;
            while (Edge != null) {
                this.AddExonToGene(Edge.LinkTo);
                Edge = Edge.Next;
            }
            if (Exon.Start < this.GeneStart) {
                this.GeneStart = Exon.Start;
            }
            if (Exon.End > this.GeneEnd) {
                this.GeneEnd = Exon.End;
            }
        }

        public MS2Gene ShuffleGene() {
            MS2Exon CurrExon;
            boolean LocalDebug = false;
            MS2Gene Ret = new MS2Gene();
            Ret.GeneName = "XXX." + this.GeneName;
            Ret.ForwardFlag = 1 - this.ForwardFlag;
            Ret.SequenceName = this.SequenceName;
            int i = 0;
            while (i < this.Exons.size()) {
                CurrExon = (MS2Exon)this.Exons.get(i);
                Ret.Exons.add(new MS2Exon(CurrExon));
                if (LocalDebug) {
                    System.out.println("Adding this exon:");
                    ((MS2Exon)Ret.Exons.get(i)).DebugPrint(true);
                    Utils.WaitForEnter();
                }
                ++i;
            }
            i = 0;
            while (i < this.Exons.size()) {
                int Index;
                CurrExon = (MS2Exon)this.Exons.get(i);
                MS2Exon NewExon = (MS2Exon)Ret.Exons.get(i);
                NewExon.ParentGene = Ret;
                MS2Edge E = CurrExon.ForwardIntrons;
                while (E != null) {
                    Index = E.LinkTo.Index;
                    MS2Exon LinkToExon = (MS2Exon)Ret.Exons.get(Index);
                    if (E.SpecialAA != '\u0000') {
                        NewExon.LinkExonForward(LinkToExon, E.SpecialAA);
                    } else {
                        NewExon.LinkExonForward(LinkToExon);
                    }
                    if (LocalDebug) {
                        System.out.println("Adding forward link from " + i + " to " + Index);
                    }
                    E = E.Next;
                }
                E = CurrExon.ReverseIntrons;
                while (E != null) {
                    Index = E.LinkTo.Index;
                    MS2Exon LinkFromExon = (MS2Exon)Ret.Exons.get(Index);
                    if (E.SpecialAA != '\u0000') {
                        LinkFromExon.LinkExonForward(NewExon, E.SpecialAA);
                    } else {
                        LinkFromExon.LinkExonForward(NewExon);
                    }
                    if (LocalDebug) {
                        System.out.println("Adding reverse link from " + i + " to " + Index);
                    }
                    E = E.Next;
                }
                if (LocalDebug) {
                    Utils.WaitForEnter();
                }
                ++i;
            }
            return Ret;
        }

        public void RepairSingleExonCustomAAs() {
            int i = 0;
            while (i < this.Exons.size()) {
                block12: {
                    MS2Exon Exon;
                    block14: {
                        int Modulo;
                        block13: {
                            Exon = (MS2Exon)this.Exons.get(i);
                            if (Exon.End > Exon.Start + 1) break block12;
                            if (Exon.Strand != 1) break block13;
                            Modulo = Exon.Start % 3;
                            if ((Exon.ReadingFrame + 1) % 3 == Modulo) break block14;
                            break block12;
                        }
                        Modulo = (Exon.End - 1) % 3;
                        int test = Exon.ReadingFrame - 1;
                        if (test == -1) {
                            test = 2;
                        }
                        if (test % 3 != Modulo) break block12;
                    }
                    if (Exon.CustomAA == -1) {
                        int CodonValue;
                        String Codon = null;
                        String EncodeCodon = null;
                        String RCCodon = null;
                        MS2Edge BackwardEdge = Exon.ReverseIntrons;
                        MS2Edge ForwardEdge = Exon.ForwardIntrons;
                        if (Exon.Strand == 1) {
                            EncodeCodon = Codon = String.valueOf(BackwardEdge.LinkTo.Suffix) + Exon.Prefix + ForwardEdge.LinkTo.Prefix;
                        } else {
                            Codon = String.valueOf(ForwardEdge.LinkTo.Suffix) + Exon.Prefix + BackwardEdge.LinkTo.Prefix;
                            EncodeCodon = RCCodon = Utils.ReverseComplement(Codon);
                        }
                        if (EncodeCodon.length() > 3) {
                            System.out.println("THIS GUY HAS TOO MUCH GOING ON (Codon is size: " + EncodeCodon.length() + "!!");
                            Exon.DebugPrint(true);
                            System.out.println("BackLink:");
                            BackwardEdge.LinkTo.DebugPrint(true);
                            System.out.println("ForwardLink:");
                            ForwardEdge.LinkTo.DebugPrint(true);
                            Utils.WaitForEnter();
                        }
                        if (EncodeCodon.length() < 3) {
                            System.err.println("ERROR: Split codon has fewer than 3 letters!");
                            System.err.println("CODON: " + Codon);
                            System.err.println("RCCODON: " + RCCodon);
                            System.err.println("EncodeCODON: " + EncodeCodon);
                            System.out.println("Considering NextExon:");
                            BackwardEdge.LinkTo.DebugPrint(true);
                            System.out.println("And PrevExon:");
                            ForwardEdge.LinkTo.DebugPrint(true);
                            Utils.WaitForEnter();
                        }
                        if ((CodonValue = BuildMS2DB.GetCodonHashValue(EncodeCodon)) < 0 || CodonValue > 64) {
                            System.err.println("ERROR: Invalid codon hash value for " + EncodeCodon + " = " + CodonValue);
                        }
                        Exon.CustomAA = Utils.translateCodon(EncodeCodon.toCharArray(), 0);
                        Exon.MS2_EXON_CUSTOMAA = true;
                        MS2Edge Edge = null;
                        Edge = Exon.Strand == 1 ? Exon.ForwardIntrons : Exon.ReverseIntrons;
                        if (Edge != null && Edge.Next == null && (Edge.LinkFrom.Start == Edge.LinkTo.End || Edge.LinkFrom.End == Edge.LinkTo.Start)) {
                            Exon.MS2_EXON_CUSTOMAA_HEAD = true;
                        }
                    }
                }
                ++i;
            }
        }

        public void AddSingleExonToGene(MS2Exon Exon) {
            boolean LocalDebug = false;
            if (Exon.ParentGene != null) {
                if (LocalDebug) {
                    System.out.println("This exon already has a gene: " + Exon.ParentGene.GeneName);
                    Utils.WaitForEnter();
                }
                return;
            }
            if (this.ForwardFlag == -1) {
                this.ForwardFlag = Exon.Strand;
                if (LocalDebug) {
                    System.out.println("This gene now has a strand!!! = " + this.ForwardFlag);
                }
            }
            Exon.ParentGene = this;
            this.Exons.add(Exon);
            if (Exon.Start < this.GeneStart) {
                this.GeneStart = Exon.Start;
            }
            if (Exon.End > this.GeneEnd) {
                this.GeneEnd = Exon.End;
            }
        }
    }
}

