/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class PlotTargetDecoyScoreCurve {
    public static String UsageInfo = "basicUtils.PlotTargetDecoyScoreCurve version 09032010\nCreates a png file of the distributions of decoy and target PSMs.  Only the best 2 peptides per spectrum are plotted\n[REQUIRED]n -r [FILE/DIR] Directory containing Inspect results with decoy matches\n -w [FILE] Output file to write image to\n -s [0/1] 0: use FScore, 1: use Spectral Probability\n";
    private String[] InputFiles;
    private String OutputFile;
    private boolean Debug = false;
    private int InspectColumn = -1;

    public PlotTargetDecoyScoreCurve(String InputDir, String OutputFile, int ScoreVal) {
        if (Utils.IsFile(InputDir)) {
            this.InputFiles = new String[1];
            this.InputFiles[0] = InputDir;
        } else if (Utils.IsDir(InputDir)) {
            this.InputFiles = Utils.ListDir(InputDir);
        } else {
            System.err.println("ERROR: Invalid input file or directory '" + InputDir + "'!");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
        this.OutputFile = OutputFile;
        if (ScoreVal == 0) {
            this.InspectColumn = InspectAnnotation.InspectColumns.FScore;
        } else if (ScoreVal == 1) {
            this.InspectColumn = InspectAnnotation.InspectColumns.SpecProb;
        } else {
            System.err.println("ERROR: Invalid score type '" + ScoreVal + "'!");
            System.err.println(UsageInfo);
            System.exit(-1);
        }
    }

    public void GenerateHistogram() {
        ArrayList<Double> TrueScores = new ArrayList<Double>();
        ArrayList<Double> FalseScores = new ArrayList<Double>();
        int i = 0;
        while (i < this.InputFiles.length) {
            System.out.println("Loading results from " + this.InputFiles[i]);
            Hashtable ScoreHash = InspectAnnotation.LoadInspectScoresTwoVotes(this.InputFiles[i], this.InspectColumn);
            Object[] Scores = ScoreHash.values().toArray();
            int j = 0;
            while (j < Scores.length) {
                double[] CurrScores = (double[])Scores[j];
                if (CurrScores[0] != Double.NEGATIVE_INFINITY && CurrScores[0] != Double.POSITIVE_INFINITY) {
                    if (this.InspectColumn == InspectAnnotation.InspectColumns.SpecProb) {
                        TrueScores.add(new Double(-1.0 * Math.log(CurrScores[0])));
                    } else {
                        TrueScores.add(new Double(CurrScores[0]));
                    }
                }
                if (CurrScores[1] != Double.NEGATIVE_INFINITY && CurrScores[1] != Double.POSITIVE_INFINITY) {
                    if (this.InspectColumn == InspectAnnotation.InspectColumns.SpecProb) {
                        FalseScores.add(new Double(-1.0 * Math.log(CurrScores[1])));
                    } else {
                        FalseScores.add(new Double(CurrScores[1]));
                    }
                }
                ++j;
            }
            ++i;
        }
        HistogramDataset ScoreHisto = new HistogramDataset();
        ScoreHisto.addSeries((Comparable)((Object)"IncorrectLabels"), Utils.ConvertArraylistToDoubleArray(FalseScores), 200);
        ScoreHisto.addSeries((Comparable)((Object)"CorrectLabels"), Utils.ConvertArraylistToDoubleArray(TrueScores), 200);
        JFreeChart Chart = ChartFactory.createHistogram((String)("Score Histogram(" + TrueScores.size() + " True, " + FalseScores.size() + " False)"), (String)"Score", (String)"Counts", (IntervalXYDataset)ScoreHisto, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        BufferedImage Image2 = Chart.createBufferedImage(1000, 1000);
        String ScoreFileName = this.OutputFile;
        System.out.println("Created histo..." + ScoreFileName);
        try {
            ImageIO.write((RenderedImage)Image2, "png", new File(ScoreFileName));
        }
        catch (Exception E) {
            System.err.println(E.getMessage());
            return;
        }
    }

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-s"};
        boolean[] values = new boolean[]{true, true, true};
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-s"))) {
            System.err.println("ERROR: Must specify an input file or directory, output file, and score type!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String InputDir = (String)CommandLineArgs.get("-r");
        String OutputFile = (String)CommandLineArgs.get("-w");
        int ScoreVal = Integer.parseInt((String)CommandLineArgs.get("-s"));
        PlotTargetDecoyScoreCurve p = new PlotTargetDecoyScoreCurve(InputDir, OutputFile, ScoreVal);
        p.GenerateHistogram();
    }
}

