/*
 * Decompiled with CFR 0.152.
 */
package ms2dbUtils;

import basicUtils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import ms2dbUtils.MS2DB;

public class MS2DBShuffler {
    public static final String UsageInfo = "sixFrameUtils.SixFrameBuilder\nPerforms analagous behavior to 'PrepDB.py' and 'ShuffleDB.py' for Splice Graphs.  Given a splice graph as input,\nMS2DBShuffler first creates a new database which is half shuffled half true proteins, and then creates the .index\nfile necessary for Inspect to search the data.\nOptions:\n -r [FILE] Splice graph (.ms2db) produced by ms2dbUtils.BuildMS2DB.java\n -w [FILE] The splice graph with decoy entries added.  A corresponding .index file is made with the same basename\n -u Unshuffle the DB (removing scrambled genes)";

    public static void main(String[] args) {
        String[] options = new String[]{"-r", "-w", "-u"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLineMulti(args, options, values);
        if (!CommandLineArgs.containsKey("-r")) {
            System.err.println("ERROR: You must specify an input file");
            System.out.println(UsageInfo);
            return;
        }
        ArrayList Temp = (ArrayList)CommandLineArgs.get("-r");
        String InputFile = (String)Temp.get(0);
        File Test = new File(InputFile);
        if (!Test.exists()) {
            System.err.println("ERROR: Specified file " + InputFile + " does not exist!");
            System.exit(1);
        }
        if (!CommandLineArgs.containsKey("-w")) {
            System.err.println("ERROR: You must specify at an output file");
            System.out.println(UsageInfo);
            return;
        }
        Temp = (ArrayList)CommandLineArgs.get("-w");
        String OutputFile = (String)Temp.get(0);
        boolean shuffle = true;
        if (CommandLineArgs.containsKey("-u")) {
            shuffle = false;
        }
        MS2DB Tester = new MS2DB(InputFile);
        String OtherDB = OutputFile;
        if (shuffle) {
            Tester.ShuffleMS2DB(OtherDB);
            System.out.println("Created shuffled Splice Graph: " + OtherDB);
        } else {
            Tester.UnShuffleMS2DB(OtherDB);
            System.out.println("Created unshuffled Splice Graph: " + OtherDB);
        }
        Tester = new MS2DB(OtherDB);
        String IndexFile = Tester.CreateIndex();
        System.out.println("Created index file: " + IndexFile);
    }
}

