/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class PValue {
    public static final int MSGF = 0;
    public static final int FScore = 1;
    public static final int MinLength = 7;
    public static final int MinSpectraPerLocalBlock = 100;
    public static final double MinBlockWidthMSGF = 1.0E-12;
    public static final double MinBlockWidthFScore = 0.2;
    public static final String UsageInfo = "basicUtils.PValue, version 10.10.2011\nEvaluates and applies an e-value or FDR cutoff using spectrum probabilities.  Expects MSGF to\nhave already been run on the file.  If FDR cutoff is used, then decoy hits must be present\n[Required]\n-r [FILE] Input file that has been run through MSGF\n-w [FILE] Output file to write filtered results\n-a [0/1] Perform an EValue (0) or FDR (1) cutoff\n-p [NUM] EValue or pvalue cutoff\n[Optional]\n-t [FILE] The searched trie file, if using EValue cutoff (default 10Mb)\n-s [0/1] Score mode (0: use MSGF, 1: usage FScore (default))\n-l Compute local FDR for each PSM\n-q Compute peptideFDR instead of psmFDR\n-m [NUM] Max missed cleavages permitted in a reported peptide\n-H report the decoy matches as well.  The FDR of a decoy match is the same as teh FDR for a target match with the same score\n";

    public static void PerformEValueCutoff(String InputFile, String OutputFile, double EValueCutOff, int ScoreMode, String SearchDB) {
        if (SearchDB != null) {
            File Temp = new File(SearchDB);
            PValue.PerformEValueCutoff(InputFile, OutputFile, EValueCutOff, ScoreMode, Temp.length());
        } else {
            PValue.PerformEValueCutoff(InputFile, OutputFile, EValueCutOff, ScoreMode, 10000000L);
        }
    }

    public static void PerformEValueCutoff(String InputFile, String OutputFile, double EValueCutOff, int ScoreMode, long DBSize) {
        if (ScoreMode != 0) {
            System.err.println("ERROR: Cannot perform EValue cutoff when not using Spectral Probabilities");
            return;
        }
        boolean LocalDebug = false;
        System.out.println("Loading results from : " + InputFile);
        InspectAnnotation[] RawAnns = InspectAnnotation.LoadInspectResultsFile(InputFile);
        System.out.println("Loaded " + RawAnns.length + " Inspect results");
        InspectAnnotation[] SortedAnns = PValue.SortIncreasingOrder(RawAnns, ScoreMode);
        System.out.println("Sorted...");
        FileWriter Writer2 = null;
        try {
            Writer2 = new FileWriter(OutputFile);
            Writer2.write(InspectAnnotation.HeaderLine);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        Hashtable<String[], Integer> ScansSeen = new Hashtable<String[], Integer>();
        int i = 0;
        while (i < SortedAnns.length) {
            String[] CurrScan = new String[]{Utils.GetBaseName(SortedAnns[i].SpectrumFile), "" + SortedAnns[i].ScanNumber};
            if (!ScansSeen.containsKey(CurrScan)) {
                if (Utils.IsDecoyProtein(SortedAnns[i].ProteinName)) {
                    ScansSeen.put(CurrScan, new Integer(1));
                } else {
                    double EValue = (double)DBSize * SortedAnns[i].SpecProb;
                    if (LocalDebug) {
                        System.out.println("Elibible spectrum-peptide match for evalueing");
                        SortedAnns[i].DebugPrint();
                        System.out.println("Evalue: " + EValue);
                    }
                    if (EValue < EValueCutOff) {
                        if (LocalDebug) {
                            System.out.println("This is good enough for reporting!!");
                            Utils.WaitForEnter();
                        }
                        try {
                            Writer2.write(String.valueOf(SortedAnns[i].toString()) + "\n");
                        }
                        catch (IOException E) {
                            E.printStackTrace();
                        }
                    }
                    ScansSeen.put(CurrScan, new Integer(1));
                }
            }
            ++i;
        }
        try {
            Writer2.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    public static void PerformPValueCutoffWithDecoys(String InputFile, String OutputFile, double PValueCutOff, int ScoreMode, boolean ComputeLocalFDR, boolean ComputePeptideFDR, boolean ReportFalse, int MaxCleavages) {
        System.out.println("Loading results from : " + InputFile);
        InspectAnnotation[] RawAnns = null;
        if (ScoreMode == 0) {
            RawAnns = InspectAnnotation.LoadInspectResultsFileIncreasingOrderTwoVotes(InputFile, InspectAnnotation.InspectColumns.SpecProb);
        } else if (ScoreMode == 1) {
            RawAnns = InspectAnnotation.LoadInspectResultsFileDecreasingOrderTwoVotes(InputFile, InspectAnnotation.InspectColumns.FScore);
        } else {
            System.err.println("ERROR: Sorry score modes besides MSGF and FScore are not currently supported!");
            System.exit(-1);
        }
        System.out.println("Loaded " + RawAnns.length + " Inspect results");
        if (ComputeLocalFDR || ComputePeptideFDR) {
            RawAnns = PValue.ComputeLocalFDR(RawAnns, ScoreMode);
        }
        if (RawAnns.length < 100) {
            System.err.println("WARNING: Fewer than 100 PSMs to compute FDR, calculations may be erroneous!");
        }
        InspectAnnotation[] FilteredAnns = null;
        FilteredAnns = ComputePeptideFDR && ComputeLocalFDR ? PValue.ApplyLocalPeptideCutOff(RawAnns, PValueCutOff, ScoreMode, ReportFalse) : (ComputePeptideFDR ? PValue.ApplyPeptideCutOff(RawAnns, PValueCutOff, ScoreMode, ReportFalse) : PValue.ApplyQValueCutOff(RawAnns, PValueCutOff, ScoreMode, ReportFalse));
        if (ComputePeptideFDR) {
            FilteredAnns = PValue.ComputeDerivedPeptideLFDR(FilteredAnns);
        }
        FileWriter Writer2 = null;
        try {
            Writer2 = new FileWriter(OutputFile);
            Writer2.write(InspectAnnotation.SplicedHeaderLine);
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        int i = 0;
        while (i < FilteredAnns.length) {
            try {
                if (Utils.CountMissedCleavages(FilteredAnns[i].Annotation) <= MaxCleavages) {
                    Writer2.write(String.valueOf(FilteredAnns[i].toString()) + "\n");
                }
            }
            catch (IOException E) {
                E.printStackTrace();
            }
            ++i;
        }
        try {
            Writer2.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    private static InspectAnnotation[] ApplyQValueCutOff(InspectAnnotation[] SortedAnns, double fdrCutOff, int scoreMode, boolean reportFalse) {
        Hashtable<Double, Double> fdr = new Hashtable<Double, Double>();
        ArrayList<InspectAnnotation> finalList = new ArrayList<InspectAnnotation>();
        int Charge = 1;
        while (Charge < 4) {
            System.out.println("Considering charge state: " + Charge);
            int cumTrue = 0;
            int cumFalse = 0;
            int Count = 0;
            int i = 0;
            while (i < SortedAnns.length) {
                if (SortedAnns[i].Charge == Charge) {
                    double Score = PValue.GetScore(SortedAnns[i], scoreMode);
                    if (Utils.IsDecoyProtein(SortedAnns[i].ProteinName)) {
                        ++cumFalse;
                    } else {
                        ++cumTrue;
                    }
                    double currFDR = (double)cumFalse / (double)cumTrue;
                    fdr.put(new Double(Score), new Double(currFDR));
                    ++Count;
                }
                ++i;
            }
            System.out.println("At charge state " + Charge + " we found " + Count + " PSMs");
            double minFDR = 1.0;
            boolean found = false;
            int i2 = SortedAnns.length - 1;
            while (i2 >= 0) {
                if (SortedAnns[i2].Charge == Charge) {
                    double Score = PValue.GetScore(SortedAnns[i2], scoreMode);
                    double currFDR = (Double)fdr.get(new Double(Score));
                    if (currFDR < minFDR) {
                        minFDR = currFDR;
                    }
                    if (minFDR == 0.0) {
                        minFDR = 1.0E-4;
                    }
                    SortedAnns[i2].FDR = minFDR;
                    if (minFDR < fdrCutOff) {
                        if (!found) {
                            System.out.println("Score cutoff: " + Score);
                            found = true;
                        }
                        finalList.add(0, SortedAnns[i2]);
                    }
                }
                --i2;
            }
            ++Charge;
        }
        System.out.println("Accepted " + finalList.size() + " PSMs");
        return InspectAnnotation.ArrayListToList(finalList);
    }

    private static InspectAnnotation[] ApplyLocalPeptideCutOff(InspectAnnotation[] rawAnns, double valueCutOff, int scoreMode, boolean reportFalse) {
        System.out.println("Computing local peptide FDR!!");
        Hashtable<String, Integer> SeenPeptides = new Hashtable<String, Integer>();
        int BlockSize = 0;
        int TrueLocalCount = 0;
        int FalseLocalCount = 0;
        double BlockEndScore = -1.0;
        int BlockEndIndex = -1;
        ArrayList<InspectAnnotation> Ret = new ArrayList<InspectAnnotation>();
        int TotalTrueCount = 0;
        boolean LocalDebug = false;
        int i = 0;
        while (i < rawAnns.length) {
            String CurrPeptide = rawAnns[i].Annotation;
            if (CurrPeptide.indexOf(".") >= 0) {
                CurrPeptide = CurrPeptide.substring(2, CurrPeptide.length() - 2);
            }
            if (!SeenPeptides.containsKey(CurrPeptide)) {
                InspectAnnotation newAnn;
                int j;
                double LFDR;
                SeenPeptides.put(CurrPeptide, new Integer(1));
                double Score = PValue.GetScore(rawAnns[i], scoreMode);
                boolean isFalseID = false;
                if (Utils.IsDecoyProtein(rawAnns[i].ProteinName)) {
                    isFalseID = true;
                }
                if (LocalDebug) {
                    System.out.println("Considering New Ann: " + rawAnns[i].toString());
                    System.out.println("Score: " + Score + ", IsFalseID: " + isFalseID);
                }
                if (BlockEndScore == -1.0) {
                    Ret.add(rawAnns[i]);
                    BlockEndScore = Score;
                    BlockEndIndex = Ret.size() - 1;
                    ++BlockSize;
                    if (isFalseID) {
                        ++FalseLocalCount;
                    } else {
                        ++TrueLocalCount;
                    }
                    if (LocalDebug) {
                        System.out.println("First of the first block!");
                        System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                        System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                        Utils.WaitForEnter();
                    }
                } else if (i == rawAnns.length - 1) {
                    Ret.add(rawAnns[i]);
                    if (isFalseID) {
                        ++FalseLocalCount;
                    } else {
                        ++TrueLocalCount;
                    }
                    LFDR = Math.min(1.0, (double)FalseLocalCount / (double)TrueLocalCount);
                    if (LFDR == 0.0) {
                        LFDR = 1.0 / (double)TrueLocalCount;
                    }
                    j = Ret.size() - 1;
                    while (j >= BlockEndIndex) {
                        newAnn = (InspectAnnotation)Ret.remove(j);
                        newAnn.FDR = LFDR;
                        if (newAnn.FDR <= valueCutOff && !Utils.IsDecoyProtein(newAnn.ProteinName)) {
                            ++TotalTrueCount;
                        }
                        Ret.add(j, newAnn);
                        --j;
                    }
                    if (LocalDebug) {
                        System.out.println("Last of the last block!");
                        System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                        System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                        System.out.println("LFDR: " + LFDR);
                        Utils.WaitForEnter();
                    }
                } else if (scoreMode == 0) {
                    if (Score > BlockEndScore - 1.0E-12 || BlockSize < 100) {
                        Ret.add(rawAnns[i]);
                        if (isFalseID) {
                            ++FalseLocalCount;
                        } else {
                            ++TrueLocalCount;
                        }
                        ++BlockSize;
                        if (LocalDebug) {
                            System.out.println("Continuing the block!");
                            System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                            System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                        }
                    } else {
                        LFDR = Math.min(1.0, (double)FalseLocalCount / (double)TrueLocalCount);
                        if (LFDR == 0.0) {
                            LFDR = 1.0 / (double)TrueLocalCount;
                        }
                        j = Ret.size() - 1;
                        while (j >= BlockEndIndex) {
                            newAnn = (InspectAnnotation)Ret.remove(j);
                            newAnn.FDR = LFDR;
                            if (newAnn.FDR <= valueCutOff && !Utils.IsDecoyProtein(newAnn.ProteinName)) {
                                ++TotalTrueCount;
                            }
                            Ret.add(j, newAnn);
                            --j;
                        }
                        if (LocalDebug) {
                            System.out.println("Last of the old block!");
                            System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                            System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                            System.out.println("LFDR: " + LFDR);
                            Utils.WaitForEnter();
                        }
                        Ret.add(rawAnns[i]);
                        BlockEndScore = Score;
                        BlockEndIndex = Ret.size() - 1;
                        BlockSize = 1;
                        FalseLocalCount = 0;
                        TrueLocalCount = 0;
                        if (isFalseID) {
                            ++FalseLocalCount;
                        } else {
                            ++TrueLocalCount;
                        }
                        if (LocalDebug) {
                            System.out.println("First of the next block!");
                            System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                            System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                            Utils.WaitForEnter();
                        }
                    }
                } else if (scoreMode == 1) {
                    if (Score > BlockEndScore - 0.2 || BlockSize < 100) {
                        Ret.add(rawAnns[i]);
                        if (isFalseID) {
                            ++FalseLocalCount;
                        } else {
                            ++TrueLocalCount;
                        }
                        ++BlockSize;
                    } else {
                        LFDR = Math.min(1.0, (double)FalseLocalCount / (double)TrueLocalCount);
                        if (LFDR == 0.0) {
                            LFDR = 1.0 / (double)TrueLocalCount;
                        }
                        j = Ret.size() - 1;
                        while (j >= BlockEndIndex) {
                            newAnn = (InspectAnnotation)Ret.remove(j);
                            newAnn.FDR = LFDR;
                            if (newAnn.FDR <= valueCutOff && !Utils.IsDecoyProtein(newAnn.ProteinName)) {
                                ++TotalTrueCount;
                            }
                            Ret.add(j, newAnn);
                            --j;
                        }
                        Ret.add(rawAnns[i]);
                        BlockEndScore = Score;
                        BlockEndIndex = Ret.size() - 1;
                        BlockSize = 1;
                        FalseLocalCount = 0;
                        TrueLocalCount = 0;
                        if (isFalseID) {
                            ++FalseLocalCount;
                        } else {
                            ++TrueLocalCount;
                        }
                    }
                }
            }
            ++i;
        }
        System.out.println("Total true count: " + TotalTrueCount);
        InspectAnnotation[] FilteredAnns = new InspectAnnotation[TotalTrueCount];
        int Index = 0;
        int i2 = 0;
        while (i2 < Ret.size()) {
            InspectAnnotation currAnn = (InspectAnnotation)Ret.get(i2);
            if (currAnn.FDR <= valueCutOff && !Utils.IsDecoyProtein(currAnn.ProteinName)) {
                FilteredAnns[Index] = currAnn;
                ++Index;
            }
            ++i2;
        }
        System.out.println("Final index val: " + Index);
        return FilteredAnns;
    }

    private static InspectAnnotation[] ComputeDerivedPeptideLFDR(InspectAnnotation[] FilteredAnns) {
        double OldScore;
        Hashtable<String, Double> PeptideScores = new Hashtable<String, Double>();
        int i = 0;
        while (i < FilteredAnns.length) {
            if (!PeptideScores.containsKey(FilteredAnns[i].Annotation)) {
                PeptideScores.put(FilteredAnns[i].Annotation, new Double(FilteredAnns[i].LocalFDR));
            } else {
                OldScore = (Double)PeptideScores.get(FilteredAnns[i].Annotation);
                if (FilteredAnns[i].LocalFDR < OldScore) {
                    PeptideScores.put(FilteredAnns[i].Annotation, new Double(FilteredAnns[i].LocalFDR));
                }
            }
            ++i;
        }
        i = 0;
        while (i < FilteredAnns.length) {
            FilteredAnns[i].LocalFDR = OldScore = ((Double)PeptideScores.get(FilteredAnns[i].Annotation)).doubleValue();
            ++i;
        }
        return FilteredAnns;
    }

    private static InspectAnnotation[] ComputeLocalFDR(InspectAnnotation[] SortedAnns, int ScoreMode) {
        boolean LocalDebug = false;
        int Charge = 1;
        while (Charge < 4) {
            System.out.println("LocalFDR, Considering charge state: " + Charge);
            int BlockSize = 0;
            int TrueLocalCount = 0;
            int FalseLocalCount = 0;
            double BlockEndScore = -1.0;
            int BlockEndIndex = -1;
            boolean Count = false;
            if (LocalDebug) {
                System.out.println("Anns: " + SortedAnns.length);
            }
            int i = 0;
            while (i < SortedAnns.length) {
                if (SortedAnns[i].Charge == Charge) {
                    int j;
                    double LFDR;
                    double Score = PValue.GetScore(SortedAnns[i], ScoreMode);
                    boolean isFalseID = false;
                    if (Utils.IsDecoyProtein(SortedAnns[i].ProteinName)) {
                        isFalseID = true;
                    }
                    if (LocalDebug) {
                        System.out.println("Considering New Ann: " + SortedAnns[i].toString());
                        System.out.println("Score: " + Score + ", IsFalseID: " + isFalseID);
                    }
                    if (BlockEndScore == -1.0) {
                        BlockEndScore = Score;
                        BlockEndIndex = i;
                        ++BlockSize;
                        if (isFalseID) {
                            ++FalseLocalCount;
                        } else {
                            ++TrueLocalCount;
                        }
                        if (LocalDebug) {
                            System.out.println("First of the first block!");
                            System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                            System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                            System.out.println("Min BlockStart = " + (BlockEndScore + 1.0E-12));
                            System.out.println("Block Width=1.0E-12");
                            Utils.WaitForEnter();
                        }
                    } else if (ScoreMode == 0) {
                        if (Score < BlockEndScore + 1.0E-12 || BlockSize < 100) {
                            if (isFalseID) {
                                ++FalseLocalCount;
                            } else {
                                ++TrueLocalCount;
                            }
                            ++BlockSize;
                            if (LocalDebug) {
                                System.out.println("Continuing the block!");
                                System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                                System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                                Utils.WaitForEnter();
                            }
                        } else {
                            FalseLocalCount = Math.max(FalseLocalCount, 1);
                            LFDR = Math.min(1.0, (double)FalseLocalCount / (double)TrueLocalCount);
                            j = i - 1;
                            while (j >= BlockEndIndex) {
                                if (SortedAnns[j].Charge == Charge) {
                                    SortedAnns[j].LocalFDR = LFDR;
                                    if (LFDR < 0.0) {
                                        System.out.println("ERROR: LocalFDR is " + LFDR);
                                        SortedAnns[j].toString();
                                        Utils.WaitForEnter();
                                    }
                                }
                                --j;
                            }
                            if (LocalDebug) {
                                System.out.println("Last of the old block!");
                                System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + BlockEndIndex);
                                System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                                System.out.println("LFDR: " + LFDR);
                            }
                            BlockEndScore = Score;
                            BlockEndIndex = i;
                            BlockSize = 1;
                            FalseLocalCount = 0;
                            TrueLocalCount = 0;
                            if (isFalseID) {
                                ++FalseLocalCount;
                            } else {
                                ++TrueLocalCount;
                            }
                            if (LocalDebug) {
                                System.out.println("First of the next block!");
                                System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + i);
                                System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                                Utils.WaitForEnter();
                            }
                        }
                    } else if (ScoreMode == 1) {
                        if (Score > BlockEndScore - 0.2 || BlockSize < 100) {
                            if (isFalseID) {
                                ++FalseLocalCount;
                            } else {
                                ++TrueLocalCount;
                            }
                            ++BlockSize;
                        } else {
                            FalseLocalCount = Math.max(FalseLocalCount, 1);
                            LFDR = Math.min(1.0, (double)FalseLocalCount / (double)TrueLocalCount);
                            j = i - 1;
                            while (j >= BlockEndIndex) {
                                if (SortedAnns[j].Charge == Charge) {
                                    SortedAnns[j].LocalFDR = LFDR;
                                    if (LFDR < 0.0) {
                                        System.out.println("ERROR: LocalFDR is " + LFDR);
                                        SortedAnns[j].toString();
                                        Utils.WaitForEnter();
                                    }
                                }
                                --j;
                            }
                            BlockEndScore = Score;
                            BlockEndIndex = i;
                            BlockSize = 1;
                            FalseLocalCount = 0;
                            TrueLocalCount = 0;
                            if (isFalseID) {
                                ++FalseLocalCount;
                            } else {
                                ++TrueLocalCount;
                            }
                        }
                    }
                }
                ++i;
            }
            FalseLocalCount = Math.max(FalseLocalCount, 1);
            double LFDR = Math.min(1.0, (double)FalseLocalCount / (double)TrueLocalCount);
            int j = SortedAnns.length - 1;
            while (j >= Math.max(0, BlockEndIndex)) {
                if (SortedAnns[j].Charge == Charge) {
                    if (LFDR < 0.0) {
                        System.out.println("ERROR: LocalFDR is " + LFDR);
                        SortedAnns[j].toString();
                        Utils.WaitForEnter();
                    }
                    SortedAnns[j].LocalFDR = LFDR;
                }
                --j;
            }
            if (LocalDebug) {
                System.out.println("Last of the last block!");
                System.out.println("BlockEndScore: " + BlockEndScore + ", BlockEndIndex: " + (SortedAnns.length - 1));
                System.out.println("Total in Block: " + BlockSize + ", True: " + TrueLocalCount + ", False: " + FalseLocalCount);
                System.out.println("LFDR: " + LFDR);
                Utils.WaitForEnter();
            }
            ++Charge;
        }
        return SortedAnns;
    }

    private static InspectAnnotation[] ApplyCutOff(InspectAnnotation[] SortedAnns, double PValueCutOff, int ScoreMode, boolean ReportFalse) {
        ArrayList<InspectAnnotation> FilteredResults = new ArrayList<InspectAnnotation>();
        Hashtable<Double, int[]> ScoreCounts = new Hashtable<Double, int[]>();
        boolean LocalDebug = false;
        int Charge = 1;
        while (Charge < 4) {
            System.out.println("Considering charge state: " + Charge);
            ScoreCounts.clear();
            LocalDebug = false;
            int Count = 0;
            int i = 0;
            while (i < SortedAnns.length) {
                if (SortedAnns[i].Charge == Charge) {
                    double Score = PValue.GetScore(SortedAnns[i], ScoreMode);
                    if (LocalDebug) {
                        System.out.println("Considering New Ann: " + SortedAnns[i].toString());
                        System.out.println("Score: " + Score);
                    }
                    int[] Counts = null;
                    if (ScoreCounts.containsKey(new Double(Score))) {
                        if (LocalDebug) {
                            System.out.println("We've seen this score before!!");
                        }
                        Counts = (int[])ScoreCounts.get(new Double(Score));
                    } else {
                        if (LocalDebug) {
                            System.out.println("This is the first time we've seen this score!");
                        }
                        Counts = new int[]{0, 0};
                    }
                    if (Utils.IsDecoyProtein(SortedAnns[i].ProteinName)) {
                        if (LocalDebug) {
                            System.out.println("FALSE PROTEIN!!");
                        }
                        Counts[1] = Counts[1] + 1;
                    } else {
                        if (LocalDebug) {
                            System.out.println("TRUE PROTEIN!");
                        }
                        Counts[0] = Counts[0] + 1;
                    }
                    ScoreCounts.put(new Double(Score), Counts);
                    ++Count;
                }
                ++i;
            }
            System.out.println("At charge state " + Charge + " we found " + Count + " PSMs");
            Hashtable<String, Integer> ScansSeen = new Hashtable<String, Integer>();
            Hashtable<String, Integer> DecoyScansSeen = new Hashtable<String, Integer>();
            double WorstFPR = Double.MIN_VALUE;
            if (ScoreMode == 1) {
                WorstFPR = Double.MAX_VALUE;
            }
            int CumTrue = 0;
            int CumFalse = 0;
            int Kept = 0;
            LocalDebug = false;
            int i2 = 0;
            while (i2 < SortedAnns.length) {
                if (SortedAnns[i2].Charge == Charge) {
                    boolean IsDecoy;
                    String CurrScan = String.valueOf(Utils.GetBaseName(SortedAnns[i2].SpectrumFile)) + "_" + SortedAnns[i2].ScanNumber;
                    if (!(!ReportFalse && (ScansSeen.containsKey(CurrScan) || DecoyScansSeen.containsKey(CurrScan)) || (IsDecoy = Utils.IsDecoyProtein(SortedAnns[i2].ProteinName)) && DecoyScansSeen.containsKey(CurrScan) || !IsDecoy && ScansSeen.containsKey(CurrScan))) {
                        if (IsDecoy) {
                            DecoyScansSeen.put(CurrScan, new Integer(1));
                        } else {
                            ScansSeen.put(CurrScan, new Integer(1));
                        }
                        double Score = PValue.GetScore(SortedAnns[i2], ScoreMode);
                        int[] Counts = (int[])ScoreCounts.get(new Double(Score));
                        CumTrue += Counts[0];
                        CumFalse += Counts[1];
                        if ((!IsDecoy || ReportFalse) && SortedAnns[i2].Length >= 7) {
                            SortedAnns[i2].FDR = Math.max(1.0E-4, (double)CumFalse / (double)CumTrue);
                            if (LocalDebug) {
                                System.out.println("For SpecProb of : " + Score);
                                System.out.println("TrueCounts = " + Counts[0]);
                                System.out.println("FalseCounts = " + Counts[1]);
                                System.out.println("CumTrue = " + CumTrue);
                                System.out.println("CumFalse = " + CumFalse);
                                System.out.println("FDR: " + SortedAnns[i2].FDR);
                            }
                            if (SortedAnns[i2].FDR <= PValueCutOff) {
                                if (LocalDebug) {
                                    System.out.println("For Score: " + Score + ", FDR: " + SortedAnns[i2].FDR);
                                    SortedAnns[i2].DebugPrint();
                                    System.out.println("KEEPING IT!");
                                    Utils.WaitForEnter();
                                }
                                ++Kept;
                                if (ScoreMode == 0 && SortedAnns[i2].SpecProb > WorstFPR) {
                                    WorstFPR = SortedAnns[i2].SpecProb;
                                } else if (ScoreMode == 1 && SortedAnns[i2].FScore < WorstFPR) {
                                    WorstFPR = SortedAnns[i2].FScore;
                                }
                                FilteredResults.add(SortedAnns[i2]);
                            }
                        }
                    }
                }
                ++i2;
            }
            System.out.println("Total for ChargeState: " + (CumTrue + CumFalse));
            System.out.println("Kept: " + Kept);
            System.out.println("Score Cutoff: " + WorstFPR);
            if (LocalDebug) {
                Utils.WaitForEnter();
            }
            ++Charge;
        }
        return InspectAnnotation.ArrayListToList(FilteredResults);
    }

    private static InspectAnnotation[] ApplyPeptideCutOff(InspectAnnotation[] SortedAnns, double PValueCutOff, int ScoreMode, boolean ReportFalse) {
        ArrayList<InspectAnnotation> FilteredResults = new ArrayList<InspectAnnotation>();
        Hashtable<Double, int[]> ScoreCounts = new Hashtable<Double, int[]>();
        boolean LocalDebug = false;
        Hashtable<String, Number> PeptidesSeen = new Hashtable<String, Number>();
        boolean Count = false;
        int i = 0;
        while (i < SortedAnns.length) {
            if (!PeptidesSeen.containsKey(SortedAnns[i].Annotation)) {
                double Score = PValue.GetScore(SortedAnns[i], ScoreMode);
                if (LocalDebug) {
                    System.out.println("Considering New Ann: " + SortedAnns[i].toString());
                    System.out.println("Score: " + Score);
                }
                int[] Counts = null;
                if (ScoreCounts.containsKey(new Double(Score))) {
                    if (LocalDebug) {
                        System.out.println("We've seen this score before!!");
                    }
                    Counts = (int[])ScoreCounts.get(new Double(Score));
                } else {
                    if (LocalDebug) {
                        System.out.println("This is the first time we've seen this score!");
                    }
                    Counts = new int[]{0, 0};
                }
                if (Utils.IsDecoyProtein(SortedAnns[i].ProteinName)) {
                    if (LocalDebug) {
                        System.out.println("FALSE PROTEIN!!");
                    }
                    Counts[1] = Counts[1] + 1;
                } else {
                    if (LocalDebug) {
                        System.out.println("TRUE PROTEIN!");
                    }
                    Counts[0] = Counts[0] + 1;
                }
                ScoreCounts.put(new Double(Score), Counts);
                if (LocalDebug) {
                    System.out.println("Score : " + Counts[0] + " true, " + Counts[1] + " false");
                }
                PeptidesSeen.put(SortedAnns[i].Annotation, new Integer(1));
            }
            ++i;
        }
        Hashtable<String, Integer> ScansSeen = new Hashtable<String, Integer>();
        Hashtable<String, Integer> DecoyScansSeen = new Hashtable<String, Integer>();
        double WorstFPR = Double.MIN_VALUE;
        LocalDebug = false;
        int CumTrue = 0;
        int CumFalse = 0;
        int Kept = 0;
        if (LocalDebug) {
            System.out.println("Computed values for " + PeptidesSeen.size() + " peptides");
            Utils.WaitForEnter();
        }
        PeptidesSeen.clear();
        int i2 = 0;
        while (i2 < SortedAnns.length) {
            String CurrScan = String.valueOf(Utils.GetBaseName(SortedAnns[i2].SpectrumFile)) + "_" + SortedAnns[i2].ScanNumber;
            if (LocalDebug) {
                System.out.println("Considering New Ann: " + SortedAnns[i2].toString());
                System.out.println("Score: " + PValue.GetScore(SortedAnns[i2], ScoreMode));
            }
            if (PeptidesSeen.containsKey(SortedAnns[i2].Annotation)) {
                SortedAnns[i2].FDR = (Double)PeptidesSeen.get(SortedAnns[i2].Annotation);
                if (LocalDebug) {
                    System.out.println("Repeat peptide " + SortedAnns[i2] + " in " + SortedAnns[i2].ProteinName + ", accepting FDR: " + SortedAnns[i2].FDR);
                }
            } else {
                double Score = PValue.GetScore(SortedAnns[i2], ScoreMode);
                int[] Counts = (int[])ScoreCounts.get(new Double(Score));
                if (Counts == null) {
                    System.out.println("FAIL ON " + SortedAnns[i2].toString());
                    System.out.println(SortedAnns[i2].Annotation);
                }
                SortedAnns[i2].FDR = Math.max(1.0E-4, (double)(CumFalse += Counts[1]) / (double)(CumTrue += Counts[0]));
                if (CumTrue <= CumFalse) {
                    SortedAnns[i2].FDR = 1.0;
                }
                PeptidesSeen.put(SortedAnns[i2].Annotation, new Double(SortedAnns[i2].FDR));
                if (LocalDebug) {
                    System.out.println("For SpecProb of : " + Score);
                    System.out.println("TrueCounts = " + Counts[0]);
                    System.out.println("FalseCounts = " + Counts[1]);
                    System.out.println("CumTrue = " + CumTrue);
                    System.out.println("CumFalse = " + CumFalse);
                    System.out.println("FDR: " + SortedAnns[i2].FDR);
                    Utils.WaitForEnter();
                }
            }
            boolean IsDecoy = Utils.IsDecoyProtein(SortedAnns[i2].ProteinName);
            if (ReportFalse || !(DecoyScansSeen.containsKey(CurrScan) | ScansSeen.containsKey(CurrScan))) {
                if (IsDecoy) {
                    DecoyScansSeen.put(CurrScan, new Integer(1));
                } else {
                    ScansSeen.put(CurrScan, new Integer(1));
                }
                if ((ReportFalse || !IsDecoy) && SortedAnns[i2].Length >= 7 && SortedAnns[i2].FDR <= PValueCutOff) {
                    if (LocalDebug) {
                        System.out.println("For Score: " + SortedAnns[i2].SpecProb + ", FDR: " + SortedAnns[i2].FDR);
                        SortedAnns[i2].DebugPrint();
                        System.out.println("KEEPING IT!");
                        Utils.WaitForEnter();
                    }
                    ++Kept;
                    if (SortedAnns[i2].SpecProb > WorstFPR) {
                        WorstFPR = SortedAnns[i2].SpecProb;
                    }
                    FilteredResults.add(SortedAnns[i2]);
                }
            }
            ++i2;
        }
        System.out.println("Kept: " + Kept);
        System.out.println("SpecProb Cutoff: " + WorstFPR);
        if (LocalDebug) {
            Utils.WaitForEnter();
        }
        return InspectAnnotation.ArrayListToList(FilteredResults);
    }

    private static InspectAnnotation[] SortIncreasingOrder(InspectAnnotation[] RawAnns, int ScoreMode) {
        int i = 0;
        while (i < RawAnns.length) {
            double CurrMinScore = PValue.GetScore(RawAnns[i], ScoreMode);
            int MinIndex = i;
            int j = i + 1;
            while (j < RawAnns.length) {
                double NextScore = PValue.GetScore(RawAnns[j], ScoreMode);
                if (NextScore < CurrMinScore) {
                    CurrMinScore = NextScore;
                    MinIndex = j;
                }
                ++j;
            }
            if (MinIndex != i) {
                InspectAnnotation Temp = RawAnns[i];
                RawAnns[i] = RawAnns[MinIndex];
                RawAnns[MinIndex] = Temp;
            }
            ++i;
        }
        return RawAnns;
    }

    private static InspectAnnotation[] RankAndCutOff(InspectAnnotation[] RawAnns, double PValueCutOff, int ScoreMode) {
        ArrayList TrueAnns = new ArrayList();
        ArrayList FalseAnns = new ArrayList();
        int i = 0;
        while (i < RawAnns.length) {
            if (Utils.IsDecoyProtein(RawAnns[i].ProteinName)) {
                FalseAnns = PValue.InsertInScoreOrder(FalseAnns, RawAnns[i], ScoreMode);
            } else {
                TrueAnns = PValue.InsertInScoreOrder(TrueAnns, RawAnns[i], ScoreMode);
            }
            ++i;
        }
        System.out.println("True Count: " + TrueAnns.size() + ", False Count: " + FalseAnns.size());
        int TrueIndex = TrueAnns.size() - 1;
        double TrueCount = 0.0;
        int FalseIndex = FalseAnns.size() - 1;
        double FalseCount = 0.0;
        double TrueMinScore = 2.147483647E9;
        int TrueIndexFinal = TrueIndex;
        InspectAnnotation FalseAnn = (InspectAnnotation)FalseAnns.get(FalseIndex);
        InspectAnnotation TrueAnn = null;
        while (TrueIndex >= 0 && FalseIndex >= 0) {
            TrueAnn = (InspectAnnotation)TrueAnns.get(TrueIndex);
            TrueCount += 1.0;
            while (FalseIndex >= 0 && PValue.GetScore(TrueAnn, ScoreMode) < PValue.GetScore(FalseAnn, ScoreMode)) {
                FalseAnn = (InspectAnnotation)FalseAnns.get(FalseIndex);
                --FalseIndex;
                FalseCount += 1.0;
            }
            if (FalseCount / (FalseCount + TrueCount) <= PValueCutOff) {
                TrueMinScore = PValue.GetScore(TrueAnn, ScoreMode);
                TrueIndexFinal = TrueIndex;
            }
            --TrueIndex;
        }
        while (TrueIndex >= 0) {
            TrueAnn = (InspectAnnotation)TrueAnns.get(TrueIndex);
            if (FalseCount / (FalseCount + (TrueCount += 1.0)) <= PValueCutOff) {
                TrueMinScore = PValue.GetScore(TrueAnn, ScoreMode);
                TrueIndexFinal = TrueIndex;
            }
            --TrueIndex;
        }
        InspectAnnotation[] Ret = new InspectAnnotation[TrueAnns.size() - TrueIndex];
        int i2 = TrueIndexFinal;
        while (i2 < TrueAnns.size()) {
            Ret[i2 - TrueIndexFinal] = (InspectAnnotation)TrueAnns.get(i2);
            ++i2;
        }
        System.out.println("Reduced to top " + Ret.length + " true annotations");
        System.out.println("Score Cutoff: " + TrueMinScore);
        return Ret;
    }

    private static ArrayList InsertInScoreOrder(ArrayList CurrList, InspectAnnotation NewAnn, int ScoreMode) {
        double NewScore = PValue.GetScore(NewAnn, ScoreMode);
        if (CurrList.size() == 0) {
            CurrList.add(NewAnn);
            return CurrList;
        }
        int i = 0;
        while (i < CurrList.size()) {
            InspectAnnotation CurrAnn = (InspectAnnotation)CurrList.get(i);
            if (NewScore > PValue.GetScore(CurrAnn, ScoreMode)) {
                CurrList.add(i, NewAnn);
                return CurrList;
            }
            ++i;
        }
        CurrList.add(NewAnn);
        return CurrList;
    }

    public static double GetScore(InspectAnnotation Ann, int ScoreMode) {
        if (ScoreMode == 0) {
            return Ann.SpecProb;
        }
        if (ScoreMode == 1) {
            return Ann.FScore;
        }
        System.err.println("ERROR: No other form of scoring is available than MSGF or FScore:0");
        return 0.0;
    }

    public static void main(String[] args) {
        int Mode;
        String InputFile;
        File Test;
        String[] options = new String[]{"-r", "-w", "-a", "-p", "-t", "-l", "-q", "-H", "-m", "-s"};
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[8] = true;
        blArray[9] = true;
        boolean[] values = blArray;
        Hashtable CommandLineArgs = Utils.ParseCommandLine(args, options, values);
        if (!(CommandLineArgs.containsKey("-r") && CommandLineArgs.containsKey("-w") && CommandLineArgs.containsKey("-a") && CommandLineArgs.containsKey("-p"))) {
            System.err.println("ERROR: Missing required arguments!");
            System.err.println(UsageInfo);
            System.exit(0);
        }
        if (!(Test = new File(InputFile = (String)CommandLineArgs.get("-r"))).exists()) {
            System.err.println("ERROR: Invalid input file: " + InputFile);
            System.err.println(UsageInfo);
            System.exit(0);
        }
        String OutputFile = (String)CommandLineArgs.get("-w");
        String SearchDB = null;
        if (CommandLineArgs.containsKey("-t")) {
            SearchDB = (String)CommandLineArgs.get("-t");
        }
        double CutOff = Double.parseDouble((String)CommandLineArgs.get("-p"));
        boolean ComputeLocalFDR = false;
        if (CommandLineArgs.containsKey("-l")) {
            ComputeLocalFDR = true;
        }
        boolean ComputePeptideFDR = false;
        if (CommandLineArgs.containsKey("-q")) {
            ComputePeptideFDR = true;
        }
        boolean ReportFalse = false;
        if (CommandLineArgs.containsKey("-H")) {
            ReportFalse = true;
        }
        int MaxCleavages = Integer.MAX_VALUE;
        if (CommandLineArgs.containsKey("-m")) {
            MaxCleavages = Integer.parseInt((String)CommandLineArgs.get("-m"));
        }
        int scoreMode = 1;
        if (CommandLineArgs.containsKey("-s")) {
            int s = Integer.parseInt((String)CommandLineArgs.get("-s"));
            if (s != 1 && s != 0) {
                System.err.println("ERROR: Invalid score mode '" + s + "' specified!");
                System.err.println(UsageInfo);
                System.exit(-1);
            }
            scoreMode = s;
        }
        if ((Mode = Integer.parseInt((String)CommandLineArgs.get("-a"))) == 0) {
            if (CutOff <= 0.0) {
                System.err.println("ERROR: Invalid EValue cutoff: " + CutOff + ", must be >0");
                System.err.println(UsageInfo);
                System.exit(0);
            }
            PValue.PerformEValueCutoff(InputFile, OutputFile, CutOff, scoreMode, SearchDB);
        } else if (Mode == 1) {
            if (CutOff > 1.0 || CutOff <= 0.0) {
                System.err.println("ERROR: Invalid FDR cutoff: " + CutOff + ", must be <= 1 and >0");
                System.err.println(UsageInfo);
                System.exit(0);
            }
            PValue.PerformPValueCutoffWithDecoys(InputFile, OutputFile, CutOff, scoreMode, ComputeLocalFDR, ComputePeptideFDR, ReportFalse, MaxCleavages);
        }
    }
}

