# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference
    from . import WorkitemReference
    from . import WrapupIdReference

class WorkitemWrapup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemWrapup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'workitem': 'WorkitemReference',
            'wrapup_code': 'WrapupIdReference',
            'modified_by': 'UserReference',
            'user': 'UserReference',
            'date_modified': 'datetime'
        }

        self.attribute_map = {
            'workitem': 'workitem',
            'wrapup_code': 'wrapupCode',
            'modified_by': 'modifiedBy',
            'user': 'user',
            'date_modified': 'dateModified'
        }

        self._workitem = None
        self._wrapup_code = None
        self._modified_by = None
        self._user = None
        self._date_modified = None

    @property
    def workitem(self) -> 'WorkitemReference':
        """
        Gets the workitem of this WorkitemWrapup.
        Workitem that the wrapup code has been added to.

        :return: The workitem of this WorkitemWrapup.
        :rtype: WorkitemReference
        """
        return self._workitem

    @workitem.setter
    def workitem(self, workitem: 'WorkitemReference') -> None:
        """
        Sets the workitem of this WorkitemWrapup.
        Workitem that the wrapup code has been added to.

        :param workitem: The workitem of this WorkitemWrapup.
        :type: WorkitemReference
        """
        

        self._workitem = workitem

    @property
    def wrapup_code(self) -> 'WrapupIdReference':
        """
        Gets the wrapup_code of this WorkitemWrapup.
        The wrapup code used in the workitem.

        :return: The wrapup_code of this WorkitemWrapup.
        :rtype: WrapupIdReference
        """
        return self._wrapup_code

    @wrapup_code.setter
    def wrapup_code(self, wrapup_code: 'WrapupIdReference') -> None:
        """
        Sets the wrapup_code of this WorkitemWrapup.
        The wrapup code used in the workitem.

        :param wrapup_code: The wrapup_code of this WorkitemWrapup.
        :type: WrapupIdReference
        """
        

        self._wrapup_code = wrapup_code

    @property
    def modified_by(self) -> 'UserReference':
        """
        Gets the modified_by of this WorkitemWrapup.
        The user who added the wrapup code to the workitem.

        :return: The modified_by of this WorkitemWrapup.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'UserReference') -> None:
        """
        Sets the modified_by of this WorkitemWrapup.
        The user who added the wrapup code to the workitem.

        :param modified_by: The modified_by of this WorkitemWrapup.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this WorkitemWrapup.
        The user for whom wrapup code was added. This may be the same as modifiedBy.

        :return: The user of this WorkitemWrapup.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this WorkitemWrapup.
        The user for whom wrapup code was added. This may be the same as modifiedBy.

        :param user: The user of this WorkitemWrapup.
        :type: UserReference
        """
        

        self._user = user

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this WorkitemWrapup.
        The modified date of the Workitem when the wrapup code was added. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this WorkitemWrapup.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this WorkitemWrapup.
        The modified date of the Workitem when the wrapup code was added. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this WorkitemWrapup.
        :type: datetime
        """
        

        self._date_modified = date_modified

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

