# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkitemQueryJobError

class WorkitemQueryJobResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemQueryJobResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'state': 'str',
            'date_started': 'datetime',
            'date_finished': 'datetime',
            'error': 'WorkitemQueryJobError',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'date_started': 'dateStarted',
            'date_finished': 'dateFinished',
            'error': 'error',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._state = None
        self._date_started = None
        self._date_finished = None
        self._error = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this WorkitemQueryJobResponse.
        The globally unique identifier for the object.

        :return: The id of this WorkitemQueryJobResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this WorkitemQueryJobResponse.
        The globally unique identifier for the object.

        :param id: The id of this WorkitemQueryJobResponse.
        :type: str
        """
        

        self._id = id

    @property
    def state(self) -> str:
        """
        Gets the state of this WorkitemQueryJobResponse.
        The state of the query job

        :return: The state of this WorkitemQueryJobResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this WorkitemQueryJobResponse.
        The state of the query job

        :param state: The state of this WorkitemQueryJobResponse.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Queued", "Running", "Succeeded", "Failed"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_started(self) -> datetime:
        """
        Gets the date_started of this WorkitemQueryJobResponse.
        The date the job was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_started of this WorkitemQueryJobResponse.
        :rtype: datetime
        """
        return self._date_started

    @date_started.setter
    def date_started(self, date_started: datetime) -> None:
        """
        Sets the date_started of this WorkitemQueryJobResponse.
        The date the job was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_started: The date_started of this WorkitemQueryJobResponse.
        :type: datetime
        """
        

        self._date_started = date_started

    @property
    def date_finished(self) -> datetime:
        """
        Gets the date_finished of this WorkitemQueryJobResponse.
        The date the job finished. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_finished of this WorkitemQueryJobResponse.
        :rtype: datetime
        """
        return self._date_finished

    @date_finished.setter
    def date_finished(self, date_finished: datetime) -> None:
        """
        Sets the date_finished of this WorkitemQueryJobResponse.
        The date the job finished. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_finished: The date_finished of this WorkitemQueryJobResponse.
        :type: datetime
        """
        

        self._date_finished = date_finished

    @property
    def error(self) -> 'WorkitemQueryJobError':
        """
        Gets the error of this WorkitemQueryJobResponse.
        The error associated with the query job, if the state is Failed

        :return: The error of this WorkitemQueryJobResponse.
        :rtype: WorkitemQueryJobError
        """
        return self._error

    @error.setter
    def error(self, error: 'WorkitemQueryJobError') -> None:
        """
        Sets the error of this WorkitemQueryJobResponse.
        The error associated with the query job, if the state is Failed

        :param error: The error of this WorkitemQueryJobResponse.
        :type: WorkitemQueryJobError
        """
        

        self._error = error

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this WorkitemQueryJobResponse.
        The URI for this object

        :return: The self_uri of this WorkitemQueryJobResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this WorkitemQueryJobResponse.
        The URI for this object

        :param self_uri: The self_uri of this WorkitemQueryJobResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

