# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WorkitemCommonCreate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkitemCommonCreate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'priority': 'int',
            'date_due': 'datetime',
            'date_expires': 'datetime',
            'duration_seconds': 'int',
            'ttl': 'int',
            'status_id': 'str',
            'workbin_id': 'str',
            'auto_status_transition': 'bool',
            'description': 'str',
            'type_id': 'str',
            'custom_fields': 'dict(str, object)',
            'queue_id': 'str',
            'assignee_id': 'str',
            'language_id': 'str',
            'external_contact_id': 'str',
            'external_tag': 'str',
            'skill_ids': 'list[str]',
            'script_id': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'priority': 'priority',
            'date_due': 'dateDue',
            'date_expires': 'dateExpires',
            'duration_seconds': 'durationSeconds',
            'ttl': 'ttl',
            'status_id': 'statusId',
            'workbin_id': 'workbinId',
            'auto_status_transition': 'autoStatusTransition',
            'description': 'description',
            'type_id': 'typeId',
            'custom_fields': 'customFields',
            'queue_id': 'queueId',
            'assignee_id': 'assigneeId',
            'language_id': 'languageId',
            'external_contact_id': 'externalContactId',
            'external_tag': 'externalTag',
            'skill_ids': 'skillIds',
            'script_id': 'scriptId'
        }

        self._name = None
        self._priority = None
        self._date_due = None
        self._date_expires = None
        self._duration_seconds = None
        self._ttl = None
        self._status_id = None
        self._workbin_id = None
        self._auto_status_transition = None
        self._description = None
        self._type_id = None
        self._custom_fields = None
        self._queue_id = None
        self._assignee_id = None
        self._language_id = None
        self._external_contact_id = None
        self._external_tag = None
        self._skill_ids = None
        self._script_id = None

    @property
    def name(self) -> str:
        """
        Gets the name of this WorkitemCommonCreate.
        The name of the Workitem. Valid length between 3 and 256 characters.

        :return: The name of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WorkitemCommonCreate.
        The name of the Workitem. Valid length between 3 and 256 characters.

        :param name: The name of this WorkitemCommonCreate.
        :type: str
        """
        

        self._name = name

    @property
    def priority(self) -> int:
        """
        Gets the priority of this WorkitemCommonCreate.
        The priority of the Workitem. The valid range is between -25,000,000 and 25,000,000.

        :return: The priority of this WorkitemCommonCreate.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority: int) -> None:
        """
        Sets the priority of this WorkitemCommonCreate.
        The priority of the Workitem. The valid range is between -25,000,000 and 25,000,000.

        :param priority: The priority of this WorkitemCommonCreate.
        :type: int
        """
        

        self._priority = priority

    @property
    def date_due(self) -> datetime:
        """
        Gets the date_due of this WorkitemCommonCreate.
        The due date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_due of this WorkitemCommonCreate.
        :rtype: datetime
        """
        return self._date_due

    @date_due.setter
    def date_due(self, date_due: datetime) -> None:
        """
        Sets the date_due of this WorkitemCommonCreate.
        The due date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_due: The date_due of this WorkitemCommonCreate.
        :type: datetime
        """
        

        self._date_due = date_due

    @property
    def date_expires(self) -> datetime:
        """
        Gets the date_expires of this WorkitemCommonCreate.
        The expiry date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_expires of this WorkitemCommonCreate.
        :rtype: datetime
        """
        return self._date_expires

    @date_expires.setter
    def date_expires(self, date_expires: datetime) -> None:
        """
        Sets the date_expires of this WorkitemCommonCreate.
        The expiry date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_expires: The date_expires of this WorkitemCommonCreate.
        :type: datetime
        """
        

        self._date_expires = date_expires

    @property
    def duration_seconds(self) -> int:
        """
        Gets the duration_seconds of this WorkitemCommonCreate.
        The estimated duration in seconds to complete the Workitem. Maximum of 365 days.

        :return: The duration_seconds of this WorkitemCommonCreate.
        :rtype: int
        """
        return self._duration_seconds

    @duration_seconds.setter
    def duration_seconds(self, duration_seconds: int) -> None:
        """
        Sets the duration_seconds of this WorkitemCommonCreate.
        The estimated duration in seconds to complete the Workitem. Maximum of 365 days.

        :param duration_seconds: The duration_seconds of this WorkitemCommonCreate.
        :type: int
        """
        

        self._duration_seconds = duration_seconds

    @property
    def ttl(self) -> int:
        """
        Gets the ttl of this WorkitemCommonCreate.
        The epoch timestamp in seconds specifying the time to live for the Workitem. Can not be greater than 365 days from the current time.

        :return: The ttl of this WorkitemCommonCreate.
        :rtype: int
        """
        return self._ttl

    @ttl.setter
    def ttl(self, ttl: int) -> None:
        """
        Sets the ttl of this WorkitemCommonCreate.
        The epoch timestamp in seconds specifying the time to live for the Workitem. Can not be greater than 365 days from the current time.

        :param ttl: The ttl of this WorkitemCommonCreate.
        :type: int
        """
        

        self._ttl = ttl

    @property
    def status_id(self) -> str:
        """
        Gets the status_id of this WorkitemCommonCreate.
        The ID of the Status of the Workitem.

        :return: The status_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._status_id

    @status_id.setter
    def status_id(self, status_id: str) -> None:
        """
        Sets the status_id of this WorkitemCommonCreate.
        The ID of the Status of the Workitem.

        :param status_id: The status_id of this WorkitemCommonCreate.
        :type: str
        """
        

        self._status_id = status_id

    @property
    def workbin_id(self) -> str:
        """
        Gets the workbin_id of this WorkitemCommonCreate.
        The ID of Workbin that contains the Workitem.

        :return: The workbin_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._workbin_id

    @workbin_id.setter
    def workbin_id(self, workbin_id: str) -> None:
        """
        Sets the workbin_id of this WorkitemCommonCreate.
        The ID of Workbin that contains the Workitem.

        :param workbin_id: The workbin_id of this WorkitemCommonCreate.
        :type: str
        """
        

        self._workbin_id = workbin_id

    @property
    def auto_status_transition(self) -> bool:
        """
        Gets the auto_status_transition of this WorkitemCommonCreate.
        Set it to false to disable auto status transition. By default, it is enabled.

        :return: The auto_status_transition of this WorkitemCommonCreate.
        :rtype: bool
        """
        return self._auto_status_transition

    @auto_status_transition.setter
    def auto_status_transition(self, auto_status_transition: bool) -> None:
        """
        Sets the auto_status_transition of this WorkitemCommonCreate.
        Set it to false to disable auto status transition. By default, it is enabled.

        :param auto_status_transition: The auto_status_transition of this WorkitemCommonCreate.
        :type: bool
        """
        

        self._auto_status_transition = auto_status_transition

    @property
    def description(self) -> str:
        """
        Gets the description of this WorkitemCommonCreate.
        The description of the Workitem. Maximum length of 512 characters.

        :return: The description of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this WorkitemCommonCreate.
        The description of the Workitem. Maximum length of 512 characters.

        :param description: The description of this WorkitemCommonCreate.
        :type: str
        """
        

        self._description = description

    @property
    def type_id(self) -> str:
        """
        Gets the type_id of this WorkitemCommonCreate.
        The ID of the Worktype of the Workitem.

        :return: The type_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._type_id

    @type_id.setter
    def type_id(self, type_id: str) -> None:
        """
        Sets the type_id of this WorkitemCommonCreate.
        The ID of the Worktype of the Workitem.

        :param type_id: The type_id of this WorkitemCommonCreate.
        :type: str
        """
        

        self._type_id = type_id

    @property
    def custom_fields(self) -> Dict[str, object]:
        """
        Gets the custom_fields of this WorkitemCommonCreate.
        Custom fields defined in the schema referenced by the worktype of the workitem.

        :return: The custom_fields of this WorkitemCommonCreate.
        :rtype: dict(str, object)
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields: Dict[str, object]) -> None:
        """
        Sets the custom_fields of this WorkitemCommonCreate.
        Custom fields defined in the schema referenced by the worktype of the workitem.

        :param custom_fields: The custom_fields of this WorkitemCommonCreate.
        :type: dict(str, object)
        """
        

        self._custom_fields = custom_fields

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this WorkitemCommonCreate.
        The ID of the Workitems queue. Must be a valid UUID.

        :return: The queue_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this WorkitemCommonCreate.
        The ID of the Workitems queue. Must be a valid UUID.

        :param queue_id: The queue_id of this WorkitemCommonCreate.
        :type: str
        """
        
        if not re.search('[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}', queue_id):
            raise ValueError("Invalid value for `queue_id`, must be a follow pattern or equal to `/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/`")


        self._queue_id = queue_id

    @property
    def assignee_id(self) -> str:
        """
        Gets the assignee_id of this WorkitemCommonCreate.
        The ID of the assignee of the Workitem. Must be a valid UUID.

        :return: The assignee_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._assignee_id

    @assignee_id.setter
    def assignee_id(self, assignee_id: str) -> None:
        """
        Sets the assignee_id of this WorkitemCommonCreate.
        The ID of the assignee of the Workitem. Must be a valid UUID.

        :param assignee_id: The assignee_id of this WorkitemCommonCreate.
        :type: str
        """
        
        if not re.search('[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}', assignee_id):
            raise ValueError("Invalid value for `assignee_id`, must be a follow pattern or equal to `/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/`")


        self._assignee_id = assignee_id

    @property
    def language_id(self) -> str:
        """
        Gets the language_id of this WorkitemCommonCreate.
        The ID of language of the Workitem. Must be a valid UUID.

        :return: The language_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._language_id

    @language_id.setter
    def language_id(self, language_id: str) -> None:
        """
        Sets the language_id of this WorkitemCommonCreate.
        The ID of language of the Workitem. Must be a valid UUID.

        :param language_id: The language_id of this WorkitemCommonCreate.
        :type: str
        """
        

        self._language_id = language_id

    @property
    def external_contact_id(self) -> str:
        """
        Gets the external_contact_id of this WorkitemCommonCreate.
        The ID of the external contact of the Workitem. Must be a valid UUID.

        :return: The external_contact_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._external_contact_id

    @external_contact_id.setter
    def external_contact_id(self, external_contact_id: str) -> None:
        """
        Sets the external_contact_id of this WorkitemCommonCreate.
        The ID of the external contact of the Workitem. Must be a valid UUID.

        :param external_contact_id: The external_contact_id of this WorkitemCommonCreate.
        :type: str
        """
        

        self._external_contact_id = external_contact_id

    @property
    def external_tag(self) -> str:
        """
        Gets the external_tag of this WorkitemCommonCreate.
        The external tag of the Workitem.

        :return: The external_tag of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._external_tag

    @external_tag.setter
    def external_tag(self, external_tag: str) -> None:
        """
        Sets the external_tag of this WorkitemCommonCreate.
        The external tag of the Workitem.

        :param external_tag: The external_tag of this WorkitemCommonCreate.
        :type: str
        """
        

        self._external_tag = external_tag

    @property
    def skill_ids(self) -> List[str]:
        """
        Gets the skill_ids of this WorkitemCommonCreate.
        The skill IDs of the Workitem. Must be valid UUIDs.

        :return: The skill_ids of this WorkitemCommonCreate.
        :rtype: list[str]
        """
        return self._skill_ids

    @skill_ids.setter
    def skill_ids(self, skill_ids: List[str]) -> None:
        """
        Sets the skill_ids of this WorkitemCommonCreate.
        The skill IDs of the Workitem. Must be valid UUIDs.

        :param skill_ids: The skill_ids of this WorkitemCommonCreate.
        :type: list[str]
        """
        

        self._skill_ids = skill_ids

    @property
    def script_id(self) -> str:
        """
        Gets the script_id of this WorkitemCommonCreate.
        The ID of the Workitems script. Must be a valid UUID.

        :return: The script_id of this WorkitemCommonCreate.
        :rtype: str
        """
        return self._script_id

    @script_id.setter
    def script_id(self, script_id: str) -> None:
        """
        Sets the script_id of this WorkitemCommonCreate.
        The ID of the Workitems script. Must be a valid UUID.

        :param script_id: The script_id of this WorkitemCommonCreate.
        :type: str
        """
        

        self._script_id = script_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

