# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkbinQuerySort
    from . import WorkitemFilter

class WorkbinQueryRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkbinQueryRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'page_size': 'int',
            'select': 'str',
            'filters': 'list[WorkitemFilter]',
            'attributes': 'list[str]',
            'after': 'str',
            'sort': 'WorkbinQuerySort'
        }

        self.attribute_map = {
            'page_size': 'pageSize',
            'select': 'select',
            'filters': 'filters',
            'attributes': 'attributes',
            'after': 'after',
            'sort': 'sort'
        }

        self._page_size = None
        self._select = None
        self._filters = None
        self._attributes = None
        self._after = None
        self._sort = None

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this WorkbinQueryRequest.
        Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.

        :return: The page_size of this WorkbinQueryRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this WorkbinQueryRequest.
        Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.

        :param page_size: The page_size of this WorkbinQueryRequest.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def select(self) -> str:
        """
        Gets the select of this WorkbinQueryRequest.
        Specify the value 'Count' for this parameter in order to return only the record count.

        :return: The select of this WorkbinQueryRequest.
        :rtype: str
        """
        return self._select

    @select.setter
    def select(self, select: str) -> None:
        """
        Sets the select of this WorkbinQueryRequest.
        Specify the value 'Count' for this parameter in order to return only the record count.

        :param select: The select of this WorkbinQueryRequest.
        :type: str
        """
        if isinstance(select, int):
            select = str(select)
        allowed_values = ["Count"]
        if select.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for select -> " + select)
            self._select = "outdated_sdk_version"
        else:
            self._select = select

    @property
    def filters(self) -> List['WorkitemFilter']:
        """
        Gets the filters of this WorkbinQueryRequest.
        List of filter objects to be used in the search.

        :return: The filters of this WorkbinQueryRequest.
        :rtype: list[WorkitemFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters: List['WorkitemFilter']) -> None:
        """
        Sets the filters of this WorkbinQueryRequest.
        List of filter objects to be used in the search.

        :param filters: The filters of this WorkbinQueryRequest.
        :type: list[WorkitemFilter]
        """
        

        self._filters = filters

    @property
    def attributes(self) -> List[str]:
        """
        Gets the attributes of this WorkbinQueryRequest.
        List of entity attributes to be retrieved in the result.

        :return: The attributes of this WorkbinQueryRequest.
        :rtype: list[str]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: List[str]) -> None:
        """
        Sets the attributes of this WorkbinQueryRequest.
        List of entity attributes to be retrieved in the result.

        :param attributes: The attributes of this WorkbinQueryRequest.
        :type: list[str]
        """
        

        self._attributes = attributes

    @property
    def after(self) -> str:
        """
        Gets the after of this WorkbinQueryRequest.
        The cursor that points to the end of the set of entities that has been returned.

        :return: The after of this WorkbinQueryRequest.
        :rtype: str
        """
        return self._after

    @after.setter
    def after(self, after: str) -> None:
        """
        Sets the after of this WorkbinQueryRequest.
        The cursor that points to the end of the set of entities that has been returned.

        :param after: The after of this WorkbinQueryRequest.
        :type: str
        """
        

        self._after = after

    @property
    def sort(self) -> 'WorkbinQuerySort':
        """
        Gets the sort of this WorkbinQueryRequest.
        Sort

        :return: The sort of this WorkbinQueryRequest.
        :rtype: WorkbinQuerySort
        """
        return self._sort

    @sort.setter
    def sort(self, sort: 'WorkbinQuerySort') -> None:
        """
        Sets the sort of this WorkbinQueryRequest.
        Sort

        :param sort: The sort of this WorkbinQueryRequest.
        :type: WorkbinQuerySort
        """
        

        self._sort = sort

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

