# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WorkitemsAttributeChangeInstant
    from . import WorkitemsAttributeChangeString

class WorkbinDelta(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkbinDelta - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'WorkitemsAttributeChangeString',
            'description': 'WorkitemsAttributeChangeString',
            'date_modified': 'WorkitemsAttributeChangeInstant',
            'modified_by': 'WorkitemsAttributeChangeString'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'date_modified': 'dateModified',
            'modified_by': 'modifiedBy'
        }

        self._name = None
        self._description = None
        self._date_modified = None
        self._modified_by = None

    @property
    def name(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the name of this WorkbinDelta.


        :return: The name of this WorkbinDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._name

    @name.setter
    def name(self, name: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the name of this WorkbinDelta.


        :param name: The name of this WorkbinDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._name = name

    @property
    def description(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the description of this WorkbinDelta.


        :return: The description of this WorkbinDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._description

    @description.setter
    def description(self, description: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the description of this WorkbinDelta.


        :param description: The description of this WorkbinDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._description = description

    @property
    def date_modified(self) -> 'WorkitemsAttributeChangeInstant':
        """
        Gets the date_modified of this WorkbinDelta.


        :return: The date_modified of this WorkbinDelta.
        :rtype: WorkitemsAttributeChangeInstant
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: 'WorkitemsAttributeChangeInstant') -> None:
        """
        Sets the date_modified of this WorkbinDelta.


        :param date_modified: The date_modified of this WorkbinDelta.
        :type: WorkitemsAttributeChangeInstant
        """
        

        self._date_modified = date_modified

    @property
    def modified_by(self) -> 'WorkitemsAttributeChangeString':
        """
        Gets the modified_by of this WorkbinDelta.


        :return: The modified_by of this WorkbinDelta.
        :rtype: WorkitemsAttributeChangeString
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'WorkitemsAttributeChangeString') -> None:
        """
        Sets the modified_by of this WorkbinDelta.


        :param modified_by: The modified_by of this WorkbinDelta.
        :type: WorkitemsAttributeChangeString
        """
        

        self._modified_by = modified_by

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

