# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BidGroupWorkPlanRequest

class WorkPlanBidGroupCreate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkPlanBidGroupCreate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'management_unit_id': 'str',
            'agent_ids': 'list[str]',
            'work_plans': 'list[BidGroupWorkPlanRequest]',
            'planning_group_ids': 'list[str]'
        }

        self.attribute_map = {
            'name': 'name',
            'management_unit_id': 'managementUnitId',
            'agent_ids': 'agentIds',
            'work_plans': 'workPlans',
            'planning_group_ids': 'planningGroupIds'
        }

        self._name = None
        self._management_unit_id = None
        self._agent_ids = None
        self._work_plans = None
        self._planning_group_ids = None

    @property
    def name(self) -> str:
        """
        Gets the name of this WorkPlanBidGroupCreate.
        The name of the work plan bid group

        :return: The name of this WorkPlanBidGroupCreate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WorkPlanBidGroupCreate.
        The name of the work plan bid group

        :param name: The name of this WorkPlanBidGroupCreate.
        :type: str
        """
        

        self._name = name

    @property
    def management_unit_id(self) -> str:
        """
        Gets the management_unit_id of this WorkPlanBidGroupCreate.
        The management unit ID this bid group belongs to

        :return: The management_unit_id of this WorkPlanBidGroupCreate.
        :rtype: str
        """
        return self._management_unit_id

    @management_unit_id.setter
    def management_unit_id(self, management_unit_id: str) -> None:
        """
        Sets the management_unit_id of this WorkPlanBidGroupCreate.
        The management unit ID this bid group belongs to

        :param management_unit_id: The management_unit_id of this WorkPlanBidGroupCreate.
        :type: str
        """
        

        self._management_unit_id = management_unit_id

    @property
    def agent_ids(self) -> List[str]:
        """
        Gets the agent_ids of this WorkPlanBidGroupCreate.
        Agent IDs who participate in this bid group

        :return: The agent_ids of this WorkPlanBidGroupCreate.
        :rtype: list[str]
        """
        return self._agent_ids

    @agent_ids.setter
    def agent_ids(self, agent_ids: List[str]) -> None:
        """
        Sets the agent_ids of this WorkPlanBidGroupCreate.
        Agent IDs who participate in this bid group

        :param agent_ids: The agent_ids of this WorkPlanBidGroupCreate.
        :type: list[str]
        """
        

        self._agent_ids = agent_ids

    @property
    def work_plans(self) -> List['BidGroupWorkPlanRequest']:
        """
        Gets the work_plans of this WorkPlanBidGroupCreate.
        The list of work plans used in this bid group

        :return: The work_plans of this WorkPlanBidGroupCreate.
        :rtype: list[BidGroupWorkPlanRequest]
        """
        return self._work_plans

    @work_plans.setter
    def work_plans(self, work_plans: List['BidGroupWorkPlanRequest']) -> None:
        """
        Sets the work_plans of this WorkPlanBidGroupCreate.
        The list of work plans used in this bid group

        :param work_plans: The work_plans of this WorkPlanBidGroupCreate.
        :type: list[BidGroupWorkPlanRequest]
        """
        

        self._work_plans = work_plans

    @property
    def planning_group_ids(self) -> List[str]:
        """
        Gets the planning_group_ids of this WorkPlanBidGroupCreate.
        The planning group IDs selected in this bid group

        :return: The planning_group_ids of this WorkPlanBidGroupCreate.
        :rtype: list[str]
        """
        return self._planning_group_ids

    @planning_group_ids.setter
    def planning_group_ids(self, planning_group_ids: List[str]) -> None:
        """
        Sets the planning_group_ids of this WorkPlanBidGroupCreate.
        The planning group IDs selected in this bid group

        :param planning_group_ids: The planning_group_ids of this WorkPlanBidGroupCreate.
        :type: list[str]
        """
        

        self._planning_group_ids = planning_group_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

