# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BidGroupWorkPlanResponse
    from . import ManagementUnitReference
    from . import PlanningGroupReference
    from . import UserReference

class WorkPlanBidGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkPlanBidGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'management_unit': 'ManagementUnitReference',
            'agents': 'list[UserReference]',
            'work_plans': 'list[BidGroupWorkPlanResponse]',
            'planning_groups': 'list[PlanningGroupReference]'
        }

        self.attribute_map = {
            'name': 'name',
            'management_unit': 'managementUnit',
            'agents': 'agents',
            'work_plans': 'workPlans',
            'planning_groups': 'planningGroups'
        }

        self._name = None
        self._management_unit = None
        self._agents = None
        self._work_plans = None
        self._planning_groups = None

    @property
    def name(self) -> str:
        """
        Gets the name of this WorkPlanBidGroup.
        The name of the work plan bid group

        :return: The name of this WorkPlanBidGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WorkPlanBidGroup.
        The name of the work plan bid group

        :param name: The name of this WorkPlanBidGroup.
        :type: str
        """
        

        self._name = name

    @property
    def management_unit(self) -> 'ManagementUnitReference':
        """
        Gets the management_unit of this WorkPlanBidGroup.
        The management unit this bid group belongs to

        :return: The management_unit of this WorkPlanBidGroup.
        :rtype: ManagementUnitReference
        """
        return self._management_unit

    @management_unit.setter
    def management_unit(self, management_unit: 'ManagementUnitReference') -> None:
        """
        Sets the management_unit of this WorkPlanBidGroup.
        The management unit this bid group belongs to

        :param management_unit: The management_unit of this WorkPlanBidGroup.
        :type: ManagementUnitReference
        """
        

        self._management_unit = management_unit

    @property
    def agents(self) -> List['UserReference']:
        """
        Gets the agents of this WorkPlanBidGroup.
        The list of agents who participate in this bid group

        :return: The agents of this WorkPlanBidGroup.
        :rtype: list[UserReference]
        """
        return self._agents

    @agents.setter
    def agents(self, agents: List['UserReference']) -> None:
        """
        Sets the agents of this WorkPlanBidGroup.
        The list of agents who participate in this bid group

        :param agents: The agents of this WorkPlanBidGroup.
        :type: list[UserReference]
        """
        

        self._agents = agents

    @property
    def work_plans(self) -> List['BidGroupWorkPlanResponse']:
        """
        Gets the work_plans of this WorkPlanBidGroup.
        The list of work plans used in this bid group

        :return: The work_plans of this WorkPlanBidGroup.
        :rtype: list[BidGroupWorkPlanResponse]
        """
        return self._work_plans

    @work_plans.setter
    def work_plans(self, work_plans: List['BidGroupWorkPlanResponse']) -> None:
        """
        Sets the work_plans of this WorkPlanBidGroup.
        The list of work plans used in this bid group

        :param work_plans: The work_plans of this WorkPlanBidGroup.
        :type: list[BidGroupWorkPlanResponse]
        """
        

        self._work_plans = work_plans

    @property
    def planning_groups(self) -> List['PlanningGroupReference']:
        """
        Gets the planning_groups of this WorkPlanBidGroup.
        The list of planning groups selected in this bid group

        :return: The planning_groups of this WorkPlanBidGroup.
        :rtype: list[PlanningGroupReference]
        """
        return self._planning_groups

    @planning_groups.setter
    def planning_groups(self, planning_groups: List['PlanningGroupReference']) -> None:
        """
        Sets the planning_groups of this WorkPlanBidGroup.
        The list of planning groups selected in this bid group

        :param planning_groups: The planning_groups of this WorkPlanBidGroup.
        :type: list[PlanningGroupReference]
        """
        

        self._planning_groups = planning_groups

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

