# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BuShortTermForecastWeekReference
    from . import WorkPlanBidMetadata

class WorkPlanBid(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkPlanBid - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'forecast': 'BuShortTermForecastWeekReference',
            'bid_window_start_date': 'date',
            'bid_window_end_date': 'date',
            'effective_date': 'date',
            'status': 'str',
            'agent_ranking_type': 'str',
            'ranking_tiebreaker_type': 'str',
            'published_date': 'datetime',
            'work_plan_fields_visible_to_agents': 'list[str]',
            'metadata': 'WorkPlanBidMetadata',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'forecast': 'forecast',
            'bid_window_start_date': 'bidWindowStartDate',
            'bid_window_end_date': 'bidWindowEndDate',
            'effective_date': 'effectiveDate',
            'status': 'status',
            'agent_ranking_type': 'agentRankingType',
            'ranking_tiebreaker_type': 'rankingTiebreakerType',
            'published_date': 'publishedDate',
            'work_plan_fields_visible_to_agents': 'workPlanFieldsVisibleToAgents',
            'metadata': 'metadata',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._forecast = None
        self._bid_window_start_date = None
        self._bid_window_end_date = None
        self._effective_date = None
        self._status = None
        self._agent_ranking_type = None
        self._ranking_tiebreaker_type = None
        self._published_date = None
        self._work_plan_fields_visible_to_agents = None
        self._metadata = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this WorkPlanBid.
        The ID of the work plan bid

        :return: The id of this WorkPlanBid.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this WorkPlanBid.
        The ID of the work plan bid

        :param id: The id of this WorkPlanBid.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this WorkPlanBid.
        The name of the work plan bid

        :return: The name of this WorkPlanBid.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WorkPlanBid.
        The name of the work plan bid

        :param name: The name of this WorkPlanBid.
        :type: str
        """
        

        self._name = name

    @property
    def forecast(self) -> 'BuShortTermForecastWeekReference':
        """
        Gets the forecast of this WorkPlanBid.
        The selected forecast in this work plan bid

        :return: The forecast of this WorkPlanBid.
        :rtype: BuShortTermForecastWeekReference
        """
        return self._forecast

    @forecast.setter
    def forecast(self, forecast: 'BuShortTermForecastWeekReference') -> None:
        """
        Sets the forecast of this WorkPlanBid.
        The selected forecast in this work plan bid

        :param forecast: The forecast of this WorkPlanBid.
        :type: BuShortTermForecastWeekReference
        """
        

        self._forecast = forecast

    @property
    def bid_window_start_date(self) -> date:
        """
        Gets the bid_window_start_date of this WorkPlanBid.
        The bid start date where agents start participate in work plan bidding. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The bid_window_start_date of this WorkPlanBid.
        :rtype: date
        """
        return self._bid_window_start_date

    @bid_window_start_date.setter
    def bid_window_start_date(self, bid_window_start_date: date) -> None:
        """
        Sets the bid_window_start_date of this WorkPlanBid.
        The bid start date where agents start participate in work plan bidding. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param bid_window_start_date: The bid_window_start_date of this WorkPlanBid.
        :type: date
        """
        

        self._bid_window_start_date = bid_window_start_date

    @property
    def bid_window_end_date(self) -> date:
        """
        Gets the bid_window_end_date of this WorkPlanBid.
        The bid end date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The bid_window_end_date of this WorkPlanBid.
        :rtype: date
        """
        return self._bid_window_end_date

    @bid_window_end_date.setter
    def bid_window_end_date(self, bid_window_end_date: date) -> None:
        """
        Sets the bid_window_end_date of this WorkPlanBid.
        The bid end date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param bid_window_end_date: The bid_window_end_date of this WorkPlanBid.
        :type: date
        """
        

        self._bid_window_end_date = bid_window_end_date

    @property
    def effective_date(self) -> date:
        """
        Gets the effective_date of this WorkPlanBid.
        The date when agents will be assigned to the new work plan. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The effective_date of this WorkPlanBid.
        :rtype: date
        """
        return self._effective_date

    @effective_date.setter
    def effective_date(self, effective_date: date) -> None:
        """
        Sets the effective_date of this WorkPlanBid.
        The date when agents will be assigned to the new work plan. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param effective_date: The effective_date of this WorkPlanBid.
        :type: date
        """
        

        self._effective_date = effective_date

    @property
    def status(self) -> str:
        """
        Gets the status of this WorkPlanBid.
        The state of the bid

        :return: The status of this WorkPlanBid.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this WorkPlanBid.
        The state of the bid

        :param status: The status of this WorkPlanBid.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Draft", "Locked", "Optimized", "Scheduled", "Open", "Closed", "Processed", "Published"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def agent_ranking_type(self) -> str:
        """
        Gets the agent_ranking_type of this WorkPlanBid.
        The type of agent ranking selected for this bid

        :return: The agent_ranking_type of this WorkPlanBid.
        :rtype: str
        """
        return self._agent_ranking_type

    @agent_ranking_type.setter
    def agent_ranking_type(self, agent_ranking_type: str) -> None:
        """
        Sets the agent_ranking_type of this WorkPlanBid.
        The type of agent ranking selected for this bid

        :param agent_ranking_type: The agent_ranking_type of this WorkPlanBid.
        :type: str
        """
        if isinstance(agent_ranking_type, int):
            agent_ranking_type = str(agent_ranking_type)
        allowed_values = ["HireDate", "Performance"]
        if agent_ranking_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for agent_ranking_type -> " + agent_ranking_type)
            self._agent_ranking_type = "outdated_sdk_version"
        else:
            self._agent_ranking_type = agent_ranking_type

    @property
    def ranking_tiebreaker_type(self) -> str:
        """
        Gets the ranking_tiebreaker_type of this WorkPlanBid.
        Ranking tiebreaker

        :return: The ranking_tiebreaker_type of this WorkPlanBid.
        :rtype: str
        """
        return self._ranking_tiebreaker_type

    @ranking_tiebreaker_type.setter
    def ranking_tiebreaker_type(self, ranking_tiebreaker_type: str) -> None:
        """
        Sets the ranking_tiebreaker_type of this WorkPlanBid.
        Ranking tiebreaker

        :param ranking_tiebreaker_type: The ranking_tiebreaker_type of this WorkPlanBid.
        :type: str
        """
        if isinstance(ranking_tiebreaker_type, int):
            ranking_tiebreaker_type = str(ranking_tiebreaker_type)
        allowed_values = ["HireDate", "Performance", "Custom", "RandomlyAssign"]
        if ranking_tiebreaker_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for ranking_tiebreaker_type -> " + ranking_tiebreaker_type)
            self._ranking_tiebreaker_type = "outdated_sdk_version"
        else:
            self._ranking_tiebreaker_type = ranking_tiebreaker_type

    @property
    def published_date(self) -> datetime:
        """
        Gets the published_date of this WorkPlanBid.
        The date the work plan bid published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The published_date of this WorkPlanBid.
        :rtype: datetime
        """
        return self._published_date

    @published_date.setter
    def published_date(self, published_date: datetime) -> None:
        """
        Sets the published_date of this WorkPlanBid.
        The date the work plan bid published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param published_date: The published_date of this WorkPlanBid.
        :type: datetime
        """
        

        self._published_date = published_date

    @property
    def work_plan_fields_visible_to_agents(self) -> List[str]:
        """
        Gets the work_plan_fields_visible_to_agents of this WorkPlanBid.
        The work plan fields visible to agents whenever work plan preferences are made

        :return: The work_plan_fields_visible_to_agents of this WorkPlanBid.
        :rtype: list[str]
        """
        return self._work_plan_fields_visible_to_agents

    @work_plan_fields_visible_to_agents.setter
    def work_plan_fields_visible_to_agents(self, work_plan_fields_visible_to_agents: List[str]) -> None:
        """
        Sets the work_plan_fields_visible_to_agents of this WorkPlanBid.
        The work plan fields visible to agents whenever work plan preferences are made

        :param work_plan_fields_visible_to_agents: The work_plan_fields_visible_to_agents of this WorkPlanBid.
        :type: list[str]
        """
        

        self._work_plan_fields_visible_to_agents = work_plan_fields_visible_to_agents

    @property
    def metadata(self) -> 'WorkPlanBidMetadata':
        """
        Gets the metadata of this WorkPlanBid.
        The meta data of this bid

        :return: The metadata of this WorkPlanBid.
        :rtype: WorkPlanBidMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'WorkPlanBidMetadata') -> None:
        """
        Sets the metadata of this WorkPlanBid.
        The meta data of this bid

        :param metadata: The metadata of this WorkPlanBid.
        :type: WorkPlanBidMetadata
        """
        

        self._metadata = metadata

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this WorkPlanBid.
        The URI for this object

        :return: The self_uri of this WorkPlanBid.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this WorkPlanBid.
        The URI for this object

        :param self_uri: The self_uri of this WorkPlanBid.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

