# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WidgetClientConfigV1(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WidgetClientConfigV1 - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'web_chat_skin': 'str',
            'authentication_url': 'str'
        }

        self.attribute_map = {
            'web_chat_skin': 'webChatSkin',
            'authentication_url': 'authenticationUrl'
        }

        self._web_chat_skin = None
        self._authentication_url = None

    @property
    def web_chat_skin(self) -> str:
        """
        Gets the web_chat_skin of this WidgetClientConfigV1.


        :return: The web_chat_skin of this WidgetClientConfigV1.
        :rtype: str
        """
        return self._web_chat_skin

    @web_chat_skin.setter
    def web_chat_skin(self, web_chat_skin: str) -> None:
        """
        Sets the web_chat_skin of this WidgetClientConfigV1.


        :param web_chat_skin: The web_chat_skin of this WidgetClientConfigV1.
        :type: str
        """
        if isinstance(web_chat_skin, int):
            web_chat_skin = str(web_chat_skin)
        allowed_values = ["basic", "modern-caret-skin"]
        if web_chat_skin.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for web_chat_skin -> " + web_chat_skin)
            self._web_chat_skin = "outdated_sdk_version"
        else:
            self._web_chat_skin = web_chat_skin

    @property
    def authentication_url(self) -> str:
        """
        Gets the authentication_url of this WidgetClientConfigV1.


        :return: The authentication_url of this WidgetClientConfigV1.
        :rtype: str
        """
        return self._authentication_url

    @authentication_url.setter
    def authentication_url(self, authentication_url: str) -> None:
        """
        Sets the authentication_url of this WidgetClientConfigV1.


        :param authentication_url: The authentication_url of this WidgetClientConfigV1.
        :type: str
        """
        

        self._authentication_url = authentication_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

