# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Button
    from . import MessageFooter
    from . import MessageHeader

class WhatsAppDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WhatsAppDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'namespace': 'str',
            'language': 'str',
            'buttons': 'list[Button]',
            'message_footer': 'MessageFooter',
            'header': 'MessageHeader'
        }

        self.attribute_map = {
            'name': 'name',
            'namespace': 'namespace',
            'language': 'language',
            'buttons': 'buttons',
            'message_footer': 'messageFooter',
            'header': 'header'
        }

        self._name = None
        self._namespace = None
        self._language = None
        self._buttons = None
        self._message_footer = None
        self._header = None

    @property
    def name(self) -> str:
        """
        Gets the name of this WhatsAppDefinition.
        The messaging template name.

        :return: The name of this WhatsAppDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this WhatsAppDefinition.
        The messaging template name.

        :param name: The name of this WhatsAppDefinition.
        :type: str
        """
        

        self._name = name

    @property
    def namespace(self) -> str:
        """
        Gets the namespace of this WhatsAppDefinition.
        The messaging template namespace.

        :return: The namespace of this WhatsAppDefinition.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str) -> None:
        """
        Sets the namespace of this WhatsAppDefinition.
        The messaging template namespace.

        :param namespace: The namespace of this WhatsAppDefinition.
        :type: str
        """
        

        self._namespace = namespace

    @property
    def language(self) -> str:
        """
        Gets the language of this WhatsAppDefinition.
        The messaging template language configured for this template. This is a WhatsApp specific value. For example, 'en_US'

        :return: The language of this WhatsAppDefinition.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this WhatsAppDefinition.
        The messaging template language configured for this template. This is a WhatsApp specific value. For example, 'en_US'

        :param language: The language of this WhatsAppDefinition.
        :type: str
        """
        

        self._language = language

    @property
    def buttons(self) -> List['Button']:
        """
        Gets the buttons of this WhatsAppDefinition.
        List of buttons to be included in the WhatsApp messages channel

        :return: The buttons of this WhatsAppDefinition.
        :rtype: list[Button]
        """
        return self._buttons

    @buttons.setter
    def buttons(self, buttons: List['Button']) -> None:
        """
        Sets the buttons of this WhatsAppDefinition.
        List of buttons to be included in the WhatsApp messages channel

        :param buttons: The buttons of this WhatsAppDefinition.
        :type: list[Button]
        """
        

        self._buttons = buttons

    @property
    def message_footer(self) -> 'MessageFooter':
        """
        Gets the message_footer of this WhatsAppDefinition.
        Footer for the message in the WhatsApp messages channel

        :return: The message_footer of this WhatsAppDefinition.
        :rtype: MessageFooter
        """
        return self._message_footer

    @message_footer.setter
    def message_footer(self, message_footer: 'MessageFooter') -> None:
        """
        Sets the message_footer of this WhatsAppDefinition.
        Footer for the message in the WhatsApp messages channel

        :param message_footer: The message_footer of this WhatsAppDefinition.
        :type: MessageFooter
        """
        

        self._message_footer = message_footer

    @property
    def header(self) -> 'MessageHeader':
        """
        Gets the header of this WhatsAppDefinition.
        Header for the message in the WhatsApp messages channel

        :return: The header of this WhatsAppDefinition.
        :rtype: MessageHeader
        """
        return self._header

    @header.setter
    def header(self, header: 'MessageHeader') -> None:
        """
        Sets the header of this WhatsAppDefinition.
        Header for the message in the WhatsApp messages channel

        :param header: The header of this WhatsAppDefinition.
        :type: MessageHeader
        """
        

        self._header = header

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

