# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmUserScheduleAdherenceUpdatedMuTopicActivityCodeReference
    from . import WfmUserScheduleAdherenceUpdatedMuTopicQueueReference
    from . import WfmUserScheduleAdherenceUpdatedMuTopicRealTimeAdherenceExplanation
    from . import WfmUserScheduleAdherenceUpdatedMuTopicUriReference
    from . import WfmUserScheduleAdherenceUpdatedMuTopicUserNextActivityReminder
    from . import WfmUserScheduleAdherenceUpdatedMuTopicUserReference

class WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user': 'WfmUserScheduleAdherenceUpdatedMuTopicUserReference',
            'management_unit_id': 'str',
            'team': 'WfmUserScheduleAdherenceUpdatedMuTopicUriReference',
            'scheduled_activity_category': 'str',
            'scheduled_activity_code': 'WfmUserScheduleAdherenceUpdatedMuTopicActivityCodeReference',
            'system_presence': 'str',
            'organization_secondary_presence_id': 'str',
            'routing_status': 'str',
            'actual_activity_category': 'str',
            'is_out_of_office': 'bool',
            'adherence_state': 'str',
            'impact': 'str',
            'adherence_explanation': 'WfmUserScheduleAdherenceUpdatedMuTopicRealTimeAdherenceExplanation',
            'adherence_change_time': 'datetime',
            'presence_update_time': 'datetime',
            'active_queues': 'list[WfmUserScheduleAdherenceUpdatedMuTopicQueueReference]',
            'active_queues_modified_time': 'datetime',
            'removed_from_management_unit': 'bool',
            'suppress_on_time_reminder': 'bool',
            'next_activity_reminders': 'list[WfmUserScheduleAdherenceUpdatedMuTopicUserNextActivityReminder]'
        }

        self.attribute_map = {
            'user': 'user',
            'management_unit_id': 'managementUnitId',
            'team': 'team',
            'scheduled_activity_category': 'scheduledActivityCategory',
            'scheduled_activity_code': 'scheduledActivityCode',
            'system_presence': 'systemPresence',
            'organization_secondary_presence_id': 'organizationSecondaryPresenceId',
            'routing_status': 'routingStatus',
            'actual_activity_category': 'actualActivityCategory',
            'is_out_of_office': 'isOutOfOffice',
            'adherence_state': 'adherenceState',
            'impact': 'impact',
            'adherence_explanation': 'adherenceExplanation',
            'adherence_change_time': 'adherenceChangeTime',
            'presence_update_time': 'presenceUpdateTime',
            'active_queues': 'activeQueues',
            'active_queues_modified_time': 'activeQueuesModifiedTime',
            'removed_from_management_unit': 'removedFromManagementUnit',
            'suppress_on_time_reminder': 'suppressOnTimeReminder',
            'next_activity_reminders': 'nextActivityReminders'
        }

        self._user = None
        self._management_unit_id = None
        self._team = None
        self._scheduled_activity_category = None
        self._scheduled_activity_code = None
        self._system_presence = None
        self._organization_secondary_presence_id = None
        self._routing_status = None
        self._actual_activity_category = None
        self._is_out_of_office = None
        self._adherence_state = None
        self._impact = None
        self._adherence_explanation = None
        self._adherence_change_time = None
        self._presence_update_time = None
        self._active_queues = None
        self._active_queues_modified_time = None
        self._removed_from_management_unit = None
        self._suppress_on_time_reminder = None
        self._next_activity_reminders = None

    @property
    def user(self) -> 'WfmUserScheduleAdherenceUpdatedMuTopicUserReference':
        """
        Gets the user of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The user of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: WfmUserScheduleAdherenceUpdatedMuTopicUserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'WfmUserScheduleAdherenceUpdatedMuTopicUserReference') -> None:
        """
        Sets the user of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param user: The user of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: WfmUserScheduleAdherenceUpdatedMuTopicUserReference
        """
        

        self._user = user

    @property
    def management_unit_id(self) -> str:
        """
        Gets the management_unit_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The management_unit_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._management_unit_id

    @management_unit_id.setter
    def management_unit_id(self, management_unit_id: str) -> None:
        """
        Sets the management_unit_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param management_unit_id: The management_unit_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        

        self._management_unit_id = management_unit_id

    @property
    def team(self) -> 'WfmUserScheduleAdherenceUpdatedMuTopicUriReference':
        """
        Gets the team of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The team of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: WfmUserScheduleAdherenceUpdatedMuTopicUriReference
        """
        return self._team

    @team.setter
    def team(self, team: 'WfmUserScheduleAdherenceUpdatedMuTopicUriReference') -> None:
        """
        Sets the team of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param team: The team of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: WfmUserScheduleAdherenceUpdatedMuTopicUriReference
        """
        

        self._team = team

    @property
    def scheduled_activity_category(self) -> str:
        """
        Gets the scheduled_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The scheduled_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._scheduled_activity_category

    @scheduled_activity_category.setter
    def scheduled_activity_category(self, scheduled_activity_category: str) -> None:
        """
        Sets the scheduled_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param scheduled_activity_category: The scheduled_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        

        self._scheduled_activity_category = scheduled_activity_category

    @property
    def scheduled_activity_code(self) -> 'WfmUserScheduleAdherenceUpdatedMuTopicActivityCodeReference':
        """
        Gets the scheduled_activity_code of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The scheduled_activity_code of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: WfmUserScheduleAdherenceUpdatedMuTopicActivityCodeReference
        """
        return self._scheduled_activity_code

    @scheduled_activity_code.setter
    def scheduled_activity_code(self, scheduled_activity_code: 'WfmUserScheduleAdherenceUpdatedMuTopicActivityCodeReference') -> None:
        """
        Sets the scheduled_activity_code of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param scheduled_activity_code: The scheduled_activity_code of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: WfmUserScheduleAdherenceUpdatedMuTopicActivityCodeReference
        """
        

        self._scheduled_activity_code = scheduled_activity_code

    @property
    def system_presence(self) -> str:
        """
        Gets the system_presence of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The system_presence of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._system_presence

    @system_presence.setter
    def system_presence(self, system_presence: str) -> None:
        """
        Sets the system_presence of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param system_presence: The system_presence of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        

        self._system_presence = system_presence

    @property
    def organization_secondary_presence_id(self) -> str:
        """
        Gets the organization_secondary_presence_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The organization_secondary_presence_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._organization_secondary_presence_id

    @organization_secondary_presence_id.setter
    def organization_secondary_presence_id(self, organization_secondary_presence_id: str) -> None:
        """
        Sets the organization_secondary_presence_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param organization_secondary_presence_id: The organization_secondary_presence_id of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        

        self._organization_secondary_presence_id = organization_secondary_presence_id

    @property
    def routing_status(self) -> str:
        """
        Gets the routing_status of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The routing_status of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._routing_status

    @routing_status.setter
    def routing_status(self, routing_status: str) -> None:
        """
        Sets the routing_status of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param routing_status: The routing_status of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        if isinstance(routing_status, int):
            routing_status = str(routing_status)
        allowed_values = ["__EMPTY__", "OFF_QUEUE", "IDLE", "INTERACTING", "NOT_RESPONDING", "COMMUNICATING", "OFFLINE"]
        if routing_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for routing_status -> " + routing_status)
            self._routing_status = "outdated_sdk_version"
        else:
            self._routing_status = routing_status

    @property
    def actual_activity_category(self) -> str:
        """
        Gets the actual_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The actual_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._actual_activity_category

    @actual_activity_category.setter
    def actual_activity_category(self, actual_activity_category: str) -> None:
        """
        Sets the actual_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param actual_activity_category: The actual_activity_category of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        

        self._actual_activity_category = actual_activity_category

    @property
    def is_out_of_office(self) -> bool:
        """
        Gets the is_out_of_office of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The is_out_of_office of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: bool
        """
        return self._is_out_of_office

    @is_out_of_office.setter
    def is_out_of_office(self, is_out_of_office: bool) -> None:
        """
        Sets the is_out_of_office of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param is_out_of_office: The is_out_of_office of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: bool
        """
        

        self._is_out_of_office = is_out_of_office

    @property
    def adherence_state(self) -> str:
        """
        Gets the adherence_state of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The adherence_state of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._adherence_state

    @adherence_state.setter
    def adherence_state(self, adherence_state: str) -> None:
        """
        Sets the adherence_state of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param adherence_state: The adherence_state of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        if isinstance(adherence_state, int):
            adherence_state = str(adherence_state)
        allowed_values = ["InAdherence", "OutOfAdherence", "Unscheduled", "Unknown", "Ignored", "Explained"]
        if adherence_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for adherence_state -> " + adherence_state)
            self._adherence_state = "outdated_sdk_version"
        else:
            self._adherence_state = adherence_state

    @property
    def impact(self) -> str:
        """
        Gets the impact of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The impact of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: str
        """
        return self._impact

    @impact.setter
    def impact(self, impact: str) -> None:
        """
        Sets the impact of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param impact: The impact of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: str
        """
        

        self._impact = impact

    @property
    def adherence_explanation(self) -> 'WfmUserScheduleAdherenceUpdatedMuTopicRealTimeAdherenceExplanation':
        """
        Gets the adherence_explanation of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The adherence_explanation of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: WfmUserScheduleAdherenceUpdatedMuTopicRealTimeAdherenceExplanation
        """
        return self._adherence_explanation

    @adherence_explanation.setter
    def adherence_explanation(self, adherence_explanation: 'WfmUserScheduleAdherenceUpdatedMuTopicRealTimeAdherenceExplanation') -> None:
        """
        Sets the adherence_explanation of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param adherence_explanation: The adherence_explanation of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: WfmUserScheduleAdherenceUpdatedMuTopicRealTimeAdherenceExplanation
        """
        

        self._adherence_explanation = adherence_explanation

    @property
    def adherence_change_time(self) -> datetime:
        """
        Gets the adherence_change_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The adherence_change_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: datetime
        """
        return self._adherence_change_time

    @adherence_change_time.setter
    def adherence_change_time(self, adherence_change_time: datetime) -> None:
        """
        Sets the adherence_change_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param adherence_change_time: The adherence_change_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: datetime
        """
        

        self._adherence_change_time = adherence_change_time

    @property
    def presence_update_time(self) -> datetime:
        """
        Gets the presence_update_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The presence_update_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: datetime
        """
        return self._presence_update_time

    @presence_update_time.setter
    def presence_update_time(self, presence_update_time: datetime) -> None:
        """
        Sets the presence_update_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param presence_update_time: The presence_update_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: datetime
        """
        

        self._presence_update_time = presence_update_time

    @property
    def active_queues(self) -> List['WfmUserScheduleAdherenceUpdatedMuTopicQueueReference']:
        """
        Gets the active_queues of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The active_queues of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: list[WfmUserScheduleAdherenceUpdatedMuTopicQueueReference]
        """
        return self._active_queues

    @active_queues.setter
    def active_queues(self, active_queues: List['WfmUserScheduleAdherenceUpdatedMuTopicQueueReference']) -> None:
        """
        Sets the active_queues of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param active_queues: The active_queues of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: list[WfmUserScheduleAdherenceUpdatedMuTopicQueueReference]
        """
        

        self._active_queues = active_queues

    @property
    def active_queues_modified_time(self) -> datetime:
        """
        Gets the active_queues_modified_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The active_queues_modified_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: datetime
        """
        return self._active_queues_modified_time

    @active_queues_modified_time.setter
    def active_queues_modified_time(self, active_queues_modified_time: datetime) -> None:
        """
        Sets the active_queues_modified_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param active_queues_modified_time: The active_queues_modified_time of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: datetime
        """
        

        self._active_queues_modified_time = active_queues_modified_time

    @property
    def removed_from_management_unit(self) -> bool:
        """
        Gets the removed_from_management_unit of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The removed_from_management_unit of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: bool
        """
        return self._removed_from_management_unit

    @removed_from_management_unit.setter
    def removed_from_management_unit(self, removed_from_management_unit: bool) -> None:
        """
        Sets the removed_from_management_unit of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param removed_from_management_unit: The removed_from_management_unit of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: bool
        """
        

        self._removed_from_management_unit = removed_from_management_unit

    @property
    def suppress_on_time_reminder(self) -> bool:
        """
        Gets the suppress_on_time_reminder of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The suppress_on_time_reminder of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: bool
        """
        return self._suppress_on_time_reminder

    @suppress_on_time_reminder.setter
    def suppress_on_time_reminder(self, suppress_on_time_reminder: bool) -> None:
        """
        Sets the suppress_on_time_reminder of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param suppress_on_time_reminder: The suppress_on_time_reminder of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: bool
        """
        

        self._suppress_on_time_reminder = suppress_on_time_reminder

    @property
    def next_activity_reminders(self) -> List['WfmUserScheduleAdherenceUpdatedMuTopicUserNextActivityReminder']:
        """
        Gets the next_activity_reminders of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :return: The next_activity_reminders of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :rtype: list[WfmUserScheduleAdherenceUpdatedMuTopicUserNextActivityReminder]
        """
        return self._next_activity_reminders

    @next_activity_reminders.setter
    def next_activity_reminders(self, next_activity_reminders: List['WfmUserScheduleAdherenceUpdatedMuTopicUserNextActivityReminder']) -> None:
        """
        Sets the next_activity_reminders of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.


        :param next_activity_reminders: The next_activity_reminders of this WfmUserScheduleAdherenceUpdatedMuTopicUserScheduleAdherenceUpdate.
        :type: list[WfmUserScheduleAdherenceUpdatedMuTopicUserNextActivityReminder]
        """
        

        self._next_activity_reminders = next_activity_reminders

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

