# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmHistoricalAdherenceBulkUserResult

class WfmHistoricalAdherenceBulkResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmHistoricalAdherenceBulkResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_date': 'datetime',
            'end_date': 'datetime',
            'management_unit_id': 'str',
            'user_results': 'list[WfmHistoricalAdherenceBulkUserResult]',
            'lookup_id_to_secondary_presence_id': 'dict(str, str)'
        }

        self.attribute_map = {
            'start_date': 'startDate',
            'end_date': 'endDate',
            'management_unit_id': 'managementUnitId',
            'user_results': 'userResults',
            'lookup_id_to_secondary_presence_id': 'lookupIdToSecondaryPresenceId'
        }

        self._start_date = None
        self._end_date = None
        self._management_unit_id = None
        self._user_results = None
        self._lookup_id_to_secondary_presence_id = None

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this WfmHistoricalAdherenceBulkResult.
        Beginning of the date range for this result in ISO-8601 format

        :return: The start_date of this WfmHistoricalAdherenceBulkResult.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this WfmHistoricalAdherenceBulkResult.
        Beginning of the date range for this result in ISO-8601 format

        :param start_date: The start_date of this WfmHistoricalAdherenceBulkResult.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self) -> datetime:
        """
        Gets the end_date of this WfmHistoricalAdherenceBulkResult.
        End of the date range for this result in ISO-8601 format

        :return: The end_date of this WfmHistoricalAdherenceBulkResult.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date: datetime) -> None:
        """
        Sets the end_date of this WfmHistoricalAdherenceBulkResult.
        End of the date range for this result in ISO-8601 format

        :param end_date: The end_date of this WfmHistoricalAdherenceBulkResult.
        :type: datetime
        """
        

        self._end_date = end_date

    @property
    def management_unit_id(self) -> str:
        """
        Gets the management_unit_id of this WfmHistoricalAdherenceBulkResult.
        The ID of the management unit for this result

        :return: The management_unit_id of this WfmHistoricalAdherenceBulkResult.
        :rtype: str
        """
        return self._management_unit_id

    @management_unit_id.setter
    def management_unit_id(self, management_unit_id: str) -> None:
        """
        Sets the management_unit_id of this WfmHistoricalAdherenceBulkResult.
        The ID of the management unit for this result

        :param management_unit_id: The management_unit_id of this WfmHistoricalAdherenceBulkResult.
        :type: str
        """
        

        self._management_unit_id = management_unit_id

    @property
    def user_results(self) -> List['WfmHistoricalAdherenceBulkUserResult']:
        """
        Gets the user_results of this WfmHistoricalAdherenceBulkResult.
        The individual results for each user

        :return: The user_results of this WfmHistoricalAdherenceBulkResult.
        :rtype: list[WfmHistoricalAdherenceBulkUserResult]
        """
        return self._user_results

    @user_results.setter
    def user_results(self, user_results: List['WfmHistoricalAdherenceBulkUserResult']) -> None:
        """
        Sets the user_results of this WfmHistoricalAdherenceBulkResult.
        The individual results for each user

        :param user_results: The user_results of this WfmHistoricalAdherenceBulkResult.
        :type: list[WfmHistoricalAdherenceBulkUserResult]
        """
        

        self._user_results = user_results

    @property
    def lookup_id_to_secondary_presence_id(self) -> Dict[str, str]:
        """
        Gets the lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceBulkResult.
        Map of secondary presence lookup ID to corresponding secondary presence ID

        :return: The lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceBulkResult.
        :rtype: dict(str, str)
        """
        return self._lookup_id_to_secondary_presence_id

    @lookup_id_to_secondary_presence_id.setter
    def lookup_id_to_secondary_presence_id(self, lookup_id_to_secondary_presence_id: Dict[str, str]) -> None:
        """
        Sets the lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceBulkResult.
        Map of secondary presence lookup ID to corresponding secondary presence ID

        :param lookup_id_to_secondary_presence_id: The lookup_id_to_secondary_presence_id of this WfmHistoricalAdherenceBulkResult.
        :type: dict(str, str)
        """
        

        self._lookup_id_to_secondary_presence_id = lookup_id_to_secondary_presence_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

