# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsResults
    from . import WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuShortTermForecastReference

class WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'business_unit_id': 'str',
            'state': 'str',
            'forecast': 'WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuShortTermForecastReference',
            'week_count': 'int',
            'interval_length_minutes': 'int',
            'reference_start_date': 'datetime',
            'results': 'list[WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsResults]'
        }

        self.attribute_map = {
            'business_unit_id': 'businessUnitId',
            'state': 'state',
            'forecast': 'forecast',
            'week_count': 'weekCount',
            'interval_length_minutes': 'intervalLengthMinutes',
            'reference_start_date': 'referenceStartDate',
            'results': 'results'
        }

        self._business_unit_id = None
        self._state = None
        self._forecast = None
        self._week_count = None
        self._interval_length_minutes = None
        self._reference_start_date = None
        self._results = None

    @property
    def business_unit_id(self) -> str:
        """
        Gets the business_unit_id of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :return: The business_unit_id of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :rtype: str
        """
        return self._business_unit_id

    @business_unit_id.setter
    def business_unit_id(self, business_unit_id: str) -> None:
        """
        Sets the business_unit_id of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :param business_unit_id: The business_unit_id of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :type: str
        """
        

        self._business_unit_id = business_unit_id

    @property
    def state(self) -> str:
        """
        Gets the state of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :return: The state of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :param state: The state of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Processing", "Complete", "Canceled", "Error"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def forecast(self) -> 'WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuShortTermForecastReference':
        """
        Gets the forecast of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :return: The forecast of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :rtype: WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuShortTermForecastReference
        """
        return self._forecast

    @forecast.setter
    def forecast(self, forecast: 'WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuShortTermForecastReference') -> None:
        """
        Sets the forecast of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :param forecast: The forecast of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :type: WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuShortTermForecastReference
        """
        

        self._forecast = forecast

    @property
    def week_count(self) -> int:
        """
        Gets the week_count of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :return: The week_count of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :rtype: int
        """
        return self._week_count

    @week_count.setter
    def week_count(self, week_count: int) -> None:
        """
        Sets the week_count of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :param week_count: The week_count of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :type: int
        """
        

        self._week_count = week_count

    @property
    def interval_length_minutes(self) -> int:
        """
        Gets the interval_length_minutes of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :return: The interval_length_minutes of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :rtype: int
        """
        return self._interval_length_minutes

    @interval_length_minutes.setter
    def interval_length_minutes(self, interval_length_minutes: int) -> None:
        """
        Sets the interval_length_minutes of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :param interval_length_minutes: The interval_length_minutes of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :type: int
        """
        

        self._interval_length_minutes = interval_length_minutes

    @property
    def reference_start_date(self) -> datetime:
        """
        Gets the reference_start_date of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :return: The reference_start_date of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :rtype: datetime
        """
        return self._reference_start_date

    @reference_start_date.setter
    def reference_start_date(self, reference_start_date: datetime) -> None:
        """
        Sets the reference_start_date of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :param reference_start_date: The reference_start_date of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :type: datetime
        """
        

        self._reference_start_date = reference_start_date

    @property
    def results(self) -> List['WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsResults']:
        """
        Gets the results of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :return: The results of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :rtype: list[WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsResults]
        """
        return self._results

    @results.setter
    def results(self, results: List['WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsResults']) -> None:
        """
        Sets the results of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.


        :param results: The results of this WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsNotification.
        :type: list[WfmBuShortTermForecastStaffingRequirementsGenerateCompleteTopicBuForecastShortTermStaffingRequirementsResults]
        """
        

        self._results = results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

