# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmBuIntradayDataUpdateTopicBuIntradayForecastData
    from . import WfmBuIntradayDataUpdateTopicBuIntradayScheduleData
    from . import WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData

class WfmBuIntradayDataUpdateTopicBuIntradayDataGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmBuIntradayDataUpdateTopicBuIntradayDataGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'media_type': 'str',
            'forecast_data_summary': 'WfmBuIntradayDataUpdateTopicBuIntradayForecastData',
            'forecast_data_per_interval': 'list[WfmBuIntradayDataUpdateTopicBuIntradayForecastData]',
            'schedule_data_summary': 'WfmBuIntradayDataUpdateTopicBuIntradayScheduleData',
            'schedule_data_per_interval': 'list[WfmBuIntradayDataUpdateTopicBuIntradayScheduleData]',
            'performance_prediction_data_summary': 'WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData',
            'performance_prediction_data_per_interval': 'list[WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData]'
        }

        self.attribute_map = {
            'media_type': 'mediaType',
            'forecast_data_summary': 'forecastDataSummary',
            'forecast_data_per_interval': 'forecastDataPerInterval',
            'schedule_data_summary': 'scheduleDataSummary',
            'schedule_data_per_interval': 'scheduleDataPerInterval',
            'performance_prediction_data_summary': 'performancePredictionDataSummary',
            'performance_prediction_data_per_interval': 'performancePredictionDataPerInterval'
        }

        self._media_type = None
        self._forecast_data_summary = None
        self._forecast_data_per_interval = None
        self._schedule_data_summary = None
        self._schedule_data_per_interval = None
        self._performance_prediction_data_summary = None
        self._performance_prediction_data_per_interval = None

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :return: The media_type of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :param media_type: The media_type of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Voice", "Chat", "Email", "Callback", "Message", "Workitem"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def forecast_data_summary(self) -> 'WfmBuIntradayDataUpdateTopicBuIntradayForecastData':
        """
        Gets the forecast_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :return: The forecast_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :rtype: WfmBuIntradayDataUpdateTopicBuIntradayForecastData
        """
        return self._forecast_data_summary

    @forecast_data_summary.setter
    def forecast_data_summary(self, forecast_data_summary: 'WfmBuIntradayDataUpdateTopicBuIntradayForecastData') -> None:
        """
        Sets the forecast_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :param forecast_data_summary: The forecast_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :type: WfmBuIntradayDataUpdateTopicBuIntradayForecastData
        """
        

        self._forecast_data_summary = forecast_data_summary

    @property
    def forecast_data_per_interval(self) -> List['WfmBuIntradayDataUpdateTopicBuIntradayForecastData']:
        """
        Gets the forecast_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :return: The forecast_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :rtype: list[WfmBuIntradayDataUpdateTopicBuIntradayForecastData]
        """
        return self._forecast_data_per_interval

    @forecast_data_per_interval.setter
    def forecast_data_per_interval(self, forecast_data_per_interval: List['WfmBuIntradayDataUpdateTopicBuIntradayForecastData']) -> None:
        """
        Sets the forecast_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :param forecast_data_per_interval: The forecast_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :type: list[WfmBuIntradayDataUpdateTopicBuIntradayForecastData]
        """
        

        self._forecast_data_per_interval = forecast_data_per_interval

    @property
    def schedule_data_summary(self) -> 'WfmBuIntradayDataUpdateTopicBuIntradayScheduleData':
        """
        Gets the schedule_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :return: The schedule_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :rtype: WfmBuIntradayDataUpdateTopicBuIntradayScheduleData
        """
        return self._schedule_data_summary

    @schedule_data_summary.setter
    def schedule_data_summary(self, schedule_data_summary: 'WfmBuIntradayDataUpdateTopicBuIntradayScheduleData') -> None:
        """
        Sets the schedule_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :param schedule_data_summary: The schedule_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :type: WfmBuIntradayDataUpdateTopicBuIntradayScheduleData
        """
        

        self._schedule_data_summary = schedule_data_summary

    @property
    def schedule_data_per_interval(self) -> List['WfmBuIntradayDataUpdateTopicBuIntradayScheduleData']:
        """
        Gets the schedule_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :return: The schedule_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :rtype: list[WfmBuIntradayDataUpdateTopicBuIntradayScheduleData]
        """
        return self._schedule_data_per_interval

    @schedule_data_per_interval.setter
    def schedule_data_per_interval(self, schedule_data_per_interval: List['WfmBuIntradayDataUpdateTopicBuIntradayScheduleData']) -> None:
        """
        Sets the schedule_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :param schedule_data_per_interval: The schedule_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :type: list[WfmBuIntradayDataUpdateTopicBuIntradayScheduleData]
        """
        

        self._schedule_data_per_interval = schedule_data_per_interval

    @property
    def performance_prediction_data_summary(self) -> 'WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData':
        """
        Gets the performance_prediction_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :return: The performance_prediction_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :rtype: WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData
        """
        return self._performance_prediction_data_summary

    @performance_prediction_data_summary.setter
    def performance_prediction_data_summary(self, performance_prediction_data_summary: 'WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData') -> None:
        """
        Sets the performance_prediction_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :param performance_prediction_data_summary: The performance_prediction_data_summary of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :type: WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData
        """
        

        self._performance_prediction_data_summary = performance_prediction_data_summary

    @property
    def performance_prediction_data_per_interval(self) -> List['WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData']:
        """
        Gets the performance_prediction_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :return: The performance_prediction_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :rtype: list[WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData]
        """
        return self._performance_prediction_data_per_interval

    @performance_prediction_data_per_interval.setter
    def performance_prediction_data_per_interval(self, performance_prediction_data_per_interval: List['WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData']) -> None:
        """
        Sets the performance_prediction_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.


        :param performance_prediction_data_per_interval: The performance_prediction_data_per_interval of this WfmBuIntradayDataUpdateTopicBuIntradayDataGroup.
        :type: list[WfmBuIntradayDataUpdateTopicIntradayPerformancePredictionData]
        """
        

        self._performance_prediction_data_per_interval = performance_prediction_data_per_interval

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

