# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CustomEventAttribute
    from . import JourneyCampaign
    from . import JourneyGeolocation
    from . import Referrer
    from . import ResponsePage
    from . import WebEventBrowser
    from . import WebEventDevice
    from . import WebEventResponseSession

class WebEventResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WebEventResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'customer_id': 'str',
            'event_name': 'str',
            'customer_id_type': 'str',
            'page': 'ResponsePage',
            'user_agent_string': 'str',
            'browser': 'WebEventBrowser',
            'device': 'WebEventDevice',
            'search_query': 'str',
            'ip_organization': 'str',
            'geolocation': 'JourneyGeolocation',
            'mkt_campaign': 'JourneyCampaign',
            'session': 'WebEventResponseSession',
            'referrer': 'Referrer',
            'attributes': 'dict(str, CustomEventAttribute)',
            'traits': 'dict(str, CustomEventAttribute)',
            'authenticated': 'bool',
            'created_date': 'datetime'
        }

        self.attribute_map = {
            'customer_id': 'customerId',
            'event_name': 'eventName',
            'customer_id_type': 'customerIdType',
            'page': 'page',
            'user_agent_string': 'userAgentString',
            'browser': 'browser',
            'device': 'device',
            'search_query': 'searchQuery',
            'ip_organization': 'ipOrganization',
            'geolocation': 'geolocation',
            'mkt_campaign': 'mktCampaign',
            'session': 'session',
            'referrer': 'referrer',
            'attributes': 'attributes',
            'traits': 'traits',
            'authenticated': 'authenticated',
            'created_date': 'createdDate'
        }

        self._customer_id = None
        self._event_name = None
        self._customer_id_type = None
        self._page = None
        self._user_agent_string = None
        self._browser = None
        self._device = None
        self._search_query = None
        self._ip_organization = None
        self._geolocation = None
        self._mkt_campaign = None
        self._session = None
        self._referrer = None
        self._attributes = None
        self._traits = None
        self._authenticated = None
        self._created_date = None

    @property
    def customer_id(self) -> str:
        """
        Gets the customer_id of this WebEventResponse.
        Identifier of the customer in the source of the event.

        :return: The customer_id of this WebEventResponse.
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id: str) -> None:
        """
        Sets the customer_id of this WebEventResponse.
        Identifier of the customer in the source of the event.

        :param customer_id: The customer_id of this WebEventResponse.
        :type: str
        """
        

        self._customer_id = customer_id

    @property
    def event_name(self) -> str:
        """
        Gets the event_name of this WebEventResponse.
        Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. page_viewed, order_completed, user_registered.

        :return: The event_name of this WebEventResponse.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name: str) -> None:
        """
        Sets the event_name of this WebEventResponse.
        Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. page_viewed, order_completed, user_registered.

        :param event_name: The event_name of this WebEventResponse.
        :type: str
        """
        

        self._event_name = event_name

    @property
    def customer_id_type(self) -> str:
        """
        Gets the customer_id_type of this WebEventResponse.
        Type of identifier for the customer ID (e.g., cookie).

        :return: The customer_id_type of this WebEventResponse.
        :rtype: str
        """
        return self._customer_id_type

    @customer_id_type.setter
    def customer_id_type(self, customer_id_type: str) -> None:
        """
        Sets the customer_id_type of this WebEventResponse.
        Type of identifier for the customer ID (e.g., cookie).

        :param customer_id_type: The customer_id_type of this WebEventResponse.
        :type: str
        """
        

        self._customer_id_type = customer_id_type

    @property
    def page(self) -> 'ResponsePage':
        """
        Gets the page of this WebEventResponse.
        The webpage where the user interaction occurred.

        :return: The page of this WebEventResponse.
        :rtype: ResponsePage
        """
        return self._page

    @page.setter
    def page(self, page: 'ResponsePage') -> None:
        """
        Sets the page of this WebEventResponse.
        The webpage where the user interaction occurred.

        :param page: The page of this WebEventResponse.
        :type: ResponsePage
        """
        

        self._page = page

    @property
    def user_agent_string(self) -> str:
        """
        Gets the user_agent_string of this WebEventResponse.
        HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :return: The user_agent_string of this WebEventResponse.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string: str) -> None:
        """
        Sets the user_agent_string of this WebEventResponse.
        HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :param user_agent_string: The user_agent_string of this WebEventResponse.
        :type: str
        """
        

        self._user_agent_string = user_agent_string

    @property
    def browser(self) -> 'WebEventBrowser':
        """
        Gets the browser of this WebEventResponse.
        Customer's browser.

        :return: The browser of this WebEventResponse.
        :rtype: WebEventBrowser
        """
        return self._browser

    @browser.setter
    def browser(self, browser: 'WebEventBrowser') -> None:
        """
        Sets the browser of this WebEventResponse.
        Customer's browser.

        :param browser: The browser of this WebEventResponse.
        :type: WebEventBrowser
        """
        

        self._browser = browser

    @property
    def device(self) -> 'WebEventDevice':
        """
        Gets the device of this WebEventResponse.
        Customer's device.

        :return: The device of this WebEventResponse.
        :rtype: WebEventDevice
        """
        return self._device

    @device.setter
    def device(self, device: 'WebEventDevice') -> None:
        """
        Sets the device of this WebEventResponse.
        Customer's device.

        :param device: The device of this WebEventResponse.
        :type: WebEventDevice
        """
        

        self._device = device

    @property
    def search_query(self) -> str:
        """
        Gets the search_query of this WebEventResponse.
        Represents the keywords in a customer search query.

        :return: The search_query of this WebEventResponse.
        :rtype: str
        """
        return self._search_query

    @search_query.setter
    def search_query(self, search_query: str) -> None:
        """
        Sets the search_query of this WebEventResponse.
        Represents the keywords in a customer search query.

        :param search_query: The search_query of this WebEventResponse.
        :type: str
        """
        

        self._search_query = search_query

    @property
    def ip_organization(self) -> str:
        """
        Gets the ip_organization of this WebEventResponse.
        Customer's IP-based organization or ISP name.

        :return: The ip_organization of this WebEventResponse.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization: str) -> None:
        """
        Sets the ip_organization of this WebEventResponse.
        Customer's IP-based organization or ISP name.

        :param ip_organization: The ip_organization of this WebEventResponse.
        :type: str
        """
        

        self._ip_organization = ip_organization

    @property
    def geolocation(self) -> 'JourneyGeolocation':
        """
        Gets the geolocation of this WebEventResponse.
        Customer's geolocation.

        :return: The geolocation of this WebEventResponse.
        :rtype: JourneyGeolocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'JourneyGeolocation') -> None:
        """
        Sets the geolocation of this WebEventResponse.
        Customer's geolocation.

        :param geolocation: The geolocation of this WebEventResponse.
        :type: JourneyGeolocation
        """
        

        self._geolocation = geolocation

    @property
    def mkt_campaign(self) -> 'JourneyCampaign':
        """
        Gets the mkt_campaign of this WebEventResponse.
        Urchin Tracking Module (UTM) parameters used to track the effectiveness of online marketing campaigns.

        :return: The mkt_campaign of this WebEventResponse.
        :rtype: JourneyCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign: 'JourneyCampaign') -> None:
        """
        Sets the mkt_campaign of this WebEventResponse.
        Urchin Tracking Module (UTM) parameters used to track the effectiveness of online marketing campaigns.

        :param mkt_campaign: The mkt_campaign of this WebEventResponse.
        :type: JourneyCampaign
        """
        

        self._mkt_campaign = mkt_campaign

    @property
    def session(self) -> 'WebEventResponseSession':
        """
        Gets the session of this WebEventResponse.
        The session that the event belongs to.

        :return: The session of this WebEventResponse.
        :rtype: WebEventResponseSession
        """
        return self._session

    @session.setter
    def session(self, session: 'WebEventResponseSession') -> None:
        """
        Sets the session of this WebEventResponse.
        The session that the event belongs to.

        :param session: The session of this WebEventResponse.
        :type: WebEventResponseSession
        """
        

        self._session = session

    @property
    def referrer(self) -> 'Referrer':
        """
        Gets the referrer of this WebEventResponse.
        Identifies the web page that originally generated the request for the current page being viewed.

        :return: The referrer of this WebEventResponse.
        :rtype: Referrer
        """
        return self._referrer

    @referrer.setter
    def referrer(self, referrer: 'Referrer') -> None:
        """
        Sets the referrer of this WebEventResponse.
        Identifies the web page that originally generated the request for the current page being viewed.

        :param referrer: The referrer of this WebEventResponse.
        :type: Referrer
        """
        

        self._referrer = referrer

    @property
    def attributes(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the attributes of this WebEventResponse.
        User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.

        :return: The attributes of this WebEventResponse.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the attributes of this WebEventResponse.
        User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.

        :param attributes: The attributes of this WebEventResponse.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._attributes = attributes

    @property
    def traits(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the traits of this WebEventResponse.
        Traits are attributes intrinsic to the customer that may be sent in selected events, (e.g. email, lastName, cellPhone). Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.

        :return: The traits of this WebEventResponse.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._traits

    @traits.setter
    def traits(self, traits: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the traits of this WebEventResponse.
        Traits are attributes intrinsic to the customer that may be sent in selected events, (e.g. email, lastName, cellPhone). Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.

        :param traits: The traits of this WebEventResponse.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._traits = traits

    @property
    def authenticated(self) -> bool:
        """
        Gets the authenticated of this WebEventResponse.
        Indicates whether the event was produced during an authenticated session.

        :return: The authenticated of this WebEventResponse.
        :rtype: bool
        """
        return self._authenticated

    @authenticated.setter
    def authenticated(self, authenticated: bool) -> None:
        """
        Sets the authenticated of this WebEventResponse.
        Indicates whether the event was produced during an authenticated session.

        :param authenticated: The authenticated of this WebEventResponse.
        :type: bool
        """
        

        self._authenticated = authenticated

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this WebEventResponse.
        UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this WebEventResponse.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this WebEventResponse.
        UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this WebEventResponse.
        :type: datetime
        """
        

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

