# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ActionEventActionMap
    from . import AddressableEntityRef
    from . import Browser
    from . import Device
    from . import EventAction
    from . import JourneyCampaign
    from . import JourneyGeolocation
    from . import Referrer

class WebActionEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WebActionEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'EventAction',
            'action_map': 'ActionEventActionMap',
            'action_target': 'AddressableEntityRef',
            'time_to_disposition': 'int',
            'error_code': 'str',
            'error_message': 'str',
            'user_agent_string': 'str',
            'browser': 'Browser',
            'device': 'Device',
            'geolocation': 'JourneyGeolocation',
            'ip_address': 'str',
            'ip_organization': 'str',
            'mkt_campaign': 'JourneyCampaign',
            'visit_referrer': 'Referrer'
        }

        self.attribute_map = {
            'action': 'action',
            'action_map': 'actionMap',
            'action_target': 'actionTarget',
            'time_to_disposition': 'timeToDisposition',
            'error_code': 'errorCode',
            'error_message': 'errorMessage',
            'user_agent_string': 'userAgentString',
            'browser': 'browser',
            'device': 'device',
            'geolocation': 'geolocation',
            'ip_address': 'ipAddress',
            'ip_organization': 'ipOrganization',
            'mkt_campaign': 'mktCampaign',
            'visit_referrer': 'visitReferrer'
        }

        self._action = None
        self._action_map = None
        self._action_target = None
        self._time_to_disposition = None
        self._error_code = None
        self._error_message = None
        self._user_agent_string = None
        self._browser = None
        self._device = None
        self._geolocation = None
        self._ip_address = None
        self._ip_organization = None
        self._mkt_campaign = None
        self._visit_referrer = None

    @property
    def action(self) -> 'EventAction':
        """
        Gets the action of this WebActionEvent.
        The action that triggered the event.

        :return: The action of this WebActionEvent.
        :rtype: EventAction
        """
        return self._action

    @action.setter
    def action(self, action: 'EventAction') -> None:
        """
        Sets the action of this WebActionEvent.
        The action that triggered the event.

        :param action: The action of this WebActionEvent.
        :type: EventAction
        """
        

        self._action = action

    @property
    def action_map(self) -> 'ActionEventActionMap':
        """
        Gets the action_map of this WebActionEvent.
        The action map that triggered the action.

        :return: The action_map of this WebActionEvent.
        :rtype: ActionEventActionMap
        """
        return self._action_map

    @action_map.setter
    def action_map(self, action_map: 'ActionEventActionMap') -> None:
        """
        Sets the action_map of this WebActionEvent.
        The action map that triggered the action.

        :param action_map: The action_map of this WebActionEvent.
        :type: ActionEventActionMap
        """
        

        self._action_map = action_map

    @property
    def action_target(self) -> 'AddressableEntityRef':
        """
        Gets the action_target of this WebActionEvent.
        The target for engagement actions.

        :return: The action_target of this WebActionEvent.
        :rtype: AddressableEntityRef
        """
        return self._action_target

    @action_target.setter
    def action_target(self, action_target: 'AddressableEntityRef') -> None:
        """
        Sets the action_target of this WebActionEvent.
        The target for engagement actions.

        :param action_target: The action_target of this WebActionEvent.
        :type: AddressableEntityRef
        """
        

        self._action_target = action_target

    @property
    def time_to_disposition(self) -> int:
        """
        Gets the time_to_disposition of this WebActionEvent.
        Milliseconds elapsed until the action is disposed.

        :return: The time_to_disposition of this WebActionEvent.
        :rtype: int
        """
        return self._time_to_disposition

    @time_to_disposition.setter
    def time_to_disposition(self, time_to_disposition: int) -> None:
        """
        Sets the time_to_disposition of this WebActionEvent.
        Milliseconds elapsed until the action is disposed.

        :param time_to_disposition: The time_to_disposition of this WebActionEvent.
        :type: int
        """
        

        self._time_to_disposition = time_to_disposition

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this WebActionEvent.
        Code of the error returned when the action fails.

        :return: The error_code of this WebActionEvent.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this WebActionEvent.
        Code of the error returned when the action fails.

        :param error_code: The error_code of this WebActionEvent.
        :type: str
        """
        

        self._error_code = error_code

    @property
    def error_message(self) -> str:
        """
        Gets the error_message of this WebActionEvent.
        Message of the error returned when the action fails.

        :return: The error_message of this WebActionEvent.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message: str) -> None:
        """
        Sets the error_message of this WebActionEvent.
        Message of the error returned when the action fails.

        :param error_message: The error_message of this WebActionEvent.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def user_agent_string(self) -> str:
        """
        Gets the user_agent_string of this WebActionEvent.
        HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :return: The user_agent_string of this WebActionEvent.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string: str) -> None:
        """
        Sets the user_agent_string of this WebActionEvent.
        HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).

        :param user_agent_string: The user_agent_string of this WebActionEvent.
        :type: str
        """
        

        self._user_agent_string = user_agent_string

    @property
    def browser(self) -> 'Browser':
        """
        Gets the browser of this WebActionEvent.
        Customer's browser.

        :return: The browser of this WebActionEvent.
        :rtype: Browser
        """
        return self._browser

    @browser.setter
    def browser(self, browser: 'Browser') -> None:
        """
        Sets the browser of this WebActionEvent.
        Customer's browser.

        :param browser: The browser of this WebActionEvent.
        :type: Browser
        """
        

        self._browser = browser

    @property
    def device(self) -> 'Device':
        """
        Gets the device of this WebActionEvent.
        Customer's device.

        :return: The device of this WebActionEvent.
        :rtype: Device
        """
        return self._device

    @device.setter
    def device(self, device: 'Device') -> None:
        """
        Sets the device of this WebActionEvent.
        Customer's device.

        :param device: The device of this WebActionEvent.
        :type: Device
        """
        

        self._device = device

    @property
    def geolocation(self) -> 'JourneyGeolocation':
        """
        Gets the geolocation of this WebActionEvent.
        Customer's geolocation.

        :return: The geolocation of this WebActionEvent.
        :rtype: JourneyGeolocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'JourneyGeolocation') -> None:
        """
        Sets the geolocation of this WebActionEvent.
        Customer's geolocation.

        :param geolocation: The geolocation of this WebActionEvent.
        :type: JourneyGeolocation
        """
        

        self._geolocation = geolocation

    @property
    def ip_address(self) -> str:
        """
        Gets the ip_address of this WebActionEvent.
        Visitor's IP address.

        :return: The ip_address of this WebActionEvent.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str) -> None:
        """
        Sets the ip_address of this WebActionEvent.
        Visitor's IP address.

        :param ip_address: The ip_address of this WebActionEvent.
        :type: str
        """
        

        self._ip_address = ip_address

    @property
    def ip_organization(self) -> str:
        """
        Gets the ip_organization of this WebActionEvent.
        Visitor's IP-based organization or ISP name.

        :return: The ip_organization of this WebActionEvent.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization: str) -> None:
        """
        Sets the ip_organization of this WebActionEvent.
        Visitor's IP-based organization or ISP name.

        :param ip_organization: The ip_organization of this WebActionEvent.
        :type: str
        """
        

        self._ip_organization = ip_organization

    @property
    def mkt_campaign(self) -> 'JourneyCampaign':
        """
        Gets the mkt_campaign of this WebActionEvent.
        Marketing / traffic source information.

        :return: The mkt_campaign of this WebActionEvent.
        :rtype: JourneyCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign: 'JourneyCampaign') -> None:
        """
        Sets the mkt_campaign of this WebActionEvent.
        Marketing / traffic source information.

        :param mkt_campaign: The mkt_campaign of this WebActionEvent.
        :type: JourneyCampaign
        """
        

        self._mkt_campaign = mkt_campaign

    @property
    def visit_referrer(self) -> 'Referrer':
        """
        Gets the visit_referrer of this WebActionEvent.
        Visit's referrer.

        :return: The visit_referrer of this WebActionEvent.
        :rtype: Referrer
        """
        return self._visit_referrer

    @visit_referrer.setter
    def visit_referrer(self, visit_referrer: 'Referrer') -> None:
        """
        Sets the visit_referrer of this WebActionEvent.
        Visit's referrer.

        :param visit_referrer: The visit_referrer of this WebActionEvent.
        :type: Referrer
        """
        

        self._visit_referrer = visit_referrer

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

