# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ValidationError

class ValidationResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ValidationResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'separator_valid': 'bool',
            'file_encoding_valid': 'bool',
            'errors': 'list[ValidationError]'
        }

        self.attribute_map = {
            'separator_valid': 'separatorValid',
            'file_encoding_valid': 'fileEncodingValid',
            'errors': 'errors'
        }

        self._separator_valid = None
        self._file_encoding_valid = None
        self._errors = None

    @property
    def separator_valid(self) -> bool:
        """
        Gets the separator_valid of this ValidationResult.
        Separator valid in the upload

        :return: The separator_valid of this ValidationResult.
        :rtype: bool
        """
        return self._separator_valid

    @separator_valid.setter
    def separator_valid(self, separator_valid: bool) -> None:
        """
        Sets the separator_valid of this ValidationResult.
        Separator valid in the upload

        :param separator_valid: The separator_valid of this ValidationResult.
        :type: bool
        """
        

        self._separator_valid = separator_valid

    @property
    def file_encoding_valid(self) -> bool:
        """
        Gets the file_encoding_valid of this ValidationResult.
        File encoding valid for the upload

        :return: The file_encoding_valid of this ValidationResult.
        :rtype: bool
        """
        return self._file_encoding_valid

    @file_encoding_valid.setter
    def file_encoding_valid(self, file_encoding_valid: bool) -> None:
        """
        Sets the file_encoding_valid of this ValidationResult.
        File encoding valid for the upload

        :param file_encoding_valid: The file_encoding_valid of this ValidationResult.
        :type: bool
        """
        

        self._file_encoding_valid = file_encoding_valid

    @property
    def errors(self) -> List['ValidationError']:
        """
        Gets the errors of this ValidationResult.
        List of errors for the upload

        :return: The errors of this ValidationResult.
        :rtype: list[ValidationError]
        """
        return self._errors

    @errors.setter
    def errors(self, errors: List['ValidationError']) -> None:
        """
        Sets the errors of this ValidationResult.
        List of errors for the upload

        :param errors: The errors of this ValidationResult.
        :type: list[ValidationError]
        """
        

        self._errors = errors

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

