# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2IntegrationPresenceEventOrganizationPresence

class V2IntegrationPresenceEventPresenceActivityEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2IntegrationPresenceEventPresenceActivityEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_id': 'str',
            'event_type': 'str',
            'source': 'str',
            'modified_date': 'datetime',
            'presence_definition': 'V2IntegrationPresenceEventOrganizationPresence',
            'message': 'str',
            'current_display_source_id': 'str',
            'previous_display_source_id': 'str'
        }

        self.attribute_map = {
            'user_id': 'userId',
            'event_type': 'eventType',
            'source': 'source',
            'modified_date': 'modifiedDate',
            'presence_definition': 'presenceDefinition',
            'message': 'message',
            'current_display_source_id': 'currentDisplaySourceId',
            'previous_display_source_id': 'previousDisplaySourceId'
        }

        self._user_id = None
        self._event_type = None
        self._source = None
        self._modified_date = None
        self._presence_definition = None
        self._message = None
        self._current_display_source_id = None
        self._previous_display_source_id = None

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The user_id of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param user_id: The user_id of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def event_type(self) -> str:
        """
        Gets the event_type of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The event_type of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type: str) -> None:
        """
        Sets the event_type of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param event_type: The event_type of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: str
        """
        if isinstance(event_type, int):
            event_type = str(event_type)
        allowed_values = ["UserPresenceStatusChanged", "UserPrimaryPresenceSourceChanged"]
        if event_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for event_type -> " + event_type)
            self._event_type = "outdated_sdk_version"
        else:
            self._event_type = event_type

    @property
    def source(self) -> str:
        """
        Gets the source of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The source of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source: str) -> None:
        """
        Sets the source of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param source: The source of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: str
        """
        

        self._source = source

    @property
    def modified_date(self) -> datetime:
        """
        Gets the modified_date of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The modified_date of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date: datetime) -> None:
        """
        Sets the modified_date of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param modified_date: The modified_date of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: datetime
        """
        

        self._modified_date = modified_date

    @property
    def presence_definition(self) -> 'V2IntegrationPresenceEventOrganizationPresence':
        """
        Gets the presence_definition of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The presence_definition of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: V2IntegrationPresenceEventOrganizationPresence
        """
        return self._presence_definition

    @presence_definition.setter
    def presence_definition(self, presence_definition: 'V2IntegrationPresenceEventOrganizationPresence') -> None:
        """
        Sets the presence_definition of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param presence_definition: The presence_definition of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: V2IntegrationPresenceEventOrganizationPresence
        """
        

        self._presence_definition = presence_definition

    @property
    def message(self) -> str:
        """
        Gets the message of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The message of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str) -> None:
        """
        Sets the message of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param message: The message of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: str
        """
        

        self._message = message

    @property
    def current_display_source_id(self) -> str:
        """
        Gets the current_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The current_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: str
        """
        return self._current_display_source_id

    @current_display_source_id.setter
    def current_display_source_id(self, current_display_source_id: str) -> None:
        """
        Sets the current_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param current_display_source_id: The current_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: str
        """
        

        self._current_display_source_id = current_display_source_id

    @property
    def previous_display_source_id(self) -> str:
        """
        Gets the previous_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.


        :return: The previous_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.
        :rtype: str
        """
        return self._previous_display_source_id

    @previous_display_source_id.setter
    def previous_display_source_id(self, previous_display_source_id: str) -> None:
        """
        Sets the previous_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.


        :param previous_display_source_id: The previous_display_source_id of this V2IntegrationPresenceEventPresenceActivityEvent.
        :type: str
        """
        

        self._previous_display_source_id = previous_display_source_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

