# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2FlowExecutionDataFlowidTopicFlow
    from . import V2FlowExecutionDataFlowidTopicJourneyActionMap
    from . import V2FlowExecutionDataFlowidTopicProcessAutomation
    from . import V2FlowExecutionDataFlowidTopicQuality
    from . import V2FlowExecutionDataFlowidTopicWorkitem

class V2FlowExecutionDataFlowidTopicInvokingContext(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2FlowExecutionDataFlowidTopicInvokingContext - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'flow': 'V2FlowExecutionDataFlowidTopicFlow',
            'journey_action_map': 'V2FlowExecutionDataFlowidTopicJourneyActionMap',
            'process_automation': 'V2FlowExecutionDataFlowidTopicProcessAutomation',
            'quality': 'V2FlowExecutionDataFlowidTopicQuality',
            'workitem': 'V2FlowExecutionDataFlowidTopicWorkitem'
        }

        self.attribute_map = {
            'flow': 'flow',
            'journey_action_map': 'journeyActionMap',
            'process_automation': 'processAutomation',
            'quality': 'quality',
            'workitem': 'workitem'
        }

        self._flow = None
        self._journey_action_map = None
        self._process_automation = None
        self._quality = None
        self._workitem = None

    @property
    def flow(self) -> 'V2FlowExecutionDataFlowidTopicFlow':
        """
        Gets the flow of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :return: The flow of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :rtype: V2FlowExecutionDataFlowidTopicFlow
        """
        return self._flow

    @flow.setter
    def flow(self, flow: 'V2FlowExecutionDataFlowidTopicFlow') -> None:
        """
        Sets the flow of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :param flow: The flow of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :type: V2FlowExecutionDataFlowidTopicFlow
        """
        

        self._flow = flow

    @property
    def journey_action_map(self) -> 'V2FlowExecutionDataFlowidTopicJourneyActionMap':
        """
        Gets the journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :return: The journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :rtype: V2FlowExecutionDataFlowidTopicJourneyActionMap
        """
        return self._journey_action_map

    @journey_action_map.setter
    def journey_action_map(self, journey_action_map: 'V2FlowExecutionDataFlowidTopicJourneyActionMap') -> None:
        """
        Sets the journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :param journey_action_map: The journey_action_map of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :type: V2FlowExecutionDataFlowidTopicJourneyActionMap
        """
        

        self._journey_action_map = journey_action_map

    @property
    def process_automation(self) -> 'V2FlowExecutionDataFlowidTopicProcessAutomation':
        """
        Gets the process_automation of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :return: The process_automation of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :rtype: V2FlowExecutionDataFlowidTopicProcessAutomation
        """
        return self._process_automation

    @process_automation.setter
    def process_automation(self, process_automation: 'V2FlowExecutionDataFlowidTopicProcessAutomation') -> None:
        """
        Sets the process_automation of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :param process_automation: The process_automation of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :type: V2FlowExecutionDataFlowidTopicProcessAutomation
        """
        

        self._process_automation = process_automation

    @property
    def quality(self) -> 'V2FlowExecutionDataFlowidTopicQuality':
        """
        Gets the quality of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :return: The quality of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :rtype: V2FlowExecutionDataFlowidTopicQuality
        """
        return self._quality

    @quality.setter
    def quality(self, quality: 'V2FlowExecutionDataFlowidTopicQuality') -> None:
        """
        Sets the quality of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :param quality: The quality of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :type: V2FlowExecutionDataFlowidTopicQuality
        """
        

        self._quality = quality

    @property
    def workitem(self) -> 'V2FlowExecutionDataFlowidTopicWorkitem':
        """
        Gets the workitem of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :return: The workitem of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :rtype: V2FlowExecutionDataFlowidTopicWorkitem
        """
        return self._workitem

    @workitem.setter
    def workitem(self, workitem: 'V2FlowExecutionDataFlowidTopicWorkitem') -> None:
        """
        Sets the workitem of this V2FlowExecutionDataFlowidTopicInvokingContext.


        :param workitem: The workitem of this V2FlowExecutionDataFlowidTopicInvokingContext.
        :type: V2FlowExecutionDataFlowidTopicWorkitem
        """
        

        self._workitem = workitem

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

