# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingFromRecipient
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingToRecipient

class V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'platform': 'str',
            'to': 'V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingToRecipient',
            'pcFrom': 'V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingFromRecipient',
            'time': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'platform': 'platform',
            'to': 'to',
            'pcFrom': 'from',
            'time': 'time'
        }

        self._id = None
        self._platform = None
        self._to = None
        self._pcFrom = None
        self._time = None

    @property
    def id(self) -> str:
        """
        Gets the id of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :return: The id of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :param id: The id of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :type: str
        """
        

        self._id = id

    @property
    def platform(self) -> str:
        """
        Gets the platform of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :return: The platform of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform: str) -> None:
        """
        Sets the platform of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :param platform: The platform of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :type: str
        """
        if isinstance(platform, int):
            platform = str(platform)
        allowed_values = ["Twitter", "Facebook", "Instagram", "Line", "Whatsapp", "WebMessaging", "Open", "Sms", "Apple"]
        if platform.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for platform -> " + platform)
            self._platform = "outdated_sdk_version"
        else:
            self._platform = platform

    @property
    def to(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingToRecipient':
        """
        Gets the to of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :return: The to of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingToRecipient
        """
        return self._to

    @to.setter
    def to(self, to: 'V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingToRecipient') -> None:
        """
        Sets the to of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :param to: The to of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingToRecipient
        """
        

        self._to = to

    @property
    def pcFrom(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingFromRecipient':
        """
        Gets the pcFrom of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :return: The pcFrom of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingFromRecipient
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom: 'V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingFromRecipient') -> None:
        """
        Sets the pcFrom of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :param pcFrom: The pcFrom of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingFromRecipient
        """
        

        self._pcFrom = pcFrom

    @property
    def time(self) -> datetime:
        """
        Gets the time of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :return: The time of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time: datetime) -> None:
        """
        Sets the time of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.


        :param time: The time of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessagingChannel.
        :type: datetime
        """
        

        self._time = time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

